/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jpt.common.utility.internal.model.value.ElementPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.ui.JaxbProjectModel;
import org.eclipse.jpt.jaxb.ui.JaxbProjectsModel;

public class ProjectAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{JaxbProjectModel.class};

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IProject) {
            return this.getAdapter((IProject)adaptableObject, adapterType);
        }
        return null;
    }

    private Object getAdapter(IProject project, Class<?> adapterType) {
        if (adapterType == JaxbProjectModel.class) {
            return this.getJaxbProjectModel(project);
        }
        return null;
    }

    private JaxbProjectModel getJaxbProjectModel(IProject project) {
        return new JaxbProjectModelAdapter(this.getJaxbProjectsModel(project.getWorkspace()), project);
    }

    private JaxbProjectsModel getJaxbProjectsModel(IWorkspace workspace) {
        return (JaxbProjectsModel)workspace.getAdapter(JaxbProjectsModel.class);
    }

    static class JaxbProjectModelAdapter
    extends ElementPropertyValueModelAdapter<JaxbProject>
    implements JaxbProjectModel {
        JaxbProjectModelAdapter(CollectionValueModel<JaxbProject> jpaProjectsModel, IProject project) {
            super(jpaProjectsModel, (Predicate)new JaxbProject.ProjectEquals(project));
        }

        @Override
        public IProject getProject() {
            return (IProject)((JaxbProject.ProjectEquals)this.predicate).getCriterion();
        }
    }
}

