/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring.Refactoring;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring.RhinoChange;

public class ProjectChange
extends RhinoChange {
    public ProjectChange(ILaunchConfiguration configuration, String oldname, String newname) {
        super(configuration, oldname, newname);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        ILaunchConfigurationWorkingCopy copy = this.configuration.getWorkingCopy();
        String value = this.computeNewContainerName(this.configuration);
        if (value != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IProject project = root.getProject(this.newname);
            IContainer cont = (IContainer)project.findMember(value);
            copy.setContainer(cont);
        }
        if ((value = this.computeNewScriptName(this.configuration)) != null) {
            copy.setAttribute("script", value);
        }
        this.updateIncludeEntries(copy);
        value = this.computeNewConfigurationName(this.configuration);
        if (value != null) {
            copy.rename(value);
        }
        Refactoring.mapResources(copy);
        if (copy.isDirty()) {
            this.configuration = copy.doSave();
            return new ProjectChange(this.configuration, this.newname, this.oldname);
        }
        return null;
    }
}

