/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.sourcemap;

import org.eclipse.wst.jsdt.chromium.debug.core.model.StringMappingData;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.TextSectionMapping;

public class TextSectionMappingImpl
implements TextSectionMapping {
    private final StringMappingData directMappingData;
    private final StringMappingData backwardMappingData;

    public TextSectionMappingImpl(StringMappingData directMappingData, StringMappingData backwardMappingData) {
        this.directMappingData = directMappingData;
        this.backwardMappingData = backwardMappingData;
    }

    @Override
    public TextSectionMapping.TextPoint transform(TextSectionMapping.TextPoint original, TextSectionMapping.Direction direction) {
        int resCol;
        int resLine;
        StringMappingData targetData;
        StringMappingData sourceData = direction == TextSectionMapping.Direction.REVERSE ? this.backwardMappingData : this.directMappingData;
        int pos = sourceData.findContainingSegment(original.getLine(), original.getColumn());
        StringMappingData stringMappingData = targetData = direction == TextSectionMapping.Direction.REVERSE ? this.directMappingData : this.backwardMappingData;
        if (sourceData.getSegmentBeginLine(pos) == original.getLine()) {
            resLine = targetData.getSegmentBeginLine(pos);
            resCol = original.getColumn() - sourceData.getSegmentBeginColumn(pos) + targetData.getSegmentBeginColumn(pos);
        } else {
            resLine = original.getLine() - sourceData.getSegmentBeginLine(pos) + targetData.getSegmentBeginLine(pos);
            resCol = original.getColumn();
        }
        if (pos < targetData.getLastSegmentId()) {
            boolean exceed;
            int nextPos = StringMappingData.getNextSegmentId(pos);
            boolean bl = exceed = resLine > targetData.getSegmentBeginLine(nextPos) || resLine == targetData.getSegmentBeginLine(nextPos) && resCol >= targetData.getSegmentBeginColumn(nextPos);
            if (exceed) {
                if (targetData.getSegmentBeginLine(pos) == targetData.getSegmentBeginLine(nextPos) && targetData.getSegmentBeginColumn(pos) == targetData.getSegmentBeginColumn(nextPos)) {
                    resLine = targetData.getSegmentBeginLine(pos);
                    resCol = targetData.getSegmentBeginColumn(pos);
                } else if (targetData.getSegmentBeginColumn(nextPos) > 0) {
                    resLine = targetData.getSegmentBeginLine(nextPos);
                    resCol = targetData.getSegmentBeginColumn(nextPos) - 1;
                } else {
                    resLine = targetData.getSegmentBeginLine(nextPos) - 1;
                    resCol = 0;
                }
            }
        }
        return new TextSectionMapping.TextPoint(resLine, resCol);
    }
}

