/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.collection;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyIterator;
import org.eclipse.jpt.common.utility.internal.iterator.EmptyListIterator;

public final class NullList<E>
implements List<E>,
Serializable {
    private static final NullList INSTANCE = new NullList();
    private static final long serialVersionUID = 1L;

    public static <E> List<E> instance() {
        return INSTANCE;
    }

    private NullList() {
    }

    @Override
    public boolean add(E o) {
        return false;
    }

    @Override
    public void add(int index, E element) {
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.isEmpty();
    }

    @Override
    public E get(int index) {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    @Override
    public int indexOf(Object o) {
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return EmptyIterator.instance();
    }

    @Override
    public int lastIndexOf(Object o) {
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return EmptyListIterator.instance();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index == 0) {
            return EmptyListIterator.instance();
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public E remove(int index) {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public E set(int index, E element) {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex == 0 && toIndex == 0) {
            return this;
        }
        throw new IndexOutOfBoundsException("Index: " + fromIndex + ", Size: 0");
    }

    @Override
    public Object[] toArray() {
        return ObjectTools.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return a;
    }

    public String toString() {
        return "[]";
    }

    private Object readResolve() {
        return INSTANCE;
    }
}

