/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.collection;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.TightMap;

public class TightMap<K, V>
implements Map<K, V> {
    K[] keys = ObjectTools.EMPTY_OBJECT_ARRAY;
    V[] values = ObjectTools.EMPTY_OBJECT_ARRAY;
    private static final String EMPTY_MAP_STRING = "{}";
    private static final String THIS_MAP_STRING = "(this Map)";

    public TightMap() {
    }

    public TightMap(Map<? extends K, ? extends V> map) {
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.keys.length;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.length == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        return ArrayTools.contains(this.values, value);
    }

    @Override
    public boolean containsKey(Object key) {
        return ArrayTools.contains(this.keys, key);
    }

    @Override
    public V get(Object key) {
        int index = this.indexOfKey(key);
        return index == -1 ? null : (V)this.values[index];
    }

    int indexOfKey(Object key) {
        return ArrayTools.indexOf(this.keys, key);
    }

    @Override
    public V put(K key, V value) {
        V prev = null;
        int index = this.indexOfKey(key);
        if (index == -1) {
            this.keys = ArrayTools.add(this.keys, key);
            this.values = ArrayTools.add(this.values, value);
        } else {
            prev = this.values[index];
            this.values[index] = value;
        }
        return prev;
    }

    @Override
    public V remove(Object key) {
        int index = this.indexOfKey(key);
        return index == -1 ? null : (V)this.remove(index);
    }

    V removeKey(Object key) {
        return this.remove(this.indexOfKey(key));
    }

    void removeValue(Object value) {
        this.remove(this.indexOfValue(value));
    }

    int indexOfValue(Object value) {
        return ArrayTools.indexOf(this.values, value);
    }

    V remove(int index) {
        V prev = this.values[index];
        this.keys = ArrayTools.removeElementAtIndex(this.keys, index);
        this.values = ArrayTools.removeElementAtIndex(this.values, index);
        if (this.keys.length == 0) {
            this.clear();
        }
        return prev;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int mapSize = map.size();
        if (mapSize == 0) {
            return;
        }
        int index = this.keys.length;
        this.keys = ArrayTools.expand(this.keys, mapSize);
        this.values = ArrayTools.expand(this.values, mapSize);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.keys[index] = entry.getKey();
            this.values[index] = entry.getValue();
            ++index;
        }
    }

    @Override
    public void clear() {
        this.keys = new Object[0];
        this.values = new Object[0];
    }

    @Override
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        return new ValueCollection();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map other = (Map)o;
        int size = this.keys.length;
        if (other.size() != size) {
            return false;
        }
        int i = size;
        while (i-- > 0) {
            K key = this.keys[i];
            V value = this.values[i];
            if (!(value == null ? other.get(key) != null || !other.containsKey(key) : !value.equals(other.get(key)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        int i = this.keys.length;
        while (i-- > 0) {
            hash += ObjectTools.hashCode(this.keys[i]) ^ ObjectTools.hashCode(this.values[i]);
        }
        return hash;
    }

    public String toString() {
        int len = this.keys.length;
        if (len == 0) {
            return EMPTY_MAP_STRING;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int i = 0;
        while (i < len) {
            K key = this.keys[i];
            V value = this.values[i];
            if (key == this) {
                sb.append(THIS_MAP_STRING);
            } else {
                sb.append(key);
            }
            sb.append('=');
            if (value == this) {
                sb.append(THIS_MAP_STRING);
            } else {
                sb.append(value);
            }
            sb.append(", ");
            ++i;
        }
        sb.setLength(sb.length() - 2);
        sb.append('}');
        return sb.toString();
    }

    Iterator<K> buildKeyIterator() {
        return new KeyIterator();
    }

    Iterator<V> buildValueIterator() {
        return new ValueIterator();
    }

    Iterator<Map.Entry<K, V>> buildEntryIterator() {
        return new EntryIterator();
    }

    boolean containsEntry(Object o) {
        return o instanceof Map.Entry && this.containsEntry((Map.Entry)o);
    }

    private boolean containsEntry(Map.Entry<K, V> entry) {
        int index = this.indexOfKey(entry.getKey());
        return index != -1 && ObjectTools.equals(this.values[index], entry.getValue());
    }

    boolean removeEntry(Object o) {
        return o instanceof Map.Entry && this.removeEntry((Map.Entry)o);
    }

    private boolean removeEntry(Map.Entry<K, V> entry) {
        int index = this.indexOfKey(entry.getKey());
        if (index == -1) {
            return false;
        }
        if (ObjectTools.notEquals(this.values[index], entry.getValue())) {
            return false;
        }
        this.keys = ArrayTools.removeElementAtIndex(this.keys, index);
        this.values = ArrayTools.removeElementAtIndex(this.values, index);
        return true;
    }

    private static abstract class ArrayIterator<E>
    implements Iterator<E> {
        E[] localArray = this.getTightMapArray();
        private E next;
        private boolean done = false;
        private int cursor = 0;
        private E current;
        private boolean currentRemoved = true;

        ArrayIterator() {
            this.loadNext();
        }

        abstract E[] getTightMapArray();

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public E next() {
            if (this.localArray != this.getTightMapArray()) {
                throw new ConcurrentModificationException();
            }
            if (this.done) {
                throw new NoSuchElementException();
            }
            E element = this.next;
            this.loadNext();
            this.current = element;
            this.currentRemoved = false;
            return element;
        }

        private void loadNext() {
            if (this.cursor < this.localArray.length) {
                this.next = this.localArray[this.cursor];
                ++this.cursor;
            } else {
                this.next = null;
                this.done = true;
            }
        }

        @Override
        public void remove() {
            if (this.currentRemoved) {
                throw new IllegalStateException();
            }
            if (this.localArray != this.getTightMapArray()) {
                throw new ConcurrentModificationException();
            }
            E element = this.current;
            this.current = null;
            this.currentRemoved = true;
            this.removeTightMapElement(element);
            this.localArray = this.getTightMapArray();
            --this.cursor;
        }

        abstract void removeTightMapElement(E var1);
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        K[] localKeys;
        V[] localValues;
        private org.eclipse.jpt.common.utility.internal.collection.TightMap$EntryIterator.Entry next;
        private int cursor = 0;
        private org.eclipse.jpt.common.utility.internal.collection.TightMap$EntryIterator.Entry current;

        EntryIterator() {
            this.localKeys = TightMap.this.keys;
            this.localValues = TightMap.this.values;
            this.next = this.buildNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.localKeys != TightMap.this.keys) {
                throw new ConcurrentModificationException();
            }
            org.eclipse.jpt.common.utility.internal.collection.TightMap$EntryIterator.Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            this.next = this.buildNext();
            this.current = entry;
            return entry;
        }

        private org.eclipse.jpt.common.utility.internal.collection.TightMap$EntryIterator.Entry buildNext() {
            Entry entry;
            if (this.cursor < this.localKeys.length) {
                int n = this.cursor++;
                entry = new Entry(this.localKeys[n]);
            } else {
                entry = null;
            }
            return entry;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (this.localKeys != TightMap.this.keys) {
                throw new ConcurrentModificationException();
            }
            Object key = this.current.getKey();
            this.current = null;
            TightMap.this.removeKey(key);
            this.localKeys = TightMap.this.keys;
            this.localValues = TightMap.this.values;
            --this.cursor;
        }

        private class Entry
        implements Map.Entry<K, V> {
            final K key;

            Entry(K key) {
                this.key = key;
            }

            @Override
            public K getKey() {
                return this.key;
            }

            private int getIndex() {
                return ArrayTools.indexOf(EntryIterator.this.localKeys, this.key);
            }

            @Override
            public V getValue() {
                return EntryIterator.this.localValues[this.getIndex()];
            }

            @Override
            public V setValue(V value) {
                int index = this.getIndex();
                Object old = EntryIterator.this.localValues[index];
                EntryIterator.this.localValues[index] = value;
                return old;
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry other = (Map.Entry)o;
                return ObjectTools.equals(this.getKey(), other.getKey()) && ObjectTools.equals(this.getValue(), other.getValue());
            }

            @Override
            public int hashCode() {
                return ObjectTools.hashCode(this.getKey()) ^ ObjectTools.hashCode(this.getValue());
            }

            public String toString() {
                return this.getKey() + "=" + this.getValue();
            }
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return TightMap.this.buildEntryIterator();
        }

        @Override
        public int size() {
            return TightMap.this.keys.length;
        }

        @Override
        public boolean contains(Object o) {
            return TightMap.this.containsEntry(o);
        }

        @Override
        public boolean remove(Object o) {
            return TightMap.this.removeEntry(o);
        }

        @Override
        public void clear() {
            TightMap.this.clear();
        }
    }

    private class KeyIterator
    extends ArrayIterator<K> {
        KeyIterator() {
        }

        @Override
        K[] getTightMapArray() {
            return TightMap.this.keys;
        }

        @Override
        void removeTightMapElement(K key) {
            TightMap.this.removeKey(key);
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return TightMap.this.buildKeyIterator();
        }

        @Override
        public int size() {
            return TightMap.this.keys.length;
        }

        @Override
        public boolean contains(Object o) {
            return TightMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int index = TightMap.this.indexOfKey(o);
            if (index == -1) {
                return false;
            }
            TightMap.this.remove(index);
            return true;
        }

        @Override
        public void clear() {
            TightMap.this.clear();
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        ValueCollection() {
        }

        @Override
        public Iterator<V> iterator() {
            return TightMap.this.buildValueIterator();
        }

        @Override
        public int size() {
            return TightMap.this.keys.length;
        }

        @Override
        public boolean contains(Object o) {
            return TightMap.this.containsValue(o);
        }

        @Override
        public boolean remove(Object o) {
            int index = TightMap.this.indexOfValue(o);
            if (index == -1) {
                return false;
            }
            TightMap.this.remove(index);
            return true;
        }

        @Override
        public void clear() {
            TightMap.this.clear();
        }
    }

    private class ValueIterator
    extends ArrayIterator<V> {
        ValueIterator() {
        }

        @Override
        V[] getTightMapArray() {
            return TightMap.this.values;
        }

        @Override
        void removeTightMapElement(V value) {
            TightMap.this.removeValue(value);
        }
    }
}

