/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.stack;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EmptyStackException;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.stack.Stack;

public class LinkedStack<E>
implements Stack<E>,
Cloneable,
Serializable {
    private final NodeFactory<E> nodeFactory;
    private transient Node<E> head;
    private static final long serialVersionUID = 1L;

    public LinkedStack() {
        this(0);
    }

    public LinkedStack(int cacheSize) {
        this(LinkedStack.buildNodeFactory(cacheSize));
        this.head = null;
    }

    private static <E> NodeFactory<E> buildNodeFactory(int cacheSize) {
        if (cacheSize < -1) {
            throw new IllegalArgumentException("Cache size must be greater than or equal to -1: " + cacheSize);
        }
        return cacheSize == 0 ? SimpleNodeFactory.instance() : new CachingNodeFactory(cacheSize);
    }

    private LinkedStack(NodeFactory<E> nodeFactory) {
        this.nodeFactory = nodeFactory;
        this.head = null;
    }

    @Override
    public void push(E element) {
        this.head = this.nodeFactory.buildNode(element, this.head);
    }

    @Override
    public E pop() {
        if (this.head == null) {
            throw new EmptyStackException();
        }
        Node<E> node = this.head;
        this.head = node.next;
        Object element = node.element;
        this.nodeFactory.release(node);
        return element;
    }

    @Override
    public E peek() {
        if (this.head == null) {
            throw new EmptyStackException();
        }
        return this.head.element;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    public LinkedStack<E> clone() {
        LinkedStack<E> clone = new LinkedStack<E>(this.nodeFactory.copy());
        E[] elements = this.buildElements();
        int i = elements.length;
        while (i-- > 0) {
            clone.push(elements[i]);
        }
        return clone;
    }

    private E[] buildElements() {
        int size = this.size();
        if (size == 0) {
            return ObjectTools.EMPTY_OBJECT_ARRAY;
        }
        Object[] elements = new Object[size];
        int i = 0;
        Node<E> node = this.head;
        while (node != null) {
            elements[i++] = node.element;
            node = node.next;
        }
        return elements;
    }

    private int size() {
        int size = 0;
        Node<E> node = this.head;
        while (node != null) {
            ++size;
            node = node.next;
        }
        return size;
    }

    public String toString() {
        return Arrays.toString(this.buildElements());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        E[] elements = this.buildElements();
        int len = elements.length;
        stream.writeInt(len);
        int i = len;
        while (i-- > 0) {
            stream.writeObject(elements[i]);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int len;
        stream.defaultReadObject();
        int i = len = stream.readInt();
        while (i-- > 0) {
            this.push(stream.readObject());
        }
    }

    private static final class CachingNodeFactory<E>
    extends NodeFactory<E>
    implements Serializable {
        private final int maxCacheSize;
        private transient int cacheSize = 0;
        private transient Node<E> cacheHead;
        private static final long serialVersionUID = 1L;

        CachingNodeFactory(int maxCacheSize) {
            this.maxCacheSize = maxCacheSize;
        }

        @Override
        Node<E> buildNode(E element, Node<E> next) {
            if (this.cacheHead == null) {
                return super.buildNode(element, next);
            }
            Node<E> node = this.cacheHead;
            this.cacheHead = node.next;
            --this.cacheSize;
            node.element = element;
            node.next = next;
            return node;
        }

        @Override
        void release(Node<E> node) {
            if (this.maxCacheSize == -1 || this.cacheSize < this.maxCacheSize) {
                node.element = null;
                node.next = this.cacheHead;
                this.cacheHead = node;
                ++this.cacheSize;
            }
        }

        @Override
        NodeFactory<E> copy() {
            return new CachingNodeFactory<E>(this.maxCacheSize);
        }

        public String toString() {
            return ObjectTools.toString((Object)this, this.cacheSize);
        }
    }

    private static final class Node<E> {
        E element;
        Node<E> next;

        Node(E element, Node<E> next) {
            this.element = element;
            this.next = next;
        }

        public String toString() {
            return ObjectTools.toString((Object)this, this.element);
        }
    }

    private static abstract class NodeFactory<E> {
        NodeFactory() {
        }

        Node<E> buildNode(E element, Node<E> next) {
            return new Node<E>(element, next);
        }

        abstract void release(Node<E> var1);

        abstract NodeFactory<E> copy();
    }

    private static class SimpleNodeFactory<E>
    extends NodeFactory<E>
    implements Serializable {
        public static final NodeFactory INSTANCE = new SimpleNodeFactory();
        private static final long serialVersionUID = 1L;

        public static <E> NodeFactory<E> instance() {
            return INSTANCE;
        }

        private SimpleNodeFactory() {
        }

        @Override
        void release(Node<E> node) {
        }

        @Override
        NodeFactory<E> copy() {
            return this;
        }

        public String toString() {
            return ObjectTools.singletonToString(this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

