/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.orm.EmbeddedMappingFileWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SelectMappingFileDialog
extends ElementTreeSelectionDialog {
    protected final IProject project;
    protected Label messageLabel;
    protected Tree treeWidget;

    public SelectMappingFileDialog(Shell parent, IProject project) {
        this(parent, project, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
    }

    public SelectMappingFileDialog(Shell parent, IProject project, ILabelProvider labelProvider, ITreeContentProvider contentProvider) {
        super(parent, labelProvider, contentProvider);
        this.setAllowMultiple(false);
        this.project = project;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Button newButton = new Button(composite, 8);
        newButton.setText(JptJpaUiMessages.SELECT_MAPPING_FILE_DIALOG_NEW_BUTTON);
        GridData browseButtonData = new GridData(128);
        newButton.setLayoutData((Object)browseButtonData);
        newButton.setToolTipText(JptJpaUiMessages.SELECT_MAPPING_FILE_DIALOG_NEW_BUTTON_TOOL_TIP);
        newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SelectMappingFileDialog.this.openNewMappingFileWizard();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return composite;
    }

    protected Label createMessageArea(Composite composite) {
        this.messageLabel = super.createMessageArea(composite);
        return this.messageLabel;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer treeViewer = super.createTreeViewer(parent);
        this.treeWidget = treeViewer.getTree();
        return treeViewer;
    }

    public String getChosenName() {
        IPath resourcePath = null;
        Object element = this.getFirstResult();
        resourcePath = element instanceof IContainer ? ((IContainer)element).getFullPath() : ((IFile)element).getFullPath();
        return this.getProjectResourceLocator().getRuntimePath(resourcePath).toString();
    }

    protected void updateOKStatus() {
        super.updateOKStatus();
        TreeSelection selection = (TreeSelection)this.getTreeViewer().getSelection();
        IResource selectedResource = (IResource)selection.getFirstElement();
        if (selectedResource instanceof IFile) {
            this.updateStatus(JptJpaUiPlugin.instance().buildOKStatus());
        } else {
            this.updateStatus(JptJpaUiPlugin.instance().buildErrorStatus());
        }
    }

    protected void openNewMappingFileWizard() {
        IPath path = EmbeddedMappingFileWizard.createNewMappingFile((IStructuredSelection)new StructuredSelection((Object)this.project));
        this.updateDialog(path);
    }

    protected void updateDialog(IPath path) {
        if (path != null) {
            this.messageLabel.setEnabled(true);
            this.treeWidget.setEnabled(true);
            IFile file = this.getProjectResourceLocator().getPlatformFile(path);
            this.getTreeViewer().refresh();
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)file), true);
        }
    }

    protected ProjectResourceLocator getProjectResourceLocator() {
        return (ProjectResourceLocator)this.project.getAdapter(ProjectResourceLocator.class);
    }
}

