/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.validation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.web.core.internal.Logger;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapter;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapterFactory;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JsValidator
extends AbstractValidator
implements IValidator,
IExecutableExtension {
    private static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jsvalidator"));
    private IValidator fMessageOriginator;
    private Set fValidFileExts = new HashSet();
    private static final String[] METADATA_FILES = new String[]{".settings/.jsdtscope", ".settings/org.eclipse.wst.jsdt.ui.superType.container", ".settings/org.eclipse.wst.jsdt.ui.superType.name"};
    private static final String JAVASCRIPT_TASK_MARKER_TYPE = "org.eclipse.wst.jsdt.core.task";

    public JsValidator() {
        this.fMessageOriginator = this;
    }

    private IMessage createMessageFromProblem(IProblem problem, IFile f, IJsTranslation translation, IDocument textDoc) {
        ITextRegion textRegion;
        int sourceStart = problem.getSourceStart();
        int sourceEnd = problem.getSourceEnd();
        if (sourceStart == -1) {
            return null;
        }
        sourceStart = translation.getWebPageOffset(sourceStart);
        sourceEnd = translation.getWebPageOffset(sourceEnd);
        IStructuredDocument doc = (IStructuredDocument)textDoc;
        IStructuredDocumentRegion documentRegion = doc.getRegionAtCharacterOffset(sourceStart);
        if (documentRegion != null && (textRegion = documentRegion.getRegionAtCharacterOffset(sourceStart)) != null && textRegion instanceof ITextRegionCollection) {
            return null;
        }
        int sev = problem.isError() ? 1 : (problem.isWarning() ? 2 : 4);
        LocalizedMessage m = new LocalizedMessage(sev, problem.getMessage(), (IResource)f);
        try {
            int lineNo = textDoc.getLineOfOffset(sourceStart) + 1;
            m.setLineNo(lineNo);
            m.setOffset(sourceStart);
            m.setLength(sourceEnd - sourceStart + 1);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return m;
    }

    void performValidation(IFile f, IReporter reporter, IStructuredModel model, boolean inBatch) {
        if (model instanceof IDOMModel) {
            IDOMModel domModel = (IDOMModel)model;
            JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)domModel);
            IDOMDocument xmlDoc = domModel.getDocument();
            JsTranslationAdapter translationAdapter = (JsTranslationAdapter)xmlDoc.getAdapterFor(IJsTranslation.class);
            IJsTranslation translation = translationAdapter.getJsTranslation(false);
            if (!reporter.isCancelled()) {
                boolean updateTasks;
                translation.setProblemCollectingActive(true);
                translation.reconcileCompilationUnit();
                List problems = translation.getProblems();
                boolean bl = updateTasks = !domModel.isDirty() && f != null && f.isAccessible();
                if (updateTasks) {
                    try {
                        IMarker[] foundMarkers = f.findMarkers(JAVASCRIPT_TASK_MARKER_TYPE, true, 1);
                        int i = 0;
                        while (i < foundMarkers.length) {
                            foundMarkers[i].delete();
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        Logger.logException(e);
                    }
                }
                int i = 0;
                while (i < problems.size() && !reporter.isCancelled()) {
                    IProblem problem = (IProblem)problems.get(i);
                    IMessage m = this.createMessageFromProblem(problem, f, translation, (IDocument)domModel.getStructuredDocument());
                    if (m != null) {
                        if (problem.getID() == 536871362) {
                            if (updateTasks) {
                                try {
                                    IMarker task = f.createMarker(JAVASCRIPT_TASK_MARKER_TYPE);
                                    task.setAttribute("lineNumber", (Object)new Integer(m.getLineNumber()));
                                    task.setAttribute("charStart", (Object)new Integer(m.getOffset()));
                                    task.setAttribute("charEnd", (Object)new Integer(m.getOffset() + m.getLength()));
                                    task.setAttribute("message", (Object)m.getText());
                                    task.setAttribute("userEditable", (Object)Boolean.FALSE);
                                    switch (m.getSeverity()) {
                                        case 1: {
                                            task.setAttribute("priority", (Object)new Integer(2));
                                            task.setAttribute("severity", (Object)new Integer(2));
                                            break;
                                        }
                                        case 4: {
                                            task.setAttribute("priority", (Object)new Integer(0));
                                            task.setAttribute("severity", (Object)new Integer(0));
                                            break;
                                        }
                                        default: {
                                            task.setAttribute("priority", (Object)new Integer(1));
                                            task.setAttribute("severity", (Object)new Integer(1));
                                            break;
                                        }
                                    }
                                }
                                catch (CoreException e) {
                                    Logger.logException(e);
                                }
                            }
                        } else {
                            reporter.addMessage(this.fMessageOriginator, m);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        IConfigurationElement[] includes = config.getChildren("include");
        int i = 0;
        while (i < includes.length) {
            IConfigurationElement[] fileexts = includes[i].getChildren("fileext");
            int j = 0;
            while (j < fileexts.length) {
                String fileext = fileexts[j].getAttribute("ext");
                if (fileext != null) {
                    this.fValidFileExts.add(fileext);
                }
                ++j;
            }
            ++i;
        }
    }

    boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return this.fValidFileExts.isEmpty() || this.fValidFileExts.contains(file.getFileExtension());
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        block10: {
            JSFileVisitor visitor;
            block8: {
                block9: {
                    String[] uris = helper.getURIs();
                    if (uris.length <= 0) break block9;
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IFile currentFile = null;
                    int i = 0;
                    while (i < uris.length && !reporter.isCancelled()) {
                        currentFile = wsRoot.getFile((IPath)new Path(uris[i]));
                        reporter.removeAllMessages((IValidator)this, (Object)currentFile);
                        if (currentFile != null && currentFile.exists()) {
                            if (this.shouldValidate(currentFile)) {
                                int percent = i * 100 / uris.length + 1;
                                LocalizedMessage message = new LocalizedMessage(4, String.valueOf(percent) + "% " + uris[i]);
                                reporter.displaySubtask((IValidator)this, (IMessage)message);
                                this.validateFile(currentFile, reporter);
                            }
                            if (DEBUG) {
                                System.out.println("validating: [" + uris[i] + "]");
                            }
                        }
                        ++i;
                    }
                    break block10;
                }
                if (!(helper instanceof IWorkbenchContext)) break block10;
                IProject project = ((IWorkbenchContext)helper).getProject();
                visitor = new JSFileVisitor(reporter);
                try {
                    project.accept((IResourceProxyVisitor)visitor, 2);
                }
                catch (CoreException e) {
                    if (!DEBUG) break block8;
                    e.printStackTrace();
                }
            }
            IFile[] files = visitor.getFiles();
            int i = 0;
            while (i < files.length && !reporter.isCancelled()) {
                int percent = i * 100 / files.length + 1;
                LocalizedMessage message = new LocalizedMessage(4, String.valueOf(percent) + "% " + files[i].getFullPath().toString());
                reporter.displaySubtask((IValidator)this, (IMessage)message);
                this.validateFile(files[i], reporter);
                if (DEBUG) {
                    System.out.println("validating: [" + files[i] + "]");
                }
                ++i;
            }
        }
    }

    public void cleanup(IReporter reporter) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateFile(IFile f, IReporter reporter) {
        if (DEBUG) {
            Logger.log(1, String.valueOf(((Object)((Object)this)).getClass().getName()) + " validating: " + f);
        }
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getModelForRead(f);
                if (reporter.isCancelled() || model == null) return;
                this.performValidation(f, reporter, model, false);
                return;
            }
            catch (IOException e) {
                Logger.logException(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
            catch (CoreException e) {
                Logger.logException(e);
                if (model == null) return;
                model.releaseFromRead();
                return;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1 || !this.shouldValidate((IFile)resource)) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        IFile file = (IFile)resource;
        this.validateFile(file, reporter);
        result.setDependsOn(this.createDependencies(file));
        return result;
    }

    private IResource[] createDependencies(IFile file) {
        IFile[] depends = new IFile[METADATA_FILES.length];
        int i = 0;
        while (i < METADATA_FILES.length) {
            depends[i] = file.getProject().getFile(METADATA_FILES[i]);
            ++i;
        }
        return depends;
    }

    protected class JSFileVisitor
    implements IResourceProxyVisitor {
        private List fFiles = new ArrayList();
        private IReporter fReporter = null;

        public JSFileVisitor(IReporter reporter) {
            this.fReporter = reporter;
        }

        public final IFile[] getFiles() {
            return this.fFiles.toArray(new IFile[this.fFiles.size()]);
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            IFile file;
            if (this.fReporter.isCancelled()) {
                return false;
            }
            if (proxy.getType() == 1 && Util.isJsType(proxy.getName()) && (file = (IFile)proxy.requestResource()).exists() && JsValidator.this.shouldValidate(file)) {
                if (DEBUG) {
                    System.out.println("(+) JSPValidator adding file: " + file.getName());
                }
                this.fFiles.add(file);
                return false;
            }
            return true;
        }
    }

    protected class LocalizedMessage
    extends Message {
        private String _message;

        public LocalizedMessage(int severity, String messageText) {
            this(severity, messageText, null);
        }

        public LocalizedMessage(int severity, String messageText, IResource targetObject) {
            this(severity, messageText, (Object)targetObject);
        }

        public LocalizedMessage(int severity, String messageText, Object targetObject) {
            super(null, severity, null);
            this._message = null;
            this.setLocalizedMessage(messageText);
            this.setTargetObject(targetObject);
        }

        public String getLocalizedMessage() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedMessage();
        }

        public String getText(ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l) {
            return this.getLocalizedMessage();
        }

        public String getText(Locale l, ClassLoader cl) {
            return this.getLocalizedMessage();
        }

        public void setLocalizedMessage(String message) {
            this._message = message;
        }
    }
}

