/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.js.node.internal.launch.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.jsdt.js.node.internal.Messages;
import org.eclipse.wst.jsdt.js.node.internal.launch.ui.NodeWorkingDirectoryBlock;
import org.eclipse.wst.jsdt.js.node.internal.ui.ImageResource;

public class NodeLaunchArgumentsTab
extends AbstractLaunchConfigurationTab {
    private Text nodeArgumentsText;
    private Text appArgumentsText;
    private Button nodeVariablesButton;
    private Button appVariablesButton;
    NodeWorkingDirectoryBlock workingDirectoryBlock = new NodeWorkingDirectoryBlock("attr_working_directory");
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            NodeLaunchArgumentsTab.this.updateLaunchConfigurationDialog();
        }
    };
    private SelectionListener nodeArgsSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(NodeLaunchArgumentsTab.this.getShell());
            dialog.open();
            String variable = dialog.getVariableExpression();
            if (variable != null) {
                NodeLaunchArgumentsTab.this.nodeArgumentsText.insert(variable);
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    };
    private SelectionListener appArgsSelectionListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(NodeLaunchArgumentsTab.this.getShell());
            dialog.open();
            String variable = dialog.getVariableExpression();
            if (variable != null) {
                NodeLaunchArgumentsTab.this.appArgumentsText.insert(variable);
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
        }
    };

    public void createControl(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        Point minSize = composite.computeSize(0, 350);
        composite.setSize(minSize);
        if (composite.getParent() instanceof ScrolledComposite) {
            ScrolledComposite sc1 = (ScrolledComposite)composite.getParent();
            sc1.setMinSize(minSize);
            sc1.setExpandHorizontal(true);
            sc1.setExpandVertical(true);
        }
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.createNodeArgumentsGroup(composite);
        this.createAppArgumentsGroup(composite);
        this.createWorkingDirectoryGroup(composite);
        this.setControl((Control)scrolledComposite);
    }

    private void createNodeArgumentsGroup(Composite parent) {
        Group nodeJSOptionsGroup = new Group(parent, 0);
        nodeJSOptionsGroup.setText(Messages.LAUNCH_CONFIGURATION_ARGUMENTS_TAB_NODE_ARGUMENTS_TEXT);
        GridData gd = new GridData(768);
        nodeJSOptionsGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        nodeJSOptionsGroup.setLayout((Layout)layout);
        nodeJSOptionsGroup.setFont(parent.getFont());
        this.nodeArgumentsText = new Text((Composite)nodeJSOptionsGroup, 2626);
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.nodeArgumentsText.setLayoutData((Object)gd);
        this.nodeArgumentsText.addModifyListener(this.modifyListener);
        this.nodeVariablesButton = this.createPushButton((Composite)nodeJSOptionsGroup, Messages.LAUNCH_CONFIGURATION_ARGUMENTS_TAB_VARIABLES_TEXT, null);
        this.nodeVariablesButton.setLayoutData((Object)new GridData(128));
        this.nodeVariablesButton.addSelectionListener(this.nodeArgsSelectionListener);
    }

    private void createAppArgumentsGroup(Composite parent) {
        Group scriptOptionsGroup = new Group(parent, 0);
        scriptOptionsGroup.setText(Messages.LAUNCH_CONFIGURATION_ARGUMENTS_TAB_APP_ARGUMENTS_TEXT);
        GridData gd = new GridData(768);
        scriptOptionsGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        scriptOptionsGroup.setLayout((Layout)layout);
        scriptOptionsGroup.setFont(parent.getFont());
        this.appArgumentsText = new Text((Composite)scriptOptionsGroup, 2626);
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.appArgumentsText.setLayoutData((Object)gd);
        this.appArgumentsText.addModifyListener(this.modifyListener);
        this.appVariablesButton = this.createPushButton((Composite)scriptOptionsGroup, Messages.LAUNCH_CONFIGURATION_ARGUMENTS_TAB_VARIABLES_TEXT, null);
        this.appVariablesButton.setLayoutData((Object)new GridData(128));
        this.appVariablesButton.addSelectionListener(this.appArgsSelectionListener);
    }

    protected void createWorkingDirectoryGroup(Composite parent) {
        this.workingDirectoryBlock.createControl(parent);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.workingDirectoryBlock.setDefaults(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.nodeArgumentsText.setText(configuration.getAttribute("attr_node_arguments", ""));
            this.appArgumentsText.setText(configuration.getAttribute("attr_app_arguments", ""));
            this.workingDirectoryBlock.initializeFrom(configuration);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("attr_node_arguments", this.nodeArgumentsText.getText().trim());
        configuration.setAttribute("attr_app_arguments", this.appArgumentsText.getText().trim());
        this.workingDirectoryBlock.performApply(configuration);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        return this.workingDirectoryBlock.isValid(launchConfig);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.workingDirectoryBlock.setLaunchConfigurationDialog(dialog);
    }

    public String getErrorMessage() {
        String m = super.getErrorMessage();
        if (m == null) {
            return this.workingDirectoryBlock.getErrorMessage();
        }
        return m;
    }

    public String getMessage() {
        String m = super.getMessage();
        if (m == null) {
            return this.workingDirectoryBlock.getMessage();
        }
        return m;
    }

    public Image getImage() {
        return ImageResource.getImage("variable_tab.gif");
    }

    public String getName() {
        return Messages.LAUNCH_CONFIGURATION_ARGUMENTS_TAB;
    }
}

