/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.views.contentoutline;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateAction;
import org.eclipse.wst.sse.ui.internal.contentoutline.PropertyChangeUpdateActionContributionItem;
import org.eclipse.wst.sse.ui.internal.editor.EditorPluginImageHelper;
import org.eclipse.wst.xml.ui.views.contentoutline.XMLContentOutlineConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TLDContentOutlineConfiguration
extends XMLContentOutlineConfiguration {
    private final String OUTLINE_SHOW_VALUE_PREF = "outline-show-value";
    boolean fShowContentValues = true;
    ILabelProvider fLabelProvider = null;

    protected IContributionItem[] createMenuContributions(TreeViewer viewer) {
        PropertyChangeUpdateActionContributionItem showValueItem = new PropertyChangeUpdateActionContributionItem((PropertyChangeUpdateAction)new ToggleShowValueAction(this.getPreferenceStore(), "outline-show-value", viewer));
        IContributionItem[] items = super.createMenuContributions(viewer);
        if (items == null) {
            items = new IContributionItem[]{showValueItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 1];
            System.arraycopy(items, 0, combinedItems, 0, items.length);
            combinedItems[items.length] = showValueItem;
            items = combinedItems;
        }
        return items;
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new ContentLabelProvider(super.getLabelProvider(viewer));
        }
        return this.fLabelProvider;
    }

    protected IPreferenceStore getPreferenceStore() {
        return JSPUIPlugin.getDefault().getPreferenceStore();
    }

    private class ContentLabelProvider
    implements ILabelProvider {
        ILabelProvider fParentProvider = null;

        ContentLabelProvider(ILabelProvider parent) {
            this.fParentProvider = parent;
        }

        public void addListener(ILabelProviderListener listener) {
            this.fParentProvider.addListener(listener);
        }

        public void dispose() {
            this.fParentProvider.dispose();
        }

        private String firstLineOf(String text) {
            if (text == null || text.length() < 1 || text.indexOf(13) < 0 && text.indexOf(10) < 0) {
                return text;
            }
            int start = 0;
            int maxLength = text.length();
            while (start < maxLength && text.charAt(start) == '\r' || text.charAt(start) == '\n') {
                ++start;
            }
            int endN = text.indexOf(10, start);
            int endR = text.indexOf(13, start);
            if (endN < 0 && endR < 0) {
                if (start == 0) {
                    return text;
                }
                return text.substring(start);
            }
            if (endN < 0) {
                return text.substring(start, endR);
            }
            if (endR < 0) {
                return text.substring(start, endN);
            }
            return text.substring(start, Math.min(endN, endR));
        }

        private String getContainedText(Node parent) {
            NodeList children = parent.getChildNodes();
            if (children.getLength() == 1) {
                return this.getValue(children.item(0));
            }
            StringBuffer s = new StringBuffer();
            Node child = parent.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 5) {
                    String reference = ((EntityReference)child).getNodeValue();
                    if (reference == null && child.getNodeName() != null) {
                        reference = "&" + child.getNodeName() + ";";
                    }
                    if (reference != null) {
                        s.append(reference.trim());
                    }
                } else {
                    s.append(this.getValue(child));
                }
                child = child.getNextSibling();
            }
            return s.toString().trim();
        }

        public Image getImage(Object element) {
            return this.fParentProvider.getImage(element);
        }

        private String getNameValue(Element domElement) {
            NodeList names = domElement.getElementsByTagName("name");
            String name = null;
            int i = 0;
            while (i < names.getLength() && (name == null || name.length() == 0)) {
                name = this.getContainedText(names.item(i));
                ++i;
            }
            return name;
        }

        private String getShortNameValue(Element domElement) {
            NodeList names = domElement.getElementsByTagName("short-name");
            String name = null;
            int i = 0;
            while (i < names.getLength() && (name == null || name.length() == 0)) {
                name = this.getContainedText(names.item(i));
                ++i;
            }
            names = domElement.getElementsByTagName("shortname");
            i = 0;
            while (i < names.getLength() && (name == null || name.length() == 0)) {
                name = this.getContainedText(names.item(i));
                ++i;
            }
            return name;
        }

        public String getText(Object element) {
            if (TLDContentOutlineConfiguration.this.fShowContentValues && element instanceof Element) {
                String value;
                String value2;
                Element domElement = (Element)element;
                String name = domElement.getNodeName();
                boolean showName = "tag".equals(name);
                boolean bl = showName = showName || "attribute".equals(name);
                if (showName && (value2 = this.getNameValue(domElement)) != null && value2.length() > 0) {
                    return String.valueOf(this.fParentProvider.getText((Object)domElement)) + " [" + this.firstLineOf(value2) + "]";
                }
                boolean showContents = "name".equals(name);
                showContents = showContents || "bodycontent".equals(name);
                showContents = showContents || "body-content".equals(name);
                showContents = showContents || "tagclass".equals(name);
                showContents = showContents || "tag-class".equals(name);
                showContents = showContents || "teiclass".equals(name);
                showContents = showContents || "tei-class".equals(name);
                showContents = showContents || "required".equals(name);
                showContents = showContents || "rtexprvalue".equals(name);
                showContents = showContents || "uri".equals(name);
                showContents = showContents || "shortname".equals(name);
                showContents = showContents || "short-name".equals(name);
                showContents = showContents || "display-name".equals(name);
                showContents = showContents || "jspversion".equals(name);
                showContents = showContents || "jsp-version".equals(name);
                showContents = showContents || "tlibversion".equals(name);
                showContents = showContents || "tlib-version".equals(name);
                showContents = showContents || "listener-class".equals(name);
                showContents = showContents || "scope".equals(name);
                showContents = showContents || "variable-class".equals(name);
                showContents = showContents || "declare".equals(name);
                showContents = showContents || "name-from-attribute".equals(name);
                showContents = showContents || "name-given".equals(name);
                showContents = showContents || "validator-class".equals(name);
                showContents = showContents || "small-icon".equals(name);
                boolean bl2 = showContents = showContents || "large-icon".equals(name);
                if (showContents) {
                    return String.valueOf(this.fParentProvider.getText((Object)domElement)) + ": " + this.getContainedText(domElement);
                }
                if ("taglib".equals(name) && (value = this.getShortNameValue(domElement)) != null && value.length() > 0) {
                    return String.valueOf(this.fParentProvider.getText((Object)domElement)) + " [" + value + "]";
                }
            }
            return this.fParentProvider.getText(element);
        }

        private String getValue(Node n) {
            if (n == null) {
                return "";
            }
            String value = n.getNodeValue();
            if (value == null) {
                return "";
            }
            return value.trim();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.fParentProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.fParentProvider.removeListener(listener);
        }
    }

    private class ToggleShowValueAction
    extends PropertyChangeUpdateAction {
        private TreeViewer fTreeViewer;

        public ToggleShowValueAction(IPreferenceStore store, String preference, TreeViewer treeViewer) {
            super(JSPUIMessages.TLDContentOutlineConfiguration_0, store, preference, true);
            this.setToolTipText(this.getText());
            this.setImageDescriptor(EditorPluginImageHelper.getInstance().getImageDescriptor("icons/full/obj16/prop_ps.gif"));
            this.fTreeViewer = treeViewer;
            this.update();
        }

        public void update() {
            super.update();
            TLDContentOutlineConfiguration.this.fShowContentValues = this.isChecked();
            this.fTreeViewer.refresh(true);
        }
    }
}

