/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jpt.common.ui.internal.jface.TreeContentProvider;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class SimpleMessageTreeContent {
    private final String message;
    private static final ITreeContentProvider CONTENT_PROVIDER = new ContentProvider();
    private static final ILabelProvider LABEL_PROVIDER = new LabelProvider();

    public SimpleMessageTreeContent(String message) {
        this.message = message;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (CharSequence)this.message);
    }

    public String getMessage() {
        return this.message;
    }

    public static ITreeContentProvider contentProvider() {
        return CONTENT_PROVIDER;
    }

    public static ILabelProvider labelProvider() {
        return LABEL_PROVIDER;
    }

    static class ContentProvider
    extends TreeContentProvider {
        ContentProvider() {
        }

        @Override
        public boolean hasChildren(Object element) {
            return element instanceof SimpleMessageTreeContent;
        }

        @Override
        public Object[] getChildren(Object element) {
            if (element instanceof SimpleMessageTreeContent) {
                String msg = ((SimpleMessageTreeContent)element).getMessage();
                return new Object[]{msg};
            }
            return ObjectTools.EMPTY_OBJECT_ARRAY;
        }
    }

    static class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider {
        LabelProvider() {
        }

        public String getText(Object element) {
            return element instanceof String ? (String)element : null;
        }

        public String toString() {
            return ObjectTools.toString((Object)((Object)this));
        }
    }
}

