/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip.tools.protocolgenerator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.EnumValueCondition;
import org.eclipse.wst.jsdt.chromium.internal.wip.tools.protocolgenerator.JavaFileUpdater;
import org.eclipse.wst.jsdt.chromium.internal.wip.tools.protocolgenerator.WipMetamodel;

class Generator {
    private static final String ROOT_PACKAGE = "org.eclipse.wst.jsdt.chromium.internal.wip.protocol";
    private static final String OUTPUT_PACKAGE = "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output";
    private static final String INPUT_PACKAGE = "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input";
    private static final String COMMON_PACKAGE = "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.common";
    private static final String PARSER_INTERFACE_LIST_CLASS_NAME = "GeneratedParserInterfaceList";
    private static final String PARSER_ROOT_INTERFACE_NAME = "WipGeneratedParserRoot";
    private final List<String> jsonProtocolParserClassNames = new ArrayList<String>();
    private final List<ParserRootInterfaceItem> parserRootInterfaceItems = new ArrayList<ParserRootInterfaceItem>();
    private final TypeMap typeMap = new TypeMap();
    private final String originReference;
    private final FileSet fileSet;
    private static final String[] DOMAIN_WHITE_LIST = new String[]{"Debugger", "Runtime", "Page", "Network", "Console", "DOM"};
    private static final Set<String> BAD_METHOD_NAMES = new HashSet<String>(Arrays.asList("this"));

    Generator(String outputDir, String originReference) {
        this.originReference = originReference;
        this.fileSet = new FileSet(new File(outputDir));
    }

    void go(WipMetamodel.Root metamodel) throws IOException {
        List<WipMetamodel.Domain> domainList = metamodel.domains();
        Generator.initializeKnownTypes(this.typeMap);
        HashSet<String> domainTodoList = new HashSet<String>(Arrays.asList(DOMAIN_WHITE_LIST));
        HashMap<String, DomainGenerator> domainGeneratorMap = new HashMap<String, DomainGenerator>();
        for (WipMetamodel.Domain domain : domainList) {
            boolean found = domainTodoList.remove(domain.domain());
            if (!found) {
                System.out.println("Domain skipped: " + domain.domain());
                continue;
            }
            DomainGenerator domainGenerator = new DomainGenerator(domain);
            domainGeneratorMap.put(domain.domain(), domainGenerator);
            domainGenerator.registerTypes();
        }
        this.typeMap.setDomainGeneratorMap(domainGeneratorMap);
        if (!domainTodoList.isEmpty()) {
            throw new RuntimeException("Domains expected but not found: " + domainTodoList);
        }
        for (DomainGenerator domainGenerator : domainGeneratorMap.values()) {
            domainGenerator.generateCommandsAndEvents();
        }
        this.typeMap.generateRequestedTypes();
        this.generateParserInterfaceList();
        this.generateParserRoot(this.parserRootInterfaceItems);
        this.fileSet.deleteOtherFiles();
    }

    <T> QualifiedTypeData resolveType(final T typedObject, final TypedObjectAccess<T> access, final ResolveAndGenerateScope scope) {
        UnqualifiedTypeData unqualifiedType = Generator.switchByType(typedObject, access, new TypeVisitor<UnqualifiedTypeData>(){

            @Override
            public UnqualifiedTypeData visitRef(String refName) {
                BoxableType typeRef = Generator.this.resolveRefType(scope.getDomainName(), refName, scope.getTypeDirection());
                return new UnqualifiedTypeData(typeRef);
            }

            @Override
            public UnqualifiedTypeData visitBoolean() {
                return UnqualifiedTypeData.BOOLEAN;
            }

            @Override
            public UnqualifiedTypeData visitEnum(List<String> enumConstants) {
                String enumName = scope.generateEnum(this.getDescription(), enumConstants);
                return new UnqualifiedTypeData(BoxableType.createReference(enumName));
            }

            @Override
            public UnqualifiedTypeData visitString() {
                return UnqualifiedTypeData.STRING;
            }

            @Override
            public UnqualifiedTypeData visitInteger() {
                return UnqualifiedTypeData.LONG;
            }

            @Override
            public UnqualifiedTypeData visitNumber() {
                return UnqualifiedTypeData.NUMBER;
            }

            @Override
            public UnqualifiedTypeData visitArray(WipMetamodel.ArrayItemType items) {
                QualifiedTypeData itemQualifiedType = scope.resolveType(items, TypedObjectAccess.FOR_ARRAY_ITEM);
                String listTypeRef = "java.util.List<" + itemQualifiedType.getJavaType().getBoxedTypeText() + ">";
                return new UnqualifiedTypeData(listTypeRef);
            }

            @Override
            public UnqualifiedTypeData visitObject(List<WipMetamodel.ObjectProperty> properties) {
                String nestedObjectName;
                try {
                    nestedObjectName = scope.generateNestedObject(this.getDescription(), properties);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new UnqualifiedTypeData(nestedObjectName);
            }

            @Override
            public UnqualifiedTypeData visitUnknown() {
                return UnqualifiedTypeData.ANY;
            }

            private <S> String getDescription() {
                return access.getDescription(typedObject);
            }
        });
        return unqualifiedType.getQualifiedType(access.getOptional(typedObject) == Boolean.TRUE);
    }

    private void generateParserInterfaceList() throws IOException {
        JavaFileUpdater fileUpdater = this.startJavaFile(INPUT_PACKAGE, "GeneratedParserInterfaceList.java");
        Collections.sort(this.jsonProtocolParserClassNames);
        Writer writer = fileUpdater.getWriter();
        writer.write("public class GeneratedParserInterfaceList {\n");
        writer.write("  public static final Class<?>[] LIST = {\n");
        for (String name : this.jsonProtocolParserClassNames) {
            writer.write("    " + name + ".class" + ",\n");
        }
        writer.write("  };\n");
        writer.write("}\n");
        fileUpdater.update();
    }

    private void generateParserRoot(List<ParserRootInterfaceItem> parserRootInterfaceItems) throws IOException {
        JavaFileUpdater fileUpdater = this.startJavaFile(INPUT_PACKAGE, "WipGeneratedParserRoot.java");
        Collections.sort(parserRootInterfaceItems);
        Writer writer = fileUpdater.getWriter();
        writer.write("@org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParserRoot\n");
        writer.write("public interface WipGeneratedParserRoot {\n");
        for (ParserRootInterfaceItem item : parserRootInterfaceItems) {
            item.writeCode(writer);
        }
        writer.write("}\n");
        fileUpdater.update();
    }

    private BoxableType resolveRefType(String scopeDomainName, String refName, TypeData.Direction direction) {
        String shortName;
        String domainName;
        int pos = refName.indexOf(46);
        if (pos == -1) {
            domainName = scopeDomainName;
            shortName = refName;
        } else {
            domainName = refName.substring(0, pos);
            shortName = refName.substring(pos + 1);
        }
        return this.typeMap.resolve(domainName, shortName, direction);
    }

    private String generateMethodNameSubstitute(String originalName, Appendable output) throws IOException {
        if (!BAD_METHOD_NAMES.contains(originalName)) {
            return originalName;
        }
        output.append("  @org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonField(jsonLiteralName=\"" + originalName + "\")\n");
        return "get" + Character.toUpperCase(originalName.charAt(0)) + originalName.substring(1);
    }

    private static String capitalizeFirstChar(String str) {
        if (Character.isLowerCase(str.charAt(0))) {
            str = String.valueOf(Character.toUpperCase(str.charAt(0))) + str.substring(1);
        }
        return str;
    }

    private JavaFileUpdater startJavaFile(ClassNameScheme nameScheme, WipMetamodel.Domain domain, String baseName) throws IOException {
        String packageName = nameScheme.getPackageNameVirtual(domain.domain());
        String fileName = String.valueOf(nameScheme.getShortName(baseName)) + ".java";
        return this.startJavaFile(packageName, fileName);
    }

    private JavaFileUpdater startJavaFile(String packageName, String filename) throws IOException {
        String filePath = packageName.replace('.', '/');
        JavaFileUpdater fileUpdater = this.fileSet.createFileUpdater(String.valueOf(filePath) + "/" + filename);
        Writer writer = fileUpdater.getWriter();
        writer.write("// Generated source.\n");
        writer.write("// Generator: " + this.getClass().getCanonicalName() + "\n");
        writer.write("// Origin: " + this.originReference + "\n\n");
        writer.write("package " + packageName + ";\n\n");
        return fileUpdater;
    }

    private static <R, T> R switchByType(T typedObject, TypedObjectAccess<T> access, TypeVisitor<R> visitor) {
        String refName = access.getRef(typedObject);
        if (refName != null) {
            return visitor.visitRef(refName);
        }
        String typeName = access.getType(typedObject);
        if ("boolean".equals(typeName)) {
            return visitor.visitBoolean();
        }
        if ("string".equals(typeName)) {
            if (access.getEnum(typedObject) != null) {
                return visitor.visitEnum(access.getEnum(typedObject));
            }
            return visitor.visitString();
        }
        if ("integer".equals(typeName)) {
            return visitor.visitInteger();
        }
        if ("number".equals(typeName)) {
            return visitor.visitNumber();
        }
        if ("array".equals(typeName)) {
            return visitor.visitArray(access.getItems(typedObject));
        }
        if ("object".equals(typeName)) {
            return visitor.visitObject(access.getProperties(typedObject));
        }
        if ("any".equals(typeName)) {
            return visitor.visitUnknown();
        }
        if ("unknown".equals(typeName)) {
            return visitor.visitUnknown();
        }
        throw new RuntimeException("Unrecognized type " + typeName);
    }

    private static void initializeKnownTypes(TypeMap typeMap) {
    }

    private static class BoxableType {
        private final String boxed;
        private final String unboxed;
        static final BoxableType STRING = BoxableType.createReference("String");
        static final BoxableType OBJECT = BoxableType.createReference("Object");
        static final BoxableType NUMBER = BoxableType.createReference("Number");
        static final BoxableType LONG = BoxableType.create("Long", "long");
        static final BoxableType BOOLEAN = BoxableType.create("Boolean", "boolean");

        public static BoxableType create(String boxed, String unboxed) {
            return new BoxableType(boxed, unboxed);
        }

        public static BoxableType createReference(String text) {
            return new BoxableType(text, text);
        }

        private BoxableType(String boxed, String unboxed) {
            this.boxed = boxed;
            this.unboxed = unboxed;
        }

        String getText() {
            return this.unboxed;
        }

        String getBoxedTypeText() {
            return this.boxed;
        }

        BoxableType convertToPureReference() {
            if (this.boxed == this.unboxed) {
                return this;
            }
            return new BoxableType(this.boxed, this.boxed);
        }
    }

    private static abstract class ClassNameScheme {
        private final String suffix;

        ClassNameScheme(String suffix) {
            this.suffix = suffix;
        }

        String getFullName(String domainName, String baseName) {
            return String.valueOf(this.getPackageNameVirtual(domainName)) + "." + this.getShortName(baseName);
        }

        String getShortName(String baseName) {
            return String.valueOf(Generator.capitalizeFirstChar(baseName)) + this.suffix;
        }

        protected abstract String getPackageNameVirtual(String var1);

        static class Common
        extends ClassNameScheme {
            Common(String suffix) {
                super(suffix);
            }

            @Override
            protected String getPackageNameVirtual(String domainName) {
                return Common.getPackageName(domainName);
            }

            static String getPackageName(String domainName) {
                return "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.common." + domainName.toLowerCase();
            }
        }

        static class Input
        extends ClassNameScheme {
            Input(String suffix) {
                super(suffix);
            }

            @Override
            protected String getPackageNameVirtual(String domainName) {
                return Input.getPackageName(domainName);
            }

            String getParseMethodName(String domain, String name) {
                return "parse" + Generator.capitalizeFirstChar(domain) + this.getShortName(name);
            }

            static String getPackageName(String domainName) {
                return "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input." + domainName.toLowerCase();
            }
        }

        static class Output
        extends ClassNameScheme {
            Output(String suffix) {
                super(suffix);
            }

            @Override
            protected String getPackageNameVirtual(String domainName) {
                return Output.getPackageName(domainName);
            }

            static String getPackageName(String domainName) {
                return "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output." + domainName.toLowerCase();
            }
        }
    }

    private class DomainGenerator {
        private final WipMetamodel.Domain domain;

        DomainGenerator(WipMetamodel.Domain domain) {
            this.domain = domain;
        }

        void registerTypes() {
            if (this.domain.types() != null) {
                for (WipMetamodel.StandaloneType type : this.domain.types()) {
                    Generator.this.typeMap.getTypeData(this.domain.domain(), type.id()).setType(type);
                }
            }
        }

        void generateCommandsAndEvents() throws IOException {
            for (WipMetamodel.Command command : this.domain.commands()) {
                boolean hasResponse = command.returns() != null;
                this.generateCommandParams(command, hasResponse);
                if (!hasResponse) continue;
                this.generateCommandData(command);
                String dataFullName = Naming.COMMAND_DATA.getFullName(this.domain.domain(), command.name());
                Generator.this.jsonProtocolParserClassNames.add(dataFullName);
                Generator.this.parserRootInterfaceItems.add(new ParserRootInterfaceItem(this.domain.domain(), command.name(), Naming.COMMAND_DATA));
            }
            if (this.domain.events() != null) {
                for (WipMetamodel.Event event : this.domain.events()) {
                    this.generateEvenData(event);
                    Generator.this.jsonProtocolParserClassNames.add(Naming.EVENT_DATA.getFullName(this.domain.domain(), event.name()));
                    Generator.this.parserRootInterfaceItems.add(new ParserRootInterfaceItem(this.domain.domain(), event.name(), Naming.EVENT_DATA));
                }
            }
        }

        private void generateCommandParams(WipMetamodel.Command command, boolean hasResponse) throws IOException {
            StringBuilder baseTypeBuilder = new StringBuilder();
            baseTypeBuilder.append("org.eclipse.wst.jsdt.chromium.internal.wip.protocol.output.");
            if (hasResponse) {
                baseTypeBuilder.append("WipParamsWithResponse<" + Naming.COMMAND_DATA.getFullName(this.domain.domain(), command.name()) + ">");
            } else {
                baseTypeBuilder.append("WipParams");
            }
            StringBuilder additionalMemberBuilder = new StringBuilder();
            additionalMemberBuilder.append("  public static final String METHOD_NAME = org.eclipse.wst.jsdt.chromium.internal.wip.protocol.BasicConstants.Domain." + this.domain.domain().toUpperCase() + " + \"." + command.name() + "\";\n");
            additionalMemberBuilder.append("\n");
            additionalMemberBuilder.append("  @Override protected String getRequestName() {\n");
            additionalMemberBuilder.append("    return METHOD_NAME;\n");
            additionalMemberBuilder.append("  }\n");
            additionalMemberBuilder.append("\n");
            if (hasResponse) {
                String dataInterfaceFullname = Naming.COMMAND_DATA.getFullName(this.domain.domain(), command.name());
                additionalMemberBuilder.append("  @Override public " + dataInterfaceFullname + " parseResponse(" + "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipCommandResponse.Data data, " + "org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input." + Generator.PARSER_ROOT_INTERFACE_NAME + " parser) " + "throws org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException {\n");
                additionalMemberBuilder.append("    return parser." + Naming.COMMAND_DATA.getParseMethodName(this.domain.domain(), command.name()) + "(data.getUnderlyingObject());\n");
                additionalMemberBuilder.append("  }\n");
                additionalMemberBuilder.append("\n");
            }
            this.generateOutputClass(Naming.PARAMS, command.name(), command.description(), baseTypeBuilder.toString(), additionalMemberBuilder.toString(), command.parameters(), PropertyLikeAccess.PARAMETER);
        }

        private void generateCommandAdditionalParam(WipMetamodel.StandaloneType type) throws IOException {
            this.generateOutputClass(Naming.ADDITIONAL_PARAM, type.id(), type.description(), "org.json.simple.JSONObject", null, type.properties(), PropertyLikeAccess.PROPERTY);
        }

        private <P> void generateOutputClass(ClassNameScheme nameScheme, String baseName, String description, String baseType, String additionalMemberText, List<P> properties, PropertyLikeAccess<P> propertyAccess) throws IOException {
            String className = nameScheme.getShortName(baseName);
            JavaFileUpdater fileUpdater = Generator.this.startJavaFile(nameScheme, this.domain, baseName);
            Writer writer = fileUpdater.getWriter();
            if (description != null) {
                writer.write("/**\n" + description + "\n */\n");
            }
            writer.write("public class " + className + " extends " + baseType + " {\n");
            OutputClassScope classScope = new OutputClassScope(writer, className);
            if (additionalMemberText != null) {
                classScope.addMember("param-specific", additionalMemberText);
            }
            classScope.generateCommandParamsBody(properties, propertyAccess, baseName);
            classScope.writeAdditionalMembers(writer);
            writer.write("}\n");
            writer.close();
            fileUpdater.update();
        }

        StandaloneTypeBinding createStandaloneOutputTypeBinding(WipMetamodel.StandaloneType type, final String name) {
            return (StandaloneTypeBinding)Generator.switchByType(type, TypedObjectAccess.FOR_STANDALONE, new CreateStandalonTypeBindingVisitorBase(this, type){

                @Override
                public StandaloneTypeBinding visitObject(List<WipMetamodel.ObjectProperty> properties) {
                    return new StandaloneTypeBinding(){

                        @Override
                        public BoxableType getJavaType() {
                            return BoxableType.createReference(Naming.ADDITIONAL_PARAM.getFullName(domain.domain(), name));
                        }

                        @Override
                        public void generate() throws IOException {
                            this.generateCommandAdditionalParam(this.getType());
                        }

                        @Override
                        public TypeData.Direction getDirection() {
                            return TypeData.Direction.OUTPUT;
                        }
                    };
                }

                @Override
                public StandaloneTypeBinding visitEnum(List<String> enumConstants) {
                    throw new RuntimeException();
                }

                @Override
                public StandaloneTypeBinding visitArray(WipMetamodel.ArrayItemType items) {
                    throw new RuntimeException();
                }
            });
        }

        StandaloneTypeBinding createStandaloneInputTypeBinding(WipMetamodel.StandaloneType type) {
            return (StandaloneTypeBinding)Generator.switchByType(type, TypedObjectAccess.FOR_STANDALONE, new CreateStandalonTypeBindingVisitorBase(this, type){

                @Override
                public StandaloneTypeBinding visitObject(List<WipMetamodel.ObjectProperty> properties) {
                    return this.createStandaloneObjectInputTypeBinding(this.getType(), properties);
                }

                @Override
                public StandaloneTypeBinding visitEnum(List<String> enumConstants) {
                    return this.createStandaloneEnumInputTypeBinding(this.getType(), enumConstants, TypeData.Direction.INPUT);
                }

                @Override
                public StandaloneTypeBinding visitArray(WipMetamodel.ArrayItemType items) {
                    ResolveAndGenerateScope resolveAndGenerateScope = new ResolveAndGenerateScope(){

                        @Override
                        public String getDomainName() {
                            return domain.domain();
                        }

                        @Override
                        public TypeData.Direction getTypeDirection() {
                            return TypeData.Direction.INPUT;
                        }

                        @Override
                        public String generateEnum(String description, List<String> enumConstants) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public <T> QualifiedTypeData resolveType(T typedObject, TypedObjectAccess<T> access) {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String generateNestedObject(String description, List<WipMetamodel.ObjectProperty> properties) throws IOException {
                            throw new UnsupportedOperationException();
                        }
                    };
                    QualifiedTypeData itemTypeData = Generator.this.resolveType(items, TypedObjectAccess.FOR_ARRAY_ITEM, resolveAndGenerateScope);
                    BoxableType itemBoxableType = itemTypeData.getJavaType();
                    BoxableType arrayType = BoxableType.createReference("java.util.List<" + itemBoxableType.getBoxedTypeText() + ">");
                    return this.createTypedefTypeBinding(this.getType(), arrayType, Naming.INPUT_TYPEDEF, TypeData.Direction.INPUT);
                }
            });
        }

        StandaloneTypeBinding createStandaloneObjectInputTypeBinding(final WipMetamodel.StandaloneType type, final List<WipMetamodel.ObjectProperty> properties) {
            final String name = type.id();
            final String fullTypeName = Naming.INPUT_VALUE.getFullName(this.domain.domain(), name);
            Generator.this.jsonProtocolParserClassNames.add(fullTypeName);
            return new StandaloneTypeBinding(){

                @Override
                public BoxableType getJavaType() {
                    return BoxableType.createReference(fullTypeName);
                }

                @Override
                public void generate() throws IOException {
                    String description = type.description();
                    String className = Naming.INPUT_VALUE.getShortName(name);
                    JavaFileUpdater fileUpdater = Generator.this.startJavaFile(Naming.INPUT_VALUE, DomainGenerator.this.domain, name);
                    Writer writer = fileUpdater.getWriter();
                    if (description != null) {
                        writer.write("/**\n " + description + "\n */\n");
                    }
                    writer.write("@org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType\n");
                    writer.write("public interface " + className + " {\n");
                    InputClassScope classScope = new InputClassScope(writer, className);
                    classScope.generateStandaloneTypeBody(properties);
                    classScope.writeAdditionalMembers(writer);
                    writer.write("}\n");
                    fileUpdater.update();
                }

                @Override
                public TypeData.Direction getDirection() {
                    return TypeData.Direction.INPUT;
                }
            };
        }

        StandaloneTypeBinding createStandaloneEnumInputTypeBinding(final WipMetamodel.StandaloneType type, final List<String> enumConstants, final TypeData.Direction direction) {
            final String name = type.id();
            return new StandaloneTypeBinding(){

                @Override
                public BoxableType getJavaType() {
                    return BoxableType.createReference(Naming.INPUT_ENUM.getFullName(DomainGenerator.this.domain.domain(), name));
                }

                @Override
                public void generate() throws IOException {
                    String description = type.description();
                    String className = Naming.INPUT_ENUM.getShortName(name);
                    JavaFileUpdater fileUpdater = Generator.this.startJavaFile(Naming.INPUT_ENUM, DomainGenerator.this.domain, name);
                    Writer writer = fileUpdater.getWriter();
                    if (description != null) {
                        writer.write("/**\n " + description + "\n */\n");
                    }
                    writer.write("public enum " + className + " {\n");
                    boolean first = true;
                    for (String constName : enumConstants) {
                        if (first) {
                            writer.write("\n  ");
                        } else {
                            writer.write(",\n  ");
                        }
                        writer.write(EnumValueCondition.decorateEnumConstantName((String)constName));
                        first = false;
                    }
                    writer.write("\n");
                    writer.write("}\n");
                    fileUpdater.update();
                }

                @Override
                public TypeData.Direction getDirection() {
                    return direction;
                }
            };
        }

        StandaloneTypeBinding createTypedefTypeBinding(final WipMetamodel.StandaloneType type, final BoxableType actualJavaType, final ClassNameScheme nameScheme, final TypeData.Direction direction) {
            final String name = type.id();
            final String typedefJavaName = nameScheme.getFullName(this.domain.domain(), name);
            return new StandaloneTypeBinding(){

                @Override
                public BoxableType getJavaType() {
                    return BoxableType.create(this.decorateTypeName(actualJavaType.getBoxedTypeText()), this.decorateTypeName(actualJavaType.getText()));
                }

                private String decorateTypeName(String typeName) {
                    return String.valueOf(typeName) + "/*See " + typedefJavaName + "*/";
                }

                @Override
                public void generate() throws IOException {
                    String description = type.description();
                    String className = nameScheme.getShortName(name);
                    JavaFileUpdater fileUpdater = Generator.this.startJavaFile(nameScheme, DomainGenerator.this.domain, name);
                    Writer writer = fileUpdater.getWriter();
                    if (description != null) {
                        writer.write("/**\n " + description + "\n */\n");
                    }
                    writer.write("public class " + className + " {\n");
                    writer.write("  /*\n   The class is 'typedef'.\n   If merely holds a type javadoc and its only field refers to an actual type.\n   */\n");
                    writer.write("  " + actualJavaType.getText() + " actualType;\n");
                    writer.write("}\n");
                    fileUpdater.update();
                }

                @Override
                public TypeData.Direction getDirection() {
                    return direction;
                }
            };
        }

        private void generateCommandData(WipMetamodel.Command command) throws IOException {
            String className = Naming.COMMAND_DATA.getShortName(command.name());
            JavaFileUpdater fileUpdater = Generator.this.startJavaFile(Naming.COMMAND_DATA, this.domain, command.name());
            Writer writer = fileUpdater.getWriter();
            this.generateJsonProtocolInterface(writer, className, command.description(), command.returns(), null);
            fileUpdater.update();
        }

        private void generateEvenData(WipMetamodel.Event event) throws IOException {
            String className = Naming.EVENT_DATA.getShortName(event.name());
            JavaFileUpdater fileUpdater = Generator.this.startJavaFile(Naming.EVENT_DATA, this.domain, event.name());
            String domainName = this.domain.domain();
            String fullName = Naming.EVENT_DATA.getFullName(domainName, event.name());
            String eventTypeMemberText = "  public static final org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipEventType<" + fullName + "> TYPE\n      = new org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.WipEventType<" + fullName + ">(\"" + domainName + "." + event.name() + "\", " + fullName + ".class) {\n" + "    @Override public " + fullName + " parse(" + Generator.INPUT_PACKAGE + "." + Generator.PARSER_ROOT_INTERFACE_NAME + " parser, org.json.simple.JSONObject obj)" + " throws org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException {\n" + "      return parser." + Naming.EVENT_DATA.getParseMethodName(domainName, event.name()) + "(obj);\n" + "    }\n" + "  };\n";
            Writer writer = fileUpdater.getWriter();
            this.generateJsonProtocolInterface(writer, className, event.description(), event.parameters(), eventTypeMemberText);
            fileUpdater.update();
        }

        private void generateJsonProtocolInterface(Writer writer, String className, String description, List<WipMetamodel.Parameter> parameters, String additionalMembersText) throws IOException {
            if (description != null) {
                writer.write("/**\n " + description + "\n */\n");
            }
            writer.write("@org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType\n");
            writer.write("public interface " + className + " {\n");
            InputClassScope classScope = new InputClassScope(writer, className);
            if (additionalMembersText != null) {
                classScope.addMember("extra", additionalMembersText);
            }
            classScope.generateMainJsonProtocolInterfaceBody(parameters);
            classScope.writeAdditionalMembers(writer);
            writer.write("}\n");
        }

        private abstract class ClassScope {
            private final List<String> additionalMemberTexts = new ArrayList<String>(2);
            private final Writer writer;
            private final String packageName;
            private final String shortClassName;

            ClassScope(Writer writer, String packageName, String shortClassName) {
                this.writer = writer;
                this.packageName = packageName;
                this.shortClassName = shortClassName;
            }

            protected String getShortClassName() {
                return this.shortClassName;
            }

            String getFullName() {
                return String.valueOf(this.packageName) + "." + this.shortClassName;
            }

            void addMember(String key, String text) {
                this.additionalMemberTexts.add(text);
            }

            void writeAdditionalMembers(Writer writer) throws IOException {
                for (String text : this.additionalMemberTexts) {
                    writer.write(text);
                }
            }

            protected Writer getWriter() {
                return this.writer;
            }

            protected abstract MemberScope newMemberScope(String var1);

            protected abstract TypeData.Direction getTypeDirection();

            protected abstract class MemberScope
            implements ResolveAndGenerateScope {
                private final String memberName;

                protected MemberScope(String memberName) {
                    this.memberName = memberName;
                }

                private QualifiedTypeData resolveType(WipMetamodel.ObjectProperty objectProperty) {
                    return this.resolveType(objectProperty, TypedObjectAccess.FOR_OBJECT_PROPERTY);
                }

                private QualifiedTypeData resolveType(WipMetamodel.Parameter parameter) {
                    return this.resolveType(parameter, TypedObjectAccess.FOR_PARAMETER);
                }

                @Override
                public <T> QualifiedTypeData resolveType(T typedObject, TypedObjectAccess<T> access) {
                    return Generator.this.resolveType(typedObject, access, this);
                }

                protected String getMemberName() {
                    return this.memberName;
                }

                @Override
                public abstract String generateEnum(String var1, List<String> var2);

                @Override
                public abstract String generateNestedObject(String var1, List<WipMetamodel.ObjectProperty> var2) throws IOException;

                @Override
                public String getDomainName() {
                    return DomainGenerator.this.domain.domain();
                }

                @Override
                public TypeData.Direction getTypeDirection() {
                    return ClassScope.this.getTypeDirection();
                }
            }
        }

        abstract class CreateStandalonTypeBindingVisitorBase
        implements TypeVisitor<StandaloneTypeBinding> {
            private final WipMetamodel.StandaloneType type;

            CreateStandalonTypeBindingVisitorBase(WipMetamodel.StandaloneType type) {
                this.type = type;
            }

            protected WipMetamodel.StandaloneType getType() {
                return this.type;
            }

            @Override
            public StandaloneTypeBinding visitString() {
                return DomainGenerator.this.createTypedefTypeBinding(this.type, BoxableType.STRING, Naming.COMMON_TYPEDEF, null);
            }

            @Override
            public StandaloneTypeBinding visitInteger() {
                return DomainGenerator.this.createTypedefTypeBinding(this.type, BoxableType.LONG, Naming.COMMON_TYPEDEF, null);
            }

            @Override
            public StandaloneTypeBinding visitRef(String refName) {
                throw new RuntimeException();
            }

            @Override
            public StandaloneTypeBinding visitBoolean() {
                throw new RuntimeException();
            }

            @Override
            public StandaloneTypeBinding visitNumber() {
                return DomainGenerator.this.createTypedefTypeBinding(this.type, BoxableType.NUMBER, Naming.COMMON_TYPEDEF, null);
            }

            @Override
            public StandaloneTypeBinding visitUnknown() {
                throw new RuntimeException();
            }
        }

        class InputClassScope
        extends ClassScope {
            InputClassScope(Writer writer, String shortClassName) {
                super(writer, ClassNameScheme.Input.getPackageName(DomainGenerator.this.domain.domain()), shortClassName);
            }

            public void generateMainJsonProtocolInterfaceBody(List<WipMetamodel.Parameter> parameters) throws IOException {
                if (parameters != null) {
                    for (WipMetamodel.Parameter param : parameters) {
                        if (param.description() != null) {
                            this.getWriter().write("  /**\n   " + param.description() + "\n   */\n");
                        }
                        String methodName = Generator.this.generateMethodNameSubstitute(param.name(), this.getWriter());
                        ClassScope.MemberScope memberScope = this.newMemberScope(param.name());
                        QualifiedTypeData paramTypeData = memberScope.resolveType(param);
                        paramTypeData.writeAnnotations(this.getWriter(), "  ");
                        this.getWriter().write("  " + paramTypeData.getJavaType().getText() + " " + methodName + "();\n");
                        this.getWriter().write("\n");
                    }
                }
            }

            void generateStandaloneTypeBody(List<WipMetamodel.ObjectProperty> properties) throws IOException {
                if (properties != null) {
                    for (WipMetamodel.ObjectProperty objectProperty : properties) {
                        String propertyName = objectProperty.name();
                        if (objectProperty.description() != null) {
                            this.getWriter().write("  /**\n   " + objectProperty.description() + "\n   */\n");
                        }
                        String methodName = Generator.this.generateMethodNameSubstitute(propertyName, this.getWriter());
                        ClassScope.MemberScope memberScope = this.newMemberScope(propertyName);
                        QualifiedTypeData propertyTypeData = memberScope.resolveType(objectProperty);
                        propertyTypeData.writeAnnotations(this.getWriter(), "  ");
                        this.getWriter().write("  " + propertyTypeData.getJavaType().getText() + " " + methodName + "();\n");
                        this.getWriter().write("\n");
                    }
                }
            }

            @Override
            protected TypeData.Direction getTypeDirection() {
                return TypeData.Direction.INPUT;
            }

            @Override
            protected ClassScope.MemberScope newMemberScope(String memberName) {
                return new InputMemberScope(memberName);
            }

            class InputMemberScope
            extends ClassScope.MemberScope {
                InputMemberScope(String memberName) {
                    super(memberName);
                }

                @Override
                public String generateEnum(String description, List<String> enumConstants) {
                    StringBuilder builder = new StringBuilder();
                    if (description != null) {
                        builder.append("  /**\n   " + description + "\n   */\n");
                    }
                    String enumName = Generator.capitalizeFirstChar(this.getMemberName());
                    builder.append("  public enum " + enumName + " {\n");
                    for (String constant : enumConstants) {
                        builder.append("    " + EnumValueCondition.decorateEnumConstantName((String)constant) + ",\n");
                    }
                    builder.append("  }\n");
                    InputClassScope.this.addMember(enumName, builder.toString());
                    return enumName;
                }

                @Override
                public String generateNestedObject(String description, List<WipMetamodel.ObjectProperty> propertyList) throws IOException {
                    StringBuilder builder = new StringBuilder();
                    if (description != null) {
                        builder.append("  /**\n   " + description + "\n   */\n");
                    }
                    String objectName = Generator.capitalizeFirstChar(this.getMemberName());
                    if (propertyList == null) {
                        builder.append("  @org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType(allowsOtherProperties=true)\n");
                        builder.append("  public interface " + objectName + " extends org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonObjectBased {\n");
                        builder.append("  }\n");
                    } else {
                        builder.append("  @org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonType\n");
                        builder.append("  public interface " + objectName + " {\n");
                        for (WipMetamodel.ObjectProperty property : propertyList) {
                            if (property.description() != null) {
                                builder.append("    /**\n     " + property.description() + "\n     */\n");
                            }
                            String methodName = Generator.this.generateMethodNameSubstitute(property.name(), builder);
                            ClassScope.MemberScope memberScope = InputClassScope.this.newMemberScope(property.name());
                            QualifiedTypeData propertyTypeData = memberScope.resolveType(property);
                            propertyTypeData.writeAnnotations(builder, "    ");
                            builder.append("    " + propertyTypeData.getJavaType().getText() + " " + methodName + "();\n");
                            builder.append("\n");
                        }
                        builder.append("  }\n");
                    }
                    InputClassScope.this.addMember(objectName, builder.toString());
                    Generator.this.jsonProtocolParserClassNames.add(String.valueOf(InputClassScope.this.getFullName()) + "." + objectName);
                    return objectName;
                }
            }
        }

        class OutputClassScope
        extends ClassScope {
            OutputClassScope(Writer writer, String shortClassName) {
                super(writer, ClassNameScheme.Output.getPackageName(DomainGenerator.this.domain.domain()), shortClassName);
            }

            <P> void generateCommandParamsBody(List<P> parameters, PropertyLikeAccess<P> access, String commandName) throws IOException {
                abstract class ParamData {
                    final String name;
                    final String description;

                    ParamData(String name, String description) {
                        this.name = name;
                        this.description = description;
                    }

                    abstract String getJavaTypeText();

                    abstract void writeSetCode(Writer var1) throws IOException;
                }
                List<ParamData> physicalParameters;
                if (parameters == null) {
                    physicalParameters = Collections.emptyList();
                } else {
                    physicalParameters = new ArrayList<ParamData>(parameters.size());
                    for (P param : parameters) {
                        class OptionalLogicalParamData
                        extends LogicalParamData {
                            final String condition;

                            OptionalLogicalParamData(String name, String description, QualifiedTypeData qualifiedTypeData, String logicalName, String condition) {
                                class LogicalParamData
                                extends ParamData {
                                    final QualifiedTypeData qualifiedTypeData;
                                    final String logicalName;

                                    LogicalParamData(String name, String description, QualifiedTypeData qualifiedTypeData, String logicalName) {
                                        super(name, description);
                                        this.qualifiedTypeData = qualifiedTypeData;
                                        this.logicalName = logicalName;
                                    }

                                    @Override
                                    String getJavaTypeText() {
                                        return this.qualifiedTypeData.getJavaType().getText();
                                    }

                                    @Override
                                    void writeSetCode(Writer writer) throws IOException {
                                        writer.append("    this.put(\"" + this.logicalName + "\", " + this.name + ");\n");
                                    }
                                }
                                super(name, description, qualifiedTypeData, logicalName);
                                this.condition = condition;
                            }

                            @Override
                            void writeSetCode(Writer writer) throws IOException {
                                writer.append("    if (" + this.condition + ") {\n  ");
                                super.writeSetCode(writer);
                                writer.append("    }\n");
                            }
                        }
                        LogicalParamData data;
                        Iterator<ParamData> logicalName = access.getName(param);
                        String description = access.forTypedObject().getDescription(param);
                        ClassScope.MemberScope memberScope = this.newMemberScope((String)((Object)logicalName));
                        QualifiedTypeData paramTypeData = memberScope.resolveType(param, access.forTypedObject());
                        if (paramTypeData.isNullable() && paramTypeData.isOptional()) {
                            Iterator<ParamData> paramName = logicalName;
                            String helperParamName = "has" + Generator.capitalizeFirstChar(paramName);
                            OptionalLogicalParamData mainParamData = new OptionalLogicalParamData((String)((Object)paramName), description, paramTypeData, (String)((Object)logicalName), helperParamName);
                            String helperDescription = "whether '" + paramName + "' actually contains value (possibly null)";
                            ParamData helperParamData = new ParamData(this, helperParamName, helperDescription){
                                {
                                    super($anonymous0, $anonymous1);
                                }

                                @Override
                                String getJavaTypeText() {
                                    return "boolean";
                                }

                                @Override
                                void writeSetCode(Writer writer) {
                                }
                            };
                            physicalParameters.add(helperParamData);
                            physicalParameters.add(mainParamData);
                            continue;
                        }
                        if (paramTypeData.isOptional()) {
                            String paramName = String.valueOf(logicalName) + "Opt";
                            data = new OptionalLogicalParamData(paramName, description, paramTypeData, (String)((Object)logicalName), String.valueOf(paramName) + " != null");
                        } else {
                            data = new LogicalParamData((String)((Object)logicalName), description, paramTypeData, (String)((Object)logicalName));
                        }
                        physicalParameters.add(data);
                    }
                }
                boolean hasDoc = false;
                for (ParamData paramData : physicalParameters) {
                    if (paramData.description == null) continue;
                    hasDoc = true;
                    break;
                }
                if (hasDoc) {
                    this.getWriter().append("  /**\n");
                    for (ParamData paramData : physicalParameters) {
                        if (paramData.description == null) continue;
                        this.getWriter().append("   @param " + paramData.name + " " + paramData.description + "\n");
                    }
                    this.getWriter().append("   */\n");
                }
                this.getWriter().write("  public " + this.getShortClassName() + "(");
                boolean needComa = false;
                for (ParamData paramData : physicalParameters) {
                    if (needComa) {
                        this.getWriter().append(", ");
                    }
                    this.getWriter().append(String.valueOf(paramData.getJavaTypeText()) + " " + paramData.name);
                    needComa = true;
                }
                this.getWriter().write(") {\n");
                for (ParamData paramData : physicalParameters) {
                    paramData.writeSetCode(this.getWriter());
                }
                this.getWriter().write("  }\n");
                this.getWriter().write("\n");
            }

            @Override
            protected TypeData.Direction getTypeDirection() {
                return TypeData.Direction.OUTPUT;
            }

            @Override
            protected ClassScope.MemberScope newMemberScope(String memberName) {
                return new OutputMemberScope(memberName);
            }

            class OutputMemberScope
            extends ClassScope.MemberScope {
                protected OutputMemberScope(String memberName) {
                    super(memberName);
                }

                @Override
                public String generateEnum(String description, List<String> enumConstants) {
                    StringBuilder builder = new StringBuilder();
                    if (description != null) {
                        builder.append("  /**\n   " + description + "\n   */\n");
                    }
                    String enumName = Generator.capitalizeFirstChar(this.getMemberName());
                    builder.append("  public enum " + enumName + " implements org.json.simple.JSONAware{\n");
                    for (String constant : enumConstants) {
                        builder.append("    " + EnumValueCondition.decorateEnumConstantName((String)constant) + "(\"" + constant + "\"),\n");
                    }
                    builder.append("    ;\n");
                    builder.append("    private final String protocolValue;\n");
                    builder.append("\n");
                    builder.append("    " + enumName + "(String protocolValue) {\n");
                    builder.append("      this.protocolValue = protocolValue;\n");
                    builder.append("    }\n");
                    builder.append("\n");
                    builder.append("    @Override public String toJSONString() {\n");
                    builder.append("      return '\"' + protocolValue + '\"';\n");
                    builder.append("    }\n");
                    builder.append("  }\n");
                    OutputClassScope.this.addMember(enumName, builder.toString());
                    return enumName;
                }

                @Override
                public String generateNestedObject(String description, List<WipMetamodel.ObjectProperty> propertyList) throws IOException {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private static class FileSet {
        private final File rootDir;
        private final Set<File> unusedFiles;

        FileSet(File rootDir) {
            this.rootDir = rootDir;
            ArrayList<File> files = new ArrayList<File>();
            FileSet.collectFilesRecursive(rootDir, files);
            this.unusedFiles = new HashSet<File>(files);
        }

        JavaFileUpdater createFileUpdater(String filePath) {
            File file = new File(this.rootDir, filePath);
            this.unusedFiles.remove(file);
            return new JavaFileUpdater(file);
        }

        void deleteOtherFiles() {
            for (File file : this.unusedFiles) {
                file.delete();
            }
        }

        private static void collectFilesRecursive(File file, Collection<File> list) {
            if (file.isFile()) {
                list.add(file);
            } else if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File inner = fileArray[n2];
                    FileSet.collectFilesRecursive(inner, list);
                    ++n2;
                }
            }
        }
    }

    static interface Naming {
        public static final ClassNameScheme PARAMS = new ClassNameScheme.Output("Params");
        public static final ClassNameScheme ADDITIONAL_PARAM = new ClassNameScheme.Output("Param");
        public static final ClassNameScheme.Input COMMAND_DATA = new ClassNameScheme.Input("Data");
        public static final ClassNameScheme.Input EVENT_DATA = new ClassNameScheme.Input("EventData");
        public static final ClassNameScheme INPUT_VALUE = new ClassNameScheme.Input("Value");
        public static final ClassNameScheme INPUT_ENUM = new ClassNameScheme.Input("Enum");
        public static final ClassNameScheme INPUT_TYPEDEF = new ClassNameScheme.Input("Typedef");
        public static final ClassNameScheme COMMON_TYPEDEF = new ClassNameScheme.Common("Typedef");
    }

    private static class ParserRootInterfaceItem
    implements Comparable<ParserRootInterfaceItem> {
        private final String domain;
        private final String name;
        private final ClassNameScheme.Input nameScheme;
        private final String fullName;

        public ParserRootInterfaceItem(String domain, String name, ClassNameScheme.Input nameScheme) {
            this.domain = domain;
            this.name = name;
            this.nameScheme = nameScheme;
            this.fullName = nameScheme.getFullName(domain, name);
        }

        void writeCode(Writer writer) throws IOException {
            writer.write("  @org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonParseMethod\n");
            writer.write("  " + this.fullName + " " + this.nameScheme.getParseMethodName(this.domain, this.name) + "(org.json.simple.JSONObject obj)" + " throws org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;\n");
            writer.write("\n");
        }

        @Override
        public int compareTo(ParserRootInterfaceItem o) {
            return this.fullName.compareTo(o.fullName);
        }
    }

    private static abstract class PropertyLikeAccess<T> {
        static final PropertyLikeAccess<WipMetamodel.Parameter> PARAMETER = new PropertyLikeAccess<WipMetamodel.Parameter>(){

            @Override
            TypedObjectAccess<WipMetamodel.Parameter> forTypedObject() {
                return TypedObjectAccess.FOR_PARAMETER;
            }

            @Override
            String getName(WipMetamodel.Parameter obj) {
                return obj.name();
            }
        };
        static final PropertyLikeAccess<WipMetamodel.ObjectProperty> PROPERTY = new PropertyLikeAccess<WipMetamodel.ObjectProperty>(){

            @Override
            TypedObjectAccess<WipMetamodel.ObjectProperty> forTypedObject() {
                return TypedObjectAccess.FOR_OBJECT_PROPERTY;
            }

            @Override
            String getName(WipMetamodel.ObjectProperty obj) {
                return obj.name();
            }
        };

        private PropertyLikeAccess() {
        }

        abstract TypedObjectAccess<T> forTypedObject();

        abstract String getName(T var1);
    }

    private static class QualifiedTypeData {
        private final BoxableType typeRef;
        private final boolean optional;
        private final boolean nullable;

        QualifiedTypeData(BoxableType typeRef, boolean optional, boolean nullable) {
            this.typeRef = typeRef;
            this.optional = optional;
            this.nullable = nullable;
        }

        boolean isOptional() {
            return this.optional;
        }

        boolean isNullable() {
            return this.nullable;
        }

        BoxableType getJavaType() {
            return this.typeRef;
        }

        void writeAnnotations(Appendable appendable, String indent) throws IOException {
            if (this.isOptional()) {
                appendable.append(String.valueOf(indent) + "@org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonOptionalField\n");
            }
            if (this.isNullable()) {
                appendable.append(String.valueOf(indent) + "@org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonNullable\n");
            }
        }
    }

    private static interface ResolveAndGenerateScope {
        public String getDomainName();

        public TypeData.Direction getTypeDirection();

        public <T> QualifiedTypeData resolveType(T var1, TypedObjectAccess<T> var2);

        public String generateEnum(String var1, List<String> var2);

        public String generateNestedObject(String var1, List<WipMetamodel.ObjectProperty> var2) throws IOException;
    }

    private static interface StandaloneTypeBinding {
        public BoxableType getJavaType();

        public void generate() throws IOException;

        public TypeData.Direction getDirection();
    }

    private static class TypeData {
        private final String domain;
        private final String name;
        private Input input = null;
        private Output output = null;
        private WipMetamodel.StandaloneType type = null;
        private StandaloneTypeBinding commonBinding = null;

        TypeData(String domain, String name) {
            this.domain = domain;
            this.name = name;
        }

        void setType(WipMetamodel.StandaloneType type) {
            this.type = type;
        }

        Input getInput() {
            if (this.input == null) {
                this.input = new Input();
            }
            return this.input;
        }

        Output getOutput() {
            if (this.output == null) {
                this.output = new Output();
            }
            return this.output;
        }

        TypeRef get(Direction direction) {
            return direction.get(this);
        }

        void checkComplete() {
            if (this.input != null) {
                this.input.checkResolved();
            }
            if (this.output != null) {
                this.output.checkResolved();
            }
        }

        static enum Direction {
            INPUT{

                @Override
                TypeRef get(TypeData typeData) {
                    return typeData.getInput();
                }
            }
            ,
            OUTPUT{

                @Override
                TypeRef get(TypeData typeData) {
                    return typeData.getOutput();
                }
            };


            abstract TypeRef get(TypeData var1);
        }

        class Input
        extends TypeRef {
            Input() {
            }

            @Override
            StandaloneTypeBinding resolveImpl(DomainGenerator domainGenerator) {
                if (TypeData.this.type == null) {
                    throw new RuntimeException();
                }
                return domainGenerator.createStandaloneInputTypeBinding(TypeData.this.type);
            }
        }

        class Output
        extends TypeRef {
            Output() {
            }

            @Override
            StandaloneTypeBinding resolveImpl(DomainGenerator domainGenerator) {
                if (TypeData.this.type == null) {
                    throw new RuntimeException();
                }
                return domainGenerator.createStandaloneOutputTypeBinding(TypeData.this.type, TypeData.this.name);
            }
        }

        abstract class TypeRef {
            private StandaloneTypeBinding oneDirectionBinding = null;

            TypeRef() {
            }

            BoxableType resolve(TypeMap typeMap, DomainGenerator domainGenerator) {
                if (TypeData.this.commonBinding != null) {
                    return TypeData.this.commonBinding.getJavaType();
                }
                if (this.oneDirectionBinding != null) {
                    return this.oneDirectionBinding.getJavaType();
                }
                StandaloneTypeBinding binding = this.resolveImpl(domainGenerator);
                if (binding.getDirection() == null) {
                    TypeData.this.commonBinding = binding;
                } else {
                    this.oneDirectionBinding = binding;
                }
                typeMap.addTypeToGenerate(binding);
                return binding.getJavaType();
            }

            abstract StandaloneTypeBinding resolveImpl(DomainGenerator var1);

            void checkResolved() {
                if (TypeData.this.type == null) {
                    throw new RuntimeException();
                }
            }
        }
    }

    private static class TypeMap {
        private final Map<List<String>, TypeData> map = new HashMap<List<String>, TypeData>();
        private Map<String, DomainGenerator> domainGeneratorMap = null;
        private List<StandaloneTypeBinding> typesToGenerate = new ArrayList<StandaloneTypeBinding>();

        private TypeMap() {
        }

        void setDomainGeneratorMap(Map<String, DomainGenerator> domainGeneratorMap) {
            this.domainGeneratorMap = domainGeneratorMap;
        }

        BoxableType resolve(String domainName, String typeName, TypeData.Direction direction) {
            DomainGenerator domainGenerator = this.domainGeneratorMap.get(domainName);
            if (domainGenerator == null) {
                throw new RuntimeException("Failed to find domain generator: " + domainName);
            }
            return this.getTypeData(domainName, typeName).get(direction).resolve(this, domainGenerator);
        }

        void addTypeToGenerate(StandaloneTypeBinding binding) {
            this.typesToGenerate.add(binding);
        }

        public void generateRequestedTypes() throws IOException {
            int i = 0;
            while (i < this.typesToGenerate.size()) {
                this.typesToGenerate.get(i).generate();
                ++i;
            }
            for (TypeData typeData : this.map.values()) {
                typeData.checkComplete();
            }
        }

        TypeData getTypeData(String domainName, String typeName) {
            List<String> key = this.createKey(domainName, typeName);
            TypeData result = this.map.get(key);
            if (result == null) {
                result = new TypeData(domainName, typeName);
                this.map.put(key, result);
            }
            return result;
        }

        private List<String> createKey(String domainName, String typeName) {
            return Arrays.asList(domainName, typeName);
        }
    }

    private static interface TypeVisitor<R> {
        public R visitRef(String var1);

        public R visitBoolean();

        public R visitEnum(List<String> var1);

        public R visitString();

        public R visitInteger();

        public R visitNumber();

        public R visitArray(WipMetamodel.ArrayItemType var1);

        public R visitObject(List<WipMetamodel.ObjectProperty> var1);

        public R visitUnknown();
    }

    private static abstract class TypedObjectAccess<T> {
        static final TypedObjectAccess<WipMetamodel.Parameter> FOR_PARAMETER = new TypedObjectAccess<WipMetamodel.Parameter>(){

            @Override
            String getDescription(WipMetamodel.Parameter obj) {
                return obj.description();
            }

            @Override
            Boolean getOptional(WipMetamodel.Parameter obj) {
                return obj.optional();
            }

            @Override
            String getRef(WipMetamodel.Parameter obj) {
                return obj.ref();
            }

            @Override
            List<String> getEnum(WipMetamodel.Parameter obj) {
                return obj.getEnum();
            }

            @Override
            String getType(WipMetamodel.Parameter obj) {
                return obj.type();
            }

            @Override
            WipMetamodel.ArrayItemType getItems(WipMetamodel.Parameter obj) {
                return obj.items();
            }

            @Override
            List<WipMetamodel.ObjectProperty> getProperties(WipMetamodel.Parameter obj) {
                return obj.properties();
            }
        };
        static final TypedObjectAccess<WipMetamodel.ObjectProperty> FOR_OBJECT_PROPERTY = new TypedObjectAccess<WipMetamodel.ObjectProperty>(){

            @Override
            String getDescription(WipMetamodel.ObjectProperty obj) {
                return obj.description();
            }

            @Override
            Boolean getOptional(WipMetamodel.ObjectProperty obj) {
                return obj.optional();
            }

            @Override
            String getRef(WipMetamodel.ObjectProperty obj) {
                return obj.ref();
            }

            @Override
            List<String> getEnum(WipMetamodel.ObjectProperty obj) {
                return obj.getEnum();
            }

            @Override
            String getType(WipMetamodel.ObjectProperty obj) {
                return obj.type();
            }

            @Override
            WipMetamodel.ArrayItemType getItems(WipMetamodel.ObjectProperty obj) {
                return obj.items();
            }

            @Override
            List<WipMetamodel.ObjectProperty> getProperties(WipMetamodel.ObjectProperty obj) {
                throw new RuntimeException();
            }
        };
        static final TypedObjectAccess<WipMetamodel.ArrayItemType> FOR_ARRAY_ITEM = new TypedObjectAccess<WipMetamodel.ArrayItemType>(){

            @Override
            String getDescription(WipMetamodel.ArrayItemType obj) {
                return obj.description();
            }

            @Override
            Boolean getOptional(WipMetamodel.ArrayItemType obj) {
                return obj.optional();
            }

            @Override
            String getRef(WipMetamodel.ArrayItemType obj) {
                return obj.ref();
            }

            @Override
            List<String> getEnum(WipMetamodel.ArrayItemType obj) {
                return obj.getEnum();
            }

            @Override
            String getType(WipMetamodel.ArrayItemType obj) {
                return obj.type();
            }

            @Override
            WipMetamodel.ArrayItemType getItems(WipMetamodel.ArrayItemType obj) {
                return obj.items();
            }

            @Override
            List<WipMetamodel.ObjectProperty> getProperties(WipMetamodel.ArrayItemType obj) {
                return obj.properties();
            }
        };
        static final TypedObjectAccess<WipMetamodel.StandaloneType> FOR_STANDALONE = new TypedObjectAccess<WipMetamodel.StandaloneType>(){

            @Override
            String getDescription(WipMetamodel.StandaloneType obj) {
                return obj.description();
            }

            @Override
            Boolean getOptional(WipMetamodel.StandaloneType obj) {
                return null;
            }

            @Override
            String getRef(WipMetamodel.StandaloneType obj) {
                return null;
            }

            @Override
            List<String> getEnum(WipMetamodel.StandaloneType obj) {
                return obj.getEnum();
            }

            @Override
            String getType(WipMetamodel.StandaloneType obj) {
                return obj.type();
            }

            @Override
            WipMetamodel.ArrayItemType getItems(WipMetamodel.StandaloneType obj) {
                return obj.items();
            }

            @Override
            List<WipMetamodel.ObjectProperty> getProperties(WipMetamodel.StandaloneType obj) {
                return obj.properties();
            }
        };

        private TypedObjectAccess() {
        }

        abstract String getDescription(T var1);

        abstract Boolean getOptional(T var1);

        abstract String getRef(T var1);

        abstract List<String> getEnum(T var1);

        abstract String getType(T var1);

        abstract WipMetamodel.ArrayItemType getItems(T var1);

        abstract List<WipMetamodel.ObjectProperty> getProperties(T var1);
    }

    private static class UnqualifiedTypeData {
        private final BoxableType typeRef;
        private final boolean nullable;
        static final UnqualifiedTypeData BOOLEAN = new UnqualifiedTypeData(BoxableType.BOOLEAN, false);
        static final UnqualifiedTypeData STRING = new UnqualifiedTypeData(BoxableType.STRING, false);
        static final UnqualifiedTypeData LONG = new UnqualifiedTypeData(BoxableType.LONG, false);
        static final UnqualifiedTypeData NUMBER = new UnqualifiedTypeData(BoxableType.NUMBER, false);
        static final UnqualifiedTypeData ANY = new UnqualifiedTypeData(BoxableType.OBJECT, true);

        UnqualifiedTypeData(String typeRefText) {
            this(BoxableType.createReference(typeRefText));
        }

        UnqualifiedTypeData(BoxableType typeRef) {
            this(typeRef, false);
        }

        UnqualifiedTypeData(BoxableType typeRef, boolean nullable) {
            this.typeRef = typeRef;
            this.nullable = nullable;
        }

        QualifiedTypeData getQualifiedType(boolean optional) {
            BoxableType ref = optional ? this.typeRef.convertToPureReference() : this.typeRef;
            return new QualifiedTypeData(ref, optional, this.nullable);
        }
    }
}

