/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.jpa.core.context;

/**
 * Specified column
 * <p>
 * Provisional API: This interface is part of an interim API that is still
 * under development and expected to change significantly before reaching
 * stability. It is available at this early stage to solicit feedback from
 * pioneering adopters on the understanding that any code that uses this API
 * will almost certainly be broken (repeatedly) as the API evolves.
 * 
 * @version 2.2
 * @since 2.0
 */
public interface SpecifiedColumn
	extends SpecifiedBaseColumn, Column
{
	/**
	 * @see org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedAttributeOverride#initializeFrom(org.eclipse.jpt.jpa.core.context.java.JavaVirtualAttributeOverride)
	 * @see org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedAttributeOverride#initializeFrom(org.eclipse.jpt.jpa.core.context.orm.OrmVirtualAttributeOverride)
	 */
	void initializeFrom(VirtualColumn virtualColumn);

	void setSpecifiedLength(Integer length);

	void setSpecifiedPrecision(Integer precision);

	void setSpecifiedScale(Integer scale);
}
