/*******************************************************************************
 * Copyright (c) 2013 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.common.utility.internal.transformer;

import org.eclipse.jpt.common.utility.factory.Factory;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/**
 * Adapt a {@link Factory} to the {@link Transformer} interface.
 * 
 * @param <I> input: the type of the object passed to the transformer;
 *     ignored
 * @param <O> output: the type of the object returned by the transformer;
 *     as generated by the factory
 * 
 * @see org.eclipse.jpt.common.utility.internal.factory.TransformerFactory
 */
public class FactoryTransformer<I, O>
	implements Transformer<I, O>
{
	private final Factory<? extends O> factory;

	public FactoryTransformer(Factory<? extends O> factory) {
		super();
		if (factory == null) {
			throw new NullPointerException();
		}
		this.factory = factory;
	}

	public O transform(I input) {
		return this.factory.create();
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this, this.factory);
	}
}
