/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.Set;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateOneToOneRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ICreateUniDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.HasReferanceRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.OneToOneUniDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class CreateOneToOneUniDirRelationFeature
extends CreateOneToOneRelationFeature
implements ICreateUniDirRelationFeature {
    public CreateOneToOneUniDirRelationFeature(IJPAEditorFeatureProvider fp, boolean isDerivedIdFeature) {
        super(fp, JPAEditorMessages.CreateOneToOneUniDirRelationFeature_oneToOneUniDirFeatureName, JPAEditorMessages.CreateOneToOneUniDirRelationFeature_oneToOneUniDirFeatureDescription, isDerivedIdFeature);
    }

    @Override
    public OneToOneUniDirRelation createRelation(IJPAEditorFeatureProvider fp, PictogramElement source, PictogramElement target, PersistentType embeddingEntity) {
        String name;
        PersistentType owner = (PersistentType)this.getBusinessObjectForPictogramElement(source);
        PersistentType inverse = (PersistentType)this.getBusinessObjectForPictogramElement(target);
        String nameWithNonCapitalLetter = name = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(inverse));
        if (JpaArtifactFactory.instance().isMethodAnnotated(owner)) {
            nameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(name);
        }
        String attribTxt = JPAEditorUtil.produceUniqueAttributeName(owner, nameWithNonCapitalLetter);
        OneToOneUniDirRelation res = new OneToOneUniDirRelation(fp, owner, inverse, attribTxt, true, this.isDerivedIdFeature);
        return res;
    }

    public String getCreateImageId() {
        if (this.isDerivedIdFeature) {
            return "org.eclipse.jpt.jpadiagrameditor.ui.one_to_one_1_key_relation";
        }
        return "org.eclipse.jpt.jpadiagrameditor.ui.one_to_one_1_dir_relation";
    }

    @Override
    protected boolean isRelationshipPossible() {
        if (JpaArtifactFactory.instance().isEmbeddable(this.owner)) {
            Set<HasReferanceRelation> refs = JpaArtifactFactory.instance().findAllHasReferenceRelsByEmbeddableWithEntity(this.owner, this.getFeatureProvider());
            if (refs.isEmpty()) {
                return false;
            }
            for (HasReferanceRelation ref : refs) {
                AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ref.getEmbeddedAnnotatedAttribute());
                if (!(attributeMapping instanceof EmbeddedIdMapping)) continue;
                return false;
            }
        }
        return true;
    }
}

