/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.logging.Level;
import javax.ws.rs.core.MediaType;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.jpa.rs.DataStorage;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.logging.LoggingLocalization;
import org.eclipse.persistence.jpa.rs.util.MethodExitLogData;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.sessions.Session;

public class JPARSLogger {
    private static final SessionLog defaultLog = AbstractSessionLog.getLog();

    public static void entering(String sourceClass, String sourceMethod, Object[] params) {
        JPARSLogger.entering(defaultLog, sourceClass, sourceMethod, params);
    }

    public static void entering(SessionLog sessionLog, String sourceClass, String sourceMethod, Object[] params) {
        if (JPARSLogger.isLoggableFinest(sessionLog)) {
            SessionLogEntry sle = JPARSLogger.newLogEntry(sessionLog.getSession());
            sle.setSourceClassName(sourceClass);
            sle.setSourceMethodName(sourceMethod);
            sle.setMessage("ENTRY {0}");
            sle.setParameters(JPARSLogger.getParamsWithAdditionalInfo(params));
            sessionLog.log(sle);
        }
    }

    public static void entering(String sourceClass, String sourceMethod, InputStream in) {
        JPARSLogger.entering(defaultLog, sourceClass, sourceMethod, in);
    }

    public static void entering(SessionLog sessionLog, String sourceClass, String sourceMethod, InputStream in) {
        if (JPARSLogger.isLoggableFinest(sessionLog) && in.markSupported()) {
            try {
                String data = JPARSLogger.readData(in);
                in.reset();
                if (data != null) {
                    SessionLogEntry sle = JPARSLogger.newLogEntry(sessionLog.getSession());
                    sle.setSourceClassName(sourceClass);
                    sle.setSourceMethodName(sourceMethod);
                    sle.setMessage("ENTRY {0}");
                    sle.setParameters(JPARSLogger.getParamsWithAdditionalInfo(new Object[]{data}));
                    sessionLog.log(sle);
                }
            }
            catch (Throwable throwable) {
                JPARSLogger.exception(throwable.getMessage(), new Object[0], throwable);
            }
        }
    }

    public static void exiting(String sourceClass, String sourceMethod, Object[] params) {
        JPARSLogger.exiting(defaultLog, sourceClass, sourceMethod, params);
    }

    public static void exiting(SessionLog sessionLog, String sourceClass, String sourceMethod, Object[] params) {
        if (JPARSLogger.isLoggableFinest()) {
            try {
                SessionLogEntry sle = JPARSLogger.newLogEntry(sessionLog.getSession());
                sle.setSourceClassName(sourceClass);
                sle.setSourceMethodName(sourceMethod);
                sle.setMessage("RETURN {0}");
                sle.setParameters(new Object[]{new MethodExitLogData(JPARSLogger.getParamsWithAdditionalInfo(params))});
                sessionLog.log(sle);
            }
            catch (Throwable throwable) {
                JPARSLogger.exception(throwable.getMessage(), new Object[0], throwable);
            }
        }
    }

    public static void exiting(String sourceClass, String sourceMethod, PersistenceContext context, Object object, MediaType mediaType) {
        JPARSLogger.exiting(defaultLog, sourceClass, sourceMethod, context, object, mediaType);
    }

    public static void exiting(SessionLog sessionLog, String sourceClass, String sourceMethod, PersistenceContext context, Object object, MediaType mediaType) {
        if (JPARSLogger.isLoggableFinest(sessionLog) && context != null && object != null && mediaType != null) {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                context.marshall(object, mediaType, outputStream, true);
                if (object instanceof PersistenceWeavedRest) {
                    JPARSLogger.exiting(sessionLog, sourceClass, sourceMethod, new Object[]{object.getClass().getName(), outputStream.toString(StandardCharsets.UTF_8.name())});
                } else {
                    JPARSLogger.exiting(sessionLog, sourceClass, sourceMethod, new Object[]{outputStream.toString(StandardCharsets.UTF_8.name())});
                }
            }
            catch (Throwable throwable) {
                JPARSLogger.exception(throwable.getMessage(), new Object[0], throwable);
            }
        }
    }

    public static void finest(String message, Object[] params) {
        JPARSLogger.finest(defaultLog, message, params);
    }

    public static void finest(SessionLog sessionLog, String message, Object[] params) {
        JPARSLogger.log(sessionLog, 1, message, JPARSLogger.getParamsWithAdditionalInfo(params));
    }

    public static void fine(String message, Object[] params) {
        JPARSLogger.fine(defaultLog, message, params);
    }

    public static void fine(SessionLog sessionLog, String message, Object[] params) {
        JPARSLogger.log(sessionLog, 3, message, JPARSLogger.getParamsWithAdditionalInfo(params));
    }

    public static void warning(String message, Object[] params) {
        JPARSLogger.warning(defaultLog, message, params);
    }

    public static void warning(SessionLog sessionLog, String message, Object[] params) {
        JPARSLogger.log(sessionLog, 6, message, JPARSLogger.getParamsWithAdditionalInfo(params));
    }

    public static void error(String message, Object[] params) {
        JPARSLogger.error(defaultLog, message, params);
    }

    public static void error(SessionLog sessionLog, String message, Object[] params) {
        JPARSLogger.log(sessionLog, 7, message, JPARSLogger.getParamsWithAdditionalInfo(params));
    }

    public static void exception(String message, Object[] params, Throwable exc) {
        JPARSLogger.exception(defaultLog, message, params, exc);
    }

    public static void exception(SessionLog sessionLog, String message, Object[] params, Throwable exc) {
        JPARSLogger.log(sessionLog, 7, message, JPARSLogger.getParamsWithAdditionalInfo(params), exc);
    }

    public static void setLogLevel(Level level) {
        JPARSLogger.setLogLevel(defaultLog, AbstractSessionLog.translateStringToLoggingLevel((String)level.getName()));
    }

    public static void setLogLevel(SessionLog sessionLog, int level) {
        sessionLog.setLevel(level, "jpars");
    }

    public static boolean isLoggableFinest() {
        return JPARSLogger.isLoggableFinest(defaultLog);
    }

    public static boolean isLoggableFinest(SessionLog sessionLog) {
        return sessionLog.shouldLog(1, "jpars");
    }

    private static Object[] getParamsWithAdditionalInfo(Object[] params) {
        String requestId = (String)DataStorage.get("requestId");
        if (params != null) {
            Object[] paramsWithRequestId = new Object[params.length + 1];
            paramsWithRequestId[0] = requestId;
            System.arraycopy(params, 0, paramsWithRequestId, 1, params.length);
            return paramsWithRequestId;
        }
        return new Object[]{requestId};
    }

    private static void log(SessionLog sessionLog, int level, String message, Object[] params) {
        JPARSLogger.log(sessionLog, level, message, params, null);
    }

    private static void log(SessionLog sessionLog, int level, String message, Object[] params, Throwable t) {
        Objects.requireNonNull(sessionLog);
        if (sessionLog.shouldLog(level, "jpars")) {
            SessionLogEntry sle = JPARSLogger.newLogEntry(sessionLog.getSession());
            sle.setLevel(level);
            sle.setMessage(LoggingLocalization.buildMessage(message, params));
            sle.setParameters(params);
            sle.setException(t);
            sessionLog.log(sle);
        }
    }

    private static SessionLogEntry newLogEntry(Session session) {
        SessionLogEntry entry = session instanceof AbstractSession ? new SessionLogEntry((AbstractSession)session) : new SessionLogEntry(null);
        entry.setLevel(1);
        entry.setNameSpace("jpars");
        entry.setShouldTranslate(false);
        return entry;
    }

    private static String readData(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ByteArrayInputStream bais = null;
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        byte[] bytes = buffer.toByteArray();
        bais = new ByteArrayInputStream(bytes);
        return JPARSLogger.getDataFromInputStream(bais);
    }

    private static String getDataFromInputStream(InputStream is) {
        StringBuilder sb = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return sb.toString();
    }
}

