/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.tests.model;

import junit.framework.TestCase;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleSheet;
import org.eclipse.wst.html.core.tests.utils.FileUtil;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TestForNPEInCSSCreation
extends TestCase {
    public void testCSSModel() {
        IDOMModel model = FileUtil.createHTMLModel();
        try {
            IStructuredDocument structuredDocument = model.getStructuredDocument();
            structuredDocument.set(this.getHTMLDocumentText());
            IDOMDocument doc = model.getDocument();
            NodeList list = doc.getElementsByTagName("HEAD");
            Element head = (Element)list.item(0);
            Element ele = doc.createElement("STYLE");
            ele.setAttribute("type", "text/css");
            String delim = model.getStructuredDocument().getLineDelimiter();
            if (delim == null) {
                delim = "\n";
            }
            StringBuffer buffer = new StringBuffer(delim);
            buffer.append("<!--");
            buffer.append(delim);
            buffer.append("-->");
            buffer.append(delim);
            Text text = doc.createTextNode(buffer.toString());
            ele.appendChild(text);
            head.insertBefore(ele, null);
            ICSSStyleSheet sheet = (ICSSStyleSheet)((IStyleSheetAdapter)((INodeNotifier)ele).getAdapterFor(IStyleSheetAdapter.class)).getSheet();
            ICSSStyleRule rule = sheet.createCSSStyleRule();
            rule.getStyle().setProperty("background-color", "lime", "");
            rule.getStyle().setProperty("background-color", "blue", "");
            rule.getStyle().setProperty("background-color", "#0080ff", "");
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    private String getHTMLDocumentText() {
        return "<html><head></head><body></body></html>";
    }
}

