/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.deque;

import org.eclipse.jpt.common.utility.internal.deque.AbstractArrayDeque;

public class ArrayDeque<E>
extends AbstractArrayDeque<E> {
    private static final long serialVersionUID = 1L;

    public ArrayDeque(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public void enqueueTail(E element) {
        this.ensureCapacity(this.size + 1);
        super.enqueueTail(element);
    }

    @Override
    public void enqueueHead(E element) {
        this.ensureCapacity(this.size + 1);
        super.enqueueHead(element);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elements.length;
        if (oldCapacity < minCapacity) {
            int newCapacity = (oldCapacity * 3 >> 1) + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elements = this.copyElements(newCapacity);
            this.head = 0;
            this.tail = this.size;
        }
    }

    public void trimToSize() {
        if (this.elements.length > this.size) {
            this.elements = this.copyElements(this.size);
            this.head = 0;
            this.tail = this.size;
        }
    }

    @Override
    public ArrayDeque<E> clone() {
        return (ArrayDeque)super.clone();
    }
}

