/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.ArrayTools;
import org.eclipse.jpt.utility.internal.Range;
import org.eclipse.jpt.utility.internal.ReflectionTools;
import org.eclipse.jpt.utility.internal.ReverseComparator;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayToolsTests
extends TestCase {
    public ArrayToolsTests(String name) {
        super(name);
    }

    public void testNewArrayObjectArray() {
        Object[] array1 = new String[2];
        String[] array2 = (String[])ArrayTools.newArray((Object[])array1);
        array2[0] = "foo";
        array2[1] = "bar";
        ArrayToolsTests.assertEquals(String.class, array2.getClass().getComponentType());
        ArrayToolsTests.assertEquals((int)2, (int)array2.length);
    }

    public void testNewArrayObjectArrayInt() {
        Object[] array1 = new String[2];
        String[] array2 = (String[])ArrayTools.newArray((Object[])array1, (int)5);
        array2[0] = "foo";
        array2[4] = "bar";
        ArrayToolsTests.assertEquals(String.class, array2.getClass().getComponentType());
        ArrayToolsTests.assertEquals((int)5, (int)array2.length);
    }

    public void testNewArrayObjectArrayInt_Exception() {
        Object[] array1 = new String[2];
        Object[] array2 = ArrayTools.newArray((Object[])array1, (int)5);
        boolean exCaught = false;
        try {
            array2[1] = 7;
            ArrayToolsTests.fail((String)("bogus array: " + Arrays.toString(array2)));
        }
        catch (ArrayStoreException arrayStoreException) {
            exCaught = true;
        }
        ArrayToolsTests.assertTrue((boolean)exCaught);
    }

    public void testComponentType() {
        Object[] array = new String[2];
        Class javaClass = ArrayTools.componentType((Object[])array);
        ArrayToolsTests.assertEquals(String.class, (Object)javaClass);
    }

    public void testNewArrayClassInt() {
        String[] array = (String[])ArrayTools.newArray(String.class, (int)5);
        array[0] = "foo";
        array[4] = "bar";
        ArrayToolsTests.assertEquals(String.class, array.getClass().getComponentType());
        ArrayToolsTests.assertEquals((int)5, (int)array.length);
    }

    public void testNewArrayClassInt_Exception() {
        Object[] array = ArrayTools.newArray(String.class, (int)5);
        boolean exCaught = false;
        try {
            array[1] = 7;
            ArrayToolsTests.fail((String)("bogus array: " + Arrays.toString(array)));
        }
        catch (ArrayStoreException arrayStoreException) {
            exCaught = true;
        }
        ArrayToolsTests.assertTrue((boolean)exCaught);
    }

    public void testNewArrayClassInt_Primitive() {
        boolean exCaught = false;
        try {
            Object[] array = ArrayTools.newArray(Integer.TYPE, (int)5);
            ArrayToolsTests.fail((String)("bogus array: " + Arrays.toString(array)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ArrayToolsTests.assertTrue((boolean)exCaught);
    }

    public void testArrayIterable() {
        List<String> iterable = this.buildStringList1();
        Object[] a = ArrayTools.array(iterable);
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIterableInt() {
        List<String> iterable = this.buildStringList1();
        Object[] a = ArrayTools.array(iterable, (int)3);
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIterableObjectArray_String() {
        List<String> iterable = this.buildStringList1();
        Object[] a = (String[])ArrayTools.array(iterable, (Object[])new String[0]);
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIterableObjectArray_Object() {
        List<String> iterable = this.buildStringList1();
        Object[] a = ArrayTools.array(iterable, (Object[])new Object[0]);
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIterableIntObjectArray() {
        List<String> iterable = this.buildStringList1();
        Object[] a = (String[])ArrayTools.array(iterable, (int)3, (Object[])new String[0]);
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIterator() {
        Object[] a = ArrayTools.array(this.buildStringList1().iterator());
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIterator_Empty() {
        Object[] a = ArrayTools.array((Iterator)EmptyIterator.instance());
        ArrayToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testArrayIteratorInt() {
        Object[] a = ArrayTools.array(this.buildStringList1().iterator(), (int)3);
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIteratorInt_Empty() {
        Object[] a = ArrayTools.array((Iterator)EmptyIterator.instance(), (int)3);
        ArrayToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testArrayIteratorObjectArray_String() {
        Object[] a = (String[])ArrayTools.array(this.buildStringList1().iterator(), (Object[])new String[0]);
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIteratorObjectArray_Empty() {
        String[] a = (String[])ArrayTools.array((Iterator)EmptyIterator.instance(), (Object[])new String[0]);
        ArrayToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testArrayIteratorObjectArray_Empty_ClearArray() {
        String[] a = (String[])ArrayTools.array((Iterator)EmptyIterator.instance(), (Object[])new String[5]);
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertNull((Object)a[0]);
    }

    public void testArrayIteratorObjectArray_Object() {
        Object[] a = ArrayTools.array(this.buildStringList1().iterator(), (Object[])new Object[0]);
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIteratorIntObjectArray() {
        Object[] a = (String[])ArrayTools.array(this.buildStringList1().iterator(), (int)3, (Object[])new String[0]);
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])a, this.buildStringList1().iterator()));
    }

    public void testArrayIteratorIntObjectArray_Empty() {
        String[] a = (String[])ArrayTools.array((Iterator)EmptyIterator.instance(), (int)3, (Object[])new String[0]);
        ArrayToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testAddObjectArrayObject_Object() {
        Object[] a = ArrayTools.add((Object[])this.buildObjectArray1(), (Object)"twenty");
        ArrayToolsTests.assertEquals((int)4, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"twenty"));
        ArrayToolsTests.assertEquals((Object)"twenty", (Object)a[a.length - 1]);
    }

    public void testAddObjectArrayObject_String() {
        Object[] a = (String[])ArrayTools.add((Object[])this.buildStringArray1(), (Object)"twenty");
        ArrayToolsTests.assertEquals((int)4, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"twenty"));
        ArrayToolsTests.assertEquals((String)"twenty", (String)a[a.length - 1]);
    }

    public void testAddObjectArrayObject_EmptyArray() {
        Object[] a = new String[]{};
        a = (String[])ArrayTools.add((Object[])a, (Object)"twenty");
        ArrayToolsTests.assertEquals((int)1, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"twenty"));
        ArrayToolsTests.assertEquals((String)"twenty", (String)a[0]);
    }

    public void testAddObjectArrayIntObject_Object() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = ArrayTools.add((Object[])a, (int)2, (Object)"X");
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"X"));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "X", "c", "d"}, a));
    }

    public void testAddObjectArrayIntObject_String() {
        Object[] a = new String[]{"a", "b", "c", "d"};
        a = (String[])ArrayTools.add((Object[])a, (int)2, (Object)"X");
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"X"));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "X", "c", "d"}, a));
    }

    public void testAddObjectArrayIntObject_End() {
        Object[] a = new String[]{"a", "b", "c", "d"};
        a = (String[])ArrayTools.add((Object[])a, (int)4, (Object)"X");
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"X"));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "c", "d", "X"}, a));
    }

    public void testAddObjectArrayIntObject_Zero() {
        Object[] a = new String[]{"a", "b", "c", "d"};
        a = (String[])ArrayTools.add((Object[])a, (int)0, (Object)"X");
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"X"));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"X", "a", "b", "c", "d"}, a));
    }

    public void testAddObjectArrayIntObject_Exception() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        boolean exCaught = false;
        try {
            a = ArrayTools.add((Object[])a, (int)33, (Object)"X");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        ArrayToolsTests.assertTrue((boolean)exCaught);
    }

    public void testAddCharArrayChar() {
        char[] a = ArrayTools.add((char[])this.buildCharArray(), (char)'d');
        ArrayToolsTests.assertEquals((int)4, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'d'));
    }

    public void testAddCharArrayChar_Empty() {
        char[] a = new char[]{};
        a = ArrayTools.add((char[])a, (char)'d');
        ArrayToolsTests.assertEquals((int)1, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'d'));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'d'}, a));
    }

    public void testAddCharArrayIntChar() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = ArrayTools.add((char[])a, (int)2, (char)'X');
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'X'));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'X', 'c', 'd'}, a));
    }

    public void testAddCharArrayIntChar_Zero() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = ArrayTools.add((char[])a, (int)0, (char)'X');
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'X'));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'X', 'a', 'b', 'c', 'd'}, a));
    }

    public void testAddCharArrayIntChar_End() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = ArrayTools.add((char[])a, (int)4, (char)'X');
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'X'));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'c', 'd', 'X'}, a));
    }

    public void testAddIntArrayInt() {
        int[] a = ArrayTools.add((int[])this.buildIntArray(), (int)30);
        ArrayToolsTests.assertEquals((int)4, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)30));
    }

    public void testAddIntArrayInt_Empty() {
        int[] a = new int[]{};
        a = ArrayTools.add((int[])a, (int)30);
        ArrayToolsTests.assertEquals((int)1, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)30));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{30}, a));
    }

    public void testAddIntArrayIntInt() {
        int[] a = new int[]{1, 2, 3, 4};
        a = ArrayTools.add((int[])a, (int)2, (int)99);
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)99));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 99, 3, 4}, a));
    }

    public void testAddIntArrayIntInt_Zero() {
        int[] a = new int[]{1, 2, 3, 4};
        a = ArrayTools.add((int[])a, (int)0, (int)99);
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)99));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{99, 1, 2, 3, 4}, a));
    }

    public void testAddIntArrayIntInt_End() {
        int[] a = new int[]{1, 2, 3, 4};
        a = ArrayTools.add((int[])a, (int)4, (int)99);
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)99));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3, 4, 99}, a));
    }

    public void testAddAllObjectArrayCollection_String() {
        Object[] a = this.buildStringArray1();
        List<String> c = this.buildStringList2();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, c);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, c));
    }

    public void testAddAllObjectArrayCollection_Object() {
        Object[] a = this.buildObjectArray1();
        List<String> c = this.buildStringList2();
        Object[] newArray = ArrayTools.addAll((Object[])a, c);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, c));
    }

    public void testAddAllObjectArrayCollection_EmptyArray() {
        Object[] a = new String[]{};
        List<String> c = this.buildStringList2();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, c);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, c));
    }

    public void testAddAllObjectArrayCollection_EmptyCollection() {
        Object[] a = this.buildStringArray1();
        ArrayList c = new ArrayList();
        String[] newArray = (String[])ArrayTools.addAll((Object[])a, c);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
    }

    public void testAddAllObjectArrayIntCollection_String() {
        Object[] a = this.buildStringArray1();
        List<String> c = this.buildStringList2();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)1, c);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, c));
    }

    public void testAddAllObjectArrayIntCollection_String_End() {
        Object[] a = this.buildStringArray1();
        List<String> c = this.buildStringList2();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)3, c);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, c));
    }

    public void testAddAllObjectArrayIntCollection_EmptyArray() {
        Object[] a = new String[]{};
        List<String> c = this.buildStringList2();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)0, c);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, c));
    }

    public void testAddAllObjectArrayIntCollection_EmptyArray_Exception() {
        Object[] a = new String[]{};
        List<String> c = this.buildStringList2();
        boolean exCaught = false;
        try {
            Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)3, c);
            ArrayToolsTests.fail((String)("bogus array: " + Arrays.toString(newArray)));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        ArrayToolsTests.assertTrue((boolean)exCaught);
    }

    public void testAddAllObjectArrayIntCollection_EmptyCollection() {
        Object[] a = this.buildStringArray1();
        ArrayList c = new ArrayList();
        String[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)1, c);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
    }

    public void testAddAllObjectArrayIntIterable_String() {
        Object[] a = this.buildStringArray1();
        List<String> iterable = this.buildStringList2();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)1, iterable);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, iterable));
    }

    public void testAddAllObjectArrayIntIterable_EmptyArray() {
        Object[] a = new String[]{};
        List<String> iterable = this.buildStringList2();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)0, iterable);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, iterable));
    }

    public void testAddAllObjectArrayIntIterable_EmptyIterable() {
        Object[] a = this.buildStringArray1();
        ArrayList iterable = new ArrayList();
        String[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)1, iterable);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
    }

    public void testAddAllObjectArrayIntIterableInt_String() {
        Object[] a = this.buildStringArray1();
        List<String> iterable = this.buildStringList2();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)1, iterable, (int)3);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, iterable));
    }

    public void testAddAllObjectArrayIntIterableInt_EmptyArray() {
        Object[] a = new String[]{};
        List<String> iterable = this.buildStringList2();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)0, iterable, (int)3);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, iterable));
    }

    public void testAddAllObjectArrayIntIterableInt_EmptyIterable() {
        Object[] a = this.buildStringArray1();
        ArrayList iterable = new ArrayList();
        String[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)1, iterable, (int)0);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
    }

    public void testAddAllObjectArrayIntIterator_String() {
        Object[] a = this.buildStringArray1();
        Iterator<String> iterator = this.buildStringList2().iterator();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)1, iterator);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, this.buildStringList2()));
    }

    public void testAddAllObjectArrayIntIterator_EmptyArray() {
        Object[] a = new String[]{};
        Iterator<String> iterator = this.buildStringList2().iterator();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)0, iterator);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, this.buildStringList2()));
    }

    public void testAddAllObjectArrayIntIterator_EmptyIterable() {
        Object[] a = this.buildStringArray1();
        Iterator iterator = EmptyIterator.instance();
        String[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)1, (Iterator)iterator);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
    }

    public void testAddAllObjectArrayIntIteratorInt_String() {
        Object[] a = this.buildStringArray1();
        Iterator<String> iterator = this.buildStringList2().iterator();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)1, iterator, (int)3);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, this.buildStringList2()));
    }

    public void testAddAllObjectArrayIntIteratorInt_EmptyArray() {
        Object[] a = new String[]{};
        Iterator<String> iterator = this.buildStringList2().iterator();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)0, iterator, (int)3);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, this.buildStringList2()));
    }

    public void testAddAllObjectArrayIntIteratorInt_EmptyIterator() {
        Object[] a = this.buildStringArray1();
        Iterator iterator = EmptyIterator.instance();
        String[] newArray = (String[])ArrayTools.addAll((Object[])a, (int)1, (Iterator)iterator, (int)0);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
    }

    public void testAddAllObjectArrayIterable() {
        Object[] a = this.buildStringArray1();
        List<String> iterable = this.buildStringList1();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, iterable);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, this.buildStringList1()));
    }

    public void testAddAllObjectArrayIterableInt() {
        Object[] a = this.buildStringArray1();
        List<String> iterable = this.buildStringList1();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, iterable, (int)33);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, this.buildStringList1()));
    }

    public void testAddAllObjectArrayIterator_String() {
        Object[] a = this.buildStringArray1();
        Iterator<String> iterator = this.buildStringList1().iterator();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, iterator);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, this.buildStringList1()));
    }

    public void testAddAllObjectArrayIterator_Object() {
        Object[] a = this.buildStringArray1();
        Iterator<Object> iterator = this.buildObjectList1().iterator();
        Object[] newArray = ArrayTools.addAll((Object[])a, iterator);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, this.buildObjectList1()));
    }

    public void testAddAllObjectArrayIterator_EmptyIterator() {
        Object[] a = this.buildStringArray1();
        Iterator iterator = EmptyIterator.instance();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (Iterator)iterator);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, this.buildStringList1()));
    }

    public void testAddAllObjectArrayIteratorInt() {
        Object[] a = this.buildStringArray1();
        Iterator<Object> iterator = this.buildObjectList1().iterator();
        Object[] newArray = ArrayTools.addAll((Object[])a, iterator, (int)3);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, this.buildObjectList1()));
    }

    public void testAddAllObjectArrayIteratorInt_EmptyIterator() {
        Object[] a = this.buildStringArray1();
        Iterator iterator = EmptyIterator.instance();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a, (Iterator)iterator, (int)0);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, this.buildStringList1()));
    }

    public void testAddAllObjectArrayObjectArray_Object() {
        Object[] a1 = this.buildObjectArray1();
        Object[] a2 = this.buildObjectArray2();
        Object[] newArray = ArrayTools.addAll((Object[])a1, (Object[])a2);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, (Object[])a1));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, (Object[])a2));
    }

    public void testAddAllObjectArrayObjectArray_String() {
        Object[] a1 = this.buildStringArray1();
        Object[] a2 = this.buildStringArray2();
        Object[] newArray = (String[])ArrayTools.addAll((Object[])a1, (Object[])a2);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, (Object[])a1));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, (Object[])a2));
    }

    public void testAddAllObjectArrayObjectArray_ObjectString() {
        Object[] a1 = this.buildObjectArray1();
        Object[] a2 = this.buildStringArray2();
        Object[] newArray = ArrayTools.addAll((Object[])a1, (Object[])a2);
        ArrayToolsTests.assertEquals((int)6, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, (Object[])a1));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, (Object[])a2));
    }

    public void testAddAllObjectArrayObjectArray_EmptyArray1() {
        Object[] a1 = new Object[]{};
        Object[] a2 = this.buildObjectArray2();
        Object[] newArray = ArrayTools.addAll((Object[])a1, (Object[])a2);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, (Object[])a2));
    }

    public void testAddAllObjectArrayObjectArray_EmptyArray2() {
        Object[] a1 = this.buildObjectArray1();
        Object[] a2 = new Object[]{};
        Object[] newArray = ArrayTools.addAll((Object[])a1, (Object[])a2);
        ArrayToolsTests.assertEquals((int)3, (int)newArray.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])newArray, (Object[])a1));
    }

    public void testAddAllObjectArrayIntObjectArray_Object() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = ArrayTools.addAll((Object[])a, (int)2, (Object[])new Object[]{"X", "X", "X"});
        ArrayToolsTests.assertEquals((int)7, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"X"));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "X", "X", "X", "c", "d"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray_String() {
        Object[] a = new String[]{"a", "b", "c", "d"};
        a = (String[])ArrayTools.addAll((Object[])a, (int)2, (Object[])new String[]{"X", "X", "X"});
        ArrayToolsTests.assertEquals((int)7, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"X"));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"a", "b", "X", "X", "X", "c", "d"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray_ObjectString() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = ArrayTools.addAll((Object[])a, (int)2, (Object[])new String[]{"X", "X", "X"});
        ArrayToolsTests.assertEquals((int)7, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"X"));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "X", "X", "X", "c", "d"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray_End() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = ArrayTools.addAll((Object[])a, (int)4, (Object[])new String[]{"X", "X", "X"});
        ArrayToolsTests.assertEquals((int)7, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"X"));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "c", "d", "X", "X", "X"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray_Zero() {
        Object[] a = new Object[]{};
        a = ArrayTools.addAll((Object[])a, (int)0, (Object[])new String[]{"X", "X", "X"});
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"X"));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"X", "X", "X"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray_EmptyArray2() {
        Object[] a = new Object[]{"a", "b", "c", "d"};
        a = ArrayTools.addAll((Object[])a, (int)4, (Object[])new String[0]);
        ArrayToolsTests.assertEquals((int)4, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "c", "d"}, a));
    }

    public void testAddAllObjectArrayIntObjectArray_EmptyArray1() {
        Object[] a = new String[]{};
        a = ArrayTools.addAll((Object[])a, (int)0, (Object[])new Object[]{"a", "b", "c", "d"});
        ArrayToolsTests.assertEquals((int)4, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"a", "b", "c", "d"}, a));
    }

    public void testAddAllCharArrayCharArray() {
        char[] a = ArrayTools.addAll((char[])this.buildCharArray(), (char[])new char[]{'d', 'e'});
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'d'));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'e'));
    }

    public void testAddAllCharArrayCharArray_EmptyArray2() {
        char[] a = ArrayTools.addAll((char[])this.buildCharArray(), (char[])new char[0]);
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
    }

    public void testAddAllCharArrayCharArrayEmptyArray1() {
        char[] a = ArrayTools.addAll((char[])new char[0], (char[])new char[]{'d', 'e'});
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'d'));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'e'));
    }

    public void testAddAllCharArrayIntCharArray() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = ArrayTools.addAll((char[])a, (int)2, (char[])new char[]{'X', 'X', 'X'});
        ArrayToolsTests.assertEquals((int)7, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'X'));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'X', 'X', 'X', 'c', 'd'}, a));
    }

    public void testAddAllCharArrayIntCharArray_End() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = ArrayTools.addAll((char[])a, (int)4, (char[])new char[]{'X', 'X', 'X'});
        ArrayToolsTests.assertEquals((int)7, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'X'));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'c', 'd', 'X', 'X', 'X'}, a));
    }

    public void testAddAllCharArrayIntCharArray_EmptyArray1() {
        char[] a = new char[]{};
        a = ArrayTools.addAll((char[])a, (int)0, (char[])new char[]{'X', 'X', 'X'});
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'X'));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'X', 'X', 'X'}, a));
    }

    public void testAddAllCharArrayIntCharArray_EmptyArray2() {
        char[] a = new char[]{'a', 'b', 'c', 'd'};
        a = ArrayTools.addAll((char[])a, (int)2, (char[])new char[0]);
        ArrayToolsTests.assertEquals((int)4, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'c', 'd'}, a));
    }

    public void testAddAllIntArrayIntArray() {
        int[] a = ArrayTools.addAll((int[])this.buildIntArray(), (int[])new int[]{30, 40});
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)30));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)40));
    }

    public void testAddAllIntArrayIntArray_EmptyArray2() {
        int[] a = ArrayTools.addAll((int[])this.buildIntArray(), (int[])new int[0]);
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
    }

    public void testAddAllIntArrayIntArray_EmptyArray1() {
        int[] a = ArrayTools.addAll((int[])new int[0], (int[])new int[]{30, 40});
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)30));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)40));
    }

    public void testAddAllIntArrayIntIntArray() {
        int[] a = new int[]{1, 2, 3, 4};
        a = ArrayTools.addAll((int[])a, (int)2, (int[])new int[]{99, 99, 99});
        ArrayToolsTests.assertEquals((int)7, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)99));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 99, 99, 99, 3, 4}, a));
    }

    public void testAddAllIntArrayIntIntArray_End() {
        int[] a = new int[]{1, 2, 3, 4};
        a = ArrayTools.addAll((int[])a, (int)4, (int[])new int[]{99, 99, 99});
        ArrayToolsTests.assertEquals((int)7, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)99));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3, 4, 99, 99, 99}, a));
    }

    public void testAddAllIntArrayIntIntArray_EmptyArray2() {
        int[] a = new int[]{1, 2, 3, 4};
        a = ArrayTools.addAll((int[])a, (int)2, (int[])new int[0]);
        ArrayToolsTests.assertEquals((int)4, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 2, 3, 4}, a));
    }

    public void testAddAllIntArrayIntIntArray_EmptyArray1() {
        int[] a = new int[]{};
        a = ArrayTools.addAll((int[])a, (int)0, (int[])new int[]{99, 99, 99});
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)99));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{99, 99, 99}, a));
    }

    public void testClearObjectArray() {
        Object[] a = this.buildStringArray1();
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        a = (String[])ArrayTools.clear((Object[])a);
        ArrayToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testClearObjectArray_Empty() {
        Object[] a = new String[]{};
        ArrayToolsTests.assertEquals((int)0, (int)a.length);
        a = (String[])ArrayTools.clear((Object[])a);
        ArrayToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testConcatenateObjectArrayArray() {
        String[] aArray = new String[]{"a", "b", "c", "d"};
        String[] eArray = new String[]{"e", "f", "g", "h"};
        String[] iArray = new String[]{"i", "j", "k", "l"};
        Object[] expected = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l"};
        Object[] actual = (String[])ArrayTools.concatenate((Object[][])new String[][]{aArray, eArray, iArray});
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    public void testConcatenateObjectArrayArray_Empty() {
        String[] aArray = new String[]{};
        String[] eArray = new String[]{};
        String[] iArray = new String[]{};
        Object[] expected = new String[]{};
        Object[] actual = (String[])ArrayTools.concatenate((Object[][])new String[][]{aArray, eArray, iArray});
        ArrayToolsTests.assertEquals((int)0, (int)actual.length);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    public void testConcatenateCharArrayArray() {
        char[] aArray = new char[]{'a', 'b', 'c', 'd'};
        char[] eArray = new char[]{'e', 'f', 'g', 'h'};
        char[] iArray = new char[]{'i', 'j', 'k', 'l'};
        char[] expected = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l'};
        char[] actual = ArrayTools.concatenate((char[][])new char[][]{aArray, eArray, iArray});
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    public void testConcatenateCharArrayArray_Empty() {
        char[] aArray = new char[]{};
        char[] eArray = new char[]{};
        char[] iArray = new char[]{};
        char[] expected = new char[]{};
        char[] actual = ArrayTools.concatenate((char[][])new char[][]{aArray, eArray, iArray});
        ArrayToolsTests.assertEquals((int)0, (int)actual.length);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    public void testConcatenateIntArrayArray() {
        int[] aArray = new int[]{97, 98, 99, 100};
        int[] eArray = new int[]{101, 102, 103, 104};
        int[] iArray = new int[]{105, 106, 107, 108};
        int[] expected = new int[]{97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108};
        int[] actual = ArrayTools.concatenate((int[][])new int[][]{aArray, eArray, iArray});
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    public void testConcatenateIntArrayArray_Empty() {
        int[] aArray = new int[]{};
        int[] eArray = new int[]{};
        int[] iArray = new int[]{};
        int[] expected = new int[]{};
        int[] actual = ArrayTools.concatenate((int[][])new int[][]{aArray, eArray, iArray});
        ArrayToolsTests.assertEquals((int)0, (int)actual.length);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(expected, actual));
    }

    public void testContainsObjectArrayObject() {
        Object[] a = this.buildObjectArray1();
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"one"));
        ArrayToolsTests.assertFalse((boolean)ArrayTools.contains((Object[])a, null));
        Object[] a2 = ArrayTools.add((Object[])a, null);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a2, null));
    }

    public void testContainsObjectArrayObject_EmptyArray() {
        Object[] a = new Object[]{};
        ArrayToolsTests.assertFalse((boolean)ArrayTools.contains((Object[])a, (Object)"one"));
        ArrayToolsTests.assertFalse((boolean)ArrayTools.contains((Object[])a, null));
    }

    public void testContainsCharArrayChar() {
        char[] a = this.buildCharArray();
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'a'));
        ArrayToolsTests.assertFalse((boolean)ArrayTools.contains((char[])a, (char)'z'));
        char[] a2 = ArrayTools.add((char[])a, (char)'z');
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a2, (char)'z'));
    }

    public void testContainsCharArrayObject_EmptyArray() {
        char[] a = new char[]{};
        ArrayToolsTests.assertFalse((boolean)ArrayTools.contains((char[])a, (char)'a'));
    }

    public void testContainsIntArrayInt() {
        int[] a = this.buildIntArray();
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)10));
        ArrayToolsTests.assertFalse((boolean)ArrayTools.contains((int[])a, (int)55));
        int[] a2 = ArrayTools.add((int[])a, (int)55);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a2, (int)55));
    }

    public void testContainsIntArrayObject_EmptyArray() {
        int[] a = new int[]{};
        ArrayToolsTests.assertFalse((boolean)ArrayTools.contains((int[])a, (int)97));
    }

    public void testContainsAllObjectArrayCollection() {
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])this.buildObjectArray1(), this.buildStringList1()));
        ArrayToolsTests.assertFalse((boolean)ArrayTools.containsAll((Object[])this.buildObjectArray1(), this.buildStringList2()));
    }

    public void testContainsAllObjectArrayIterable() {
        List<String> iterable = this.buildStringList1();
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])this.buildObjectArray1(), iterable));
        iterable = this.buildStringList2();
        ArrayToolsTests.assertFalse((boolean)ArrayTools.containsAll((Object[])this.buildObjectArray1(), iterable));
    }

    public void testContainsAllObjectArrayIterator() {
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])this.buildObjectArray1(), this.buildStringList1().iterator()));
        ArrayToolsTests.assertFalse((boolean)ArrayTools.containsAll((Object[])this.buildObjectArray1(), this.buildStringList2().iterator()));
    }

    public void testContainsAllObjectArrayIterator_Empty() {
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])this.buildObjectArray1(), (Iterator)EmptyIterator.instance()));
    }

    public void testContainsAllObjectArrayObjectArray() {
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])this.buildObjectArray1(), (Object[])this.buildObjectArray1()));
        ArrayToolsTests.assertFalse((boolean)ArrayTools.containsAll((Object[])this.buildObjectArray1(), (Object[])this.buildObjectArray2()));
    }

    public void testContainsAllCharArrayCharArray() {
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((char[])this.buildCharArray(), (char[])this.buildCharArray()));
        ArrayToolsTests.assertFalse((boolean)ArrayTools.containsAll((char[])this.buildCharArray(), (char[])new char[]{'x', 'y'}));
    }

    public void testContainsAllIntArrayIntArray() {
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((int[])this.buildIntArray(), (int[])this.buildIntArray()));
        ArrayToolsTests.assertFalse((boolean)ArrayTools.containsAll((int[])this.buildIntArray(), (int[])new int[]{444, 888}));
    }

    public void testDiffEnd() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = new String("a");
        String b_ = new String("b");
        String c_ = new String("c");
        String d_ = new String("d");
        String e_ = new String("e");
        ArrayToolsTests.assertTrue((a != a_ && a.equals(a_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((b != b_ && b.equals(b_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((c != c_ && c.equals(c_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((d != d_ && d.equals(d_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((e != e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)4, (int)ArrayTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)4, (int)ArrayTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)4, (int)ArrayTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        ArrayToolsTests.assertEquals((int)4, (int)ArrayTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        ArrayToolsTests.assertEquals((int)2, (int)ArrayTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.diffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        ArrayToolsTests.assertEquals((int)3, (int)ArrayTools.diffEnd((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        ArrayToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.diffEnd((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)2, (int)ArrayTools.diffEnd((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.diffEnd((Object[])array1, (Object[])array2));
    }

    public void testDiffRange() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        ArrayToolsTests.assertTrue((a == a_ && a.equals(a_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((b == b_ && b.equals(b_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((c == c_ && c.equals(c_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((d == d_ && d.equals(d_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(5, -1), (Object)ArrayTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        ArrayToolsTests.assertEquals((Object)new Range(1, -1), (Object)ArrayTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(0, 4), (Object)ArrayTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(0, 4), (Object)ArrayTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(0, 4), (Object)ArrayTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        ArrayToolsTests.assertEquals((Object)new Range(0, 4), (Object)ArrayTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        ArrayToolsTests.assertEquals((Object)new Range(0, -1), (Object)ArrayTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(0, 2), (Object)ArrayTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(0, 0), (Object)ArrayTools.diffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        ArrayToolsTests.assertEquals((Object)new Range(3, 3), (Object)ArrayTools.diffRange((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        ArrayToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(5, -1), (Object)ArrayTools.diffRange((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(2, 2), (Object)ArrayTools.diffRange((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        ArrayToolsTests.assertEquals((Object)new Range(5, -1), (Object)ArrayTools.diffRange((Object[])array1, (Object[])array2));
    }

    public void testDiffStart() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = new String("a");
        String b_ = new String("b");
        String c_ = new String("c");
        String d_ = new String("d");
        String e_ = new String("e");
        ArrayToolsTests.assertTrue((a != a_ && a.equals(a_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((b != b_ && b.equals(b_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((c != c_ && c.equals(c_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((d != d_ && d.equals(d_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((e != e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)5, (int)ArrayTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        ArrayToolsTests.assertEquals((int)1, (int)ArrayTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d};
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)4, (int)ArrayTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_};
        ArrayToolsTests.assertEquals((int)4, (int)ArrayTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, e_, c_, d_};
        ArrayToolsTests.assertEquals((int)2, (int)ArrayTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        ArrayToolsTests.assertEquals((int)3, (int)ArrayTools.diffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.diffStart((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        ArrayToolsTests.assertTrue((c != c__ && c.equals(c__) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        ArrayToolsTests.assertEquals((int)5, (int)ArrayTools.diffStart((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)2, (int)ArrayTools.diffStart((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        ArrayToolsTests.assertEquals((int)5, (int)ArrayTools.diffStart((Object[])array1, (Object[])array2));
    }

    public void testIdentityDiffEnd() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        ArrayToolsTests.assertTrue((a == a_ && a.equals(a_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((b == b_ && b.equals(b_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((c == c_ && c.equals(c_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((d == d_ && d.equals(d_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)4, (int)ArrayTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)4, (int)ArrayTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)4, (int)ArrayTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        ArrayToolsTests.assertEquals((int)4, (int)ArrayTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        ArrayToolsTests.assertEquals((int)2, (int)ArrayTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.identityDiffEnd((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        ArrayToolsTests.assertEquals((int)3, (int)ArrayTools.identityDiffEnd((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        ArrayToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        ArrayToolsTests.assertEquals((int)2, (int)ArrayTools.identityDiffEnd((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)2, (int)ArrayTools.identityDiffEnd((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.identityDiffEnd((Object[])array1, (Object[])array2));
    }

    public void testIdentityDiffRange() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        ArrayToolsTests.assertTrue((a == a_ && a.equals(a_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((b == b_ && b.equals(b_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((c == c_ && c.equals(c_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((d == d_ && d.equals(d_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(5, -1), (Object)ArrayTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        ArrayToolsTests.assertEquals((Object)new Range(1, -1), (Object)ArrayTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(0, 4), (Object)ArrayTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(0, 4), (Object)ArrayTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(0, 4), (Object)ArrayTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        ArrayToolsTests.assertEquals((Object)new Range(0, 4), (Object)ArrayTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        ArrayToolsTests.assertEquals((Object)new Range(0, -1), (Object)ArrayTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{b_, c_, a_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(0, 2), (Object)ArrayTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(0, 0), (Object)ArrayTools.identityDiffRange((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        ArrayToolsTests.assertEquals((Object)new Range(3, 3), (Object)ArrayTools.identityDiffRange((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        ArrayToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(2, 2), (Object)ArrayTools.identityDiffRange((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((Object)new Range(2, 2), (Object)ArrayTools.identityDiffRange((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        ArrayToolsTests.assertEquals((Object)new Range(5, -1), (Object)ArrayTools.identityDiffRange((Object[])array1, (Object[])array2));
    }

    public void testIdentityDiffStart() {
        String a = "a";
        String b = "b";
        String c = "c";
        String d = "d";
        String e = "e";
        String a_ = a;
        String b_ = b;
        String c_ = c;
        String d_ = d;
        String e_ = e;
        ArrayToolsTests.assertTrue((a == a_ && a.equals(a_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((b == b_ && b.equals(b_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((c == c_ && c.equals(c_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((d == d_ && d.equals(d_) ? 1 : 0) != 0);
        ArrayToolsTests.assertTrue((e == e_ && e.equals(e_) ? 1 : 0) != 0);
        Object[] array1 = new String[]{a, b, c, d, e};
        Object[] array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)5, (int)ArrayTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a};
        array2 = new String[]{a_};
        ArrayToolsTests.assertEquals((int)1, (int)ArrayTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d};
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)4, (int)ArrayTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c_, d_};
        ArrayToolsTests.assertEquals((int)4, (int)ArrayTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{};
        array2 = new String[]{};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, e_, c_, d_};
        ArrayToolsTests.assertEquals((int)2, (int)ArrayTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{a, b, c, e};
        array2 = new String[]{a_, b_, c_, d_};
        ArrayToolsTests.assertEquals((int)3, (int)ArrayTools.identityDiffStart((Object[])array1, (Object[])array2));
        array1 = new String[]{b, c, d, e};
        array2 = new String[]{a_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.identityDiffStart((Object[])array1, (Object[])array2));
        String c__ = new String(c);
        ArrayToolsTests.assertTrue((c != c__ && c.equals(c_) ? 1 : 0) != 0);
        array1 = new String[]{a, b, c, d, e};
        array2 = new String[]{a_, b_, c__, d_, e_};
        ArrayToolsTests.assertEquals((int)2, (int)ArrayTools.identityDiffStart((Object[])array1, (Object[])array2));
        String[] stringArray = new String[5];
        stringArray[0] = a;
        stringArray[1] = b;
        stringArray[3] = d;
        stringArray[4] = e;
        array1 = stringArray;
        array2 = new String[]{a_, b_, c_, d_, e_};
        ArrayToolsTests.assertEquals((int)2, (int)ArrayTools.identityDiffStart((Object[])array1, (Object[])array2));
        String[] stringArray2 = new String[5];
        stringArray2[0] = a;
        stringArray2[1] = b;
        stringArray2[3] = d;
        stringArray2[4] = e;
        array1 = stringArray2;
        String[] stringArray3 = new String[5];
        stringArray3[0] = a_;
        stringArray3[1] = b_;
        stringArray3[3] = d_;
        stringArray3[4] = e_;
        array2 = stringArray3;
        ArrayToolsTests.assertEquals((int)5, (int)ArrayTools.identityDiffStart((Object[])array1, (Object[])array2));
    }

    public void testElementsAreIdenticalObjectArrayObjectArray() {
        Object[] a1 = new Object[4];
        int i = 0;
        while (i < a1.length) {
            a1[i] = String.valueOf(i * 1000);
            ++i;
        }
        Object[] a2 = new Object[a1.length];
        int i2 = 0;
        while (i2 < a2.length) {
            a2[i2] = a1[i2];
            ++i2;
        }
        ArrayToolsTests.assertTrue((boolean)ArrayTools.elementsAreIdentical((Object[])a1, (Object[])a2));
        a2[2] = "2000";
        ArrayToolsTests.assertFalse((boolean)ArrayTools.elementsAreIdentical((Object[])a1, (Object[])a2));
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testElementsAreIdenticalObjectArrayObjectArray_BothNull() {
        Object[] a1 = null;
        Object[] a2 = null;
        ArrayToolsTests.assertTrue((boolean)ArrayTools.elementsAreIdentical((Object[])a1, (Object[])a2));
    }

    public void testElementsAreIdenticalObjectArrayObjectArray_OneNull() {
        Object[] a1 = null;
        Object[] a2 = new Object[]{};
        ArrayToolsTests.assertFalse((boolean)ArrayTools.elementsAreIdentical((Object[])a1, (Object[])a2));
    }

    public void testElementsAreIdenticalObjectArrayObjectArray_DifferentLengths() {
        Object[] a1 = new String[]{"foo", "bar"};
        Object[] a2 = new String[]{"foo", "bar", "baz"};
        ArrayToolsTests.assertFalse((boolean)ArrayTools.elementsAreIdentical((Object[])a1, (Object[])a2));
    }

    public void testIndexOfObjectArrayObject() {
        Object[] a = this.buildObjectArray1();
        ArrayToolsTests.assertEquals((int)1, (int)ArrayTools.indexOf((Object[])a, (Object)"one"));
    }

    public void testIndexOfObjectArrayObject_NotFound() {
        Object[] a = this.buildObjectArray1();
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.indexOf((Object[])a, (Object)"twenty"));
    }

    public void testIndexOfObjectArrayObject_Null() {
        Object[] a = this.buildObjectArray1();
        a = ArrayTools.add((Object[])a, null);
        ArrayToolsTests.assertEquals((int)(a.length - 1), (int)ArrayTools.indexOf((Object[])a, null));
    }

    public void testIndexOfObjectArrayObject_Null_NotFound() {
        Object[] a = this.buildObjectArray1();
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.indexOf((Object[])a, null));
    }

    public void testIdentityIndexOfObjectArrayObject() {
        String foo = "foo";
        String bar = "bar";
        String baz = "baz";
        Object[] a = new Object[]{foo, bar, baz};
        ArrayToolsTests.assertEquals((int)1, (int)ArrayTools.identityIndexOf((Object[])a, (Object)bar));
    }

    public void testIdentityIndexOfObjectArrayObject_NotFound() {
        String foo = "foo";
        String bar = "bar";
        String baz = "baz";
        Object[] a = new Object[]{foo, bar, baz};
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.identityIndexOf((Object[])a, (Object)new String("bar")));
    }

    public void testIndexOfCharArrayChar() {
        char[] a = this.buildCharArray();
        ArrayToolsTests.assertEquals((int)1, (int)ArrayTools.indexOf((char[])a, (char)'b'));
        a = ArrayTools.add((char[])a, (char)'d');
        ArrayToolsTests.assertEquals((int)(a.length - 1), (int)ArrayTools.indexOf((char[])a, (char)'d'));
    }

    public void testIndexOfCharArrayChar_NotFound() {
        char[] a = this.buildCharArray();
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.indexOf((char[])a, (char)'z'));
    }

    public void testIndexOfIntArrayInt() {
        int[] a = this.buildIntArray();
        ArrayToolsTests.assertEquals((int)1, (int)ArrayTools.indexOf((int[])a, (int)10));
        a = ArrayTools.add((int[])a, (int)30);
        ArrayToolsTests.assertEquals((int)(a.length - 1), (int)ArrayTools.indexOf((int[])a, (int)30));
    }

    public void testIndexOfIntArrayInt_NotFound() {
        int[] a = this.buildIntArray();
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.indexOf((int[])a, (int)1000));
    }

    public void testInsertionIndexOfObjectArrayComparable() {
        String[] a = new String[]{"A", "C", "D"};
        ArrayToolsTests.assertEquals((int)1, (int)ArrayTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"B")));
        a = new String[]{"A", "B", "C", "D"};
        ArrayToolsTests.assertEquals((int)2, (int)ArrayTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"B")));
        a = new String[]{"A", "B", "B", "B", "C", "D"};
        ArrayToolsTests.assertEquals((int)4, (int)ArrayTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"B")));
        a = new String[]{"A", "B", "B", "B", "C", "D"};
        ArrayToolsTests.assertEquals((int)6, (int)ArrayTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"E")));
        a = new String[]{"B", "B", "B", "C", "D"};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"A")));
        a = new String[]{"A", "A", "B", "B", "C", "D"};
        ArrayToolsTests.assertEquals((int)2, (int)ArrayTools.insertionIndexOf((Comparable[])a, (Comparable)((Object)"A")));
    }

    public void testInsertionIndexOfObjectArrayObjectComparator() {
        ReverseComparator c = new ReverseComparator();
        Object[] a = new String[]{"D", "C", "A"};
        ArrayToolsTests.assertEquals((int)2, (int)ArrayTools.insertionIndexOf((Object[])a, (Object)"B", (Comparator)c));
        a = new String[]{"D", "C", "B", "A"};
        ArrayToolsTests.assertEquals((int)3, (int)ArrayTools.insertionIndexOf((Object[])a, (Object)"B", (Comparator)c));
        a = new String[]{"D", "C", "B", "B", "B", "A"};
        ArrayToolsTests.assertEquals((int)5, (int)ArrayTools.insertionIndexOf((Object[])a, (Object)"B", (Comparator)c));
        a = new String[]{"D", "C", "B", "B", "B", "A"};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.insertionIndexOf((Object[])a, (Object)"E", (Comparator)c));
        a = new String[]{"D", "C", "B", "B", "B"};
        ArrayToolsTests.assertEquals((int)5, (int)ArrayTools.insertionIndexOf((Object[])a, (Object)"A", (Comparator)c));
        a = new String[]{"D", "C", "B", "B", "A", "A"};
        ArrayToolsTests.assertEquals((int)6, (int)ArrayTools.insertionIndexOf((Object[])a, (Object)"A", (Comparator)c));
    }

    public void testLastIndexOfObjectArrayObject() {
        Object[] a = this.buildObjectArray1();
        ArrayToolsTests.assertEquals((int)1, (int)ArrayTools.lastIndexOf((Object[])a, (Object)"one"));
    }

    public void testLastIndexOfObjectArrayObject_NotFound() {
        Object[] a = this.buildObjectArray1();
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.lastIndexOf((Object[])a, (Object)"twenty"));
    }

    public void testLastIndexOfObjectArrayObject_Null() {
        Object[] a = this.buildObjectArray1();
        a = ArrayTools.add((Object[])a, null);
        ArrayToolsTests.assertEquals((int)(a.length - 1), (int)ArrayTools.lastIndexOf((Object[])a, null));
    }

    public void testLastIndexOfObjectArrayObject_Null_NotFound() {
        Object[] a = this.buildObjectArray1();
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.lastIndexOf((Object[])a, null));
    }

    public void testLastIndexOfCharArrayChar() {
        char[] a = this.buildCharArray();
        ArrayToolsTests.assertEquals((int)1, (int)ArrayTools.lastIndexOf((char[])a, (char)'b'));
        a = ArrayTools.add((char[])a, (char)'d');
        ArrayToolsTests.assertEquals((int)(a.length - 1), (int)ArrayTools.lastIndexOf((char[])a, (char)'d'));
    }

    public void testLastIndexOfCharArrayChar_NotFound() {
        char[] a = this.buildCharArray();
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.lastIndexOf((char[])a, (char)'z'));
    }

    public void testLastIndexOfIntArrayInt() {
        int[] a = this.buildIntArray();
        ArrayToolsTests.assertEquals((int)1, (int)ArrayTools.lastIndexOf((int[])a, (int)10));
        a = ArrayTools.add((int[])a, (int)30);
        ArrayToolsTests.assertEquals((int)(a.length - 1), (int)ArrayTools.lastIndexOf((int[])a, (int)30));
    }

    public void testLastIndexOfIntArrayInt_NotFound() {
        int[] a = this.buildIntArray();
        ArrayToolsTests.assertEquals((int)-1, (int)ArrayTools.lastIndexOf((int[])a, (int)1000));
    }

    public void testMinCharArray() {
        ArrayToolsTests.assertEquals((char)'a', (char)ArrayTools.min((char[])this.buildCharArray()));
    }

    public void testMinCharArray_Exception() {
        char[] array = new char[]{};
        boolean exCaught = false;
        try {
            char c = ArrayTools.min((char[])array);
            ArrayToolsTests.fail((String)("bogus char: " + c));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        ArrayToolsTests.assertTrue((boolean)exCaught);
    }

    public void testMinIntArray() {
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.min((int[])this.buildIntArray()));
    }

    public void testMinIntArray_Exception() {
        int[] array = new int[]{};
        boolean exCaught = false;
        try {
            int i = ArrayTools.min((int[])array);
            ArrayToolsTests.fail((String)("bogus int: " + i));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        ArrayToolsTests.assertTrue((boolean)exCaught);
    }

    public void testMaxCharArray1() {
        ArrayToolsTests.assertEquals((char)'c', (char)ArrayTools.max((char[])this.buildCharArray()));
    }

    public void testMaxCharArray2() {
        char[] array = new char[]{'x', 'a', 'b', 'c'};
        ArrayToolsTests.assertEquals((char)'x', (char)ArrayTools.max((char[])array));
    }

    public void testMaxCharArray_Exception() {
        char[] array = new char[]{};
        boolean exCaught = false;
        try {
            char c = ArrayTools.max((char[])array);
            ArrayToolsTests.fail((String)("bogus char: " + c));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        ArrayToolsTests.assertTrue((boolean)exCaught);
    }

    public void testMaxIntArray1() {
        ArrayToolsTests.assertEquals((int)20, (int)ArrayTools.max((int[])this.buildIntArray()));
    }

    public void testMaxIntArray2() {
        int[] array = new int[]{77, 3, 1, -3};
        ArrayToolsTests.assertEquals((int)77, (int)ArrayTools.max((int[])array));
    }

    public void testMaxIntArray_Exception() {
        int[] array = new int[]{};
        boolean exCaught = false;
        try {
            int i = ArrayTools.max((int[])array);
            ArrayToolsTests.fail((String)("bogus int: " + i));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            exCaught = true;
        }
        ArrayToolsTests.assertTrue((boolean)exCaught);
    }

    public void testMoveObjectArrayIntInt() {
        Object[] array = new String[]{"0", "1", "2", "3", "4", "5"};
        Object[] result = (String[])ArrayTools.move((Object[])array, (int)4, (int)2);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result));
        result = (String[])ArrayTools.move((Object[])array, (int)0, (int)5);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result));
        result = (String[])ArrayTools.move((Object[])array, (int)2, (int)4);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result));
        result = (String[])ArrayTools.move((Object[])array, (int)4, (int)4);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result));
    }

    public void testMoveObjectArrayIntIntInt() {
        Object[] array = new String[]{"0", "1", "2", "3", "4", "5"};
        Object[] result = (String[])ArrayTools.move((Object[])array, (int)4, (int)2, (int)1);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "1", "3", "4", "2", "5"}, result));
        result = (String[])ArrayTools.move((Object[])array, (int)0, (int)5, (int)1);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "1", "3", "4", "2"}, result));
        result = (String[])ArrayTools.move((Object[])array, (int)2, (int)4, (int)1);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "4", "1", "3", "2"}, result));
        result = (String[])ArrayTools.move((Object[])array, (int)2, (int)4, (int)2);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result));
        result = (String[])ArrayTools.move((Object[])array, (int)0, (int)1, (int)4);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"0", "3", "2", "4", "5", "1"}, result));
        result = (String[])ArrayTools.move((Object[])array, (int)1, (int)0, (int)4);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result));
        result = (String[])ArrayTools.move((Object[])array, (int)1, (int)1, (int)4);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result));
        result = (String[])ArrayTools.move((Object[])array, (int)1, (int)0, (int)0);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"5", "0", "3", "2", "4", "1"}, result));
    }

    public void testMoveIntArrayIntInt() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        int[] array = nArray;
        int[] result = ArrayTools.move((int[])array, (int)4, (int)2);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray2 = new int[6];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 4;
        nArray2[4] = 2;
        nArray2[5] = 5;
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(nArray2, result));
        result = ArrayTools.move((int[])array, (int)0, (int)5);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray3 = new int[6];
        nArray3[0] = 5;
        nArray3[2] = 1;
        nArray3[3] = 3;
        nArray3[4] = 4;
        nArray3[5] = 2;
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(nArray3, result));
        result = ArrayTools.move((int[])array, (int)2, (int)4);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray4 = new int[6];
        nArray4[0] = 5;
        nArray4[2] = 4;
        nArray4[3] = 1;
        nArray4[4] = 3;
        nArray4[5] = 2;
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(nArray4, result));
        result = ArrayTools.move((int[])array, (int)2, (int)2);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray5 = new int[6];
        nArray5[0] = 5;
        nArray5[2] = 4;
        nArray5[3] = 1;
        nArray5[4] = 3;
        nArray5[5] = 2;
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(nArray5, result));
    }

    public void testMoveIntArrayIntIntInt() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        int[] array = nArray;
        int[] result = ArrayTools.move((int[])array, (int)4, (int)2, (int)1);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray2 = new int[6];
        nArray2[1] = 1;
        nArray2[2] = 3;
        nArray2[3] = 4;
        nArray2[4] = 2;
        nArray2[5] = 5;
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(nArray2, result));
        result = ArrayTools.move((int[])array, (int)0, (int)5, (int)1);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray3 = new int[6];
        nArray3[0] = 5;
        nArray3[2] = 1;
        nArray3[3] = 3;
        nArray3[4] = 4;
        nArray3[5] = 2;
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(nArray3, result));
        result = ArrayTools.move((int[])array, (int)2, (int)4, (int)1);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray4 = new int[6];
        nArray4[0] = 5;
        nArray4[2] = 4;
        nArray4[3] = 1;
        nArray4[4] = 3;
        nArray4[5] = 2;
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(nArray4, result));
        result = ArrayTools.move((int[])array, (int)2, (int)4, (int)2);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray5 = new int[6];
        nArray5[0] = 5;
        nArray5[2] = 3;
        nArray5[3] = 2;
        nArray5[4] = 4;
        nArray5[5] = 1;
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(nArray5, result));
        result = ArrayTools.move((int[])array, (int)0, (int)1, (int)4);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray6 = new int[6];
        nArray6[1] = 3;
        nArray6[2] = 2;
        nArray6[3] = 4;
        nArray6[4] = 5;
        nArray6[5] = 1;
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(nArray6, result));
        result = ArrayTools.move((int[])array, (int)1, (int)0, (int)4);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray7 = new int[6];
        nArray7[0] = 5;
        nArray7[2] = 3;
        nArray7[3] = 2;
        nArray7[4] = 4;
        nArray7[5] = 1;
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(nArray7, result));
        result = ArrayTools.move((int[])array, (int)1, (int)1, (int)4);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray8 = new int[6];
        nArray8[0] = 5;
        nArray8[2] = 3;
        nArray8[3] = 2;
        nArray8[4] = 4;
        nArray8[5] = 1;
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(nArray8, result));
        result = ArrayTools.move((int[])array, (int)1, (int)0, (int)0);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        int[] nArray9 = new int[6];
        nArray9[0] = 5;
        nArray9[2] = 3;
        nArray9[3] = 2;
        nArray9[4] = 4;
        nArray9[5] = 1;
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(nArray9, result));
    }

    public void testMoveCharArrayIntInt() {
        char[] array = new char[]{'a', 'b', 'c', 'd', 'e', 'f'};
        char[] result = ArrayTools.move((char[])array, (int)4, (int)2);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'd', 'e', 'c', 'f'}, result));
        result = ArrayTools.move((char[])array, (int)0, (int)5);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'f', 'a', 'b', 'd', 'e', 'c'}, result));
        result = ArrayTools.move((char[])array, (int)2, (int)4);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'f', 'a', 'e', 'b', 'd', 'c'}, result));
        result = ArrayTools.move((char[])array, (int)2, (int)2);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'f', 'a', 'e', 'b', 'd', 'c'}, result));
    }

    public void testMoveCharArrayIntIntInt() {
        char[] array = new char[]{'a', 'b', 'b', 'c', 'd', 'e'};
        char[] result = ArrayTools.move((char[])array, (int)4, (int)2, (int)1);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'b', 'c', 'd', 'b', 'e'}, result));
        result = ArrayTools.move((char[])array, (int)0, (int)5, (int)1);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'e', 'a', 'b', 'c', 'd', 'b'}, result));
        result = ArrayTools.move((char[])array, (int)2, (int)4, (int)1);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'e', 'a', 'd', 'b', 'c', 'b'}, result));
        result = ArrayTools.move((char[])array, (int)2, (int)4, (int)2);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'e', 'a', 'c', 'b', 'd', 'b'}, result));
        result = ArrayTools.move((char[])array, (int)0, (int)1, (int)4);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'a', 'c', 'b', 'd', 'e', 'b'}, result));
        result = ArrayTools.move((char[])array, (int)1, (int)0, (int)4);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'e', 'a', 'c', 'b', 'd', 'b'}, result));
        result = ArrayTools.move((char[])array, (int)1, (int)1, (int)4);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'e', 'a', 'c', 'b', 'd', 'b'}, result));
        result = ArrayTools.move((char[])array, (int)1, (int)0, (int)0);
        ArrayToolsTests.assertSame((Object)array, (Object)result);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'e', 'a', 'c', 'b', 'd', 'b'}, result));
    }

    public void testRemoveObjectArrayObject_Object() {
        Object[] a = this.buildObjectArray1();
        a = ArrayTools.add((Object[])a, (Object)"three");
        a = ArrayTools.add((Object[])a, (Object)"four");
        a = ArrayTools.add((Object[])a, (Object)"five");
        ArrayToolsTests.assertEquals((int)6, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"three"));
        a = ArrayTools.remove((Object[])a, (Object)"three");
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertFalse((boolean)ArrayTools.contains((Object[])a, (Object)"three"));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"four"));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"five"));
    }

    public void testRemoveObjectArrayObject_String() {
        Object[] a = this.buildStringArray1();
        a = (String[])ArrayTools.add((Object[])a, (Object)"three");
        a = (String[])ArrayTools.add((Object[])a, (Object)"four");
        a = (String[])ArrayTools.add((Object[])a, (Object)"five");
        ArrayToolsTests.assertEquals((int)6, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"three"));
        a = (String[])ArrayTools.remove((Object[])a, (Object)"three");
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertFalse((boolean)ArrayTools.contains((Object[])a, (Object)"three"));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"four"));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((Object[])a, (Object)"five"));
    }

    public void testRemoveCharArrayChar() {
        char[] a = this.buildCharArray();
        a = ArrayTools.add((char[])a, (char)'d');
        a = ArrayTools.add((char[])a, (char)'e');
        a = ArrayTools.add((char[])a, (char)'f');
        ArrayToolsTests.assertEquals((int)6, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'d'));
        a = ArrayTools.remove((char[])a, (char)'d');
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertFalse((boolean)ArrayTools.contains((char[])a, (char)'d'));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'e'));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((char[])a, (char)'f'));
    }

    public void testRemoveIntArrayInt() {
        int[] a = this.buildIntArray();
        a = ArrayTools.add((int[])a, (int)30);
        a = ArrayTools.add((int[])a, (int)40);
        a = ArrayTools.add((int[])a, (int)50);
        ArrayToolsTests.assertEquals((int)6, (int)a.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)30));
        a = ArrayTools.remove((int[])a, (int)30);
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        ArrayToolsTests.assertFalse((boolean)ArrayTools.contains((int[])a, (int)30));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)40));
        ArrayToolsTests.assertTrue((boolean)ArrayTools.contains((int[])a, (int)50));
    }

    public void testRemoveAllObjectArrayObjectArray() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a2 = new String[]{"E", "B"};
        Object[] a3 = (String[])ArrayTools.removeAll((Object[])a1, (Object[])a2);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "A", "C", "C", "D", "D", "F", "F"}, a3));
    }

    public void testRemoveAllObjectArrayObjectArray_Empty() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a2 = new String[]{};
        Object[] a3 = (String[])ArrayTools.removeAll((Object[])a1, (Object[])a2);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a3));
    }

    public void testRemoveAllObjectArrayObjectArray_NoMatches() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a2 = new String[]{"X", "Y", "Z"};
        Object[] a3 = (String[])ArrayTools.removeAll((Object[])a1, (Object[])a2);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a3));
    }

    public void testRemoveAllObjectArrayIterable() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        List<String> iterable = Arrays.asList("E", "B");
        Object[] a3 = (String[])ArrayTools.removeAll((Object[])a1, iterable);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "A", "C", "C", "D", "D", "F", "F"}, a3));
    }

    public void testRemoveAllObjectArrayIterableInt() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        List<String> iterable = Arrays.asList("E", "B");
        Object[] a3 = (String[])ArrayTools.removeAll((Object[])a1, iterable, (int)7);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "A", "C", "C", "D", "D", "F", "F"}, a3));
    }

    public void testRemoveAllObjectArrayIterator() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        List<String> iterable = Arrays.asList("E", "B");
        Object[] a3 = (String[])ArrayTools.removeAll((Object[])a1, iterable.iterator());
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "A", "C", "C", "D", "D", "F", "F"}, a3));
    }

    public void testRemoveAllObjectArrayIterator_Empty() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a3 = (String[])ArrayTools.removeAll((Object[])a1, (Iterator)EmptyIterator.instance());
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a3));
    }

    public void testRemoveAllObjectArrayIteratorInt() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        List<String> iterable = Arrays.asList("E", "B");
        Object[] a3 = (String[])ArrayTools.removeAll((Object[])a1, iterable.iterator(), (int)7);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "A", "C", "C", "D", "D", "F", "F"}, a3));
    }

    public void testRemoveAllObjectArrayIteratorInt_Empty() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a3 = (String[])ArrayTools.removeAll((Object[])a1, (Iterator)EmptyIterator.instance(), (int)7);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a3));
    }

    public void testRemoveAllObjectArrayCollection() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        List<String> collection = Arrays.asList("E", "B");
        Object[] a3 = (String[])ArrayTools.removeAll((Object[])a1, collection);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "A", "C", "C", "D", "D", "F", "F"}, a3));
    }

    public void testRemoveAllObjectArrayCollection_Empty() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        ArrayList collection = new ArrayList();
        Object[] a3 = (String[])ArrayTools.removeAll((Object[])a1, collection);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a3));
    }

    public void testRemoveAllObjectArrayCollection_EmptyArray() {
        Object[] a1 = new String[]{};
        List<String> collection = Arrays.asList("E", "B");
        Object[] a3 = (String[])ArrayTools.removeAll((Object[])a1, collection);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a3));
        ArrayToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRemoveAllObjectArrayCollection_NoMatches() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        List<String> collection = Arrays.asList("X", "Y", "Z");
        Object[] a3 = (String[])ArrayTools.removeAll((Object[])a1, collection);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a3));
    }

    public void testRemoveAllCharArrayCharArray() {
        char[] a1 = new char[]{'A', 'A', 'B', 'B', 'C', 'C', 'D', 'D', 'E', 'E', 'F', 'F'};
        char[] a2 = new char[]{'E', 'B'};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'A', 'A', 'C', 'C', 'D', 'D', 'F', 'F'}, ArrayTools.removeAll((char[])a1, (char[])a2)));
    }

    public void testRemoveAllCharArrayCharArray_Empty1() {
        char[] a1 = new char[]{};
        char[] a2 = new char[]{'E', 'B'};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, ArrayTools.removeAll((char[])a1, (char[])a2)));
    }

    public void testRemoveAllCharArrayCharArray_Empty2() {
        char[] a1 = new char[]{'A', 'A', 'B', 'B', 'C', 'C', 'D', 'D', 'E', 'E', 'F', 'F'};
        char[] a2 = new char[]{};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, ArrayTools.removeAll((char[])a1, (char[])a2)));
    }

    public void testRemoveAllCharArrayCharArray_NoMatches() {
        char[] a1 = new char[]{'A', 'A', 'B', 'B', 'C', 'C', 'D', 'D', 'E', 'E', 'F', 'F'};
        char[] a2 = new char[]{'X', 'Z'};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, ArrayTools.removeAll((char[])a1, (char[])a2)));
    }

    public void testRemoveAllIntArrayIntArray() {
        int[] a1 = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        int[] a2 = new int[]{5, 2};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{1, 1, 3, 3, 4, 4, 6, 6}, ArrayTools.removeAll((int[])a1, (int[])a2)));
    }

    public void testRemoveAllIntArrayIntArray_Empty1() {
        int[] a1 = new int[]{};
        int[] a2 = new int[]{5, 2};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, ArrayTools.removeAll((int[])a1, (int[])a2)));
    }

    public void testRemoveAllIntArrayIntArray_Empty2() {
        int[] a1 = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        int[] a2 = new int[]{};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, ArrayTools.removeAll((int[])a1, (int[])a2)));
    }

    public void testRemoveAllIntArrayIntArray_NoMatches() {
        int[] a1 = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        int[] a2 = new int[]{52, 67};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, ArrayTools.removeAll((int[])a1, (int[])a2)));
    }

    public void testRemoveAllOccurrencesObjectArrayObject() {
        Object[] a = this.buildStringArray1();
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        a = (String[])ArrayTools.removeAllOccurrences((Object[])a, (Object)"three");
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        a = (String[])ArrayTools.removeAllOccurrences((Object[])a, (Object)"two");
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])ArrayTools.removeAllOccurrences((Object[])a, (Object)"two");
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])ArrayTools.add((Object[])a, (Object)"five");
        a = (String[])ArrayTools.add((Object[])a, (Object)"five");
        a = (String[])ArrayTools.add((Object[])a, (Object)"five");
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        a = (String[])ArrayTools.removeAllOccurrences((Object[])a, (Object)"five");
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])ArrayTools.removeAllOccurrences((Object[])a, (Object)"five");
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])ArrayTools.add((Object[])a, null);
        a = (String[])ArrayTools.add((Object[])a, null);
        a = (String[])ArrayTools.add((Object[])a, null);
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        a = (String[])ArrayTools.removeAllOccurrences((Object[])a, null);
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
        a = (String[])ArrayTools.removeAllOccurrences((Object[])a, null);
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
    }

    public void testRemoveAllOccurrencesObjectArrayObject_Empty() {
        Object[] a = new String[]{};
        a = (String[])ArrayTools.removeAllOccurrences((Object[])a, (Object)"three");
        ArrayToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testRemoveAllOccurrencesCharArrayChar() {
        char[] a = this.buildCharArray();
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        a = ArrayTools.removeAllOccurrences((char[])a, (char)'d');
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        a = ArrayTools.removeAllOccurrences((char[])a, (char)'b');
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
        a = ArrayTools.removeAllOccurrences((char[])a, (char)'b');
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
        a = ArrayTools.add((char[])a, (char)'g');
        a = ArrayTools.add((char[])a, (char)'g');
        a = ArrayTools.add((char[])a, (char)'g');
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        a = ArrayTools.removeAllOccurrences((char[])a, (char)'g');
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
        a = ArrayTools.removeAllOccurrences((char[])a, (char)'g');
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
    }

    public void testRemoveAllOccurrencesCharArrayChar_Empty() {
        char[] a = new char[]{};
        a = ArrayTools.removeAllOccurrences((char[])a, (char)'a');
        ArrayToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testRemoveAllOccurrencesIntArrayInt() {
        int[] a = this.buildIntArray();
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        a = ArrayTools.removeAllOccurrences((int[])a, (int)55);
        ArrayToolsTests.assertEquals((int)3, (int)a.length);
        a = ArrayTools.removeAllOccurrences((int[])a, (int)10);
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
        a = ArrayTools.removeAllOccurrences((int[])a, (int)10);
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
        a = ArrayTools.add((int[])a, (int)77);
        a = ArrayTools.add((int[])a, (int)77);
        a = ArrayTools.add((int[])a, (int)77);
        ArrayToolsTests.assertEquals((int)5, (int)a.length);
        a = ArrayTools.removeAllOccurrences((int[])a, (int)77);
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
        a = ArrayTools.removeAllOccurrences((int[])a, (int)77);
        ArrayToolsTests.assertEquals((int)2, (int)a.length);
    }

    public void testRemoveAllOccurrencesIntArrayInt_Empty() {
        int[] a = new int[]{};
        a = ArrayTools.removeAllOccurrences((int[])a, (int)22);
        ArrayToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testRemoveDuplicateElementsObjectArray() {
        Vector<String> list = this.buildStringVector1();
        list.add("zero");
        list.add("zero");
        list.add("two");
        list.add("zero");
        String[] array = (String[])ArrayTools.removeDuplicateElements((Object[])list.toArray(new String[list.size()]));
        int i = 0;
        ArrayToolsTests.assertEquals((String)"zero", (String)array[i++]);
        ArrayToolsTests.assertEquals((String)"one", (String)array[i++]);
        ArrayToolsTests.assertEquals((String)"two", (String)array[i++]);
        ArrayToolsTests.assertEquals((int)i, (int)array.length);
    }

    public void testRemoveDuplicateElementsObjectArray_Empty() {
        String[] array = (String[])ArrayTools.removeDuplicateElements((Object[])new String[0]);
        ArrayToolsTests.assertEquals((int)0, (int)array.length);
    }

    public void testRemoveDuplicateElementsObjectArray_SingleElement() {
        String[] array = (String[])ArrayTools.removeDuplicateElements((Object[])new String[]{"foo"});
        ArrayToolsTests.assertEquals((int)1, (int)array.length);
    }

    public void testRemoveDuplicateElementsObjectArray_NoDuplicates() {
        Object[] a1 = new String[]{"foo", "bar", "baz"};
        Object[] a2 = (String[])ArrayTools.removeDuplicateElements((Object[])a1);
        ArrayToolsTests.assertEquals((int)3, (int)a2.length);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testRemoveElementAtIndexObjectArrayInt() {
        Object[] a = new String[]{"A", "B", "A", "C", "A", "D"};
        a = (String[])ArrayTools.removeElementAtIndex((Object[])a, (int)3);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "A", "A", "D"}, a));
    }

    public void testRemoveElementAtIndexCharArrayInt() {
        char[] a = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        a = ArrayTools.removeElementAtIndex((char[])a, (int)3);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'A', 'B', 'A', 'A', 'D'}, a));
    }

    public void testRemoveElementAtIndexIntArrayInt() {
        int[] a = new int[]{8, 6, 7, 33, 2, 11};
        a = ArrayTools.removeElementsAtIndex((int[])a, (int)3, (int)3);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{8, 6, 7}, a));
    }

    public void testRemoveFirstObjectArray() {
        Object[] a = new String[]{"A", "B", "A", "C", "A", "D"};
        a = (String[])ArrayTools.removeFirst((Object[])a);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "A", "C", "A", "D"}, a));
    }

    public void testRemoveFirstCharArray() {
        char[] a = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        a = ArrayTools.removeFirst((char[])a);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'B', 'A', 'C', 'A', 'D'}, a));
    }

    public void testRemoveFirstIntArray() {
        int[] a = new int[]{8, 6, 7, 33, 2, 11};
        a = ArrayTools.removeFirst((int[])a);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{6, 7, 33, 2, 11}, a));
    }

    public void testRemoveLastObjectArray() {
        Object[] a = new String[]{"A", "B", "A", "C", "A", "D"};
        a = (String[])ArrayTools.removeLast((Object[])a);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "A", "C", "A"}, a));
    }

    public void testRemoveLastCharArray() {
        char[] a = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        a = ArrayTools.removeLast((char[])a);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'A', 'B', 'A', 'C', 'A'}, a));
    }

    public void testRemoveLastIntArray() {
        int[] a = new int[]{8, 6, 7, 33, 2, 11};
        a = ArrayTools.removeLast((int[])a);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{8, 6, 7, 33, 2}, a));
    }

    public void testRemoveElementsAtIndexObjectArrayIntInt() {
        Object[] a = new String[]{"A", "B", "A", "C", "A", "D"};
        a = (String[])ArrayTools.removeElementsAtIndex((Object[])a, (int)3, (int)2);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "A", "D"}, a));
    }

    public void testRemoveElementsAtIndexObjectArrayIntInt_ZeroLength() {
        Object[] a1 = new String[]{"A", "B", "A", "C", "A", "D"};
        Object[] a2 = (String[])ArrayTools.removeElementsAtIndex((Object[])a1, (int)3, (int)0);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testRemoveElementsAtIndexObjectArrayIntInt_Empty() {
        Object[] a = new String[]{"A", "B", "A", "C", "A", "D"};
        a = (String[])ArrayTools.removeElementsAtIndex((Object[])a, (int)0, (int)6);
        ArrayToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testRemoveElementsAtIndexCharArrayIntInt() {
        char[] a = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        a = ArrayTools.removeElementsAtIndex((char[])a, (int)0, (int)5);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'D'}, a));
    }

    public void testRemoveElementsAtIndexCharArrayIntInt_ZeroLength() {
        char[] a1 = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        char[] a2 = ArrayTools.removeElementsAtIndex((char[])a1, (int)3, (int)0);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testRemoveElementsAtIndexCharArrayIntInt_Empty() {
        char[] a = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        a = ArrayTools.removeElementsAtIndex((char[])a, (int)0, (int)6);
        ArrayToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testRemoveElementsAtIndexIntArrayIntInt() {
        int[] a = new int[]{8, 6, 7, 33, 2, 11};
        a = ArrayTools.removeElementsAtIndex((int[])a, (int)3, (int)3);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{8, 6, 7}, a));
    }

    public void testRemoveElementsAtIndexIntArrayIntInt_ZeroLength() {
        int[] a1 = new int[]{8, 6, 7, 33, 2, 11};
        int[] a2 = ArrayTools.removeElementsAtIndex((int[])a1, (int)3, (int)0);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testRemoveElementsAtIndexIntArrayIntInt_Empty() {
        int[] a = new int[]{8, 6, 7, 33, 2, 11};
        a = ArrayTools.removeElementsAtIndex((int[])a, (int)0, (int)6);
        ArrayToolsTests.assertEquals((int)0, (int)a.length);
    }

    public void testReplaceAllObjectArrayObjectObject_Object() {
        Object[] a = new Object[]{"A", "B", "A", "C", "A", "D"};
        a = ArrayTools.replaceAll((Object[])a, (Object)"A", (Object)"Z");
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new Object[]{"Z", "B", "Z", "C", "Z", "D"}, a));
    }

    public void testReplaceAllObjectArrayObjectObject_String() {
        Object[] a = new String[]{"A", "B", "A", "C", "A", "D"};
        a = (String[])ArrayTools.replaceAll((Object[])a, (Object)"A", (Object)"Z");
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"Z", "B", "Z", "C", "Z", "D"}, a));
    }

    public void testReplaceAllObjectArrayObjectObject_Null() {
        Object[] objectArray = new String[6];
        objectArray[1] = "B";
        objectArray[3] = "C";
        objectArray[5] = "D";
        Object[] a = objectArray;
        a = (String[])ArrayTools.replaceAll((Object[])a, null, (Object)"Z");
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"Z", "B", "Z", "C", "Z", "D"}, a));
    }

    public void testReplaceAllCharArrayCharChar() {
        char[] a = new char[]{'A', 'B', 'A', 'C', 'A', 'D'};
        a = ArrayTools.replaceAll((char[])a, (char)'A', (char)'Z');
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'Z', 'B', 'Z', 'C', 'Z', 'D'}, a));
    }

    public void testReplaceAllIntArrayIntInt() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[3] = 7;
        nArray[5] = 99;
        int[] a = nArray;
        a = ArrayTools.replaceAll((int[])a, (int)0, (int)13);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{13, 1, 13, 7, 13, 99}, a));
    }

    public void testRetainAllObjectArrayObjectArray() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Object[] a2 = new Object[]{"E", "B", new Integer(7)};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "B", "E", "E"}, ArrayTools.retainAll((Object[])a1, (Object[])a2)));
    }

    public void testRetainAllObjectArrayObjectArray_EmptyObjectArray1() {
        Object[] a1 = new String[]{};
        Object[] a2 = new String[]{"E", "B", ""};
        String[] a3 = (String[])ArrayTools.retainAll((Object[])a1, (Object[])a2);
        ArrayToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayObjectArray_EmptyObjectArray2() {
        Object[] a1 = new String[]{"E", "B", ""};
        Object[] a2 = new String[]{};
        String[] a3 = (String[])ArrayTools.retainAll((Object[])a1, (Object[])a2);
        ArrayToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayObjectArray_BothEmpty() {
        Object[] a1 = new String[]{};
        Object[] a2 = new String[]{};
        String[] a3 = (String[])ArrayTools.retainAll((Object[])a1, (Object[])a2);
        ArrayToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayIterable() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        List<String> iterable = Arrays.asList("E", "B", "");
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "B", "E", "E"}, ArrayTools.retainAll((Object[])a1, iterable)));
    }

    public void testRetainAllObjectArrayIterable_EmptyObjectArray() {
        Object[] a1 = new String[]{};
        List<String> iterable = Arrays.asList("E", "B", "");
        String[] a3 = (String[])ArrayTools.retainAll((Object[])a1, iterable);
        ArrayToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayIterableInt() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        List<String> iterable = Arrays.asList("E", "B", "");
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "B", "E", "E"}, ArrayTools.retainAll((Object[])a1, iterable, (int)3)));
    }

    public void testRetainAllObjectArrayIterableInt_EmptyObjectArray() {
        Object[] a1 = new String[]{};
        List<String> iterable = Arrays.asList("E", "B", "");
        String[] a3 = (String[])ArrayTools.retainAll((Object[])a1, iterable, (int)3);
        ArrayToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayIterator() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Iterator<String> iterator = Arrays.asList("E", "B", "").iterator();
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "B", "E", "E"}, ArrayTools.retainAll((Object[])a1, iterator)));
    }

    public void testRetainAllObjectArrayIterator_EmptyObjectArray() {
        Object[] a1 = new String[]{};
        Iterator<String> iterator = Arrays.asList("E", "B", "").iterator();
        String[] a3 = (String[])ArrayTools.retainAll((Object[])a1, iterator);
        ArrayToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayIterator_EmptyIterator() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[0], ArrayTools.retainAll((Object[])a1, (Iterator)EmptyIterator.instance())));
    }

    public void testRetainAllObjectArrayIteratorInt() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        Iterator<String> iterator = Arrays.asList("E", "B", "").iterator();
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "B", "E", "E"}, ArrayTools.retainAll((Object[])a1, iterator, (int)3)));
    }

    public void testRetainAllObjectArrayIteratorInt_EmptyIterator() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[0], ArrayTools.retainAll((Object[])a1, (Iterator)EmptyIterator.instance(), (int)3)));
    }

    public void testRetainAllObjectArrayIteratorInt_EmptyObjectArray() {
        Object[] a1 = new String[]{};
        Iterator<String> iterator = Arrays.asList("E", "B", "").iterator();
        String[] a3 = (String[])ArrayTools.retainAll((Object[])a1, iterator, (int)3);
        ArrayToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayCollection() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        List<String> collection = Arrays.asList("E", "B", "");
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new String[]{"B", "B", "E", "E"}, ArrayTools.retainAll((Object[])a1, collection)));
    }

    public void testRetainAllObjectArrayCollection_EmptyObjectArray() {
        Object[] a1 = new String[]{};
        List<String> collection = Arrays.asList("E", "B", "");
        String[] a3 = (String[])ArrayTools.retainAll((Object[])a1, collection);
        ArrayToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayCollection_EmptyCollection() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        ArrayList collection = new ArrayList();
        String[] a3 = (String[])ArrayTools.retainAll((Object[])a1, collection);
        ArrayToolsTests.assertEquals((int)0, (int)a3.length);
    }

    public void testRetainAllObjectArrayCollection_All() {
        Object[] a1 = new String[]{"A", "A", "B", "B", "C", "C", "D", "D", "E", "E", "F", "F"};
        List<String> collection = Arrays.asList("A", "B", "C", "D", "E", "F");
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, ArrayTools.retainAll((Object[])a1, collection)));
    }

    public void testRetainAllCharArrayCharArray() {
        char[] a1 = new char[]{'A', 'A', 'B', 'B', 'C', 'C', 'D', 'D', 'E', 'E', 'F', 'F'};
        char[] a2 = new char[]{'E', 'B'};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new char[]{'B', 'B', 'E', 'E'}, ArrayTools.retainAll((char[])a1, (char[])a2)));
    }

    public void testRetainAllCharArrayCharArray_EmptyCharArray1() {
        char[] a1 = new char[]{};
        char[] a2 = new char[]{'E', 'B'};
        ArrayToolsTests.assertSame((Object)a1, (Object)ArrayTools.retainAll((char[])a1, (char[])a2));
    }

    public void testRetainAllCharArrayCharArray_EmptyCharArray2() {
        char[] a1 = new char[]{'E', 'B'};
        char[] a2 = new char[]{};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.retainAll((char[])a1, (char[])a2).length);
    }

    public void testRetainAllCharArrayCharArray_RetainAll() {
        char[] a1 = new char[]{'E', 'B', 'E', 'B', 'E', 'B', 'E', 'B', 'E'};
        char[] a2 = new char[]{'E', 'B'};
        ArrayToolsTests.assertSame((Object)a1, (Object)ArrayTools.retainAll((char[])a1, (char[])a2));
    }

    public void testRetainAllIntArrayIntArray() {
        int[] a1 = new int[]{1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6};
        int[] a2 = new int[]{5, 2};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(new int[]{2, 2, 5, 5}, ArrayTools.retainAll((int[])a1, (int[])a2)));
    }

    public void testRetainAllIntArrayIntArray_EmptyIntArray1() {
        int[] a1 = new int[]{};
        int[] a2 = new int[]{5, 2};
        ArrayToolsTests.assertSame((Object)a1, (Object)ArrayTools.retainAll((int[])a1, (int[])a2));
    }

    public void testRetainAllIntArrayIntArray_EmptyIntArray2() {
        int[] a1 = new int[]{5, 2};
        int[] a2 = new int[]{};
        ArrayToolsTests.assertEquals((int)0, (int)ArrayTools.retainAll((int[])a1, (int[])a2).length);
    }

    public void testRetainAllIntArrayIntArray_RetainAll() {
        int[] a1 = new int[]{5, 2, 5, 2, 5, 2, 5, 2, 5, 2, 5};
        int[] a2 = new int[]{5, 2};
        ArrayToolsTests.assertSame((Object)a1, (Object)ArrayTools.retainAll((int[])a1, (int[])a2));
    }

    public void testReverseObjectArray_Object() {
        Object[] a = this.buildObjectArray1();
        a = ArrayTools.reverse((Object[])a);
        ArrayToolsTests.assertEquals((Object)"two", (Object)a[0]);
        ArrayToolsTests.assertEquals((Object)"one", (Object)a[1]);
        ArrayToolsTests.assertEquals((Object)"zero", (Object)a[2]);
    }

    public void testReverseObjectArray_String() {
        Object[] a = this.buildStringArray1();
        a = (String[])ArrayTools.reverse((Object[])a);
        ArrayToolsTests.assertEquals((String)"two", (String)a[0]);
        ArrayToolsTests.assertEquals((String)"one", (String)a[1]);
        ArrayToolsTests.assertEquals((String)"zero", (String)a[2]);
    }

    public void testReverseObjectArray_Singleton() {
        Object[] a1 = new String[]{"foo"};
        Object[] a2 = (String[])ArrayTools.reverse((Object[])a1);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testReverseCharArray() {
        char[] a = this.buildCharArray();
        a = ArrayTools.reverse((char[])a);
        ArrayToolsTests.assertEquals((char)'c', (char)a[0]);
        ArrayToolsTests.assertEquals((char)'b', (char)a[1]);
        ArrayToolsTests.assertEquals((char)'a', (char)a[2]);
    }

    public void testReverseCharArray_Singleton() {
        char[] a1 = new char[]{'f'};
        char[] a2 = ArrayTools.reverse((char[])a1);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testReverseIntArray() {
        int[] a = this.buildIntArray();
        a = ArrayTools.reverse((int[])a);
        ArrayToolsTests.assertEquals((int)20, (int)a[0]);
        ArrayToolsTests.assertEquals((int)10, (int)a[1]);
        ArrayToolsTests.assertEquals((int)0, (int)a[2]);
    }

    public void testReverseIntArray_Singleton() {
        int[] a1 = new int[]{7};
        int[] a2 = ArrayTools.reverse((int[])a1);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testRotateObjectArray() {
        Object[] a = this.buildStringArray1();
        a = (String[])ArrayTools.rotate((Object[])a);
        ArrayToolsTests.assertEquals((String)"two", (String)a[0]);
        ArrayToolsTests.assertEquals((String)"zero", (String)a[1]);
        ArrayToolsTests.assertEquals((String)"one", (String)a[2]);
    }

    public void testRotateObjectArray_Zero() {
        Object[] a1 = new String[]{};
        String[] a2 = (String[])ArrayTools.rotate((Object[])a1);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateObjectArray_One() {
        Object[] a1 = new String[]{"foo  "};
        String[] a2 = (String[])ArrayTools.rotate((Object[])a1);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateObjectArrayInt() {
        Object[] a = this.buildStringArray1();
        a = (String[])ArrayTools.rotate((Object[])a, (int)2);
        ArrayToolsTests.assertEquals((String)"one", (String)a[0]);
        ArrayToolsTests.assertEquals((String)"two", (String)a[1]);
        ArrayToolsTests.assertEquals((String)"zero", (String)a[2]);
    }

    public void testRotateObjectArrayInt_ZeroDistance() {
        Object[] a1 = this.buildStringArray1();
        String[] a2 = (String[])ArrayTools.rotate((Object[])a1, (int)0);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateObjectArrayInt_NegativeDistance() {
        Object[] a1 = this.buildStringArray1();
        String[] a2 = (String[])ArrayTools.rotate((Object[])a1, (int)-1);
        ArrayToolsTests.assertEquals((String)"one", (String)a2[0]);
        ArrayToolsTests.assertEquals((String)"two", (String)a2[1]);
        ArrayToolsTests.assertEquals((String)"zero", (String)a2[2]);
    }

    public void testRotateObjectArrayInt_Zero() {
        Object[] a1 = new String[]{};
        String[] a2 = (String[])ArrayTools.rotate((Object[])a1, (int)7);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateObjectArrayInt_One() {
        Object[] a1 = new String[]{"foo  "};
        String[] a2 = (String[])ArrayTools.rotate((Object[])a1, (int)8);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateCharArray() {
        char[] a = this.buildCharArray();
        a = ArrayTools.rotate((char[])a);
        ArrayToolsTests.assertEquals((char)'c', (char)a[0]);
        ArrayToolsTests.assertEquals((char)'a', (char)a[1]);
        ArrayToolsTests.assertEquals((char)'b', (char)a[2]);
    }

    public void testRotateCharArray_Zero() {
        char[] a1 = new char[]{};
        char[] a2 = ArrayTools.rotate((char[])a1);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateCharArray_One() {
        char[] a1 = new char[]{'a'};
        char[] a2 = ArrayTools.rotate((char[])a1);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateCharArrayInt() {
        char[] a = this.buildCharArray();
        a = ArrayTools.rotate((char[])a, (int)2);
        ArrayToolsTests.assertEquals((char)'b', (char)a[0]);
        ArrayToolsTests.assertEquals((char)'c', (char)a[1]);
        ArrayToolsTests.assertEquals((char)'a', (char)a[2]);
    }

    public void testRotateCharArrayInt_ZeroDistance() {
        char[] a1 = new char[]{'a', 'b', 'c'};
        char[] a2 = ArrayTools.rotate((char[])a1, (int)0);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateCharArrayInt_NegativeDistance() {
        char[] a = this.buildCharArray();
        a = ArrayTools.rotate((char[])a, (int)-1);
        ArrayToolsTests.assertEquals((char)'b', (char)a[0]);
        ArrayToolsTests.assertEquals((char)'c', (char)a[1]);
        ArrayToolsTests.assertEquals((char)'a', (char)a[2]);
    }

    public void testRotateCharArrayInt_Zero() {
        char[] a1 = new char[]{};
        char[] a2 = ArrayTools.rotate((char[])a1, (int)2001);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateCharArrayInt_One() {
        char[] a1 = new char[]{'a'};
        char[] a2 = ArrayTools.rotate((char[])a1, (int)22);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateIntArray() {
        int[] a = this.buildIntArray();
        a = ArrayTools.rotate((int[])a);
        ArrayToolsTests.assertEquals((int)20, (int)a[0]);
        ArrayToolsTests.assertEquals((int)0, (int)a[1]);
        ArrayToolsTests.assertEquals((int)10, (int)a[2]);
    }

    public void testRotateIntArray_Zero() {
        int[] a1 = new int[]{};
        int[] a2 = ArrayTools.rotate((int[])a1);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateIntArray_One() {
        int[] a1 = new int[]{77};
        int[] a2 = ArrayTools.rotate((int[])a1);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateIntArrayInt() {
        int[] a = this.buildIntArray();
        a = ArrayTools.rotate((int[])a, (int)2);
        ArrayToolsTests.assertEquals((int)10, (int)a[0]);
        ArrayToolsTests.assertEquals((int)20, (int)a[1]);
        ArrayToolsTests.assertEquals((int)0, (int)a[2]);
    }

    public void testRotateIntArrayInt_ZeroDistance() {
        int[] a1 = new int[]{3, 2, 1};
        int[] a2 = ArrayTools.rotate((int[])a1, (int)0);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateIntArrayInt_NegativeDistance() {
        int[] a = this.buildIntArray();
        a = ArrayTools.rotate((int[])a, (int)-1);
        ArrayToolsTests.assertEquals((int)10, (int)a[0]);
        ArrayToolsTests.assertEquals((int)20, (int)a[1]);
        ArrayToolsTests.assertEquals((int)0, (int)a[2]);
    }

    public void testRotateIntArrayInt_Zero() {
        int[] a1 = new int[]{};
        int[] a2 = ArrayTools.rotate((int[])a1, (int)3);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testRotateIntArrayInt_One() {
        int[] a1 = new int[]{77};
        int[] a2 = ArrayTools.rotate((int[])a1, (int)44);
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testShuffleObjectArray() {
        Object[] array1 = this.buildStringArray1();
        Object[] array2 = (String[])ArrayTools.shuffle((Object[])this.buildStringArray1());
        ArrayToolsTests.assertEquals((int)array1.length, (int)array2.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])array1, (Object[])array2));
    }

    public void testShuffleObjectArray_Singleton() {
        Object[] array1 = new String[]{"foo"};
        Object[] array2 = (String[])ArrayTools.shuffle((Object[])new String[]{"foo"});
        ArrayToolsTests.assertEquals((int)array1.length, (int)array2.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((Object[])array1, (Object[])array2));
    }

    public void testShuffleCharArray() {
        char[] array1 = this.buildCharArray();
        char[] array2 = ArrayTools.shuffle((char[])this.buildCharArray());
        ArrayToolsTests.assertEquals((int)array1.length, (int)array2.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((char[])array1, (char[])array2));
    }

    public void testShuffleCharArray_Singleton() {
        char[] array1 = new char[]{'f'};
        char[] array2 = ArrayTools.shuffle((char[])new char[]{'f'});
        ArrayToolsTests.assertEquals((int)array1.length, (int)array2.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((char[])array1, (char[])array2));
    }

    public void testShuffleIntArray() {
        int[] array1 = this.buildIntArray();
        int[] array2 = ArrayTools.shuffle((int[])this.buildIntArray());
        ArrayToolsTests.assertEquals((int)array1.length, (int)array2.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((int[])array1, (int[])array2));
    }

    public void testShuffleIntArray_Singleton() {
        int[] array1 = new int[]{7};
        int[] array2 = ArrayTools.shuffle((int[])new int[]{7});
        ArrayToolsTests.assertEquals((int)array1.length, (int)array2.length);
        ArrayToolsTests.assertTrue((boolean)ArrayTools.containsAll((int[])array1, (int[])array2));
    }

    public void testSubArrayObjectArrayIntInt() {
        Object[] array = new String[]{"foo", "bar", "baz", "joo", "jar", "jaz"};
        Object[] result = new String[]{"foo", "bar", "baz", "joo"};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(result, ArrayTools.subArray((Object[])array, (int)0, (int)4)));
        result = new String[]{"jar"};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(result, ArrayTools.subArray((Object[])array, (int)4, (int)5)));
        result = new String[]{};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(result, ArrayTools.subArray((Object[])array, (int)5, (int)5)));
        result = new String[]{"joo", "jar", "jaz"};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(result, ArrayTools.subArray((Object[])array, (int)3, (int)6)));
    }

    public void testSubArrayIntArrayIntInt() {
        int[] array = new int[]{77, 99, 333, 4, 9090, 42};
        int[] result = new int[]{77, 99, 333, 4};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(result, ArrayTools.subArray((int[])array, (int)0, (int)4)));
        result = new int[]{9090};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(result, ArrayTools.subArray((int[])array, (int)4, (int)5)));
        result = new int[]{};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(result, ArrayTools.subArray((int[])array, (int)5, (int)5)));
        result = new int[]{4, 9090, 42};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(result, ArrayTools.subArray((int[])array, (int)3, (int)6)));
    }

    public void testSubArrayCharArrayIntInt() {
        char[] array = new char[]{'a', 'b', 'c', 'd', 'e', 'f'};
        char[] result = new char[]{'a', 'b', 'c', 'd'};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(result, ArrayTools.subArray((char[])array, (int)0, (int)4)));
        result = new char[]{'e'};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(result, ArrayTools.subArray((char[])array, (int)4, (int)5)));
        result = new char[]{};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(result, ArrayTools.subArray((char[])array, (int)5, (int)5)));
        result = new char[]{'d', 'e', 'f'};
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(result, ArrayTools.subArray((char[])array, (int)3, (int)6)));
    }

    public void testSwapObjectArray() {
        Object[] a = this.buildStringArray1();
        a = (String[])ArrayTools.swap((Object[])a, (int)1, (int)2);
        ArrayToolsTests.assertEquals((String)"zero", (String)a[0]);
        ArrayToolsTests.assertEquals((String)"two", (String)a[1]);
        ArrayToolsTests.assertEquals((String)"one", (String)a[2]);
    }

    public void testSwapObjectArray_SameIndices() {
        Object[] a1 = this.buildStringArray1();
        Object[] a2 = this.buildStringArray1();
        a1 = (String[])ArrayTools.swap((Object[])a1, (int)1, (int)1);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testSwapCharArray() {
        char[] a = this.buildCharArray();
        a = ArrayTools.swap((char[])a, (int)1, (int)2);
        ArrayToolsTests.assertEquals((char)'a', (char)a[0]);
        ArrayToolsTests.assertEquals((char)'c', (char)a[1]);
        ArrayToolsTests.assertEquals((char)'b', (char)a[2]);
    }

    public void testSwapCharArray_SameIndices() {
        char[] a1 = this.buildCharArray();
        char[] a2 = this.buildCharArray();
        a1 = ArrayTools.swap((char[])a1, (int)1, (int)1);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testSwapIntArray() {
        int[] a = this.buildIntArray();
        a = ArrayTools.swap((int[])a, (int)1, (int)2);
        ArrayToolsTests.assertEquals((int)0, (int)a[0]);
        ArrayToolsTests.assertEquals((int)20, (int)a[1]);
        ArrayToolsTests.assertEquals((int)10, (int)a[2]);
    }

    public void testSwapIntArray_SameIndices() {
        int[] a1 = this.buildIntArray();
        int[] a2 = this.buildIntArray();
        a1 = ArrayTools.swap((int[])a1, (int)1, (int)1);
        ArrayToolsTests.assertTrue((boolean)Arrays.equals(a1, a2));
    }

    public void testFillBooleanArrayBoolean() {
        boolean[] a1 = new boolean[9];
        boolean[] a2 = ArrayTools.fill((boolean[])a1, (boolean)true);
        boolean[] blArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            boolean x = blArray[n2];
            ArrayToolsTests.assertTrue((boolean)x);
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testFillBooleanArrayIntIntBoolean() {
        boolean[] a1 = new boolean[9];
        boolean[] a2 = ArrayTools.fill((boolean[])a1, (boolean)false);
        int from = 3;
        int to = 6;
        boolean[] a3 = ArrayTools.fill((boolean[])a2, (int)from, (int)to, (boolean)true);
        int i = 0;
        while (i < a1.length) {
            boolean x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertFalse((boolean)x);
            } else {
                ArrayToolsTests.assertTrue((boolean)x);
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testFillByteArrayByte() {
        byte[] a1 = new byte[9];
        byte[] a2 = ArrayTools.fill((byte[])a1, (byte)77);
        byte[] byArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            byte x = byArray[n2];
            ArrayToolsTests.assertEquals((int)77, (int)x);
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testFillByteArrayIntIntByte() {
        byte[] a1 = new byte[9];
        byte[] a2 = ArrayTools.fill((byte[])a1, (byte)3);
        int from = 3;
        int to = 6;
        byte[] a3 = ArrayTools.fill((byte[])a2, (int)from, (int)to, (byte)77);
        int i = 0;
        while (i < a1.length) {
            byte x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((int)3, (int)x);
            } else {
                ArrayToolsTests.assertEquals((int)77, (int)x);
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testFillCharArrayChar() {
        char[] a1 = new char[9];
        char[] a2 = ArrayTools.fill((char[])a1, (char)'c');
        char[] cArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            char x = cArray[n2];
            ArrayToolsTests.assertEquals((char)'c', (char)x);
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testFillCharArrayIntIntChar() {
        char[] a1 = new char[9];
        char[] a2 = ArrayTools.fill((char[])a1, (char)'a');
        int from = 3;
        int to = 6;
        char[] a3 = ArrayTools.fill((char[])a2, (int)from, (int)to, (char)'c');
        int i = 0;
        while (i < a1.length) {
            char x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((char)'a', (char)x);
            } else {
                ArrayToolsTests.assertEquals((char)'c', (char)x);
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testFillDoubleArrayDouble() {
        double[] a1 = new double[9];
        double[] a2 = ArrayTools.fill((double[])a1, (double)77.77);
        double[] dArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            ArrayToolsTests.assertEquals((double)77.77, (double)x, (double)0.0);
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testFillDoubleArrayIntIntDouble() {
        double[] a1 = new double[9];
        double[] a2 = ArrayTools.fill((double[])a1, (double)3.3);
        int from = 3;
        int to = 6;
        double[] a3 = ArrayTools.fill((double[])a2, (int)from, (int)to, (double)77.77);
        int i = 0;
        while (i < a1.length) {
            double x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((double)3.3, (double)x, (double)0.0);
            } else {
                ArrayToolsTests.assertEquals((double)77.77, (double)x, (double)0.0);
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testFillFloatArrayFloat() {
        float[] a1 = new float[9];
        float[] a2 = ArrayTools.fill((float[])a1, (float)77.77f);
        float[] fArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            float x = fArray[n2];
            ArrayToolsTests.assertEquals((double)77.77f, (double)x, (double)0.0);
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testFillFloatArrayIntIntFloat() {
        float[] a1 = new float[9];
        float[] a2 = ArrayTools.fill((float[])a1, (float)3.3f);
        int from = 3;
        int to = 6;
        float[] a3 = ArrayTools.fill((float[])a2, (int)from, (int)to, (float)77.77f);
        int i = 0;
        while (i < a1.length) {
            float x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((double)3.3f, (double)x, (double)0.0);
            } else {
                ArrayToolsTests.assertEquals((double)77.77f, (double)x, (double)0.0);
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testFillIntArrayInt() {
        int[] a1 = new int[9];
        int[] a2 = ArrayTools.fill((int[])a1, (int)77);
        int[] nArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            int x = nArray[n2];
            ArrayToolsTests.assertEquals((int)77, (int)x);
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testFillIntArrayIntIntInt() {
        int[] a1 = new int[9];
        int[] a2 = ArrayTools.fill((int[])a1, (int)3);
        int from = 3;
        int to = 6;
        int[] a3 = ArrayTools.fill((int[])a2, (int)from, (int)to, (int)77);
        int i = 0;
        while (i < a1.length) {
            int x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((int)3, (int)x);
            } else {
                ArrayToolsTests.assertEquals((int)77, (int)x);
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testFillObjectArrayObject() {
        Object[] a1 = new String[9];
        String[] a2 = (String[])ArrayTools.fill((Object[])a1, (Object)"77");
        Object[] objectArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            Object x = objectArray[n2];
            ArrayToolsTests.assertEquals((String)"77", (String)x);
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testFillObjectArrayIntIntObject() {
        Object[] a1 = new String[9];
        Object[] a2 = (String[])ArrayTools.fill((Object[])a1, (Object)"3");
        int from = 3;
        int to = 6;
        String[] a3 = (String[])ArrayTools.fill((Object[])a2, (int)from, (int)to, (Object)"77");
        int i = 0;
        while (i < a1.length) {
            Object x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((String)"3", (String)x);
            } else {
                ArrayToolsTests.assertEquals((String)"77", (String)x);
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testFillLongArrayLong() {
        long[] a1 = new long[9];
        long[] a2 = ArrayTools.fill((long[])a1, (long)77L);
        long[] lArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            long x = lArray[n2];
            ArrayToolsTests.assertEquals((long)77L, (long)x);
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testFillLongArrayIntIntLong() {
        long[] a1 = new long[9];
        long[] a2 = ArrayTools.fill((long[])a1, (long)3L);
        int from = 3;
        int to = 6;
        long[] a3 = ArrayTools.fill((long[])a2, (int)from, (int)to, (long)77L);
        int i = 0;
        while (i < a1.length) {
            long x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((long)3L, (long)x);
            } else {
                ArrayToolsTests.assertEquals((long)77L, (long)x);
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testFillShortArrayShort() {
        short[] a1 = new short[9];
        short[] a2 = ArrayTools.fill((short[])a1, (short)77);
        short[] sArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            short x = sArray[n2];
            ArrayToolsTests.assertEquals((int)77, (int)x);
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testFillShortArrayIntIntShort() {
        short[] a1 = new short[9];
        short[] a2 = ArrayTools.fill((short[])a1, (short)3);
        int from = 3;
        int to = 6;
        short[] a3 = ArrayTools.fill((short[])a2, (int)from, (int)to, (short)77);
        int i = 0;
        while (i < a1.length) {
            short x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((int)3, (int)x);
            } else {
                ArrayToolsTests.assertEquals((int)77, (int)x);
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testSortByteArray() {
        byte[] a1 = new byte[]{33, 11, 22};
        byte[] a2 = ArrayTools.sort((byte[])a1);
        byte last = 0;
        byte[] byArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            byte x = byArray[n2];
            ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
            last = x;
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testSortByteArrayIntInt() {
        byte[] a1 = new byte[9];
        byte[] a2 = ArrayTools.fill((byte[])a1, (byte)3);
        a2[3] = 33;
        a2[4] = 11;
        a2[5] = 22;
        int from = 3;
        int to = 6;
        byte[] a3 = ArrayTools.sort((byte[])a2, (int)from, (int)to);
        byte last = 0;
        int i = 0;
        while (i < a1.length) {
            byte x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((int)3, (int)x);
            } else {
                ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
                last = x;
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testSortCharArray() {
        char[] a1 = new char[]{'z', 'b', 'm'};
        char[] a2 = ArrayTools.sort((char[])a1);
        char last = 'a';
        char[] cArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            char x = cArray[n2];
            ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
            last = x;
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testSortCharArrayIntInt() {
        char[] a1 = new char[9];
        char[] a2 = ArrayTools.fill((char[])a1, (char)'c');
        a2[3] = 122;
        a2[4] = 98;
        a2[5] = 109;
        int from = 3;
        int to = 6;
        char[] a3 = ArrayTools.sort((char[])a2, (int)from, (int)to);
        char last = 'a';
        int i = 0;
        while (i < a1.length) {
            char x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((char)'c', (char)x);
            } else {
                ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
                last = x;
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testSortDoubleArray() {
        double[] a1 = new double[]{33.33, 11.11, 22.22};
        double[] a2 = ArrayTools.sort((double[])a1);
        double last = 0.0;
        double[] dArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
            last = x;
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testSortDoubleArrayIntInt() {
        double[] a1 = new double[9];
        double[] a2 = ArrayTools.fill((double[])a1, (double)3.3);
        a2[3] = 33.33;
        a2[4] = 11.11;
        a2[5] = 22.22;
        int from = 3;
        int to = 6;
        double[] a3 = ArrayTools.sort((double[])a2, (int)from, (int)to);
        double last = 0.0;
        int i = 0;
        while (i < a1.length) {
            double x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((double)3.3, (double)x, (double)0.0);
            } else {
                ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
                last = x;
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testSortFloatArray() {
        float[] a1 = new float[]{33.33f, 11.11f, 22.22f};
        float[] a2 = ArrayTools.sort((float[])a1);
        float last = 0.0f;
        float[] fArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            float x = fArray[n2];
            ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
            last = x;
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testSortFloatArrayIntInt() {
        float[] a1 = new float[9];
        float[] a2 = ArrayTools.fill((float[])a1, (float)3.3f);
        a2[3] = 33.33f;
        a2[4] = 11.11f;
        a2[5] = 22.22f;
        int from = 3;
        int to = 6;
        float[] a3 = ArrayTools.sort((float[])a2, (int)from, (int)to);
        float last = 0.0f;
        int i = 0;
        while (i < a1.length) {
            float x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((double)3.3f, (double)x, (double)0.0);
            } else {
                ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
                last = x;
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testSortIntArray() {
        int[] a1 = new int[]{33, 11, 22};
        int[] a2 = ArrayTools.sort((int[])a1);
        int last = 0;
        int[] nArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            int x = nArray[n2];
            ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
            last = x;
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testSortIntArrayIntInt() {
        int[] a1 = new int[9];
        int[] a2 = ArrayTools.fill((int[])a1, (int)3);
        a2[3] = 33;
        a2[4] = 11;
        a2[5] = 22;
        int from = 3;
        int to = 6;
        int[] a3 = ArrayTools.sort((int[])a2, (int)from, (int)to);
        int last = 0;
        int i = 0;
        while (i < a1.length) {
            int x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((int)3, (int)x);
            } else {
                ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
                last = x;
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testSortObjectArray() {
        Object[] a1 = new String[]{"y", "b", "m"};
        String[] a2 = (String[])ArrayTools.sort((Object[])a1);
        Object last = "a";
        Object[] objectArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            Object x = objectArray[n2];
            ArrayToolsTests.assertTrue((((String)last).compareTo((String)x) < 0 ? 1 : 0) != 0);
            last = x;
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testSortObjectArrayComparator() {
        Object[] a1 = new String[]{"y", "b", "m"};
        String[] a2 = (String[])ArrayTools.sort((Object[])a1, (Comparator)new ReverseComparator());
        Object last = "z";
        Object[] objectArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            Object x = objectArray[n2];
            ArrayToolsTests.assertTrue((((String)last).compareTo((String)x) > 0 ? 1 : 0) != 0);
            last = x;
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testSortObjectArrayIntInt() {
        Object[] a1 = new String[9];
        Object[] a2 = (String[])ArrayTools.fill((Object[])a1, (Object)"c");
        a2[3] = "y";
        a2[4] = "b";
        a2[5] = "m";
        int from = 3;
        int to = 6;
        String[] a3 = (String[])ArrayTools.sort((Object[])a2, (int)from, (int)to);
        Object last = "a";
        int i = 0;
        while (i < a1.length) {
            Object x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((String)"c", (String)x);
            } else {
                ArrayToolsTests.assertTrue((((String)last).compareTo((String)x) < 0 ? 1 : 0) != 0);
                last = x;
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testSortObjectArrayIntIntComparator() {
        Object[] a1 = new String[9];
        Object[] a2 = (String[])ArrayTools.fill((Object[])a1, (Object)"c");
        a2[3] = "y";
        a2[4] = "b";
        a2[5] = "m";
        int from = 3;
        int to = 6;
        String[] a3 = (String[])ArrayTools.sort((Object[])a2, (int)from, (int)to, (Comparator)new ReverseComparator());
        Object last = "z";
        int i = 0;
        while (i < a1.length) {
            Object x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((String)"c", (String)x);
            } else {
                ArrayToolsTests.assertTrue((((String)last).compareTo((String)x) > 0 ? 1 : 0) != 0);
                last = x;
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testSortLongArray() {
        long[] a1 = new long[]{33L, 11L, 22L};
        long[] a2 = ArrayTools.sort((long[])a1);
        long last = 0L;
        long[] lArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            long x = lArray[n2];
            ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
            last = x;
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testSortLongArrayIntInt() {
        long[] a1 = new long[9];
        long[] a2 = ArrayTools.fill((long[])a1, (long)3L);
        a2[3] = 33L;
        a2[4] = 11L;
        a2[5] = 22L;
        int from = 3;
        int to = 6;
        long[] a3 = ArrayTools.sort((long[])a2, (int)from, (int)to);
        long last = 0L;
        int i = 0;
        while (i < a1.length) {
            long x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((long)3L, (long)x);
            } else {
                ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
                last = x;
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testSortShortArray() {
        short[] a1 = new short[]{33, 11, 22};
        short[] a2 = ArrayTools.sort((short[])a1);
        short last = 0;
        short[] sArray = a1;
        int n = a1.length;
        int n2 = 0;
        while (n2 < n) {
            short x = sArray[n2];
            ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
            last = x;
            ++n2;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
    }

    public void testSortShortArrayIntInt() {
        short[] a1 = new short[9];
        short[] a2 = ArrayTools.fill((short[])a1, (short)3);
        a2[3] = 33;
        a2[4] = 11;
        a2[5] = 22;
        int from = 3;
        int to = 6;
        short[] a3 = ArrayTools.sort((short[])a2, (int)from, (int)to);
        short last = 0;
        int i = 0;
        while (i < a1.length) {
            short x = a1[i];
            if (i < from || i >= to) {
                ArrayToolsTests.assertEquals((int)3, (int)x);
            } else {
                ArrayToolsTests.assertTrue((last < x ? 1 : 0) != 0);
                last = x;
            }
            ++i;
        }
        ArrayToolsTests.assertSame((Object)a1, (Object)a2);
        ArrayToolsTests.assertSame((Object)a1, (Object)a3);
    }

    public void testConstructor() {
        boolean exCaught;
        block2: {
            exCaught = false;
            try {
                Object at = ReflectionTools.newInstance(ArrayTools.class);
                ArrayToolsTests.fail((String)("bogus: " + at));
            }
            catch (RuntimeException ex) {
                if (!(ex.getCause() instanceof InvocationTargetException) || !(ex.getCause().getCause() instanceof UnsupportedOperationException)) break block2;
                exCaught = true;
            }
        }
        ArrayToolsTests.assertTrue((boolean)exCaught);
    }

    private Object[] buildObjectArray1() {
        return new Object[]{"zero", "one", "two"};
    }

    private String[] buildStringArray1() {
        return new String[]{"zero", "one", "two"};
    }

    private char[] buildCharArray() {
        return new char[]{'a', 'b', 'c'};
    }

    private int[] buildIntArray() {
        int[] nArray = new int[3];
        nArray[1] = 10;
        nArray[2] = 20;
        return nArray;
    }

    private Object[] buildObjectArray2() {
        return new Object[]{"three", "four", "five"};
    }

    private String[] buildStringArray2() {
        return new String[]{"three", "four", "five"};
    }

    private List<String> buildStringList1() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection1(l);
        return l;
    }

    private List<Object> buildObjectList1() {
        ArrayList<Object> l = new ArrayList<Object>();
        this.addToCollection1(l);
        return l;
    }

    private void addToCollection1(Collection<? super String> c) {
        c.add("zero");
        c.add("one");
        c.add("two");
    }

    private List<String> buildStringList2() {
        ArrayList<String> l = new ArrayList<String>();
        this.addToCollection2(l);
        return l;
    }

    private void addToCollection2(Collection<? super String> c) {
        c.add("three");
        c.add("four");
        c.add("five");
    }

    private Vector<String> buildStringVector1() {
        Vector<String> v = new Vector<String>();
        this.addToCollection1(v);
        return v;
    }
}

