/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.model.value.SetCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.SimpleCollectionValueModel;
import org.eclipse.jpt.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetCollectionValueModelTests
extends TestCase {
    private SimpleCollectionValueModel<String> collectionHolder;
    CollectionAddEvent addEvent;
    CollectionRemoveEvent removeEvent;
    CollectionClearEvent collectionClearedEvent;
    CollectionChangeEvent collectionChangedEvent;
    private CollectionValueModel<String> setHolder;
    CollectionAddEvent setAddEvent;
    CollectionRemoveEvent setRemoveEvent;
    CollectionClearEvent setClearedEvent;
    CollectionChangeEvent setChangedEvent;

    public SetCollectionValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.collectionHolder = new SimpleCollectionValueModel(this.buildCollection());
        this.setHolder = new SetCollectionValueModel(this.collectionHolder);
    }

    private Collection<String> buildCollection() {
        ArrayList<String> collection = new ArrayList<String>();
        collection.add("foo");
        collection.add("foo");
        return collection;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator() {
        this.setHolder.addChangeListener(this.buildSetChangeListener());
        this.verify((CollectionValueModel<String>)this.collectionHolder, "foo", "foo");
        this.verify(this.setHolder, "foo");
        this.collectionHolder.add((Object)"bar");
        this.collectionHolder.add((Object)"bar");
        this.verify((CollectionValueModel<String>)this.collectionHolder, "foo", "foo", "bar", "bar");
        this.verify(this.setHolder, "foo", "bar");
        this.collectionHolder.remove((Object)"bar");
        this.verify((CollectionValueModel<String>)this.collectionHolder, "foo", "foo", "bar");
        this.verify(this.setHolder, "foo", "bar");
        this.collectionHolder.remove((Object)"bar");
        this.verify((CollectionValueModel<String>)this.collectionHolder, "foo", "foo");
        this.verify(this.setHolder, "foo");
        this.collectionHolder.remove((Object)"foo");
        this.verify((CollectionValueModel<String>)this.collectionHolder, "foo");
        this.verify(this.setHolder, "foo");
        this.collectionHolder.remove((Object)"foo");
        SetCollectionValueModelTests.assertFalse((boolean)this.collectionHolder.iterator().hasNext());
        SetCollectionValueModelTests.assertFalse((boolean)this.setHolder.iterator().hasNext());
    }

    public void testSize() {
        this.setHolder.addChangeListener(this.buildSetChangeListener());
        SetCollectionValueModelTests.assertEquals((int)2, (int)this.collectionHolder.size());
        SetCollectionValueModelTests.assertEquals((int)1, (int)this.setHolder.size());
        this.collectionHolder.add((Object)"bar");
        this.collectionHolder.add((Object)"bar");
        SetCollectionValueModelTests.assertEquals((int)4, (int)this.collectionHolder.size());
        SetCollectionValueModelTests.assertEquals((int)2, (int)this.setHolder.size());
        this.collectionHolder.remove((Object)"bar");
        SetCollectionValueModelTests.assertEquals((int)3, (int)this.collectionHolder.size());
        SetCollectionValueModelTests.assertEquals((int)2, (int)this.setHolder.size());
        this.collectionHolder.remove((Object)"bar");
        SetCollectionValueModelTests.assertEquals((int)2, (int)this.collectionHolder.size());
        SetCollectionValueModelTests.assertEquals((int)1, (int)this.setHolder.size());
        this.collectionHolder.remove((Object)"foo");
        SetCollectionValueModelTests.assertEquals((int)1, (int)this.collectionHolder.size());
        SetCollectionValueModelTests.assertEquals((int)1, (int)this.setHolder.size());
        this.collectionHolder.remove((Object)"foo");
        SetCollectionValueModelTests.assertEquals((int)0, (int)this.collectionHolder.size());
        SetCollectionValueModelTests.assertEquals((int)0, (int)this.setHolder.size());
    }

    public void testBulkChange() {
        this.setHolder.addChangeListener(this.buildSetChangeListener());
        ArrayList<String> newCollection = new ArrayList<String>();
        newCollection.add("fox");
        newCollection.add("fox");
        newCollection.add("bat");
        this.collectionHolder.setValues(newCollection);
        this.verify((CollectionValueModel<String>)this.collectionHolder, "fox", "fox", "bat");
        this.verify(this.setHolder, "fox", "bat");
    }

    public void testLazyListening() {
        SetCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasNoCollectionChangeListeners("values"));
        ChangeListener listener = this.buildSetChangeListener();
        this.setHolder.addChangeListener(listener);
        SetCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasAnyCollectionChangeListeners("values"));
        this.setHolder.removeChangeListener(listener);
        SetCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasNoCollectionChangeListeners("values"));
        this.setHolder.addCollectionChangeListener("values", (CollectionChangeListener)listener);
        SetCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasAnyCollectionChangeListeners("values"));
        this.setHolder.removeCollectionChangeListener("values", (CollectionChangeListener)listener);
        SetCollectionValueModelTests.assertTrue((boolean)this.collectionHolder.hasNoCollectionChangeListeners("values"));
    }

    public void testEvents1() {
        this.collectionHolder.addChangeListener(this.buildChangeListener());
        this.setHolder.addChangeListener(this.buildSetChangeListener());
        this.verifyEvents();
    }

    public void testEvents2() {
        this.collectionHolder.addCollectionChangeListener("values", this.buildCollectionChangeListener());
        this.setHolder.addCollectionChangeListener("values", this.buildSetCollectionChangeListener());
        this.verifyEvents();
    }

    private void clearEvents() {
        this.addEvent = null;
        this.removeEvent = null;
        this.collectionClearedEvent = null;
        this.collectionChangedEvent = null;
        this.setAddEvent = null;
        this.setRemoveEvent = null;
        this.setClearedEvent = null;
        this.setChangedEvent = null;
    }

    private void verifyEvents() {
        this.clearEvents();
        this.collectionHolder.add((Object)"bar");
        this.verifyEvent(this.addEvent, this.collectionHolder, "bar");
        this.verifyEvent(this.setAddEvent, this.setHolder, "bar");
        this.clearEvents();
        this.collectionHolder.remove((Object)"foo");
        this.verifyEvent(this.removeEvent, this.collectionHolder, "foo");
        SetCollectionValueModelTests.assertNull((Object)this.setRemoveEvent);
        this.clearEvents();
        this.collectionHolder.add((Object)"bar");
        this.verifyEvent(this.addEvent, this.collectionHolder, "bar");
        SetCollectionValueModelTests.assertNull((Object)this.setAddEvent);
        this.clearEvents();
        this.collectionHolder.remove((Object)"foo");
        this.verifyEvent(this.removeEvent, this.collectionHolder, "foo");
        this.verifyEvent(this.setRemoveEvent, this.setHolder, "foo");
        this.clearEvents();
        this.collectionHolder.add((Object)"foo");
        this.verifyEvent(this.addEvent, this.collectionHolder, "foo");
        this.verifyEvent(this.setAddEvent, this.setHolder, "foo");
        this.clearEvents();
        this.collectionHolder.clear();
        this.verifyEvent(this.collectionClearedEvent, this.collectionHolder);
        this.verifyEvent(this.setClearedEvent, this.setHolder);
        this.clearEvents();
        ArrayList<String> newCollection = new ArrayList<String>();
        newCollection.add("fox");
        newCollection.add("fox");
        newCollection.add("bat");
        newCollection.add("bat");
        newCollection.add("bat");
        this.collectionHolder.setValues(newCollection);
        this.verifyEvent(this.collectionChangedEvent, this.collectionHolder, "fox", "fox", "bat", "bat", "bat");
        this.verifyEvent(this.setChangedEvent, this.setHolder, "fox", "bat");
    }

    private CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent event) {
                SetCollectionValueModelTests.this.addEvent = event;
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                SetCollectionValueModelTests.this.removeEvent = event;
            }

            public void collectionCleared(CollectionClearEvent event) {
                SetCollectionValueModelTests.this.collectionClearedEvent = event;
            }

            public void collectionChanged(CollectionChangeEvent event) {
                SetCollectionValueModelTests.this.collectionChangedEvent = event;
            }
        };
    }

    private ChangeListener buildChangeListener() {
        return new ChangeAdapter(){

            public void itemsAdded(CollectionAddEvent event) {
                SetCollectionValueModelTests.this.addEvent = event;
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                SetCollectionValueModelTests.this.removeEvent = event;
            }

            public void collectionCleared(CollectionClearEvent event) {
                SetCollectionValueModelTests.this.collectionClearedEvent = event;
            }

            public void collectionChanged(CollectionChangeEvent event) {
                SetCollectionValueModelTests.this.collectionChangedEvent = event;
            }
        };
    }

    private CollectionChangeListener buildSetCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionAddEvent event) {
                SetCollectionValueModelTests.this.setAddEvent = event;
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                SetCollectionValueModelTests.this.setRemoveEvent = event;
            }

            public void collectionCleared(CollectionClearEvent event) {
                SetCollectionValueModelTests.this.setClearedEvent = event;
            }

            public void collectionChanged(CollectionChangeEvent event) {
                SetCollectionValueModelTests.this.setChangedEvent = event;
            }
        };
    }

    private ChangeListener buildSetChangeListener() {
        return new ChangeAdapter(){

            public void itemsAdded(CollectionAddEvent event) {
                SetCollectionValueModelTests.this.setAddEvent = event;
            }

            public void itemsRemoved(CollectionRemoveEvent event) {
                SetCollectionValueModelTests.this.setRemoveEvent = event;
            }

            public void collectionCleared(CollectionClearEvent event) {
                SetCollectionValueModelTests.this.setClearedEvent = event;
            }

            public void collectionChanged(CollectionChangeEvent event) {
                SetCollectionValueModelTests.this.setChangedEvent = event;
            }
        };
    }

    private void verify(CollectionValueModel<String> cvm, String ... expectedItems) {
        HashBag actual = CollectionTools.bag(cvm);
        HashBag expected = CollectionTools.bag((Object[])expectedItems);
        SetCollectionValueModelTests.assertEquals((Object)expected, (Object)actual);
    }

    private void verifyEvent(CollectionAddEvent event, Object source, Object ... expectedItems) {
        SetCollectionValueModelTests.assertEquals((Object)source, (Object)event.getSource());
        SetCollectionValueModelTests.assertEquals((String)"values", (String)event.getCollectionName());
        SetCollectionValueModelTests.assertEquals((Object)CollectionTools.bag((Object[])expectedItems), (Object)CollectionTools.bag((Iterable)event.getItems()));
    }

    private void verifyEvent(CollectionRemoveEvent event, Object source, Object ... expectedItems) {
        SetCollectionValueModelTests.assertEquals((Object)source, (Object)event.getSource());
        SetCollectionValueModelTests.assertEquals((String)"values", (String)event.getCollectionName());
        SetCollectionValueModelTests.assertEquals((Object)CollectionTools.bag((Object[])expectedItems), (Object)CollectionTools.bag((Iterable)event.getItems()));
    }

    private void verifyEvent(CollectionClearEvent event, Object source) {
        SetCollectionValueModelTests.assertEquals((Object)source, (Object)event.getSource());
        SetCollectionValueModelTests.assertEquals((String)"values", (String)event.getCollectionName());
    }

    private void verifyEvent(CollectionChangeEvent event, Object source, Object ... expectedItems) {
        SetCollectionValueModelTests.assertEquals((Object)source, (Object)event.getSource());
        SetCollectionValueModelTests.assertEquals((String)"values", (String)event.getCollectionName());
        SetCollectionValueModelTests.assertEquals((Object)CollectionTools.bag((Object[])expectedItems), (Object)CollectionTools.bag((Iterable)event.getCollection()));
    }
}

