/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.utility.tests.internal.model.value;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.utility.model.event.ListAddEvent;
import org.eclipse.jpt.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.utility.model.event.ListClearEvent;
import org.eclipse.jpt.utility.model.event.ListEvent;
import org.eclipse.jpt.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.utility.model.listener.ChangeAdapter;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.utility.tests.internal.TestTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleListValueModelTests
extends TestCase {
    private SimpleListValueModel<String> listHolder;
    ListEvent event;
    String eventType;
    private static final String ADD = "add";
    private static final String REMOVE = "remove";
    private static final String REPLACE = "replace";
    private static final String MOVE = "move";
    private static final String CLEAR = "clear";
    private static final String CHANGE = "change";

    public SimpleListValueModelTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.listHolder = new SimpleListValueModel(this.buildList());
    }

    private List<String> buildList() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("foo");
        result.add("bar");
        result.add("baz");
        return result;
    }

    private List<String> buildAddList() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("joo");
        result.add("jar");
        result.add("jaz");
        return result;
    }

    protected void tearDown() throws Exception {
        TestTools.clear(this);
        super.tearDown();
    }

    public void testIterator() {
        SimpleListValueModelTests.assertEquals(this.buildList(), (Object)CollectionTools.list((Iterator)this.listHolder.iterator()));
    }

    public void testListIterator() {
        SimpleListValueModelTests.assertEquals(this.buildList(), (Object)CollectionTools.list((Iterator)this.listHolder.listIterator()));
    }

    public void testListIteratorInt() {
        SimpleListValueModelTests.assertEquals((Object)CollectionTools.list(this.buildList().listIterator(1)), (Object)CollectionTools.list((Iterator)this.listHolder.listIterator(1)));
    }

    public void testSize() {
        SimpleListValueModelTests.assertEquals((int)this.buildList().size(), (int)this.listHolder.size());
    }

    private boolean listContains(Object item) {
        return CollectionTools.contains((Iterator)this.listHolder.listIterator(), (Object)item);
    }

    private boolean listContainsAll(Collection<String> items) {
        return CollectionTools.containsAll((Iterator)this.listHolder.listIterator(), items);
    }

    private boolean listContainsAny(Collection<String> items) {
        HashSet set = CollectionTools.set((Iterator)this.listHolder.iterator());
        Iterator<String> stream = items.iterator();
        while (stream.hasNext()) {
            if (!set.contains(stream.next())) continue;
            return true;
        }
        return false;
    }

    public void testAddObject() {
        SimpleListValueModelTests.assertFalse((boolean)this.listContains("joo"));
        this.listHolder.add((Object)"joo");
        SimpleListValueModelTests.assertTrue((boolean)this.listContains("joo"));
        SimpleListValueModelTests.assertFalse((boolean)this.listContains(null));
        this.listHolder.add(null);
        SimpleListValueModelTests.assertTrue((boolean)this.listContains(null));
    }

    public void testAddIntObject() {
        SimpleListValueModelTests.assertFalse((boolean)this.listContains("joo"));
        this.listHolder.add(2, (Object)"joo");
        SimpleListValueModelTests.assertTrue((boolean)this.listContains("joo"));
        SimpleListValueModelTests.assertFalse((boolean)this.listContains(null));
        this.listHolder.add(0, null);
        SimpleListValueModelTests.assertTrue((boolean)this.listContains(null));
    }

    public void testAddAllCollection() {
        SimpleListValueModelTests.assertFalse((boolean)this.listContainsAny(this.buildAddList()));
        this.listHolder.addAll(this.buildAddList());
        SimpleListValueModelTests.assertTrue((boolean)this.listContainsAll(this.buildAddList()));
    }

    public void testAddAllIntCollection() {
        SimpleListValueModelTests.assertFalse((boolean)this.listContainsAny(this.buildAddList()));
        this.listHolder.addAll(2, this.buildAddList());
        SimpleListValueModelTests.assertTrue((boolean)this.listContainsAll(this.buildAddList()));
    }

    public void testClear() {
        SimpleListValueModelTests.assertFalse((boolean)this.listHolder.isEmpty());
        this.listHolder.clear();
        SimpleListValueModelTests.assertTrue((boolean)this.listHolder.isEmpty());
    }

    public void testContainsObject() {
        SimpleListValueModelTests.assertTrue((boolean)this.listHolder.contains((Object)"foo"));
        SimpleListValueModelTests.assertFalse((boolean)this.listHolder.contains((Object)"joo"));
    }

    public void testContainsAllCollection() {
        ArrayList<String> c = new ArrayList<String>();
        c.add("foo");
        c.add("bar");
        SimpleListValueModelTests.assertTrue((boolean)this.listHolder.containsAll(c));
        c.add("joo");
        SimpleListValueModelTests.assertFalse((boolean)this.listHolder.containsAll(c));
    }

    public void testEquals() {
        SimpleListValueModelTests.assertEquals((Object)new SimpleListValueModel(this.buildList()), this.listHolder);
        SimpleListValueModelTests.assertFalse((boolean)this.listHolder.equals((Object)new SimpleListValueModel(this.buildAddList())));
        SimpleListValueModelTests.assertFalse((boolean)this.listHolder.equals(this.buildList()));
        SimpleListValueModelTests.assertFalse((boolean)this.listHolder.equals((Object)new SimpleListValueModel()));
    }

    public void testGetInt() {
        SimpleListValueModelTests.assertEquals((String)"foo", (String)((String)this.listHolder.get(0)));
        SimpleListValueModelTests.assertEquals((String)"bar", (String)((String)this.listHolder.get(1)));
        SimpleListValueModelTests.assertEquals((String)"baz", (String)((String)this.listHolder.get(2)));
    }

    public void testHashCode() {
        SimpleListValueModelTests.assertEquals((int)new SimpleListValueModel(this.buildList()).hashCode(), (int)this.listHolder.hashCode());
    }

    public void testIndexOfObject() {
        SimpleListValueModelTests.assertEquals((int)0, (int)this.listHolder.indexOf((Object)"foo"));
        SimpleListValueModelTests.assertEquals((int)1, (int)this.listHolder.indexOf((Object)"bar"));
        SimpleListValueModelTests.assertEquals((int)2, (int)this.listHolder.indexOf((Object)"baz"));
        SimpleListValueModelTests.assertEquals((int)-1, (int)this.listHolder.indexOf((Object)"joo"));
    }

    public void testLastIndexOfObject() {
        SimpleListValueModelTests.assertEquals((int)0, (int)this.listHolder.lastIndexOf((Object)"foo"));
        SimpleListValueModelTests.assertEquals((int)1, (int)this.listHolder.lastIndexOf((Object)"bar"));
        SimpleListValueModelTests.assertEquals((int)2, (int)this.listHolder.lastIndexOf((Object)"baz"));
        SimpleListValueModelTests.assertEquals((int)-1, (int)this.listHolder.lastIndexOf((Object)"joo"));
        this.listHolder.add((Object)"foo");
        SimpleListValueModelTests.assertEquals((int)3, (int)this.listHolder.lastIndexOf((Object)"foo"));
    }

    public void testIsEmpty() {
        SimpleListValueModelTests.assertFalse((boolean)this.listHolder.isEmpty());
        this.listHolder.clear();
        SimpleListValueModelTests.assertTrue((boolean)this.listHolder.isEmpty());
    }

    public void testRemove() {
        SimpleListValueModelTests.assertTrue((boolean)this.listContains("bar"));
        this.listHolder.remove(this.buildList().indexOf("bar"));
        SimpleListValueModelTests.assertFalse((boolean)this.listContains("bar"));
        this.listHolder.add(1, null);
        SimpleListValueModelTests.assertTrue((boolean)this.listContains(null));
        this.listHolder.remove(1);
        SimpleListValueModelTests.assertFalse((boolean)this.listContains(null));
    }

    public void testSetValues() {
        ArrayList<String> newList = new ArrayList<String>();
        newList.add("joo");
        newList.add("jar");
        newList.add("jaz");
        SimpleListValueModelTests.assertTrue((boolean)this.listContains("bar"));
        SimpleListValueModelTests.assertFalse((boolean)this.listContains("jar"));
        this.listHolder.setListValues(newList);
        SimpleListValueModelTests.assertFalse((boolean)this.listContains("bar"));
        SimpleListValueModelTests.assertTrue((boolean)this.listContains("jar"));
        this.listHolder.add(1, null);
        SimpleListValueModelTests.assertTrue((boolean)this.listContains(null));
        this.listHolder.remove(1);
        SimpleListValueModelTests.assertFalse((boolean)this.listContains(null));
        this.listHolder.setListValues(new ArrayList());
        SimpleListValueModelTests.assertFalse((boolean)this.listContains("jar"));
    }

    public void testListChange1() {
        this.listHolder.addChangeListener(this.buildChangeListener());
        this.verifyListChange();
    }

    public void testListChange2() {
        this.listHolder.addListChangeListener("list values", this.buildListener());
        this.verifyListChange();
    }

    private void verifyListChange() {
        this.event = null;
        this.eventType = null;
        this.listHolder.add(1, (Object)"joo");
        this.verifyEvent(ADD, 1, "joo");
        this.event = null;
        this.eventType = null;
        this.listHolder.add(1, null);
        this.verifyEvent(ADD, 1, null);
        this.event = null;
        this.eventType = null;
        this.listHolder.remove(1);
        this.verifyEvent(REMOVE, 1, null);
        this.event = null;
        this.eventType = null;
        this.listHolder.remove(1);
        this.verifyEvent(REMOVE, 1, "joo");
        this.event = null;
        this.eventType = null;
        this.listHolder.setListValues(this.buildList());
        this.verifyEvent(CHANGE);
        this.event = null;
        this.eventType = null;
        this.listHolder.addAll(0, this.buildList());
        this.verifyEvent(ADD);
        SimpleListValueModelTests.assertEquals(this.buildList(), (Object)CollectionTools.list((Iterable)((ListAddEvent)this.event).getItems()));
        this.event = null;
        this.eventType = null;
        this.listHolder.set(0, (Object)"joo");
        this.verifyEvent(REPLACE);
        SimpleListValueModelTests.assertFalse((boolean)CollectionTools.contains((Iterable)((ListReplaceEvent)this.event).getNewItems(), (Object)"foo"));
        SimpleListValueModelTests.assertTrue((boolean)CollectionTools.contains((Iterable)((ListReplaceEvent)this.event).getNewItems(), (Object)"joo"));
    }

    private ListChangeListener buildListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent e) {
                SimpleListValueModelTests.this.eventType = SimpleListValueModelTests.ADD;
                SimpleListValueModelTests.this.event = e;
            }

            public void itemsRemoved(ListRemoveEvent e) {
                SimpleListValueModelTests.this.eventType = SimpleListValueModelTests.REMOVE;
                SimpleListValueModelTests.this.event = e;
            }

            public void itemsReplaced(ListReplaceEvent e) {
                SimpleListValueModelTests.this.eventType = SimpleListValueModelTests.REPLACE;
                SimpleListValueModelTests.this.event = e;
            }

            public void itemsMoved(ListMoveEvent e) {
                SimpleListValueModelTests.this.eventType = SimpleListValueModelTests.MOVE;
                SimpleListValueModelTests.this.event = e;
            }

            public void listCleared(ListClearEvent e) {
                SimpleListValueModelTests.this.eventType = SimpleListValueModelTests.CLEAR;
                SimpleListValueModelTests.this.event = e;
            }

            public void listChanged(ListChangeEvent e) {
                SimpleListValueModelTests.this.eventType = SimpleListValueModelTests.CHANGE;
                SimpleListValueModelTests.this.event = e;
            }
        };
    }

    private ChangeListener buildChangeListener() {
        return new ChangeAdapter(){

            public void itemsAdded(ListAddEvent e) {
                SimpleListValueModelTests.this.eventType = SimpleListValueModelTests.ADD;
                SimpleListValueModelTests.this.event = e;
            }

            public void itemsRemoved(ListRemoveEvent e) {
                SimpleListValueModelTests.this.eventType = SimpleListValueModelTests.REMOVE;
                SimpleListValueModelTests.this.event = e;
            }

            public void itemsReplaced(ListReplaceEvent e) {
                SimpleListValueModelTests.this.eventType = SimpleListValueModelTests.REPLACE;
                SimpleListValueModelTests.this.event = e;
            }

            public void itemsMoved(ListMoveEvent e) {
                SimpleListValueModelTests.this.eventType = SimpleListValueModelTests.MOVE;
                SimpleListValueModelTests.this.event = e;
            }

            public void listCleared(ListClearEvent e) {
                SimpleListValueModelTests.this.eventType = SimpleListValueModelTests.CLEAR;
                SimpleListValueModelTests.this.event = e;
            }

            public void listChanged(ListChangeEvent e) {
                SimpleListValueModelTests.this.eventType = SimpleListValueModelTests.CHANGE;
                SimpleListValueModelTests.this.event = e;
            }
        };
    }

    private void verifyEvent(String e) {
        SimpleListValueModelTests.assertEquals((String)e, (String)this.eventType);
        SimpleListValueModelTests.assertEquals(this.listHolder, (Object)this.event.getSource());
        SimpleListValueModelTests.assertEquals((String)"list values", (String)this.event.getListName());
    }

    private void verifyEvent(String e, int index, Object item) {
        this.verifyEvent(e);
        if (e == ADD) {
            SimpleListValueModelTests.assertEquals((int)index, (int)((ListAddEvent)this.event).getIndex());
            SimpleListValueModelTests.assertEquals((Object)item, ((ListAddEvent)this.event).getItems().iterator().next());
        } else if (e == REMOVE) {
            SimpleListValueModelTests.assertEquals((int)index, (int)((ListRemoveEvent)this.event).getIndex());
            SimpleListValueModelTests.assertEquals((Object)item, ((ListRemoveEvent)this.event).getItems().iterator().next());
        }
    }
}

