/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.ui.internal.assembly.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.common.internal.modulecore.util.JavaModuleComponentUtility;
import org.eclipse.jst.common.ui.internal.Messages;
import org.eclipse.jst.common.ui.internal.assembly.wizard.ManifestModuleDependencyControl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.impl.TaskModel;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.IWizardHandle;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.TaskWizard;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;

public class AddManifestEntryTaskWizard
extends TaskWizard {
    public static final String PARENT_PROJECT = "PARENT_PROJECT";
    public static final String CHILD_PROJECT = "CHILD_PROJECT";
    public static final String CURRENT_REFERENCES = "CURRENT_REFERENCES";
    public static final String RETURNED_REFERENCES = "RETURNED_REFERENCES";

    public AddManifestEntryTaskWizard() {
        super(Messages.AddManifestEntryTaskWizardTitle, (WizardFragment)new ManifestRootFragment());
    }

    public static class ManifestRootFragment
    extends WizardFragment {
        private TableViewer viewer;
        private Button addCustom;
        private Text customEntryText;
        protected IProject parentProject;
        protected IProject childProject;
        private IVirtualReference[] selected;
        private ShowPossibleManifestEntryContentProvider contentProvider;
        private Link parentContainerLink;

        public boolean hasComposite() {
            return true;
        }

        private void updateWidgets() throws InvocationTargetException {
            this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
            this.viewer.refresh();
        }

        public Composite createComposite(Composite parent, IWizardHandle handle) {
            this.parentProject = (IProject)this.getTaskModel().getObject(AddManifestEntryTaskWizard.PARENT_PROJECT);
            this.childProject = (IProject)this.getTaskModel().getObject(AddManifestEntryTaskWizard.CHILD_PROJECT);
            handle.setTitle(Messages.AddManifestEntryTaskWizardTitle);
            handle.setDescription(NLS.bind((String)Messages.AddManifestEntryTaskWizardDesc, (Object)this.parentProject.getName()));
            Composite root = new Composite(parent, 0);
            root.setLayout((Layout)new FormLayout());
            this.createConfigLink(root);
            this.parentContainerLink.setLayoutData((Object)ManifestModuleDependencyControl.createFormData(0, 5, null, 5, 0, 5, 100, -5));
            Label tableLabel = new Label(root, 0);
            tableLabel.setText(Messages.ManifestEntries);
            tableLabel.setLayoutData((Object)ManifestModuleDependencyControl.createFormData(10, 5, null, 0, 0, 5, 100, -5));
            this.viewer = ManifestModuleDependencyControl.createManifestReferenceTableViewer(root, 2);
            this.contentProvider = new ShowPossibleManifestEntryContentProvider(this.parentProject, this.childProject, this.getTaskModel());
            this.viewer.setContentProvider((IContentProvider)this.contentProvider);
            this.viewer.setLabelProvider((IBaseLabelProvider)new ManifestModuleDependencyControl.ManifestLabelProvider());
            this.viewer.setInput((Object)ResourcesPlugin.getWorkspace());
            this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ManifestRootFragment.this.viewerSelectionChanged();
                }
            });
            this.customEntryText = new Text(root, 2048);
            this.addCustom = new Button(root, 8);
            this.addCustom.setText(Messages.CustomEntryButton);
            this.addCustom.setLayoutData((Object)ManifestModuleDependencyControl.createFormData(null, 0, 100, -5, null, 0, 100, -5));
            this.addCustom.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ManifestRootFragment.this.addCustomPressed();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.customEntryText.setLayoutData((Object)ManifestModuleDependencyControl.createFormData(null, 0, 100, -5, 0, 5, this.addCustom, -5));
            this.viewer.getTable().setLayoutData((Object)ManifestModuleDependencyControl.createFormData(tableLabel, 5, this.addCustom, 0, 0, 5, 100, -5));
            return root;
        }

        private void addCustomPressed() {
            IVirtualReference ref = ManifestModuleDependencyControl.createDummyReference(this.customEntryText.getText(), this.parentProject, ComponentCore.createComponent((IProject)this.parentProject));
            this.contentProvider.addPossibleReference(ref);
            this.customEntryText.setText("");
            this.viewer.refresh();
        }

        private void viewerSelectionChanged() {
            IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
            Object[] obj = sel.toArray();
            IVirtualReference[] ret = new IVirtualReference[obj.length];
            int i = 0;
            while (i < ret.length) {
                ret[i] = (IVirtualReference)obj[i];
                ++i;
            }
            this.selected = ret;
        }

        private void createConfigLink(Composite aGroup) {
            this.parentContainerLink = new Link(aGroup, 0);
            this.parentContainerLink.setText("<A>" + Messages.ConfigureParentLink + "</A>");
            this.parentContainerLink.addSelectionListener(new SelectionListener(){

                public void doLinkActivated(Link e) {
                    IProject parentProject = ManifestRootFragment.this.parentProject;
                    PropertyDialog dialog = PropertyDialog.createDialogOn((Shell)ManifestRootFragment.this.getPage().getControl().getShell(), (String)"org.eclipse.wst.common.componentcore.ui.DeploymentAssemblyPage", (Object)parentProject);
                    if (dialog != null) {
                        dialog.open();
                    }
                    try {
                        ManifestRootFragment.this.updateWidgets();
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.doLinkActivated((Link)e.widget);
                }

                public void widgetSelected(SelectionEvent e) {
                    this.doLinkActivated((Link)e.widget);
                }
            });
        }

        public void performFinish(IProgressMonitor monitor) throws CoreException {
            this.getTaskModel().putObject(AddManifestEntryTaskWizard.RETURNED_REFERENCES, (Object)this.selected);
        }
    }

    public static class ShowPossibleManifestEntryContentProvider
    extends ArrayContentProvider {
        private IProject parent;
        private IProject child;
        private TaskModel model;
        private IVirtualReference[] possible;

        public ShowPossibleManifestEntryContentProvider(IProject parent, IProject child, TaskModel taskModel) {
            this.parent = parent;
            this.child = child;
            this.model = taskModel;
        }

        public Object[] getElements(Object inputElement) {
            if (this.possible == null) {
                IVirtualReference[] current = (IVirtualReference[])this.model.getObject(AddManifestEntryTaskWizard.CURRENT_REFERENCES);
                this.possible = JavaModuleComponentUtility.findPossibleManifestEntries((IProject)this.parent, (IProject)this.child, (IVirtualReference[])current);
            }
            return this.possible;
        }

        public void addPossibleReference(IVirtualReference ref) {
            ArrayList<IVirtualReference> newRefs = new ArrayList<IVirtualReference>();
            newRefs.addAll(Arrays.asList(this.possible));
            newRefs.add(ref);
            this.possible = newRefs.toArray(new IVirtualReference[newRefs.size()]);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                this.possible = null;
                viewer.refresh();
            }
        }
    }
}

