/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.debugger;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.Breakpoint;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.RhinoDebuggerImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.ScriptSource;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.StackFrame;
import org.eclipse.wst.jsdt.debug.internal.rhino.debugger.ThreadData;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Request;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Response;

public class RequestHandler {
    public static final String VERSION_1_6 = "1.6";
    private RhinoDebuggerImpl debugger;

    public RequestHandler(RhinoDebuggerImpl debugger) {
        this.debugger = debugger;
    }

    public Response handleRequest(Request request) {
        String command = request.getCommand();
        Response response = new Response(request.getSequence(), command);
        try {
            if (command.equals("version")) {
                this.handleVersionRequest(request, response);
            } else if (command.equals("suspend")) {
                this.handleSuspendRequest(request, response);
            } else if (command.equals("continue")) {
                this.handleContinueRequest(request, response);
            } else if (command.equals("dispose")) {
                this.handleDisposeRequest(request, response);
            } else if (command.equals("threads")) {
                this.handleThreadsRequest(request, response);
            } else if (command.equals("thread")) {
                this.handleThreadRequest(request, response);
            } else if (command.equals("frames")) {
                this.handleFramesRequest(request, response);
            } else if (command.equals("frame")) {
                this.handleFrameRequest(request, response);
            } else if (command.equals("scripts")) {
                this.handleScriptsRequest(request, response);
            } else if (command.equals("script")) {
                this.handleScriptRequest(request, response);
            } else if (command.equals("evaluate")) {
                this.handleEvaluateRequest(request, response);
            } else if (command.equals("lookup")) {
                this.handleLookupRequest(request, response);
            } else if (command.equals("breakpoints")) {
                this.handleBreakpointsRequest(request, response);
            } else if (command.equals("breakpoint")) {
                this.handleBreakpointRequest(request, response);
            } else if (command.equals("setbreakpoint")) {
                this.handleSetBreakpointRequest(request, response);
            } else if (command.equals("clearbreakpoint")) {
                this.handleClearBreakpointRequest(request, response);
            } else {
                response.setSuccess(false);
                response.setMessage("command not supported");
            }
        }
        catch (Throwable t) {
            response.setSuccess(false);
            response.setMessage(String.valueOf(t.getClass().getName()) + " - " + t.getMessage());
            t.printStackTrace();
        }
        return response;
    }

    private void handleClearBreakpointRequest(Request request, Response response) {
        Map arguments = request.getArguments();
        Long breakpointId = RequestHandler.numberToLong((Number)arguments.get("breakpointId"));
        if (breakpointId == null) {
            response.setSuccess(false);
            response.setMessage(this.missingArgument("breakpointId"));
            return;
        }
        Breakpoint breakpoint = this.debugger.clearBreakpoint(breakpointId);
        if (breakpoint == null) {
            response.setSuccess(false);
            response.setMessage("not found");
            return;
        }
        response.getBody().put("breakpoint", breakpoint.toJSON());
    }

    private void handleSetBreakpointRequest(Request request, Response response) {
        Map arguments = request.getArguments();
        Long scriptId = RequestHandler.numberToLong((Number)arguments.get("scriptId"));
        Integer line = this.numberToInteger((Number)arguments.get("line"));
        String function = (String)arguments.get("function");
        Long threadId = RequestHandler.numberToLong((Number)arguments.get("threadId"));
        String condition = (String)arguments.get("condition");
        Breakpoint breakpoint = this.debugger.setBreakpoint(scriptId, line, function, condition, threadId);
        if (breakpoint != null) {
            response.getBody().put("breakpoint", breakpoint.toJSON());
        }
    }

    private void handleBreakpointRequest(Request request, Response response) {
        Map arguments = request.getArguments();
        Long breakpointId = RequestHandler.numberToLong((Number)arguments.get("breakpointId"));
        if (breakpointId == null) {
            response.setSuccess(false);
            response.setMessage(this.missingArgument("breakpointId"));
            return;
        }
        Breakpoint breakpoint = this.debugger.getBreakpoint(breakpointId);
        if (breakpoint == null) {
            response.setSuccess(false);
            response.setMessage("not found");
            return;
        }
        response.getBody().put("breakpoint", breakpoint.toJSON());
    }

    private void handleBreakpointsRequest(Request request, Response response) {
        Collection breakpoints = this.debugger.getBreakpoints();
        response.getBody().put("breakpoints", breakpoints);
    }

    private void handleEvaluateRequest(Request request, Response response) {
        Map arguments = request.getArguments();
        Long threadId = RequestHandler.numberToLong((Number)arguments.get("threadId"));
        if (threadId == null) {
            response.setSuccess(false);
            response.setMessage(this.missingArgument("threadId"));
            return;
        }
        Long frameId = RequestHandler.numberToLong((Number)arguments.get("frameId"));
        if (frameId == null) {
            response.setSuccess(false);
            response.setMessage(this.missingArgument("frameId"));
            return;
        }
        String evaluate = (String)arguments.get("expression");
        if (evaluate == null) {
            response.setSuccess(false);
            response.setMessage(this.missingArgument("expression"));
            return;
        }
        StackFrame frame = this.debugger.getFrame(threadId, frameId);
        if (frame == null) {
            response.setSuccess(false);
            response.setMessage("not found");
            return;
        }
        Object result = frame.evaluate(evaluate);
        response.getBody().put("evaluate", result);
    }

    private void handleLookupRequest(Request request, Response response) {
        Map arguments = request.getArguments();
        Long threadId = RequestHandler.numberToLong((Number)arguments.get("threadId"));
        if (threadId == null) {
            response.setSuccess(false);
            response.setMessage(this.missingArgument("threadId"));
            return;
        }
        Long frameId = RequestHandler.numberToLong((Number)arguments.get("frameId"));
        if (frameId == null) {
            response.setSuccess(false);
            response.setMessage(this.missingArgument("frameId"));
            return;
        }
        Long handle = RequestHandler.numberToLong((Number)arguments.get("handle"));
        if (handle == null) {
            response.setSuccess(false);
            response.setMessage(this.missingArgument("handle"));
            return;
        }
        StackFrame frame = this.debugger.getFrame(threadId, frameId);
        if (frame == null) {
            response.setSuccess(false);
            response.setMessage("not found");
            return;
        }
        Object result = frame.lookup(handle);
        response.getBody().put("lookup", result);
    }

    private void handleScriptRequest(Request request, Response response) {
        Map arguments = request.getArguments();
        Long scriptId = RequestHandler.numberToLong((Number)arguments.get("scriptId"));
        if (scriptId == null) {
            response.setSuccess(false);
            response.setMessage(this.missingArgument("scriptId"));
            return;
        }
        ScriptSource script = this.debugger.getScript(scriptId);
        if (script == null) {
            response.setSuccess(false);
            response.setMessage("not found");
            return;
        }
        response.getBody().put("script", script.toJSON());
    }

    private void handleScriptsRequest(Request request, Response response) {
        List scriptIds = this.debugger.getScriptIds();
        response.getBody().put("scripts", scriptIds);
    }

    private void handleFrameRequest(Request request, Response response) {
        Map arguments = request.getArguments();
        Long threadId = RequestHandler.numberToLong((Number)arguments.get("threadId"));
        if (threadId == null) {
            response.setSuccess(false);
            response.setMessage(this.missingArgument("threadId"));
            return;
        }
        Long frameId = RequestHandler.numberToLong((Number)arguments.get("frameId"));
        if (frameId == null) {
            response.setSuccess(false);
            response.setMessage(this.missingArgument("frameId"));
            return;
        }
        StackFrame frame = this.debugger.getFrame(threadId, frameId);
        if (frame == null) {
            response.setSuccess(false);
            response.setMessage("not found");
            return;
        }
        response.getBody().put("frame", frame.toJSON());
    }

    private void handleFramesRequest(Request request, Response response) {
        Map arguments = request.getArguments();
        Long threadId = RequestHandler.numberToLong((Number)arguments.get("threadId"));
        if (threadId == null) {
            response.setSuccess(false);
            response.setMessage(this.missingArgument("threadId"));
            return;
        }
        List frameIds = this.debugger.getFrameIds(threadId);
        response.getBody().put("frames", frameIds);
    }

    private void handleThreadRequest(Request request, Response response) {
        Map arguments = request.getArguments();
        Long threadId = RequestHandler.numberToLong((Number)arguments.get("threadId"));
        if (threadId == null) {
            response.setSuccess(false);
            response.setMessage(this.missingArgument("threadId"));
            return;
        }
        ThreadData threadData = this.debugger.getThreadData(threadId);
        if (threadData == null) {
            response.setSuccess(false);
            response.setMessage("not found");
            return;
        }
        response.getBody().put("thread", threadData.toJSON());
    }

    private String missingArgument(String key) {
        return "Missing Argument: " + key;
    }

    private void handleThreadsRequest(Request request, Response response) {
        List threadIds = this.debugger.getThreadIds();
        response.getBody().put("threads", threadIds);
    }

    private void handleDisposeRequest(Request request, Response response) {
        this.debugger.disconnect();
    }

    private void handleContinueRequest(Request request, Response response) {
        Map arguments = request.getArguments();
        Long threadId = RequestHandler.numberToLong((Number)arguments.get("threadId"));
        if (threadId == null) {
            this.debugger.resumeAll();
            return;
        }
        String stepType = (String)arguments.get("step");
        this.debugger.resume(threadId, stepType);
    }

    private void handleSuspendRequest(Request request, Response response) {
        Map arguments = request.getArguments();
        Long threadId = RequestHandler.numberToLong((Number)arguments.get("threadId"));
        if (threadId == null) {
            this.debugger.suspendAll();
            return;
        }
        this.debugger.suspend(threadId);
    }

    private static Long numberToLong(Number number) {
        if (number == null) {
            return null;
        }
        return new Long(number.longValue());
    }

    private Integer numberToInteger(Number number) {
        if (number == null) {
            return null;
        }
        return new Integer(number.intValue());
    }

    private void handleVersionRequest(Request request, Response response) {
        Map body = response.getBody();
        body.put("javascript.version", VERSION_1_6);
        body.put("ecmascript.version", "3");
        body.put("javascript.vm.name", "Rhino");
        body.put("javascript.vm.version", VERSION_1_6);
        body.put("javascript.vm.vendor", "Mozilla");
    }
}

