/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Connection;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.DisconnectedException;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Packet;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.PacketManager;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Response;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.TimeoutException;

public class PacketReceiveManager
extends PacketManager {
    public static final int TIMEOUT_NOT_BLOCKING = 0;
    public static final int TIMEOUT_INFINITE = -1;
    private List commandPackets = new LinkedList();
    private List responsePackets = new LinkedList();
    private List timedOutPackets = new ArrayList();

    public PacketReceiveManager(Connection connection) {
        super(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        super.disconnect();
        List list = this.commandPackets;
        synchronized (list) {
            this.commandPackets.notifyAll();
        }
        list = this.responsePackets;
        synchronized (list) {
            this.responsePackets.notifyAll();
        }
    }

    public void run() {
        try {
            while (!this.isDisconnected()) {
                this.readAvailablePacket();
            }
        }
        catch (InterruptedIOException e) {
            this.disconnect(e);
        }
        catch (IOException e) {
            this.disconnect(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet getCommand(String type, long timeToWait) throws TimeoutException, DisconnectedException {
        List list = this.commandPackets;
        synchronized (list) {
            long remainingTime = timeToWait;
            while (!this.isDisconnected() || !this.commandPackets.isEmpty()) {
                Packet packet = this.removeCommandPacket(type);
                if (packet != null) {
                    return packet;
                }
                if (remainingTime < 0L && timeToWait != -1L) break;
                long timeBeforeWait = System.currentTimeMillis();
                try {
                    this.waitForPacketAvailable(remainingTime, this.commandPackets);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                long waitedTime = System.currentTimeMillis() - timeBeforeWait;
                remainingTime -= waitedTime;
            }
        }
        if (this.isDisconnected()) {
            throw new DisconnectedException("Runtime disconnected", this.getDisconnectedException());
        }
        throw new TimeoutException("Timed out waiting for command packet: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getResponse(int requestSequence, long timeToWait) throws TimeoutException, DisconnectedException {
        List list = this.responsePackets;
        synchronized (list) {
            long remainingTime = timeToWait;
            while (!this.isDisconnected()) {
                Response response = this.removeResponsePacket(requestSequence);
                if (response != null) {
                    return response;
                }
                if (remainingTime < 0L && timeToWait != -1L) break;
                long timeBeforeWait = System.currentTimeMillis();
                try {
                    this.waitForPacketAvailable(remainingTime, this.responsePackets);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                long waitedTime = System.currentTimeMillis() - timeBeforeWait;
                remainingTime -= waitedTime;
            }
        }
        if (this.isDisconnected()) {
            throw new DisconnectedException("Runtime disconnected", this.getDisconnectedException());
        }
        list = this.responsePackets;
        synchronized (list) {
            this.timedOutPackets.add(new Integer(requestSequence));
        }
        throw new TimeoutException("Timed out waiting for packet: " + requestSequence);
    }

    private void waitForPacketAvailable(long timeToWait, Object lock) throws InterruptedException {
        if (timeToWait == 0L) {
            return;
        }
        if (timeToWait < 0L) {
            lock.wait();
        } else {
            lock.wait(timeToWait);
        }
    }

    private Packet removeCommandPacket(String type) {
        ListIterator iter = this.commandPackets.listIterator();
        while (iter.hasNext()) {
            Packet packet = (Packet)iter.next();
            if (type != null && !packet.getType().equals(type)) continue;
            iter.remove();
            return packet;
        }
        return null;
    }

    private Response removeResponsePacket(int requestSequence) {
        ListIterator iter = this.responsePackets.listIterator();
        while (iter.hasNext()) {
            Response response = (Response)iter.next();
            if (requestSequence != response.getRequestSequence()) continue;
            iter.remove();
            return response;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommandPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        List list = this.commandPackets;
        synchronized (list) {
            this.commandPackets.add(packet);
            this.commandPackets.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addResponsePacket(Response response) {
        if (response == null) {
            return;
        }
        List list = this.responsePackets;
        synchronized (list) {
            Integer requestSeq;
            if (!this.timedOutPackets.isEmpty() && this.timedOutPackets.remove(requestSeq = new Integer(response.getRequestSequence()))) {
                return;
            }
            this.responsePackets.add(response);
            this.responsePackets.notifyAll();
        }
    }

    private void readAvailablePacket() throws IOException {
        Packet packet = this.getConnection().readPacket();
        if (packet instanceof Response) {
            this.addResponsePacket((Response)packet);
        } else {
            this.addCommandPacket(packet);
        }
    }
}

