/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.transport;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Connection;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.PipedConnection;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.TransportService;

public class PipedTransportService
implements TransportService {
    Map listeners = new HashMap();

    public synchronized TransportService.ListenerKey startListening(String address) throws IOException {
        PipedListenerKey key = new PipedListenerKey(address == null ? "" : address);
        this.listeners.put(key, null);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopListening(TransportService.ListenerKey key) throws IOException {
        TransportService.ListenerKey listenerKey = key;
        synchronized (listenerKey) {
            if (this.listeners.containsKey(key)) {
                key.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection accept(TransportService.ListenerKey key, long attachTimeout, long handshakeTimeout) throws IOException {
        long timeout = attachTimeout;
        if (timeout > 0L && timeout > Integer.MAX_VALUE) {
            timeout = Integer.MAX_VALUE;
        }
        Map map = this.listeners;
        synchronized (map) {
            PipedOutputStream serveros;
            PipedInputStream serveris;
            block10: {
                if (!this.listeners.containsKey(key)) {
                    throw new IllegalStateException("not listening");
                }
                if (this.listeners.get(key) != null) {
                    throw new IllegalStateException("PipedTransport only accepts one accept at a time");
                }
                serveris = new PipedInputStream();
                PipedOutputStream clientos = new PipedOutputStream();
                serveris.connect(clientos);
                serveros = new PipedOutputStream();
                PipedInputStream clientis = new PipedInputStream();
                serveros.connect(clientis);
                this.listeners.put(key, new PipedConnection(clientis, clientos));
                this.listeners.notifyAll();
                long startTime = System.currentTimeMillis();
                do {
                    try {
                        this.listeners.wait(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException("accept failed: interrupted");
                    }
                    if (!this.listeners.containsKey(key)) {
                        throw new IOException("accept failed: stopped listening");
                    }
                    if (this.listeners.get(key) == null) break block10;
                } while (System.currentTimeMillis() - startTime <= timeout);
                this.listeners.put(key, null);
                throw new IOException("accept failed: timed out");
            }
            return new PipedConnection(serveris, serveros);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection attach(String address, long attachTimeout, long handshakeTimeout) throws IOException {
        Connection connection;
        PipedListenerKey key = new PipedListenerKey(address == null ? "" : address);
        long startTime = System.currentTimeMillis();
        Map map = this.listeners;
        synchronized (map) {
            connection = (Connection)this.listeners.get(key);
            while (connection == null) {
                if (System.currentTimeMillis() - startTime > attachTimeout) {
                    throw new IOException("attach failed: timed out");
                }
                try {
                    this.listeners.wait(attachTimeout);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("attach failed: interrupted");
                }
                connection = (Connection)this.listeners.get(key);
            }
            this.listeners.put(key, null);
            this.listeners.notifyAll();
        }
        return connection;
    }

    public static class PipedListenerKey
    implements TransportService.ListenerKey {
        private String address;

        public PipedListenerKey(String address) {
            this.address = address;
        }

        public String address() {
            return this.address;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PipedListenerKey other = (PipedListenerKey)obj;
            return !(this.address == null ? other.address != null : !this.address.equals(other.address));
        }
    }
}

