/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.transport;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Connection;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.EventPacket;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.JSONUtil;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Packet;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Request;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Response;

public class SocketConnection
implements Connection {
    private Writer writer;
    private Reader reader;
    private Socket socket;

    public SocketConnection(Socket socket) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("You cannot create a new SocketConnection on a null Socket");
        }
        this.socket = socket;
        this.writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
    }

    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public void writePacket(Packet packet) throws IOException {
        String jsonString = JSONUtil.write(packet.toJSON());
        String count = Integer.toString(jsonString.length());
        this.writer.write(count);
        this.writer.write(13);
        this.writer.write(10);
        this.writer.write(jsonString);
        this.writer.flush();
    }

    public Packet readPacket() throws IOException {
        int c;
        StringBuffer buffer = new StringBuffer();
        while ((c = this.reader.read()) != -1) {
            if (c == 13) break;
            buffer.append((char)c);
            if (buffer.length() <= 10) continue;
            throw new IOException("Invalid content length: " + buffer.toString());
        }
        int length = 0;
        try {
            length = Integer.parseInt(buffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Failed to parse content length: " + buffer.toString());
        }
        if (13 != c || '\n' != (char)this.reader.read()) {
            throw new IOException("Missing CRLF after content length");
        }
        char[] message = new char[length];
        int n = 0;
        int off = 0;
        while (n < length) {
            int count = this.reader.read(message, off + n, length - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
        Map json = (Map)JSONUtil.read(new String(message));
        String type = Packet.getType(json);
        if ("event".equals(type)) {
            return new EventPacket(json);
        }
        if ("request".equals(type)) {
            return new Request(json);
        }
        if ("response".equals(type)) {
            return new Response(json);
        }
        throw new IOException("Unknown packet type: " + type);
    }
}

