/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************
 *
 **/
/**
  * Object strong()
  * @type strong
  * @super Object
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535897.aspx
*/

function strong(){};
strong.prototype= new Object();
/**
  * Property accessKey
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533062.aspx
*/

strong.prototype.accessKey="";
/**
  * Property canHaveChildren
  * @type Boolean
  * @returns {Boolean}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533546.aspx
*/

strong.prototype.canHaveChildren=false;
/**
  * Property canHaveHTML
  * @type Boolean
  * @returns {Boolean}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537836.aspx
*/

strong.prototype.canHaveHTML=false;
/**
  * Property className
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533560.aspx
*/

strong.prototype.className="";
/**
  * Property clientHeight
  * @type Number
  * @returns {Number}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533563.aspx
*/

strong.prototype.clientHeight=0;
/**
  * Property clientLeft
  * @type Number
  * @returns {Number}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533564.aspx
*/

strong.prototype.clientLeft=0;
/**
  * Property offsetLeft
  * @type Number
  * @returns {Number}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534200.aspx
*/

strong.prototype.offsetLeft=0;
/**
  * Property clientTop
  * @type Number
  * @returns {Number}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533565.aspx
*/

strong.prototype.clientTop=0;
/**
  * Property offsetTop
  * @type Number
  * @returns {Number}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534303.aspx
*/

strong.prototype.offsetTop=0;
/**
  * Property clientWidth
  * @type Number
  * @returns {Number}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533566.aspx
*/

strong.prototype.clientWidth=0;
/**
  * Property contentEditable
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537837.aspx
*/

strong.prototype.contentEditable="";
/**
  * Property dir
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533728.aspx
*/

strong.prototype.dir="";
/**
  * Property firstChild
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533755.aspx
*/

strong.prototype.firstChild=new Object();
/**
  * Property childNodes
  * @type childNodes
  * @returns {childNodes}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537445.aspx
*/

strong.prototype.childNodes= new childNodes();
/**
  * Property hideFocus
  * @type Boolean
  * @returns {Boolean}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533783.aspx
*/

strong.prototype.hideFocus=false;
/**
  * Property id
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533880.aspx
*/

strong.prototype.id="";
/**
  * Property innerHTML
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533897.aspx
*/

strong.prototype.innerHTML="";
/**
  * Property innerText
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533899.aspx
*/

strong.prototype.innerText="";
/**
  * Property isContentEditable
  * @type Boolean
  * @returns {Boolean}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537838.aspx
*/

strong.prototype.isContentEditable=false;
/**
  * Property isDisabled
  * @type Boolean
  * @returns {Boolean}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533902.aspx
*/

strong.prototype.isDisabled=false;
/**
  * Property isMultiLine
  * @type Boolean
  * @returns {Boolean}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537839.aspx
*/

strong.prototype.isMultiLine=false;
/**
  * Property isTextEdit
  * @type Boolean
  * @returns {Boolean}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533920.aspx
*/

strong.prototype.isTextEdit=false;
/**
  * Property TextRange
  * @type TextRange
  * @returns {TextRange}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535872.aspx
*/

strong.prototype.TextRange= new TextRange();
/**
  * Property lang
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533935.aspx
*/

strong.prototype.lang="";
/**
  * Property language
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533940.aspx
*/

strong.prototype.language="";
/**
  * Property lastChild
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533943.aspx
*/

strong.prototype.lastChild=new Object();
/**
  * Property nextSibling
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534189.aspx
*/

strong.prototype.nextSibling=new Object();
/**
  * Property nodeName
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534190.aspx
*/

strong.prototype.nodeName="";
/**
  * Property nodeType
  * @type Number
  * @returns {Number}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534191.aspx
*/

strong.prototype.nodeType=0;
/**
  * Property nodeValue
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534192.aspx
*/

strong.prototype.nodeValue=new Object();
/**
  * Property offsetHeight
  * @type Number
  * @returns {Number}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534199.aspx
*/

strong.prototype.offsetHeight=0;
/**
  * Property offsetParent
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534302.aspx
*/

strong.prototype.offsetParent=new Object();
/**
  * Property offsetWidth
  * @type Number
  * @returns {Number}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534304.aspx
*/

strong.prototype.offsetWidth=0;
/**
  * Property onOffBehavior
  * @type DABoolean
  * @returns {DABoolean}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533630.aspx
*/

strong.prototype.onOffBehavior=new DABoolean();
/**
  * Property outerHTML
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534310.aspx
*/

strong.prototype.outerHTML="";
/**
  * Property outerText
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534311.aspx
*/

strong.prototype.outerText="";
/**
  * Property ownerDocument
  * @type document
  * @returns {document}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534315.aspx
*/

strong.prototype.ownerDocument=new document();
/**
  * Property document
  * @type document
  * @returns {document}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531073.aspx
*/

strong.prototype.document= new document();
/**
  * Property parentElement
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534327.aspx
*/

strong.prototype.parentElement=new Object();
/**
  * Property parentNode
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534328.aspx
*/

strong.prototype.parentNode=new Object();
/**
  * Property parentTextEdit
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534330.aspx
*/

strong.prototype.parentTextEdit=new Object();
/**
  * Property previousSibling
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534350.aspx
*/

strong.prototype.previousSibling=new Object();
/**
  * Property readyState
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534358.aspx
*/

strong.prototype.readyState=new Object();
/**
  * Property scopeName
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534388.aspx
*/

strong.prototype.scopeName="";
/**
  * Property scrollHeight
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534615.aspx
*/

strong.prototype.scrollHeight=new Object();
/**
  * Property scrollLeft
  * @type Number
  * @returns {Number}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534617.aspx
*/

strong.prototype.scrollLeft=0;
/**
  * Property scrollTop
  * @type Number
  * @returns {Number}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534618.aspx
*/

strong.prototype.scrollTop=0;
/**
  * Property scrollWidth
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534619.aspx
*/

strong.prototype.scrollWidth=new Object();
/**
  * Property sourceIndex
  * @type Number
  * @returns {Number}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534635.aspx
*/

strong.prototype.sourceIndex=0;
/**
  * Property all
  * @type all
  * @returns {all}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537434.aspx
*/

strong.prototype.all= new all();
/**
  * Property tabIndex
  * @type Number
  * @returns {Number}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534654.aspx
*/

strong.prototype.tabIndex=0;
/**
  * Property tagName
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534657.aspx
*/

strong.prototype.tagName="";
/**
  * Property tagUrn
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534658.aspx
*/

strong.prototype.tagUrn="";
/**
  * Property title
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534683.aspx
*/

strong.prototype.title="";
/**
  * Property uniqueID
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534704.aspx
*/

strong.prototype.uniqueID="";
/**
  * function addBehavior(sUrl)
  * @param {String} sUrl
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535922.aspx
*/

strong.prototype.addBehavior=function(sUrl){};
/**
  * function appendChild(oNode)
  * @param {appendChild} oNode
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535934.aspx
*/

strong.prototype.appendChild=function(oNode){};
/**
  * function applyElement(oNewElement)
  * @param {String} oNewElement
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536341.aspx
*/

strong.prototype.applyElement=function(oNewElement){};
/**
  * function attachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {Boolean} fpNotify
  * @type Boolean
  * @returns {Boolean}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536343.aspx
*/

strong.prototype.attachEvent=function(sEvent,fpNotify){};
/**
  * function blur()
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536347.aspx
*/

strong.prototype.blur=function(){};
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

strong.prototype.onblur= new onblur();
/**
  * function clearAttributes()
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536350.aspx
*/

strong.prototype.clearAttributes=function(){};
/**
  * function click()
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536363.aspx
*/

strong.prototype.click=function(){};
/**
  * Property onclick
  * @type onclick
  * @returns {onclick}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536913.aspx
*/

strong.prototype.onclick= new onclick();
/**
  * function cloneNode(bCloneChildren)
  * @param {Boolean} bCloneChildren
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536365.aspx
*/

strong.prototype.cloneNode=function(bCloneChildren){};
/**
  * function componentFromPoint(iCoordX,iCoordY)
  * @param {Number} iCoordX
  * @param {Number} iCoordY
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536375.aspx
*/

strong.prototype.componentFromPoint=function(iCoordX,iCoordY){};
/**
  * function contains(oElement)
  * @param {Boolean} oElement
  * @type Boolean
  * @returns {Boolean}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536377.aspx
*/

strong.prototype.contains=function(oElement){};
/**
  * function detachEvent(sEvent,fpNotify)
  * @param {String} sEvent
  * @param {attachEvent} fpNotify
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536411.aspx
*/

strong.prototype.detachEvent=function(sEvent,fpNotify){};
/**
  * function fireEvent(sEvent,oEventObject)
  * @param {String} sEvent
  * @param {event} oEventObject
  * @type Boolean
  * @returns {Boolean}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536423.aspx
*/

strong.prototype.fireEvent=function(sEvent,oEventObject){};
/**
  * function focus()
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536425.aspx
*/

strong.prototype.focus=function(){};
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

strong.prototype.onfocus= new onfocus();
/**
  * function getAdjacentText(sWhere)
  * @param {String} sWhere
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536427.aspx
*/

strong.prototype.getAdjacentText=function(sWhere){};
/**
  * function getAttribute(sAttrName,iFlags,sAttrName)
  * @param {String} sAttrName
  * @param {Number} iFlags
  * @param {getAttribute} sAttrName
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536429.aspx
*/

strong.prototype.getAttribute=function(sAttrName,iFlags,sAttrName){};
/**
  * function getAttributeNode(sName)
  * @param {String} sName
  * @type attribute
  * @returns {attribute}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536430.aspx
*/

strong.prototype.getAttributeNode=function(sName){};
/**
  * Property attribute
  * @type attribute
  * @returns {attribute}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535187.aspx
*/

strong.prototype.attribute= new attribute();
/**
  * Property name
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms534184.aspx
*/

strong.prototype.name="";
/**
  * function getBoundingClientRect()
  * @type TextRectangle
  * @returns {TextRectangle}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536433.aspx
*/

strong.prototype.getBoundingClientRect=function(){};
/**
  * Property TextRectangle
  * @type TextRectangle
  * @returns {TextRectangle}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535906.aspx
*/

strong.prototype.TextRectangle= new TextRectangle();
/**
  * function getClientRects()
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536435.aspx
*/

strong.prototype.getClientRects=function(){};
/**
  * function getElementsByTagName(sTagName)
  * @param {String} sTagName
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536439.aspx
*/

strong.prototype.getElementsByTagName=function(sTagName){};
/**
  * function getExpression(sPropertyName)
  * @param {String} sPropertyName
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa358797.aspx
*/

strong.prototype.getExpression=function(sPropertyName){};
/**
  * function hasChildNodes()
  * @type HTML Elements
  * @returns {HTML}
 Elements
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536445.aspx
*/

strong.prototype.hasChildNodes=function(){};
/**
  * function insertAdjacentElement(sWhere,oElement)
  * @param {String} sWhere
  * @param {insertAdjacentElement} oElement
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536451.aspx
*/

strong.prototype.insertAdjacentElement=function(sWhere,oElement){};
/**
  * function insertAdjacentHTML(sWhere,sText)
  * @param {String} sWhere
  * @param {String} sText
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536452.aspx
*/

strong.prototype.insertAdjacentHTML=function(sWhere,sText){};
/**
  * function insertAdjacentText(sWhere,sText)
  * @param {String} sWhere
  * @param {String} sText
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536453.aspx
*/

strong.prototype.insertAdjacentText=function(sWhere,sText){};
/**
  * function insertBefore(oNewNode,oChildNode)
  * @param {Object} oNewNode
  * @param {Object} oChildNode
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536454.aspx
*/

strong.prototype.insertBefore=function(oNewNode,oChildNode){};
/**
  * function mergeAttributes(oSource,bPreserve)
  * @param {Object} oSource
  * @param {Boolean} bPreserve
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536614.aspx
*/

strong.prototype.mergeAttributes=function(oSource,bPreserve){};
/**
  * function normalize()
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536646.aspx
*/

strong.prototype.normalize=function(){};
/**
  * function releaseCapture()
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536689.aspx
*/

strong.prototype.releaseCapture=function(){};
/**
  * function removeAttribute(sName,iCaseSensitive)
  * @param {String} sName
  * @param {Number} iCaseSensitive
  * @type Boolean
  * @returns {Boolean}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536696.aspx
*/

strong.prototype.removeAttribute=function(sName,iCaseSensitive){};
/**
  * function removeAttributeNode(oSrcAttribute)
  * @param {attribute} oSrcAttribute
  * @type attribute
  * @returns {attribute}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536698.aspx
*/

strong.prototype.removeAttributeNode=function(oSrcAttribute){};
/**
  * function removeBehavior(iID)
  * @param {Number} iID
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536700.aspx
*/

strong.prototype.removeBehavior=function(iID){};
/**
  * function removeChild(oNode)
  * @param {Object} oNode
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536702.aspx
*/

strong.prototype.removeChild=function(oNode){};
/**
  * function removeExpression(sPropertyName)
  * @param {String} sPropertyName
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/aa358798.aspx
*/

strong.prototype.removeExpression=function(sPropertyName){};
/**
  * function removeNode(bRemoveChildren)
  * @param {Boolean} bRemoveChildren
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536708.aspx
*/

strong.prototype.removeNode=function(bRemoveChildren){};
/**
  * function replaceAdjacentText(sWhere,sReplaceText)
  * @param {String} sWhere
  * @param {String} sReplaceText
  * @type String
  * @returns {String}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536714.aspx
*/

strong.prototype.replaceAdjacentText=function(sWhere,sReplaceText){};
/**
  * function replaceChild(oNewNode,oChildNode)
  * @param {Object} oNewNode
  * @param {Object} oChildNode
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536716.aspx
*/

strong.prototype.replaceChild=function(oNewNode,oChildNode){};
/**
  * function replaceNode(oNewNode)
  * @param {Object} oNewNode
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536719.aspx
*/

strong.prototype.replaceNode=function(oNewNode){};
/**
  * function scrollIntoView(bAlignToTop)
  * @param {Boolean} bAlignToTop
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536730.aspx
*/

strong.prototype.scrollIntoView=function(bAlignToTop){};
/**
  * function setActive()
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536738.aspx
*/

strong.prototype.setActive=function(){};
/**
  * function setAttribute(sName,vValue)
  * @param {String} sName
  * @param {Number} vValue
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536739.aspx
*/

strong.prototype.setAttribute=function(sName,vValue){};
/**
  * function setAttributeNode(oSrcAttribute)
  * @param {attribute} oSrcAttribute
  * @type attribute
  * @returns {attribute}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536741.aspx
*/

strong.prototype.setAttributeNode=function(oSrcAttribute){};
/**
  * function setCapture(bContainerCapture)
  * @param {Boolean} bContainerCapture
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536742.aspx
*/

strong.prototype.setCapture=function(bContainerCapture){};
/**
  * function setExpression(sPropertyName,sExpression,sLanguage)
  * @param {String} sPropertyName
  * @param {String} sExpression
  * @param {String} sLanguage
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms531196.aspx
*/

strong.prototype.setExpression=function(sPropertyName,sExpression,sLanguage){};
/**
  * function swapNode(oNode)
  * @param {Object} oNode
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536774.aspx
*/

strong.prototype.swapNode=function(oNode){};
/**
  * Property onactivate
  * @type onactivate
  * @returns {onactivate}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536787.aspx
*/

strong.prototype.onactivate= new onactivate();
/**
  * Property activeElement
  * @type Object
  * @returns {Object}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533065.aspx
*/

strong.prototype.activeElement=new Object();
/**
  * Property onbeforeactivate
  * @type onbeforeactivate
  * @returns {onbeforeactivate}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536791.aspx
*/

strong.prototype.onbeforeactivate= new onbeforeactivate();
/**
  * Property onbeforecopy
  * @type onbeforecopy
  * @returns {onbeforecopy}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536901.aspx
*/

strong.prototype.onbeforecopy= new onbeforecopy();
/**
  * Property onbeforecut
  * @type onbeforecut
  * @returns {onbeforecut}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536902.aspx
*/

strong.prototype.onbeforecut= new onbeforecut();
/**
  * Property onbeforedeactivate
  * @type onbeforedeactivate
  * @returns {onbeforedeactivate}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536903.aspx
*/

strong.prototype.onbeforedeactivate= new onbeforedeactivate();
/**
  * Property onbeforeeditfocus
  * @type onbeforeeditfocus
  * @returns {onbeforeeditfocus}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536904.aspx
*/

strong.prototype.onbeforeeditfocus= new onbeforeeditfocus();
/**
  * Property onbeforepaste
  * @type onbeforepaste
  * @returns {onbeforepaste}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536905.aspx
*/

strong.prototype.onbeforepaste= new onbeforepaste();
/**
  * Property onblur
  * @type onblur
  * @returns {onblur}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536909.aspx
*/

strong.prototype.onblur= new onblur();
/**
  * Property onclick
  * @type onclick
  * @returns {onclick}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536913.aspx
*/

strong.prototype.onclick= new onclick();
/**
  * Property oncontextmenu
  * @type oncontextmenu
  * @returns {oncontextmenu}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536914.aspx
*/

strong.prototype.oncontextmenu= new oncontextmenu();
/**
  * Property oncontrolselect
  * @type oncontrolselect
  * @returns {oncontrolselect}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537844.aspx
*/

strong.prototype.oncontrolselect= new oncontrolselect();
/**
  * Property oncopy
  * @type oncopy
  * @returns {oncopy}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536916.aspx
*/

strong.prototype.oncopy= new oncopy();
/**
  * Property oncut
  * @type oncut
  * @returns {oncut}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536917.aspx
*/

strong.prototype.oncut= new oncut();
/**
  * Property ondblclick
  * @type ondblclick
  * @returns {ondblclick}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536921.aspx
*/

strong.prototype.ondblclick= new ondblclick();
/**
  * Property ondeactivate
  * @type ondeactivate
  * @returns {ondeactivate}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536922.aspx
*/

strong.prototype.ondeactivate= new ondeactivate();
/**
  * Property ondrag
  * @type ondrag
  * @returns {ondrag}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536923.aspx
*/

strong.prototype.ondrag= new ondrag();
/**
  * Property ondragend
  * @type ondragend
  * @returns {ondragend}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536924.aspx
*/

strong.prototype.ondragend= new ondragend();
/**
  * Property ondragenter
  * @type ondragenter
  * @returns {ondragenter}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536925.aspx
*/

strong.prototype.ondragenter= new ondragenter();
/**
  * Property ondragleave
  * @type ondragleave
  * @returns {ondragleave}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536926.aspx
*/

strong.prototype.ondragleave= new ondragleave();
/**
  * Property ondragover
  * @type ondragover
  * @returns {ondragover}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536927.aspx
*/

strong.prototype.ondragover= new ondragover();
/**
  * Property ondragstart
  * @type ondragstart
  * @returns {ondragstart}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536928.aspx
*/

strong.prototype.ondragstart= new ondragstart();
/**
  * Property ondrop
  * @type ondrop
  * @returns {ondrop}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536929.aspx
*/

strong.prototype.ondrop= new ondrop();
/**
  * Property onfocus
  * @type onfocus
  * @returns {onfocus}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536934.aspx
*/

strong.prototype.onfocus= new onfocus();
/**
  * Property onfocusin
  * @type onfocusin
  * @returns {onfocusin}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536935.aspx
*/

strong.prototype.onfocusin= new onfocusin();
/**
  * Property onfocusout
  * @type onfocusout
  * @returns {onfocusout}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536936.aspx
*/

strong.prototype.onfocusout= new onfocusout();
/**
  * Property onhelp
  * @type onhelp
  * @returns {onhelp}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536937.aspx
*/

strong.prototype.onhelp= new onhelp();
/**
  * Property onkeydown
  * @type onkeydown
  * @returns {onkeydown}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536938.aspx
*/

strong.prototype.onkeydown= new onkeydown();
/**
  * Property onkeypress
  * @type onkeypress
  * @returns {onkeypress}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536939.aspx
*/

strong.prototype.onkeypress= new onkeypress();
/**
  * Property onkeyup
  * @type onkeyup
  * @returns {onkeyup}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536940.aspx
*/

strong.prototype.onkeyup= new onkeyup();
/**
  * Property onlosecapture
  * @type onlosecapture
  * @returns {onlosecapture}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536943.aspx
*/

strong.prototype.onlosecapture= new onlosecapture();
/**
  * Property onmousedown
  * @type onmousedown
  * @returns {onmousedown}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536944.aspx
*/

strong.prototype.onmousedown= new onmousedown();
/**
  * Property onmouseenter
  * @type onmouseenter
  * @returns {onmouseenter}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536945.aspx
*/

strong.prototype.onmouseenter= new onmouseenter();
/**
  * Property onmouseleave
  * @type onmouseleave
  * @returns {onmouseleave}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536946.aspx
*/

strong.prototype.onmouseleave= new onmouseleave();
/**
  * Property onmousemove
  * @type onmousemove
  * @returns {onmousemove}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536947.aspx
*/

strong.prototype.onmousemove= new onmousemove();
/**
  * Property onmouseout
  * @type onmouseout
  * @returns {onmouseout}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536948.aspx
*/

strong.prototype.onmouseout= new onmouseout();
/**
  * Property onmouseover
  * @type onmouseover
  * @returns {onmouseover}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536949.aspx
*/

strong.prototype.onmouseover= new onmouseover();
/**
  * Property onmouseup
  * @type onmouseup
  * @returns {onmouseup}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536950.aspx
*/

strong.prototype.onmouseup= new onmouseup();
/**
  * Property onmousewheel
  * @type onmousewheel
  * @returns {onmousewheel}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536951.aspx
*/

strong.prototype.onmousewheel= new onmousewheel();
/**
  * Property onmove
  * @type onmove
  * @returns {onmove}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536952.aspx
*/

strong.prototype.onmove= new onmove();
/**
  * Property onmoveend
  * @type onmoveend
  * @returns {onmoveend}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536953.aspx
*/

strong.prototype.onmoveend= new onmoveend();
/**
  * Property onmovestart
  * @type onmovestart
  * @returns {onmovestart}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536954.aspx
*/

strong.prototype.onmovestart= new onmovestart();
/**
  * Property onpaste
  * @type onpaste
  * @returns {onpaste}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536955.aspx
*/

strong.prototype.onpaste= new onpaste();
/**
  * Property onpropertychange
  * @type onpropertychange
  * @returns {onpropertychange}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536956.aspx
*/

strong.prototype.onpropertychange= new onpropertychange();
/**
  * Property onreadystatechange
  * @type onreadystatechange
  * @returns {onreadystatechange}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536957.aspx
*/

strong.prototype.onreadystatechange= new onreadystatechange();
/**
  * Property onresize
  * @type onresize
  * @returns {onresize}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536959.aspx
*/

strong.prototype.onresize= new onresize();
/**
  * Property onresizeend
  * @type onresizeend
  * @returns {onresizeend}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536960.aspx
*/

strong.prototype.onresizeend= new onresizeend();
/**
  * Property onresizestart
  * @type onresizestart
  * @returns {onresizestart}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536961.aspx
*/

strong.prototype.onresizestart= new onresizestart();
/**
  * Property onselectstart
  * @type onselectstart
  * @returns {onselectstart}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms536969.aspx
*/

strong.prototype.onselectstart= new onselectstart();
/**
  * Property ontimeerror
  * @type ontimeerror
  * @returns {ontimeerror}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms533588.aspx
*/

strong.prototype.ontimeerror= new ontimeerror();
/**
  * Property all
  * @type all
  * @returns {all}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537434.aspx
*/

strong.prototype.all= new all();
/**
  * Property attributes
  * @type attributes
  * @returns {attributes}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537438.aspx
*/

strong.prototype.attributes= new attributes();
/**
  * Property behaviorUrns
  * @type behaviorUrns
  * @returns {behaviorUrns}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537439.aspx
*/

strong.prototype.behaviorUrns= new behaviorUrns();
/**
  * Property childNodes
  * @type childNodes
  * @returns {childNodes}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537445.aspx
*/

strong.prototype.childNodes= new childNodes();
/**
  * Property TextNode
  * @type TextNode
  * @returns {TextNode}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms535905.aspx
*/

strong.prototype.TextNode= new TextNode();
/**
  * Property children
  * @type children
  * @returns {children}
  * @memberOf strong
  * @since JScript 5.6
  * @see http://msdn2.microsoft.com/en-us/library/ms537446.aspx
*/

strong.prototype.children= new children();
