/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.rhino.tests;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Request;
import org.eclipse.wst.jsdt.debug.internal.rhino.transport.Response;
import org.eclipse.wst.jsdt.debug.rhino.tests.RequestTest;
import org.eclipse.wst.jsdt.debug.rhino.tests.Util;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ScriptRequestTests
extends RequestTest {
    public void testScriptsWithNoScripts() throws Exception {
        Request request = new Request("scripts");
        this.debugSession.sendRequest(request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        ScriptRequestTests.assertTrue((boolean)response.isSuccess());
        Collection scripts = (Collection)response.getBody().get("scripts");
        ScriptRequestTests.assertNotNull((Object)scripts);
        ScriptRequestTests.assertTrue((boolean)scripts.isEmpty());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testScript() throws Exception {
        String script = Util.getTestSource("scripts", "script1.js");
        ScriptRequestTests.assertNotNull((String)"The test source for [script1.js] must exist", (Object)script);
        ScriptableObject scope = null;
        Context context = this.contextFactory.enterContext();
        try {
            scope = context.initStandardObjects();
            context.evaluateString((Scriptable)scope, script, "script", 0, null);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            Context.exit();
            throw throwable;
        }
        {
            Object var4_7 = null;
        }
        Context.exit();
        Request request = new Request("scripts");
        this.debugSession.sendRequest(request);
        Response response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        ScriptRequestTests.assertTrue((boolean)response.isSuccess());
        List scripts = (List)response.getBody().get("scripts");
        ScriptRequestTests.assertNotNull((Object)scripts);
        ScriptRequestTests.assertFalse((boolean)scripts.isEmpty());
        request = new Request("script");
        request.getArguments().put("scriptId", scripts.get(0));
        this.debugSession.sendRequest(request);
        response = this.debugSession.receiveResponse(request.getSequence(), 30000);
        ScriptRequestTests.assertTrue((boolean)response.isSuccess());
        Map result = (Map)response.getBody().get("script");
        ScriptRequestTests.assertEquals((Object)script, result.get("source"));
        List lineNumbers = (List)result.get("lines");
        ScriptRequestTests.assertEquals((int)7, (int)lineNumbers.size());
        ScriptRequestTests.assertTrue((String)"The line number [1] should be returned", (boolean)lineNumbers.contains(new BigDecimal(1.0)));
        ScriptRequestTests.assertTrue((String)"The line number [2] should be returned", (boolean)lineNumbers.contains(new BigDecimal(2.0)));
        ScriptRequestTests.assertTrue((String)"The line number [5] should be returned", (boolean)lineNumbers.contains(new BigDecimal(5.0)));
        ScriptRequestTests.assertTrue((String)"The line number [6] should be returned", (boolean)lineNumbers.contains(new BigDecimal(6.0)));
        ScriptRequestTests.assertTrue((String)"The line number [9] should be returned", (boolean)lineNumbers.contains(new BigDecimal(9.0)));
        ScriptRequestTests.assertTrue((String)"The line number [12] should be returned", (boolean)lineNumbers.contains(new BigDecimal(12.0)));
        ScriptRequestTests.assertTrue((String)"The line number [13] should be returned", (boolean)lineNumbers.contains(new BigDecimal(13.0)));
        List functionNames = (List)result.get("functions");
        ScriptRequestTests.assertEquals((int)2, (int)functionNames.size());
        ScriptRequestTests.assertEquals((Object)"test", functionNames.get(0));
        ScriptRequestTests.assertEquals((Object)"test2", functionNames.get(1));
    }
}

