/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.translation;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteral;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.internal.core.DocumentAdapter;
import org.eclipse.wst.jsdt.internal.corext.ValidateEditException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;

public class RunCodeHandler
extends AbstractHandler {
    static /* synthetic */ Class class$0;

    protected void doExecute(IFile jsFile) {
        jsFile.getProject();
        IJavaScriptUnit jsUnit = (IJavaScriptUnit)JavaScriptCore.create((IFile)jsFile);
        if (jsUnit == null) {
            return;
        }
        NullProgressMonitor monitor = null;
        monitor = new NullProgressMonitor();
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(jsUnit);
        ASTNode ast = parser.createAST(null);
        MyNodeVisitor visitor = new MyNodeVisitor(jsUnit, null, ast);
        ast.accept((ASTVisitor)visitor);
    }

    protected static IDocument getDocument(IJavaScriptUnit cu) throws JavaScriptModelException {
        IBuffer buffer = cu.getBuffer();
        if (buffer instanceof IDocument) {
            return (IDocument)buffer;
        }
        return new DocumentAdapter(buffer);
    }

    static ObjectLiteralField getObjectLiteralField(String source) {
        String js = "x.prototype = {" + source + "}";
        JavaScriptUnit jsu = RunCodeHandler.getAST(js);
        ExpressionStatement stmt = (ExpressionStatement)jsu.statements().get(0);
        ObjectLiteral lit = (ObjectLiteral)((Assignment)stmt.getExpression()).getRightHandSide();
        ObjectLiteralField field = (ObjectLiteralField)lit.fields().get(0);
        ASTNode node = ASTNode.copySubtree((AST)jsu.getAST(), (ASTNode)field);
        return (ObjectLiteralField)node;
    }

    static JavaScriptUnit getAST(String source) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(source.toCharArray());
        ASTNode ast = parser.createAST(null);
        return (JavaScriptUnit)ast;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (!(activeEditor instanceof JavaEditor)) {
            return null;
        }
        IEditorInput iEditorInput = HandlerUtil.getActiveEditor((ExecutionEvent)event).getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.doExecute((IFile)iEditorInput.getAdapter((Class)clazz));
        return null;
    }

    static final class MyNodeVisitor
    extends ASTVisitor {
        IJavaScriptUnit jsUnit;
        String className;
        private JavaScriptUnit cu;

        public MyNodeVisitor(IJavaScriptUnit jsUnit, String className, ASTNode ast) {
            this.jsUnit = jsUnit;
            this.className = className;
            this.cu = (JavaScriptUnit)ast;
        }

        public boolean visit(FunctionDeclaration node) {
            Block body = node.getBody();
            try {
                IType type;
                IFunction function;
                IJavaScriptElement element = this.jsUnit.getElementAt(body.getStartPosition());
                if (element instanceof IFunction && !(function = (IFunction)element).isConstructor() && function.getDisplayName().equals("sayHello") && (type = function.getDeclaringType()) != null) {
                    this.cu.recordModifications();
                    AST ast = node.getAST();
                    String functionLiteral = "handler : function(args){alert(\"Hello\");}";
                    ObjectLiteralField field = RunCodeHandler.getObjectLiteralField(functionLiteral);
                    List fields = ((ObjectLiteral)node.getParent().getParent().getParent()).fields();
                    fields.add(field);
                    FunctionInvocation methodInvocation = ast.newFunctionInvocation();
                    QualifiedName name = ast.newQualifiedName((Name)ast.newSimpleName("dojo"), ast.newSimpleName("connect"));
                    methodInvocation.setExpression((Expression)name);
                    methodInvocation.arguments().add(ast.newSimpleName("a"));
                    StringLiteral lit = ast.newStringLiteral();
                    lit.setLiteralValue("a");
                    methodInvocation.arguments().add(lit);
                    ExpressionStatement expressionStatement = ast.newExpressionStatement((Expression)methodInvocation);
                    body.statements().add(expressionStatement);
                    TextEdit edits = this.cu.rewrite(RunCodeHandler.getDocument(this.jsUnit), (Map)JavaScriptCore.getDefaultOptions());
                    try {
                        JavaModelUtil.applyEdit((IJavaScriptUnit)this.jsUnit, (TextEdit)edits, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (ValidateEditException e) {
                        e.printStackTrace();
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
            }
            return false;
        }
    }
}

