/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.tests;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.server.core.internal.GenericRuntimeUtil;
import org.eclipse.jst.server.core.internal.IGenericRuntime;
import org.eclipse.jst.server.core.internal.IGenericRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;

public class GenericRuntimeTestCase
extends TestCase {
    private static final String RUNTIME_TYPE_ID = "org.eclipse.jst.server.core.runtimeType";
    protected static IRuntime runtime;

    protected IRuntime getRuntime() throws Exception {
        if (runtime == null) {
            IRuntimeType rt = ServerCore.findRuntimeType((String)RUNTIME_TYPE_ID);
            IRuntimeWorkingCopy wc = rt.createRuntime("a", null);
            wc.setLocation((IPath)new Path("c://test"));
            runtime = wc.save(false, null);
        }
        return runtime;
    }

    protected IGenericRuntime getGenericRuntime() throws Exception {
        return (IGenericRuntime)this.getRuntime().getAdapter(IGenericRuntime.class);
    }

    protected IRuntime getRuntimeWC() throws Exception {
        return this.getRuntime().createWorkingCopy();
    }

    protected IGenericRuntimeWorkingCopy getGenericRuntimeWC() throws Exception {
        return (IGenericRuntimeWorkingCopy)this.getRuntimeWC().loadAdapter(IGenericRuntimeWorkingCopy.class, null);
    }

    public static void addOrderedTests(TestSuite suite) {
        suite.addTest(TestSuite.createTest(GenericRuntimeTestCase.class, (String)"deleteRuntime"));
    }

    public void testCreateRuntime() throws Exception {
        GenericRuntimeTestCase.assertTrue((!this.getRuntime().isWorkingCopy() ? 1 : 0) != 0);
    }

    public void testValidateRuntime() throws Exception {
        IStatus status = this.getRuntime().validate(null);
        GenericRuntimeTestCase.assertTrue((!status.isOK() ? 1 : 0) != 0);
    }

    public void testUtil() throws Exception {
        GenericRuntimeTestCase.assertTrue((boolean)GenericRuntimeUtil.isGenericJ2EERuntime((IRuntime)this.getRuntime()));
    }

    public void testAdapt() throws Exception {
        GenericRuntimeTestCase.assertNotNull((Object)this.getGenericRuntime());
    }

    public void testAdaptWorkingCopy() throws Exception {
        GenericRuntimeTestCase.assertNotNull((Object)this.getRuntime().getAdapter(IGenericRuntimeWorkingCopy.class));
    }

    public void testGetJVM() throws Exception {
        GenericRuntimeTestCase.assertNotNull((Object)this.getGenericRuntime().getVMInstall());
    }

    public void testAdapt2() throws Exception {
        GenericRuntimeTestCase.assertNotNull((Object)this.getGenericRuntimeWC());
    }

    public void testAdapt3() throws Exception {
        GenericRuntimeTestCase.assertNotNull((Object)this.getRuntimeWC().loadAdapter(IGenericRuntime.class, null));
    }

    public void testSetJVM() throws Exception {
        GenericRuntimeTestCase.assertNotNull((Object)this.getGenericRuntimeWC().getVMInstall());
        GenericRuntimeTestCase.assertNotNull((Object)this.getGenericRuntimeWC().getVMInstall());
    }

    public void deleteRuntime() throws Exception {
        this.getRuntime().delete();
        runtime = null;
    }
}

