/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.tests.j2ee;

import java.util.ArrayList;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.tests.j2ee.ModuleHelper;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;

public class BinaryTestCase
extends TestCase {
    private static final String[] PROJECT_NAMES = new String[]{"PublishTestEAR", "PublishTestEJB", "test", "test2", "PublishTestWeb", "PublishTestWeb2", "PublishTestConnector", "PublishTestClient"};
    private static final String EJB_PATH = "lib/PublishTestEAR/EarContent/PublishTestEJB.jar";
    private static final String CONN_PATH = "lib/PublishTestEAR/EarContent/PublishTestConnector.rar";
    private static final String CLIENT_PATH = "lib/PublishTestEAR/EarContent/PublishTestClient.jar";
    private static final String WEBAPP_PATH = "lib/PublishTestEAR/EarContent/PublishTestWeb.war";
    private static final String WEBAPP2_PATH = "lib/PublishTestEAR/EarContent/PublishTestWeb2.war";
    private static boolean projectsCreated;

    protected void setUp() throws Exception {
        if (!projectsCreated) {
            ModuleHelper.importProject("PublishTestBinary.zip", new String[]{PROJECT_NAMES[0]});
            ModuleHelper.buildIncremental();
            projectsCreated = true;
        }
    }

    protected IModule getEARModule(String project) throws Exception {
        return ModuleHelper.getModule("jst.ear", project);
    }

    protected IEnterpriseApplication getEnterpriseApp(String project) throws Exception {
        return (IEnterpriseApplication)this.getEARModule(project).loadAdapter(IEnterpriseApplication.class, null);
    }

    protected IModule getEJBModule(String ejb) throws Exception {
        return ModuleHelper.getModule("jst.ejb", ejb);
    }

    protected IJ2EEModule getJ2EEEJBModule(String ejb) throws Exception {
        return (IJ2EEModule)this.getEJBModule(ejb).loadAdapter(IJ2EEModule.class, null);
    }

    protected IModule getConnectorModule(String conn) throws Exception {
        return ModuleHelper.getModule("jst.connector", conn);
    }

    protected IJ2EEModule getJ2EEConnectorModule(String conn) throws Exception {
        return (IJ2EEModule)this.getConnectorModule(conn).loadAdapter(IJ2EEModule.class, null);
    }

    protected IModule getAppClientModule(String client) throws Exception {
        return ModuleHelper.getModule("jst.appclient", client);
    }

    protected IJ2EEModule getJ2EEAppClientModule(String client) throws Exception {
        return (IJ2EEModule)this.getAppClientModule(client).loadAdapter(IJ2EEModule.class, null);
    }

    protected IModule getWebModule(String webapp) throws Exception {
        return ModuleHelper.getModule("jst.web", webapp);
    }

    protected IWebModule getJ2EEWebModule(String webapp) throws Exception {
        return (IWebModule)this.getWebModule(webapp).loadAdapter(IWebModule.class, null);
    }

    public static void addOrderedTests(TestSuite suite) {
        suite.addTest(TestSuite.createTest(BinaryTestCase.class, (String)"deleteProjects"));
    }

    public void testNumEarModules() throws Exception {
        BinaryTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.ear").length, (int)1);
    }

    public void testNumWebModules() throws Exception {
        BinaryTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.web").length, (int)2);
    }

    public void testNumEjbModules() throws Exception {
        BinaryTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.ejb").length, (int)1);
    }

    public void testNumUtilityModules() throws Exception {
        BinaryTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.utility").length, (int)0);
    }

    public void testNumClientModules() throws Exception {
        BinaryTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.appclient").length, (int)1);
    }

    public void testNumConnectorModules() throws Exception {
        BinaryTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.connector").length, (int)1);
    }

    public void testEARModule() throws Exception {
        BinaryTestCase.assertNotNull((Object)this.getEARModule("PublishTestEAR"));
    }

    public void testEARFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getEARModule("PublishTestEAR"), "META-INF/application.xml")) {
            BinaryTestCase.fail();
        }
    }

    public void test0EARJarExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getEARModule("PublishTestEAR"), "PublishTestUtil2.jar")) {
            BinaryTestCase.fail();
        }
    }

    public void testEARFileCount() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFiles(this.getEARModule("PublishTestEAR")), (int)4);
    }

    public void testEARFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFolders(this.getEARModule("PublishTestEAR")), (int)1);
    }

    public void testEARModuleType() throws Exception {
        BinaryTestCase.assertEquals((String)this.getEARModule("PublishTestEAR").getModuleType().getId(), (String)"jst.ear");
    }

    public void testEARGetApp() throws Exception {
        BinaryTestCase.assertNotNull((Object)this.getEnterpriseApp("PublishTestEAR"));
    }

    public void testEARResourceFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getEnterpriseApp("PublishTestEAR").getResourceFolders().length, (int)1);
    }

    public void testEARModuleCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getEnterpriseApp("PublishTestEAR").getModules().length, (int)5);
    }

    public void testEARModuleNames() throws Exception {
        String[] s;
        IModule[] modules = this.getEnterpriseApp("PublishTestEAR").getModules();
        int size = modules.length;
        ArrayList<String> list = new ArrayList<String>(size);
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            list.add(m.getName());
            ++n2;
        }
        String[] stringArray = s = new String[]{"PublishTestEJB.jar", "PublishTestWeb.war", "PublishTestWeb2.war", "PublishTestConnector.rar", "PublishTestClient.jar"};
        int n3 = s.length;
        n = 0;
        while (n < n3) {
            String ss = stringArray[n];
            if (!list.contains(ss)) {
                BinaryTestCase.fail((String)("EAR does not contain " + ss));
            }
            ++n;
        }
    }

    public void testEJBModule() throws Exception {
        BinaryTestCase.assertNotNull((Object)this.getEJBModule(EJB_PATH));
    }

    public void testEJBFileExists() throws Exception {
    }

    public void testEJBFileCount() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFiles(this.getEJBModule(EJB_PATH)), (int)1);
    }

    public void test085EJB() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFolders(this.getEJBModule(EJB_PATH)), (int)0);
    }

    public void testEJBModuleType() throws Exception {
        BinaryTestCase.assertEquals((String)this.getEJBModule(EJB_PATH).getModuleType().getId(), (String)"jst.ejb");
    }

    public void testEJBJ2EEModule() throws Exception {
        BinaryTestCase.assertNotNull((Object)this.getJ2EEEJBModule(EJB_PATH));
    }

    public void testEJBResourceFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getJ2EEEJBModule(EJB_PATH).getResourceFolders().length, (int)1);
    }

    public void testEJBJavaOutputFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getJ2EEEJBModule(EJB_PATH).getJavaOutputFolders().length, (int)0);
    }

    public void testEJBIsBinary() throws Exception {
        BinaryTestCase.assertTrue((boolean)this.getJ2EEEJBModule(EJB_PATH).isBinary());
    }

    public void testConnectorModule() throws Exception {
        BinaryTestCase.assertNotNull((Object)this.getConnectorModule(CONN_PATH));
    }

    public void testConnectorFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getConnectorModule(CONN_PATH), "PublishTestConnector.rar")) {
            BinaryTestCase.fail();
        }
    }

    public void testConnectorFileCount() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFiles(this.getConnectorModule(CONN_PATH)), (int)1);
    }

    public void testConnectorFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFolders(this.getConnectorModule(CONN_PATH)), (int)0);
    }

    public void testConnectorModuleType() throws Exception {
        BinaryTestCase.assertEquals((String)this.getConnectorModule(CONN_PATH).getModuleType().getId(), (String)"jst.connector");
    }

    public void testConnectorJ2EEModule() throws Exception {
        BinaryTestCase.assertNotNull((Object)this.getJ2EEConnectorModule(CONN_PATH));
    }

    public void testConnectorResourceFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getJ2EEConnectorModule(CONN_PATH).getResourceFolders().length, (int)1);
    }

    public void testConnectorJavaOutputFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getJ2EEConnectorModule(CONN_PATH).getJavaOutputFolders().length, (int)0);
    }

    public void testConnectorIsBinary() throws Exception {
        BinaryTestCase.assertTrue((boolean)this.getJ2EEConnectorModule(CONN_PATH).isBinary());
    }

    public void testClientModule() throws Exception {
        BinaryTestCase.assertNotNull((Object)this.getAppClientModule(CLIENT_PATH));
    }

    public void testClientFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getAppClientModule(CLIENT_PATH), "PublishTestClient.jar")) {
            BinaryTestCase.fail();
        }
    }

    public void testClientFileCount() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFiles(this.getAppClientModule(CLIENT_PATH)), (int)1);
    }

    public void testClientFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFolders(this.getAppClientModule(CLIENT_PATH)), (int)0);
    }

    public void testClientModuleTime() throws Exception {
        BinaryTestCase.assertEquals((String)this.getAppClientModule(CLIENT_PATH).getModuleType().getId(), (String)"jst.appclient");
    }

    public void testClientJ2EEModule() throws Exception {
        BinaryTestCase.assertNotNull((Object)this.getJ2EEAppClientModule(CLIENT_PATH));
    }

    public void testClientResourceFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getJ2EEAppClientModule(CLIENT_PATH).getResourceFolders().length, (int)1);
    }

    public void testClientJavaOutputFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getJ2EEAppClientModule(CLIENT_PATH).getJavaOutputFolders().length, (int)0);
    }

    public void testClientIsBinary() throws Exception {
        BinaryTestCase.assertTrue((boolean)this.getJ2EEAppClientModule(CLIENT_PATH).isBinary());
    }

    public void testWebModule() throws Exception {
        BinaryTestCase.assertNotNull((Object)this.getWebModule(WEBAPP_PATH));
    }

    public void testWebFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getWebModule(WEBAPP_PATH), "PublishTestWeb.war")) {
            BinaryTestCase.fail();
        }
    }

    public void testWebFileCount() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFiles(this.getWebModule(WEBAPP_PATH)), (int)1);
    }

    public void testWebFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFolders(this.getWebModule(WEBAPP_PATH)), (int)0);
    }

    public void testWebModuleType() throws Exception {
        BinaryTestCase.assertEquals((String)this.getWebModule(WEBAPP_PATH).getModuleType().getId(), (String)"jst.web");
    }

    public void testWebJ2EEModule() throws Exception {
        BinaryTestCase.assertNotNull((Object)this.getJ2EEWebModule(WEBAPP_PATH));
    }

    public void testWebResourceFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getJ2EEWebModule(WEBAPP_PATH).getResourceFolders().length, (int)1);
    }

    public void testWebJavaOutputFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getJ2EEWebModule(WEBAPP_PATH).getJavaOutputFolders().length, (int)0);
    }

    public void testWebModuleCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getJ2EEWebModule(WEBAPP_PATH).getModules().length, (int)0);
    }

    public void _testWebContextRoot() throws Exception {
        BinaryTestCase.assertEquals((String)this.getJ2EEWebModule(WEBAPP_PATH).getContextRoot(), (String)"PublishTestWeb");
    }

    public void testWebIsBinaary() throws Exception {
        BinaryTestCase.assertTrue((boolean)this.getJ2EEWebModule(WEBAPP_PATH).isBinary());
    }

    public void testWeb2Module() throws Exception {
        BinaryTestCase.assertNotNull((Object)this.getWebModule(WEBAPP2_PATH));
    }

    public void testWeb2FileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getWebModule(WEBAPP2_PATH), "PublishTestWeb2.war")) {
            BinaryTestCase.fail();
        }
    }

    public void testWeb2FileCount() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFiles(this.getWebModule(WEBAPP2_PATH)), (int)1);
    }

    public void testWeb2FolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFolders(this.getWebModule(WEBAPP2_PATH)), (int)0);
    }

    public void testWeb2ModuleType() throws Exception {
        BinaryTestCase.assertEquals((String)this.getWebModule(WEBAPP2_PATH).getModuleType().getId(), (String)"jst.web");
    }

    public void testWeb2J2EEModule() throws Exception {
        BinaryTestCase.assertNotNull((Object)this.getJ2EEWebModule(WEBAPP2_PATH));
    }

    public void testWeb2ResourceFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getJ2EEWebModule(WEBAPP2_PATH).getResourceFolders().length, (int)1);
    }

    public void testWeb2JavaOutputFolderCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getJ2EEWebModule(WEBAPP2_PATH).getJavaOutputFolders().length, (int)0);
    }

    public void testWeb2ModuleCount() throws Exception {
        BinaryTestCase.assertEquals((int)this.getJ2EEWebModule(WEBAPP2_PATH).getModules().length, (int)0);
    }

    public void _testWeb2ContextRoot() throws Exception {
        BinaryTestCase.assertEquals((String)this.getJ2EEWebModule(WEBAPP2_PATH).getContextRoot(), (String)"PublishTestWeb2");
    }

    public void testWeb2IsBinary() throws Exception {
        BinaryTestCase.assertTrue((boolean)this.getJ2EEWebModule(WEBAPP2_PATH).isBinary());
    }

    public void deleteProjects() throws Exception {
        ModuleHelper.deleteProject(PROJECT_NAMES[0]);
    }
}

