/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.tests.j2ee;

import java.util.ArrayList;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.tests.AllTests;
import org.eclipse.jst.server.core.tests.j2ee.ModuleHelper;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class ModuleTestCase
extends TestCase {
    private static final String RUNTIME_TYPE_ID = "org.eclipse.jst.server.core.runtimeType";
    private static final String[] PROJECT_NAMES = new String[]{"PublishTestEAR", "PublishTestEJB", "PublishTestUtil", "PublishTestUtil2", "PublishTestWeb", "PublishTestWeb2", "PublishTestConnector", "PublishTestClient"};
    protected static IRuntime runtime;
    private static boolean projectsCreated;

    protected void setUp() throws Exception {
        if (!projectsCreated) {
            ModuleHelper.importProject("PublishEAR.zip", PROJECT_NAMES);
            ModuleHelper.buildIncremental();
            projectsCreated = true;
        }
    }

    protected IRuntime getRuntime() throws Exception {
        if (runtime == null) {
            IRuntimeType rt = ServerCore.findRuntimeType((String)RUNTIME_TYPE_ID);
            IRuntimeWorkingCopy wc = rt.createRuntime("RuntimeLibraries", null);
            wc.setLocation(AllTests.runtimeLocation);
            wc.setName("RuntimeLibraries");
            runtime = wc.save(false, null);
        }
        return runtime;
    }

    protected IModule getModule(String project) throws Exception {
        return ModuleHelper.getModuleFromProject(project);
    }

    protected IEnterpriseApplication getEnterpriseApp(String project) throws Exception {
        return (IEnterpriseApplication)this.getModule(project).loadAdapter(IEnterpriseApplication.class, null);
    }

    protected IJ2EEModule getJ2EEModule(String project) throws Exception {
        return (IJ2EEModule)this.getModule(project).loadAdapter(IJ2EEModule.class, null);
    }

    protected IWebModule getWebModule(String project) throws Exception {
        return (IWebModule)this.getModule(project).loadAdapter(IWebModule.class, null);
    }

    public static void addOrderedTests(TestSuite suite) {
        suite.addTest(TestSuite.createTest(ModuleTestCase.class, (String)"deleteProjects"));
    }

    public void testCreateRuntime() throws Exception {
        ModuleTestCase.assertTrue((!this.getRuntime().isWorkingCopy() ? 1 : 0) != 0);
    }

    public void testNumEARModules() throws Exception {
        ModuleTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.ear").length, (int)1);
    }

    public void testNumWebModules() throws Exception {
        ModuleTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.web").length, (int)2);
    }

    public void testNumEJBModules() throws Exception {
        ModuleTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.ejb").length, (int)1);
    }

    public void testNumUtilityModules() throws Exception {
        ModuleTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.utility").length, (int)2);
    }

    public void testNumClientModules() throws Exception {
        ModuleTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.appclient").length, (int)1);
    }

    public void testNumConnectorModules() throws Exception {
        ModuleTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.connector").length, (int)1);
    }

    public void testEARModule() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getModule("PublishTestEAR"));
    }

    public void testEARFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestEAR"), "META-INF/application.xml")) {
            ModuleTestCase.fail();
        }
    }

    public void testEARJarExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestEAR"), "test.jar")) {
            ModuleTestCase.fail();
        }
    }

    public void testEARJarExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestEAR"), "jarfolder/test3.jar")) {
            ModuleTestCase.fail();
        }
    }

    public void testEARFileCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestEAR")), (int)4);
    }

    public void testEARFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestEAR")), (int)2);
    }

    public void testEARModuleType() throws Exception {
        ModuleTestCase.assertEquals((String)this.getModule("PublishTestEAR").getModuleType().getId(), (String)"jst.ear");
    }

    public void testEARGetApp() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getEnterpriseApp("PublishTestEAR"));
    }

    public void testEARResourceFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getEnterpriseApp("PublishTestEAR").getResourceFolders().length, (int)1);
    }

    public void testEARModuleCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getEnterpriseApp("PublishTestEAR").getModules().length, (int)6);
    }

    public void _testEARModuleNames() throws Exception {
        String[] s;
        IModule[] modules = this.getEnterpriseApp("PublishTestEAR").getModules();
        ArrayList<String> list = new ArrayList<String>(modules.length);
        IModule[] iModuleArray = modules;
        int n = modules.length;
        int n2 = 0;
        while (n2 < n) {
            IModule m = iModuleArray[n2];
            System.out.println(m.getName());
            list.add(m.getName());
            ++n2;
        }
        String[] stringArray = s = new String[]{"PublishTestEJB", "PublishTestUtil2", "PublishTestWeb", "PublishTestWeb2", "PublishTestConnector", "PublishTestClient"};
        int n3 = s.length;
        n = 0;
        while (n < n3) {
            String ss = stringArray[n];
            if (!list.contains(ss)) {
                ModuleTestCase.fail((String)("EAR does not contain " + ss));
            }
            ++n;
        }
    }

    public void testUtilModule() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getModule("PublishTestUtil"));
    }

    public void testUtilFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestUtil"), "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void testUtilFileExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestUtil"), "test.properties")) {
            ModuleTestCase.fail();
        }
    }

    public void testUtilClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestUtil"), "publish/TestUtil.class")) {
            ModuleTestCase.fail();
        }
    }

    public void testUtilFileCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestUtil")), (int)3);
    }

    public void testUtilFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestUtil")), (int)2);
    }

    public void testUtilModuleType() throws Exception {
        ModuleTestCase.assertEquals((String)this.getModule("PublishTestUtil").getModuleType().getId(), (String)"jst.utility");
    }

    public void testUtilJ2EEModule() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getJ2EEModule("PublishTestUtil"));
    }

    public void testUtilResourceFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getJ2EEModule("PublishTestUtil").getResourceFolders().length, (int)1);
    }

    public void testUtilJavaOutputFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getJ2EEModule("PublishTestUtil").getJavaOutputFolders().length, (int)1);
    }

    public void testUtilIsBinary() throws Exception {
        ModuleTestCase.assertFalse((boolean)this.getJ2EEModule("PublishTestUtil").isBinary());
    }

    public void testUtil2Module() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getModule("PublishTestUtil2"));
    }

    public void testUtil2FileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestUtil2"), "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void testUtil2FileExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestUtil2"), "temp/test.properties")) {
            ModuleTestCase.fail();
        }
    }

    public void testUtil2ClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestUtil2"), "publish/TestUtil2.class")) {
            ModuleTestCase.fail();
        }
    }

    public void testUtil2FileCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestUtil2")), (int)3);
    }

    public void testUtil2FolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestUtil2")), (int)3);
    }

    public void testUtil2ModuleType() throws Exception {
        ModuleTestCase.assertEquals((String)this.getModule("PublishTestUtil2").getModuleType().getId(), (String)"jst.utility");
    }

    public void testUtil2J2EEModule() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getJ2EEModule("PublishTestUtil2"));
    }

    public void testUtil2ResourceFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getJ2EEModule("PublishTestUtil2").getResourceFolders().length, (int)1);
    }

    public void testUtil2JavaOutputFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getJ2EEModule("PublishTestUtil2").getJavaOutputFolders().length, (int)1);
    }

    public void testUtil2IsBinary() throws Exception {
        ModuleTestCase.assertFalse((boolean)this.getJ2EEModule("PublishTestUtil2").isBinary());
    }

    public void testEJBModule() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getModule("PublishTestEJB"));
    }

    public void testEJBFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestEJB"), "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void testEJBFileExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestEJB"), "META-INF/ejb-jar.xml")) {
            ModuleTestCase.fail();
        }
    }

    public void testEJBClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestEJB"), "ejbs/MyBeanLocalHome.class")) {
            ModuleTestCase.fail();
        }
    }

    public void testEJBFileCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestEJB")), (int)7);
    }

    public void testEJBFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestEJB")), (int)2);
    }

    public void testEJBModuleType() throws Exception {
        ModuleTestCase.assertEquals((String)this.getModule("PublishTestEJB").getModuleType().getId(), (String)"jst.ejb");
    }

    public void testEJBJ2EEModule() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getJ2EEModule("PublishTestEJB"));
    }

    public void testEJBResourceFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getJ2EEModule("PublishTestEJB").getResourceFolders().length, (int)1);
    }

    public void testEJBJavaOutputFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getJ2EEModule("PublishTestEJB").getJavaOutputFolders().length, (int)1);
    }

    public void testEJBIsBinary() throws Exception {
        ModuleTestCase.assertFalse((boolean)this.getJ2EEModule("PublishTestEJB").isBinary());
    }

    public void testConnectorModule() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getModule("PublishTestConnector"));
    }

    public void testConnectorFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestConnector"), "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void testConnectorFileExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestConnector"), "META-INF/ra.xml")) {
            ModuleTestCase.fail();
        }
    }

    public void testConnectorClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestConnector"), "test/MyOtherConnectorClass.class")) {
            ModuleTestCase.fail();
        }
    }

    public void testConnectorFileCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestConnector")), (int)5);
    }

    public void testConnectorFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestConnector")), (int)3);
    }

    public void testConnectorModuleType() throws Exception {
        ModuleTestCase.assertEquals((String)this.getModule("PublishTestConnector").getModuleType().getId(), (String)"jst.connector");
    }

    public void testConnectorJ2EEModule() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getJ2EEModule("PublishTestConnector"));
    }

    public void testConnectorResourceFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getJ2EEModule("PublishTestConnector").getResourceFolders().length, (int)1);
    }

    public void testConnectorJavaOutputFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getJ2EEModule("PublishTestConnector").getJavaOutputFolders().length, (int)1);
    }

    public void testConnectorIsBinary() throws Exception {
        ModuleTestCase.assertFalse((boolean)this.getJ2EEModule("PublishTestConnector").isBinary());
    }

    public void testClientModule() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getModule("PublishTestClient"));
    }

    public void testClientFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestClient"), "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void testClientFileExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestClient"), "META-INF/application-client.xml")) {
            ModuleTestCase.fail();
        }
    }

    public void testClientClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestClient"), "Main.class")) {
            ModuleTestCase.fail();
        }
    }

    public void testClientClassExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestClient"), "Main2.class")) {
            ModuleTestCase.fail();
        }
    }

    public void testClientFileCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestClient")), (int)4);
    }

    public void testClientFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestClient")), (int)1);
    }

    public void testClientModuleType() throws Exception {
        ModuleTestCase.assertEquals((String)this.getModule("PublishTestClient").getModuleType().getId(), (String)"jst.appclient");
    }

    public void testClientJ2EEModule() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getJ2EEModule("PublishTestClient"));
    }

    public void testClientResourceFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getJ2EEModule("PublishTestClient").getResourceFolders().length, (int)1);
    }

    public void testClientJavaOutputFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getJ2EEModule("PublishTestClient").getJavaOutputFolders().length, (int)1);
    }

    public void testClientIsBinary() throws Exception {
        ModuleTestCase.assertFalse((boolean)this.getJ2EEModule("PublishTestClient").isBinary());
    }

    public void testWebModule() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getModule("PublishTestWeb"));
    }

    public void testWebFileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb"), "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void testWebWebXmlExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb"), "WEB-INF/web.xml")) {
            ModuleTestCase.fail();
        }
    }

    public void testWebJSPExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb"), "test.jsp")) {
            ModuleTestCase.fail();
        }
    }

    public void testWebClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb"), "WEB-INF/classes/servtest/TestServlet2.class")) {
            ModuleTestCase.fail();
        }
    }

    public void testWebClassExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb"), "WEB-INF/classes/servtest/TestServlet.class")) {
            ModuleTestCase.fail();
        }
    }

    public void testWebFileCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestWeb")), (int)5);
    }

    public void testWebFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestWeb")), (int)5);
    }

    public void testWebModuleType() throws Exception {
        ModuleTestCase.assertEquals((String)this.getModule("PublishTestWeb").getModuleType().getId(), (String)"jst.web");
    }

    public void test149Web() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getWebModule("PublishTestWeb"));
    }

    public void testWebResourceFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getWebModule("PublishTestWeb").getResourceFolders().length, (int)1);
    }

    public void testWebJavaOutputFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getWebModule("PublishTestWeb").getJavaOutputFolders().length, (int)1);
    }

    public void testWebModuleCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getWebModule("PublishTestWeb").getModules().length, (int)1);
    }

    public void testWebModuleName() throws Exception {
        ModuleTestCase.assertEquals((String)this.getWebModule("PublishTestWeb").getModules()[0].getName(), (String)"PublishTestUtil");
    }

    public void testWebContextRoot() throws Exception {
        ModuleTestCase.assertEquals((String)this.getWebModule("PublishTestWeb").getContextRoot(), (String)"PublishTestWeb");
    }

    public void testWebIsBinary() throws Exception {
        ModuleTestCase.assertFalse((boolean)this.getWebModule("PublishTestWeb").isBinary());
    }

    public void testWeb2Module() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getModule("PublishTestWeb2"));
    }

    public void testWeb2FileExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb2"), "META-INF/MANIFEST.MF")) {
            ModuleTestCase.fail();
        }
    }

    public void testWeb2WebXmlExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb2"), "WEB-INF/web.xml")) {
            ModuleTestCase.fail();
        }
    }

    public void testWeb2JarExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb2"), "WEB-INF/lib/test.jar")) {
            ModuleTestCase.fail();
        }
    }

    public void testWeb2ClassExists() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb2"), "WEB-INF/classes/serv/AServlet.class")) {
            ModuleTestCase.fail();
        }
    }

    public void testWeb2ClassExists2() throws Exception {
        if (!ModuleHelper.fileExists(this.getModule("PublishTestWeb2"), "WEB-INF/classes/serv/BServlet.class")) {
            ModuleTestCase.fail();
        }
    }

    public void testWeb2FileCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFiles(this.getModule("PublishTestWeb2")), (int)5);
    }

    public void testWeb2FolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)ModuleHelper.countFolders(this.getModule("PublishTestWeb2")), (int)5);
    }

    public void testWeb2ModuleType() throws Exception {
        ModuleTestCase.assertEquals((String)this.getModule("PublishTestWeb2").getModuleType().getId(), (String)"jst.web");
    }

    public void testWeb2J2EEModule() throws Exception {
        ModuleTestCase.assertNotNull((Object)this.getWebModule("PublishTestWeb2"));
    }

    public void testWeb2ResourceFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getWebModule("PublishTestWeb2").getResourceFolders().length, (int)1);
    }

    public void testWeb2JavaOutputFolderCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getWebModule("PublishTestWeb2").getJavaOutputFolders().length, (int)1);
    }

    public void testWeb2ModuleCount() throws Exception {
        ModuleTestCase.assertEquals((int)this.getWebModule("PublishTestWeb2").getModules().length, (int)0);
    }

    public void testWeb2ContextRoot() throws Exception {
        ModuleTestCase.assertEquals((String)this.getWebModule("PublishTestWeb2").getContextRoot(), (String)"PublishTestWeb2");
    }

    public void testWeb2IsBinary() throws Exception {
        ModuleTestCase.assertFalse((boolean)this.getWebModule("PublishTestWeb2").isBinary());
    }

    public void deleteProjects() throws Exception {
        String[] stringArray = PROJECT_NAMES;
        int n = PROJECT_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String projectName = stringArray[n2];
            ModuleHelper.deleteProject(projectName);
            ++n2;
        }
    }
}

