/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.format;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jst.jsp.ui.StructuredTextViewerConfigurationJSP;
import org.eclipse.jst.jsp.ui.tests.util.ProjectUtil;
import org.eclipse.jst.jsp.ui.tests.util.StringCompareUtil;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class TestContentFormatter
extends TestCase {
    String wtp_autotest_noninteractive = null;
    private static final String PROJECT_NAME = "jspformatting";
    private static final String UTF_8 = "UTF-8";
    private StringCompareUtil fStringCompareUtil;
    private IFormattingContext fContext;

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty("wtp.autotest.noninteractive");
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty("wtp.autotest.noninteractive", "true");
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists()) {
            ProjectUtil.createProject(PROJECT_NAME, null, new String[]{"org.eclipse.jdt.core.javanature"});
            ProjectUtil.copyBundleEntriesIntoWorkspace("/testfiles/jspformatting", "/jspformatting");
        }
        TestContentFormatter.assertTrue((String)"project could not be created", (boolean)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists());
        this.fContext = new FormattingContext();
        this.fContext.setProperty((Object)"formatting.context.document", (Object)true);
        this.fStringCompareUtil = new StringCompareUtil();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void formatAndAssertEquals(String beforePath, String afterPath, boolean resetPreferences) throws UnsupportedEncodingException, IOException, CoreException {
        IStructuredModel afterModel;
        block5: {
            IStructuredModel beforeModel = null;
            afterModel = null;
            try {
                beforeModel = this.getModelForEdit(beforePath);
                TestContentFormatter.assertNotNull((String)("could not retrieve structured model for : " + beforePath), (Object)beforeModel);
                afterModel = this.getModelForEdit(afterPath);
                TestContentFormatter.assertNotNull((String)("could not retrieve structured model for : " + afterPath), (Object)afterModel);
                if (resetPreferences) {
                    this.resetPreferencesToDefault();
                }
                StructuredTextViewerConfigurationJSP configuration = new StructuredTextViewerConfigurationJSP();
                IContentFormatterExtension formatter = (IContentFormatterExtension)configuration.getContentFormatter(null);
                IStructuredDocument document = beforeModel.getStructuredDocument();
                Region region = new Region(0, document.getLength());
                this.fContext.setProperty((Object)"formatting.context.region", (Object)region);
                formatter.format((IDocument)document, this.fContext);
                ByteArrayOutputStream formattedBytes = new ByteArrayOutputStream();
                beforeModel.save((OutputStream)formattedBytes);
                ByteArrayOutputStream afterBytes = new ByteArrayOutputStream();
                afterModel.save((OutputStream)afterBytes);
                String expectedContents = new String(afterBytes.toByteArray(), UTF_8);
                String actualContents = new String(formattedBytes.toByteArray(), UTF_8);
                TestContentFormatter.assertTrue((String)("Formatted document differs from the expected.\nExpected Contents:\n" + expectedContents + "\nActual Contents:\n" + actualContents), (boolean)this.fStringCompareUtil.equalsIgnoreLineSeperator(expectedContents, actualContents));
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (beforeModel != null) {
                    beforeModel.releaseFromEdit();
                }
                if (afterModel == null) throw throwable;
                afterModel.releaseFromEdit();
                throw throwable;
            }
            {
                Object var14_16 = null;
                if (beforeModel == null) break block5;
            }
            beforeModel.releaseFromEdit();
        }
        if (afterModel == null) return;
        afterModel.releaseFromEdit();
    }

    private IStructuredModel getModelForEdit(String filename) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filename));
        TestContentFormatter.assertTrue((String)("unable to find file: " + filename), (boolean)file.exists());
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            model = modelManager.getModelForEdit(file);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return model;
    }

    private void resetPreferencesToDefault() {
        Preferences preferences = HTMLCorePlugin.getDefault().getPluginPreferences();
        preferences.setToDefault("splitMultiAttrs");
        preferences.setToDefault("lineWidth");
        preferences.setToDefault("indentationChar");
        preferences.setToDefault("indentationSize");
        preferences.setToDefault("clearAllBlankLines");
    }

    public void testFormatBug102495() throws UnsupportedEncodingException, IOException, CoreException {
        String beforePath = "/jspformatting/WebContent/formatbug102495.jsp";
        String afterPath = "/jspformatting/WebContent/formatbug102495-fmt.jsp";
        this.formatAndAssertEquals(beforePath, afterPath, true);
    }

    public void testFormatBug102495_1() throws UnsupportedEncodingException, IOException, CoreException {
        String beforePath = "/jspformatting/WebContent/formatbug102495_1.jsp";
        String afterPath = "/jspformatting/WebContent/formatbug102495_1-fmt.jsp";
        this.formatAndAssertEquals(beforePath, afterPath, true);
    }

    public void testFormatBug102495_2() throws UnsupportedEncodingException, IOException, CoreException {
        String beforePath = "/jspformatting/WebContent/formatbug102495_2.jsp";
        String afterPath = "/jspformatting/WebContent/formatbug102495_2-fmt.jsp";
        this.formatAndAssertEquals(beforePath, afterPath, true);
    }

    public void testFormatBug102495_3() throws UnsupportedEncodingException, IOException, CoreException {
        String beforePath = "/jspformatting/WebContent/formatbug102495_3.jsp";
        String afterPath = "/jspformatting/WebContent/formatbug102495_3-fmt.jsp";
        this.formatAndAssertEquals(beforePath, afterPath, true);
    }

    public void testFormatBug102495_4() throws UnsupportedEncodingException, IOException, CoreException {
        String beforePath = "/jspformatting/WebContent/formatbug102495_4.jsp";
        String afterPath = "/jspformatting/WebContent/formatbug102495_4-fmt.jsp";
        this.formatAndAssertEquals(beforePath, afterPath, true);
    }
}

