/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.tests.validation;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.jsp.core.internal.validation.JSPContentValidator;
import org.eclipse.jst.jsp.ui.internal.validation.JSPContentSourceValidator;
import org.eclipse.jst.jsp.ui.tests.JSPUITestsPlugin;
import org.eclipse.jst.jsp.ui.tests.util.ProjectUtil;
import org.eclipse.jst.jsp.ui.tests.validation.ReporterForTest;
import org.eclipse.jst.jsp.ui.tests.validation.ValidationContextForTest;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSPHTMLValidatorTest
extends TestCase {
    String wtp_autotest_noninteractive = null;
    private static final String PROJECT_NAME = "bug_143209";

    protected void setUp() throws Exception {
        super.setUp();
        String noninteractive = System.getProperty("wtp.autotest.noninteractive");
        if (noninteractive != null) {
            this.wtp_autotest_noninteractive = noninteractive;
        }
        System.setProperty("wtp.autotest.noninteractive", "true");
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists()) {
            ProjectUtil.createProject(PROJECT_NAME, null, new String[]{"org.eclipse.jdt.core.javanature"});
            ProjectUtil.copyBundleEntriesIntoWorkspace("/testfiles/bug_143209", "/bug_143209");
        }
        JSPHTMLValidatorTest.assertTrue((String)"project could not be created", (boolean)ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME).exists());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.wtp_autotest_noninteractive != null) {
            System.setProperty("wtp.autotest.noninteractive", this.wtp_autotest_noninteractive);
        }
    }

    public void testJSPinAttributes() throws Exception {
        JSPContentValidator validator = new JSPContentValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/bug_143209/WebContent/usejspinattribute.jsp";
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPHTMLValidatorTest.assertTrue((String)"jsp in attributes are errors when they should not be (in .jsp)", (boolean)reporter.getMessages().isEmpty());
    }

    public void testJSPinAttributesHTML() throws Exception {
        JSPContentValidator validator = new JSPContentValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/bug_143209/WebContent/usejspinattribute.html";
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPHTMLValidatorTest.assertTrue((String)"jsp in attributes are not errors when they should be (in .html)", (!reporter.getMessages().isEmpty() ? 1 : 0) != 0);
    }

    public void testBadAttributeName() throws Exception {
        JSPContentValidator validator = new JSPContentValidator();
        ReporterForTest reporter = new ReporterForTest();
        ValidationContextForTest helper = new ValidationContextForTest();
        String filePath = "/bug_143209/WebContent/badattributenames.jsp";
        helper.setURI(filePath);
        validator.validate((IValidationContext)helper, (IReporter)reporter);
        JSPHTMLValidatorTest.assertTrue((String)"bad attribute name is not error when it should be", (!reporter.getMessages().isEmpty() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testRemoveAndAddBackCommentEndTag() throws Exception {
        IProject project;
        block4: {
            JSPContentSourceValidator fValidator = new JSPContentSourceValidator();
            String projectName = "RemoveAndAddBackCommentEndTag";
            project = ProjectUtil.createProject(projectName, JSPUITestsPlugin.getDefault().getStateLocation().append(this.getName()), null);
            IFile testFile = null;
            IStructuredModel model = null;
            try {
                ProjectUtil.copyBundleEntriesIntoWorkspace("testfiles/RemoveAndAddBackCommentEndTag", projectName);
                testFile = project.getFile("Test1.jsp");
                JSPHTMLValidatorTest.assertTrue((String)("Test file " + testFile + " does not exist"), (boolean)testFile.exists());
                model = StructuredModelManager.getModelManager().getModelForEdit(testFile);
                IStructuredDocument document = model.getStructuredDocument();
                WorkbenchContext context = new WorkbenchContext();
                ArrayList<String> fileList = new ArrayList<String>();
                fileList.add(testFile.getFullPath().toPortableString());
                context.setValidationFileURIs(fileList);
                TestReporter reporter = new TestReporter();
                fValidator.validate((IValidationContext)context, (IReporter)reporter);
                JSPHTMLValidatorTest.assertFalse((String)("There should be no validation errors on " + testFile), (boolean)reporter.isMessageReported());
                String contents = document.get();
                int endCommentIndex = contents.indexOf("-->");
                document.replace(endCommentIndex, 3, "");
                reporter = new TestReporter();
                fValidator.validate((IValidationContext)context, (IReporter)reporter);
                JSPHTMLValidatorTest.assertTrue((String)("There should be validation errors on " + testFile), (boolean)reporter.isMessageReported());
                document.replace(endCommentIndex, 0, "-->");
                reporter = new TestReporter();
                fValidator.validate((IValidationContext)context, (IReporter)reporter);
                JSPHTMLValidatorTest.assertFalse((String)("There should be no validation errors on " + testFile), (boolean)reporter.isMessageReported());
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (model != null) {
                    model.releaseFromEdit();
                }
                throw throwable;
            }
            {
                Object var12_14 = null;
                if (model == null) break block4;
            }
            model.releaseFromEdit();
        }
        project.delete(true, null);
    }

    private class TestReporter
    implements IReporter {
        private boolean messageReported = false;

        public void addMessage(IValidator origin, IMessage message) {
            this.messageReported = true;
        }

        public boolean isMessageReported() {
            return this.messageReported;
        }

        public void displaySubtask(IValidator validator, IMessage message) {
        }

        public List getMessages() {
            return null;
        }

        public boolean isCancelled() {
            return false;
        }

        public void removeAllMessages(IValidator origin, Object object) {
        }

        public void removeAllMessages(IValidator origin) {
        }

        public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        }
    }
}

