/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.dependency.tests.util;

import java.io.IOException;
import java.util.Set;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyCreationUtil;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class DependencyVerificationUtil {
    public static final IPath WEB_INF_LIB = new Path("/WEB-INF/lib");
    public static final IPath ROOT = new Path("/");

    public static void verifyDependency(IProject source, IProject target, boolean hasDep) {
        Set referencingComponents = IDependencyGraph.INSTANCE.getReferencingComponents(target);
        boolean dep = false;
        for (IProject project : referencingComponents) {
            if (!project.equals((Object)source)) continue;
            dep = true;
            break;
        }
        if (hasDep) {
            Assert.assertTrue((String)("DependencyGraphManager does not report dependency between " + source + " and " + target), (boolean)dep);
        } else {
            Assert.assertFalse((String)("DependencyGraphManager incorrectly reporting dependency between " + source + " and " + target), (boolean)dep);
        }
    }

    public static void verifyComponentReference(IProject source, IProject target, IPath runtimePath, boolean hasRef) {
        IVirtualComponent sourceComp = ComponentCore.createComponent((IProject)source);
        IVirtualReference[] refs = sourceComp.getReferences();
        boolean ref = false;
        int i = 0;
        while (i < refs.length) {
            if (refs[i].getReferencedComponent().getProject().equals((Object)target) && (runtimePath == null || refs[i].getRuntimePath().equals((Object)runtimePath))) {
                ref = true;
                break;
            }
            ++i;
        }
        if (hasRef) {
            Assert.assertTrue((String)("Source project " + source + " missing component reference to " + target), (boolean)ref);
        } else {
            Assert.assertFalse((String)("Source project " + source + " still has component reference to " + target), (boolean)ref);
        }
    }

    public static void verifyProjectReference(IProject source, IProject target, boolean hasRef) throws CoreException {
        IProjectDescription desc = source.getDescription();
        IProject[] refs = desc.getReferencedProjects();
        boolean ref = false;
        int i = 0;
        while (i < refs.length) {
            if (refs[i].equals((Object)target)) {
                ref = true;
                break;
            }
            ++i;
        }
        if (hasRef) {
            Assert.assertTrue((String)("Source project " + source + " missing project reference to " + target), (boolean)ref);
        } else {
            Assert.assertFalse((String)("Source project " + source + " still has project reference to " + target), (boolean)ref);
        }
    }

    public static void verifyManifestReference(IProject source, String entry, boolean hasEntry) throws CoreException, IOException {
        IVirtualComponent sourceComp = ComponentCore.createComponent((IProject)source);
        IVirtualFile vf = sourceComp.getRootFolder().getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        IFile manifestmf = vf.getUnderlyingFile();
        ArchiveManifest manifest = DependencyCreationUtil.getArchiveManifest(manifestmf);
        String[] cp = manifest.getClassPathTokenized();
        boolean hasManifestRef = false;
        int i = 0;
        while (i < cp.length) {
            if (cp[i].equals(entry)) {
                hasManifestRef = true;
            }
            ++i;
        }
        if (hasEntry) {
            Assert.assertTrue((String)("Source project " + source + " missing MANIFEST.MF entry " + entry), (boolean)hasManifestRef);
        } else {
            Assert.assertFalse((String)("Source project " + source + " still has MANIFEST.MF entry " + entry), (boolean)hasManifestRef);
        }
    }

    public static String verifyApplicationXMLReference(IProject earProject, IProject moduleProject, String moduleURI, boolean hasRef) throws CoreException {
        EARArtifactEdit earEdit = null;
        try {
            earEdit = EARArtifactEdit.getEARArtifactEditForRead((IProject)earProject);
            Assert.assertTrue((earEdit != null ? 1 : 0) != 0);
            Application application = earEdit.getApplication();
            if (hasRef) {
                IVirtualComponent moduleComp = ComponentCore.createComponent((IProject)moduleProject);
                String computedURI = earEdit.getModuleURI(moduleComp);
                Assert.assertTrue((String)("EAR's application.xml missing module element for " + moduleURI), (application.getFirstModule(computedURI) != null ? 1 : 0) != 0);
                String string = computedURI;
                return string;
            }
            Module module = application.getFirstModule(moduleURI);
            Assert.assertTrue((String)("EAR's application.xml should not have a module element for " + moduleURI), (module == null ? 1 : 0) != 0);
        }
        finally {
            if (earEdit != null) {
                earEdit.dispose();
            }
        }
        return null;
    }

    public static void waitForClasspathUpdate() {
        Job[] jobs = Job.getJobManager().find((Object)J2EEComponentClasspathUpdater.MODULE_UPDATE_JOB_NAME);
        if (jobs.length > 0) {
            try {
                int i = 0;
                while (i < jobs.length) {
                    if (jobs[i].getName().equals(J2EEComponentClasspathUpdater.MODULE_UPDATE_JOB_NAME)) {
                        jobs[i].join();
                    }
                    ++i;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void verifyClasspathReference(IProject source, IProject target, boolean hasRef) throws CoreException {
        DependencyVerificationUtil.waitForClasspathUpdate();
        boolean onClasspath = DependencyVerificationUtil.hasClasspathReference(source, target);
        if (hasRef) {
            Assert.assertTrue((String)("Project " + target + " missing from resolved classpath of project " + source), (boolean)onClasspath);
        } else {
            Assert.assertFalse((String)("Project " + target + " should not be on resolved classpath of project " + source), (boolean)onClasspath);
        }
    }

    public static boolean hasClasspathReference(IProject source, IProject target) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)source);
        IClasspathEntry[] cp = javaProject.getResolvedClasspath(true);
        boolean onClasspath = false;
        int i = 0;
        while (i < cp.length) {
            if (cp[i].getEntryKind() == 2 && cp[i].getPath().equals((Object)target.getFullPath())) {
                onClasspath = true;
                break;
            }
            ++i;
        }
        return onClasspath;
    }

    public static String verifyEARDependency(IProject earProject, IProject childProject, boolean moduleRef) throws CoreException {
        DependencyVerificationUtil.verifyProjectReference(earProject, childProject, true);
        DependencyVerificationUtil.verifyComponentReference(earProject, childProject, ROOT, true);
        String moduleURI = null;
        if (moduleRef) {
            moduleURI = DependencyVerificationUtil.verifyApplicationXMLReference(earProject, childProject, null, true);
        }
        DependencyVerificationUtil.verifyDependency(earProject, childProject, true);
        return moduleURI;
    }

    public static void verifyEARDependencyChanged(IProject earProject, IProject oldChildProject, IProject newChildProject) throws CoreException {
        DependencyVerificationUtil.verifyEARDependencyChanged(earProject, oldChildProject, null, newChildProject);
    }

    public static void verifyEARDependencyChanged(IProject earProject, IProject oldChildProject, String oldModuleURI, IProject newChildProject) throws CoreException {
        DependencyVerificationUtil.verifyEARDependency(earProject, newChildProject, oldModuleURI != null);
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject, oldChildProject, oldModuleURI);
    }

    public static void verifyEARDependencyRemoved(IProject earProject, IProject childProject) throws CoreException {
        DependencyVerificationUtil.verifyEARDependencyRemoved(earProject, childProject, null);
    }

    public static void verifyEARDependencyRemoved(IProject earProject, IProject childProject, String oldModuleURI) throws CoreException {
        DependencyVerificationUtil.verifyComponentReference(earProject, childProject, ROOT, false);
        if (oldModuleURI != null) {
            DependencyVerificationUtil.verifyApplicationXMLReference(earProject, childProject, oldModuleURI, false);
        }
        DependencyVerificationUtil.verifyDependency(earProject, childProject, false);
        DependencyVerificationUtil.verifyProjectReference(earProject, childProject, false);
    }

    public static void verifyModuleDependency(IProject source, IProject target) throws CoreException, IOException {
        DependencyVerificationUtil.verifyManifestReference(source, String.valueOf(target.getName()) + ".jar", true);
        DependencyVerificationUtil.verifyClasspathReference(source, target, true);
        DependencyVerificationUtil.verifyDependency(source, target, true);
    }

    public static void verifyModuleDependencyChanged(IProject source, IProject oldTarget, IProject newTarget) throws CoreException, IOException {
        DependencyVerificationUtil.verifyModuleDependency(source, newTarget);
        DependencyVerificationUtil.verifyModuleDependencyRemoved(source, oldTarget);
    }

    public static void verifyModuleDependencyRemoved(IProject source, IProject target) throws CoreException, IOException {
        DependencyVerificationUtil.verifyManifestReference(source, String.valueOf(target.getName()) + ".jar", false);
        DependencyVerificationUtil.verifyClasspathReference(source, target, false);
        DependencyVerificationUtil.verifyDependency(source, target, false);
    }

    public static void verifyWebLibDependency(IProject source, IProject target) throws CoreException {
        DependencyVerificationUtil.verifyProjectReference(source, target, true);
        DependencyVerificationUtil.verifyComponentReference(source, target, WEB_INF_LIB, true);
        DependencyVerificationUtil.verifyClasspathReference(source, target, true);
        DependencyVerificationUtil.verifyDependency(source, target, true);
    }

    public static void verifyWebLibDependencyChanged(IProject source, IProject oldTarget, IProject newTarget) throws CoreException {
        DependencyVerificationUtil.verifyWebLibDependency(source, newTarget);
        DependencyVerificationUtil.verifyWebLibDependencyRemoved(source, oldTarget);
    }

    public static void verifyWebLibDependencyRemoved(IProject source, IProject target) throws CoreException {
        DependencyVerificationUtil.verifyProjectReference(source, target, false);
        DependencyVerificationUtil.verifyComponentReference(source, target, WEB_INF_LIB, false);
        DependencyVerificationUtil.verifyClasspathReference(source, target, false);
        DependencyVerificationUtil.verifyDependency(source, target, false);
    }
}

