/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.javaee.core.LifecycleCallback;
import org.eclipse.jst.javaee.ejb.MessageDrivenBean;
import org.eclipse.jst.javaee.ejb.SessionBean;
import org.eclipse.jst.jee.model.internal.common.Result;
import org.eclipse.jst.jee.model.tests.AbstractAnnotationFactoryTest;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.TestUtils;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class LifecycleAnnotationsTest
extends AbstractAnnotationFactoryTest {
    private IFacetedProject facetedProject;

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite(LifecycleAnnotationsTest.class);
        return suite;
    }

    protected void setUp() throws Exception {
        LifecycleAnnotationsTest.setUpProject();
        super.setUp();
        this.facetedProject = ProjectFacetsManager.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(((Object)((Object)this)).getClass().getSimpleName()));
    }

    public static void setUpProject() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(LifecycleAnnotationsTest.class.getSimpleName());
        if (!project.exists()) {
            project = ProjectUtil.createEJBProject(LifecycleAnnotationsTest.class.getSimpleName(), null, 30, true);
            LifecycleAnnotationsTest.createProjectContent(project);
        }
    }

    public static void tearDownAfterClass() throws InterruptedException {
        AbstractTest.deleteProject(LifecycleAnnotationsTest.class.getSimpleName());
    }

    private static void createProjectContent(IProject project) throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder comFolder = javaProject.getProject().getFolder("ejbModule/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
    }

    public void testPostActivate() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testPostActivate.java");
        AbstractTest.saveFile(beanFile, "package com.sap;@Stateful public class testPostActivate implements SessionBeanLocal{@PostActivate public void postActivateMethod() {}@PostActivate protected void protectedMethod() {}@PostActivate void defaultMethod() {}@PostActivate private void privateMethod() {}@PostActivate public String returnTypeMethod() {return null;}@PostActivate public void paramMethod(String param) {}@PostActivate public void exceptionMethod() throws Exception {}@PostActivate public final void finalMethod() {}}");
        IType type = JavaCore.createCompilationUnitFrom((IFile)beanFile).findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        LifecycleAnnotationsTest.assertNotNull((Object)sessionBean);
        LifecycleAnnotationsTest.assertEquals((String)"testPostActivate", (String)sessionBean.getEjbName());
        LifecycleCallback postActivateMethod = TestUtils.findLifecycleMethod(sessionBean.getPostActivates(), "postActivateMethod");
        LifecycleAnnotationsTest.assertEquals((String)"com.sap.testPostActivate", (String)postActivateMethod.getLifecycleCallbackClass());
        LifecycleCallback protectedMethod = TestUtils.findLifecycleMethod(sessionBean.getPostActivates(), "protectedMethod");
        LifecycleAnnotationsTest.assertEquals((String)"com.sap.testPostActivate", (String)protectedMethod.getLifecycleCallbackClass());
        LifecycleCallback defaultMethod = TestUtils.findLifecycleMethod(sessionBean.getPostActivates(), "defaultMethod");
        LifecycleAnnotationsTest.assertEquals((String)"com.sap.testPostActivate", (String)defaultMethod.getLifecycleCallbackClass());
        LifecycleCallback privateMethod = TestUtils.findLifecycleMethod(sessionBean.getPostActivates(), "privateMethod");
        LifecycleAnnotationsTest.assertEquals((String)"com.sap.testPostActivate", (String)privateMethod.getLifecycleCallbackClass());
        LifecycleAnnotationsTest.assertEquals((Object)new Integer(4), (Object)new Integer(sessionBean.getPostActivates().size()));
    }

    public void testPrePassivate() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testPrePassivate.java");
        AbstractTest.saveFile(beanFile, "package com.sap;@Stateful public class testPrePassivate implements SessionBeanLocal{@PrePassivate public void prePassivateMethod() {}@PrePassivate protected void protectedMethod() {}@PrePassivate void defaultMethod() {}@PrePassivate private void privateMethod() {}@PrePassivate public String returnTypeMethod() {return null;}@PrePassivate public void paramMethod(String param) {}@PrePassivate public void exceptionMethod() throws Exception {}@PrePassivate public final void finalMethod() {}}");
        IType type = JavaCore.createCompilationUnitFrom((IFile)beanFile).findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        LifecycleAnnotationsTest.assertNotNull((Object)sessionBean);
        LifecycleCallback postActivateMethod = TestUtils.findLifecycleMethod(sessionBean.getPrePassivates(), "prePassivateMethod");
        LifecycleAnnotationsTest.assertEquals((String)"com.sap.testPrePassivate", (String)postActivateMethod.getLifecycleCallbackClass());
        LifecycleCallback protectedMethod = TestUtils.findLifecycleMethod(sessionBean.getPrePassivates(), "protectedMethod");
        LifecycleAnnotationsTest.assertEquals((String)"com.sap.testPrePassivate", (String)protectedMethod.getLifecycleCallbackClass());
        LifecycleCallback defaultMethod = TestUtils.findLifecycleMethod(sessionBean.getPrePassivates(), "defaultMethod");
        LifecycleAnnotationsTest.assertEquals((String)"com.sap.testPrePassivate", (String)defaultMethod.getLifecycleCallbackClass());
        LifecycleCallback privateMethod = TestUtils.findLifecycleMethod(sessionBean.getPrePassivates(), "privateMethod");
        LifecycleAnnotationsTest.assertEquals((String)"com.sap.testPrePassivate", (String)privateMethod.getLifecycleCallbackClass());
        LifecycleAnnotationsTest.assertEquals((Object)new Integer(4), (Object)new Integer(sessionBean.getPrePassivates().size()));
    }

    public void testPostConstruct() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testPostConstruct.java");
        AbstractTest.saveFile(beanFile, "package com.sap;@Stateless public class testPostConstruct implements SessionBeanLocal {@PostConstruct public void publicMethod() {}@PostConstruct public static void staticMethod() {}@PostConstruct public final void finalMethod(){}@PostConstruct public String returnType() {}@PostConstruct public void paramMethod(String param) {}@PostConstruct public void throwExpception() throws Exception {};}");
        IType type = JavaCore.createCompilationUnitFrom((IFile)beanFile).findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        LifecycleAnnotationsTest.assertNotNull((Object)sessionBean);
        LifecycleAnnotationsTest.assertEquals((String)"testPostConstruct", (String)sessionBean.getEjbName());
        LifecycleCallback callback = TestUtils.findLifecycleMethod(sessionBean.getPostConstructs(), "publicMethod");
        LifecycleAnnotationsTest.assertEquals((String)"com.sap.testPostConstruct", (String)callback.getLifecycleCallbackClass());
        LifecycleAnnotationsTest.assertEquals((Object)new Integer(1), (Object)new Integer(sessionBean.getPostConstructs().size()));
    }

    public void testPreDestroy() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testPreDestroy.java");
        AbstractTest.saveFile(beanFile, "package com.sap;@Stateless public class testPreDestroy implements SessionBeanLocal {@PreDestroy public void publicMethod() {}@PreDestroy public static void staticMethod() {}@PreDestroy public final void finalMethod(){}@PreDestroy public String returnType() {}@PreDestroy public void paramMethod(String param) {}@PreDestroy public void throwExpception() throws Exception {};}");
        IType type = JavaCore.createCompilationUnitFrom((IFile)beanFile).findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        SessionBean sessionBean = (SessionBean)result.getMainObject();
        LifecycleAnnotationsTest.assertNotNull((Object)sessionBean);
        LifecycleCallback callback = TestUtils.findLifecycleMethod(sessionBean.getPreDestroys(), "publicMethod");
        LifecycleAnnotationsTest.assertEquals((String)"com.sap.testPreDestroy", (String)callback.getLifecycleCallbackClass());
        LifecycleAnnotationsTest.assertEquals((Object)new Integer(1), (Object)new Integer(sessionBean.getPreDestroys().size()));
    }

    public void testLifecycleOnMessageDriven() throws Exception {
        IFile beanFile = this.facetedProject.getProject().getFile("ejbModule/com/sap/testLifecycleOnMessageDriven.java");
        AbstractTest.saveFile(beanFile, "package com.sap;@MessageDriven public class testLifecycleOnMessageDriven implements SessionBeanLocal {@PostConstruct public void postConstructMethod() {}@PreDestroy public void preDestroyMethod() {}}");
        IType type = JavaCore.createCompilationUnitFrom((IFile)beanFile).findPrimaryType();
        Result result = this.fixture.createJavaeeObject(type);
        MessageDrivenBean mdb = (MessageDrivenBean)result.getMainObject();
        LifecycleAnnotationsTest.assertNotNull((Object)mdb);
        LifecycleCallback callback1 = TestUtils.findLifecycleMethod(mdb.getPostConstructs(), "postConstructMethod");
        LifecycleAnnotationsTest.assertNotNull((Object)callback1);
        LifecycleAnnotationsTest.assertEquals((String)"com.sap.testLifecycleOnMessageDriven", (String)callback1.getLifecycleCallbackClass());
        LifecycleCallback callback2 = TestUtils.findLifecycleMethod(mdb.getPreDestroys(), "preDestroyMethod");
        LifecycleAnnotationsTest.assertNotNull((Object)callback2);
        LifecycleAnnotationsTest.assertEquals((String)"com.sap.testLifecycleOnMessageDriven", (String)callback2.getLifecycleCallbackClass());
        LifecycleAnnotationsTest.assertEquals((Object)new Integer(1), (Object)new Integer(mdb.getPreDestroys().size()));
        LifecycleAnnotationsTest.assertEquals((Object)new Integer(1), (Object)new Integer(mdb.getPostConstructs().size()));
    }
}

