/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.mergers.tests;

import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.jst.javaee.core.JavaEEObject;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.core.RunAs;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.core.UrlPatternType;
import org.eclipse.jst.javaee.web.AuthConstraint;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.FilterMapping;
import org.eclipse.jst.javaee.web.SecurityConstraint;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.ServletMapping;
import org.eclipse.jst.javaee.web.TransportGuaranteeType;
import org.eclipse.jst.javaee.web.UserDataConstraint;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jee.model.internal.mergers.ModelException;
import org.eclipse.jst.jee.model.internal.mergers.WebApp3Merger;

public class WebApp3MergerTest
extends TestCase {
    public void testSingleSecurityRoleCaseBase() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        SecurityRole role = JavaeeFactory.eINSTANCE.createSecurityRole();
        role.setRoleName("test1");
        descriptorBase.getSecurityRoles().add(role);
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)descriptorBase.getSecurityRoles());
        Assert.assertTrue((descriptorBase.getSecurityRoles().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((descriptorToMerge.getSecurityRoles().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((SecurityRole)descriptorBase.getSecurityRoles().get(0)).getRoleName().equals("test1"));
    }

    public void testSingleSecurityRoleCaseToMerge() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        SecurityRole role = JavaeeFactory.eINSTANCE.createSecurityRole();
        role.setRoleName("test1");
        descriptorToMerge.getSecurityRoles().add(role);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)descriptorBase.getSecurityRoles());
        Assert.assertEquals((int)1, (int)descriptorBase.getSecurityRoles().size());
        Assert.assertEquals((int)1, (int)descriptorToMerge.getSecurityRoles().size());
        Assert.assertTrue((boolean)((SecurityRole)descriptorBase.getSecurityRoles().get(0)).getRoleName().equals("test1"));
    }

    public void testSingleSecurityRoleCaseSameRole() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        SecurityRole role = JavaeeFactory.eINSTANCE.createSecurityRole();
        role.setRoleName("test1");
        descriptorBase.getSecurityRoles().add(role);
        descriptorToMerge.getSecurityRoles().add(role);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)descriptorBase.getSecurityRoles());
        Assert.assertTrue((descriptorBase.getSecurityRoles().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((descriptorToMerge.getSecurityRoles().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((SecurityRole)descriptorBase.getSecurityRoles().get(0)).getRoleName().equals("test1"));
    }

    public void testSingleSecurityRoleCaseComplex() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        SecurityRole role0 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role1 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role2 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role3 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role4 = JavaeeFactory.eINSTANCE.createSecurityRole();
        SecurityRole role5 = JavaeeFactory.eINSTANCE.createSecurityRole();
        role0.setRoleName("test1");
        role1.setRoleName("test2");
        role2.setRoleName("test3");
        role3.setRoleName("test4");
        role4.setRoleName("test5");
        role5.setRoleName("test6");
        descriptorBase.getSecurityRoles().add(role1);
        descriptorBase.getSecurityRoles().add(role3);
        descriptorBase.getSecurityRoles().add(role4);
        descriptorBase.getSecurityRoles().add(role5);
        descriptorToMerge.getSecurityRoles().add(role0);
        descriptorToMerge.getSecurityRoles().add(role1);
        descriptorToMerge.getSecurityRoles().add(role2);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)descriptorBase.getSecurityRoles());
        Assert.assertTrue((descriptorBase.getSecurityRoles().size() == 6 ? 1 : 0) != 0);
        Assert.assertTrue((descriptorToMerge.getSecurityRoles().size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role0.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role1.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role2.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role3.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role4.getRoleName()));
        Assert.assertTrue((boolean)this.containsSecRole(descriptorBase.getSecurityRoles(), role5.getRoleName()));
    }

    private boolean containsSecRole(List list, String roleName) {
        for (Object object : list) {
            SecurityRole role = (SecurityRole)object;
            if (!(roleName == null ? roleName == role.getRoleName() : roleName.equals(role.getRoleName()))) continue;
            return true;
        }
        return false;
    }

    public void testSingleRunAsCaseBase() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        RunAs role = JavaeeFactory.eINSTANCE.createRunAs();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        servletBase.setServletName("servName");
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        servletMerge.setServletName("servName");
        role.setRoleName("test1");
        servletBase.setRunAs(role);
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)servletBase.getRunAs());
        Assert.assertTrue((boolean)servletBase.getRunAs().getRoleName().equals("test1"));
    }

    public void testSingleRunAsCaseToMerge() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        RunAs role = JavaeeFactory.eINSTANCE.createRunAs();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        servletBase.setServletName("servName");
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        servletMerge.setServletName("servName");
        role.setRoleName("test1");
        servletMerge.setRunAs(role);
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)servletBase.getRunAs());
        Assert.assertTrue((boolean)servletBase.getRunAs().getRoleName().equals("test1"));
        Assert.assertEquals((int)1, (int)descriptorBase.getServlets().size());
    }

    public void testSingleNullServletToMerge() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        descriptorToMerge.getServlets().add(servletBase);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)0, (int)descriptorBase.getServlets().size());
    }

    public void testSingleNullNamedServletInBase() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        servletMerge.setServletName("servName");
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)2, (int)descriptorBase.getServlets().size());
    }

    public void testSingleRunAsCaseSameRole() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        RunAs role = JavaeeFactory.eINSTANCE.createRunAs();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        servletBase.setServletName("servName");
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        servletMerge.setServletName("servName");
        role.setRoleName("test1");
        servletBase.setRunAs(role);
        servletMerge.setRunAs(role);
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)servletBase.getRunAs());
        Assert.assertTrue((boolean)servletBase.getRunAs().getRoleName().equals("test1"));
    }

    public void testSingleSecurityConstraintCaseBase() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        SecurityConstraint sc = WebFactory.eINSTANCE.createSecurityConstraint();
        AuthConstraint createAuthConstraint = WebFactory.eINSTANCE.createAuthConstraint();
        createAuthConstraint.getRoleNames().add("test");
        sc.setAuthConstraint(createAuthConstraint);
        UserDataConstraint userDataConstraint = WebFactory.eINSTANCE.createUserDataConstraint();
        userDataConstraint.setTransportGuarantee(TransportGuaranteeType.CONFIDENTIAL_LITERAL);
        sc.setUserDataConstraint(userDataConstraint);
        descriptorBase.getSecurityConstraints().add(sc);
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertNotNull((Object)descriptorBase.getSecurityConstraints());
        Assert.assertTrue((descriptorBase.getSecurityConstraints().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((descriptorToMerge.getSecurityConstraints().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)((SecurityConstraint)descriptorBase.getSecurityConstraints().get(0)).getAuthConstraint().getRoleNames().get(0)).equals("test"));
    }

    public void testSingleSecurityConstraintCaseToMerge() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        SecurityConstraint sc = WebFactory.eINSTANCE.createSecurityConstraint();
        AuthConstraint createAuthConstraint = WebFactory.eINSTANCE.createAuthConstraint();
        createAuthConstraint.getRoleNames().add("test");
        sc.setAuthConstraint(createAuthConstraint);
        UserDataConstraint userDataConstraint = WebFactory.eINSTANCE.createUserDataConstraint();
        userDataConstraint.setTransportGuarantee(TransportGuaranteeType.CONFIDENTIAL_LITERAL);
        sc.setUserDataConstraint(userDataConstraint);
        descriptorBase.getSecurityConstraints().add(sc);
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorToMerge, (JavaEEObject)descriptorBase, 0);
        result.process();
        Assert.assertNotNull((Object)descriptorToMerge.getSecurityConstraints());
        Assert.assertTrue((descriptorToMerge.getSecurityConstraints().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((String)((SecurityConstraint)descriptorToMerge.getSecurityConstraints().get(0)).getAuthConstraint().getRoleNames().get(0)).equals("test"));
    }

    public void testSingleServletMappingInBase() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        String sname = "servName";
        servletBase.setServletName(sname);
        servletMerge.setServletName(sname);
        ServletMapping servletMappingBase = WebFactory.eINSTANCE.createServletMapping();
        UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
        String value = "/1";
        urlPatternType.setValue(value);
        servletMappingBase.setServletName(sname);
        servletMappingBase.getUrlPatterns().add(urlPatternType);
        descriptorBase.getServletMappings().add(servletMappingBase);
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getServletMappings().size());
        ServletMapping mapping = (ServletMapping)descriptorBase.getServletMappings().get(0);
        Assert.assertEquals((String)sname, (String)mapping.getServletName());
        Assert.assertEquals((int)1, (int)mapping.getUrlPatterns().size());
        Assert.assertEquals((String)value, (String)((UrlPatternType)mapping.getUrlPatterns().get(0)).getValue());
    }

    public void testSingleServletMappingInToMerge() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        String sname = "servName";
        servletBase.setServletName(sname);
        servletMerge.setServletName(sname);
        ServletMapping servletMappingBase = WebFactory.eINSTANCE.createServletMapping();
        UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
        String value = "/1";
        urlPatternType.setValue(value);
        servletMappingBase.setServletName(sname);
        servletMappingBase.getUrlPatterns().add(urlPatternType);
        descriptorToMerge.getServletMappings().add(servletMappingBase);
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getServletMappings().size());
        ServletMapping mapping = (ServletMapping)descriptorBase.getServletMappings().get(0);
        Assert.assertEquals((String)sname, (String)mapping.getServletName());
        Assert.assertEquals((int)1, (int)mapping.getUrlPatterns().size());
        Assert.assertEquals((String)value, (String)((UrlPatternType)mapping.getUrlPatterns().get(0)).getValue());
    }

    public void testSingleServletMappingSame() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        String sname = "servName";
        servletBase.setServletName(sname);
        servletMerge.setServletName(sname);
        ServletMapping servletMappingBase = WebFactory.eINSTANCE.createServletMapping();
        UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
        String value = "/1";
        urlPatternType.setValue(value);
        servletMappingBase.setServletName(sname);
        servletMappingBase.getUrlPatterns().add(urlPatternType);
        descriptorToMerge.getServletMappings().add(servletMappingBase);
        descriptorBase.getServletMappings().add(servletMappingBase);
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getServletMappings().size());
        ServletMapping mapping = (ServletMapping)descriptorBase.getServletMappings().get(0);
        Assert.assertEquals((String)sname, (String)mapping.getServletName());
        Assert.assertEquals((int)1, (int)mapping.getUrlPatterns().size());
        Assert.assertEquals((String)value, (String)((UrlPatternType)mapping.getUrlPatterns().get(0)).getValue());
    }

    public void testSingleServletMappingAdditive() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        String sname = "servName";
        servletBase.setServletName(sname);
        servletMerge.setServletName(sname);
        String value = "/1";
        String value2 = "/2";
        UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
        urlPatternType.setValue(value);
        UrlPatternType urlPatternType2 = JavaeeFactory.eINSTANCE.createUrlPatternType();
        urlPatternType2.setValue(value2);
        ServletMapping servletMappingBase = WebFactory.eINSTANCE.createServletMapping();
        ServletMapping servletMappingMerge = WebFactory.eINSTANCE.createServletMapping();
        servletMappingBase.setServletName(sname);
        servletMappingBase.getUrlPatterns().add(urlPatternType);
        servletMappingMerge.setServletName(sname);
        servletMappingMerge.getUrlPatterns().add(urlPatternType2);
        descriptorBase.getServletMappings().add(servletMappingBase);
        descriptorToMerge.getServletMappings().add(servletMappingMerge);
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getServletMappings().size());
        ServletMapping mapping = (ServletMapping)descriptorBase.getServletMappings().get(0);
        Assert.assertEquals((String)sname, (String)mapping.getServletName());
        Assert.assertEquals((int)2, (int)mapping.getUrlPatterns().size());
        Assert.assertEquals((String)value, (String)((UrlPatternType)mapping.getUrlPatterns().get(0)).getValue());
    }

    public void testSingleServletMappingDifferentServletName() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        String sname = "servName";
        String sname1 = "servName1";
        servletBase.setServletName(sname);
        servletMerge.setServletName(sname1);
        String value = "/1";
        String value2 = "/2";
        UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
        urlPatternType.setValue(value);
        UrlPatternType urlPatternType2 = JavaeeFactory.eINSTANCE.createUrlPatternType();
        urlPatternType2.setValue(value2);
        ServletMapping servletMappingBase = WebFactory.eINSTANCE.createServletMapping();
        ServletMapping servletMappingMerge = WebFactory.eINSTANCE.createServletMapping();
        servletMappingBase.setServletName(sname);
        servletMappingBase.getUrlPatterns().add(urlPatternType);
        servletMappingMerge.setServletName(sname1);
        servletMappingMerge.getUrlPatterns().add(urlPatternType2);
        descriptorBase.getServletMappings().add(servletMappingBase);
        descriptorToMerge.getServletMappings().add(servletMappingMerge);
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)2, (int)descriptorBase.getServletMappings().size());
    }

    public void testSingleFilterMappingInBase() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Filter servletBase = WebFactory.eINSTANCE.createFilter();
        Filter servletMerge = WebFactory.eINSTANCE.createFilter();
        String sname = "servName";
        servletBase.setFilterName(sname);
        servletMerge.setFilterName(sname);
        FilterMapping FilterMappingBase = WebFactory.eINSTANCE.createFilterMapping();
        UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
        String value = "/1";
        urlPatternType.setValue(value);
        FilterMappingBase.setFilterName(sname);
        FilterMappingBase.getUrlPatterns().add(urlPatternType);
        descriptorBase.getFilterMappings().add(FilterMappingBase);
        descriptorBase.getFilters().add(servletBase);
        descriptorToMerge.getFilters().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getFilterMappings().size());
        FilterMapping mapping = (FilterMapping)descriptorBase.getFilterMappings().get(0);
        Assert.assertEquals((String)sname, (String)mapping.getFilterName());
        Assert.assertEquals((int)1, (int)mapping.getUrlPatterns().size());
        Assert.assertEquals((String)value, (String)((UrlPatternType)mapping.getUrlPatterns().get(0)).getValue());
    }

    public void testSingleFilterMappingInToMerge() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Filter servletBase = WebFactory.eINSTANCE.createFilter();
        Filter servletMerge = WebFactory.eINSTANCE.createFilter();
        String sname = "servName";
        servletBase.setFilterName(sname);
        servletMerge.setFilterName(sname);
        FilterMapping FilterMappingBase = WebFactory.eINSTANCE.createFilterMapping();
        UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
        String value = "/1";
        urlPatternType.setValue(value);
        FilterMappingBase.setFilterName(sname);
        FilterMappingBase.getUrlPatterns().add(urlPatternType);
        descriptorToMerge.getFilterMappings().add(FilterMappingBase);
        descriptorBase.getFilters().add(servletBase);
        descriptorToMerge.getFilters().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getFilterMappings().size());
        FilterMapping mapping = (FilterMapping)descriptorBase.getFilterMappings().get(0);
        Assert.assertEquals((String)sname, (String)mapping.getFilterName());
        Assert.assertEquals((int)1, (int)mapping.getUrlPatterns().size());
        Assert.assertEquals((String)value, (String)((UrlPatternType)mapping.getUrlPatterns().get(0)).getValue());
    }

    public void testSingleFilterMappingSame() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Filter servletBase = WebFactory.eINSTANCE.createFilter();
        Filter servletMerge = WebFactory.eINSTANCE.createFilter();
        String sname = "servName";
        servletBase.setFilterName(sname);
        servletMerge.setFilterName(sname);
        FilterMapping FilterMappingBase = WebFactory.eINSTANCE.createFilterMapping();
        UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
        String value = "/1";
        urlPatternType.setValue(value);
        FilterMappingBase.setFilterName(sname);
        FilterMappingBase.getUrlPatterns().add(urlPatternType);
        descriptorToMerge.getFilterMappings().add(FilterMappingBase);
        descriptorBase.getFilterMappings().add(FilterMappingBase);
        descriptorBase.getFilters().add(servletBase);
        descriptorToMerge.getFilters().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getFilterMappings().size());
        FilterMapping mapping = (FilterMapping)descriptorBase.getFilterMappings().get(0);
        Assert.assertEquals((String)sname, (String)mapping.getFilterName());
        Assert.assertEquals((int)1, (int)mapping.getUrlPatterns().size());
        Assert.assertEquals((String)value, (String)((UrlPatternType)mapping.getUrlPatterns().get(0)).getValue());
    }

    public void testSingleFilterMappingAdditive() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Filter servletBase = WebFactory.eINSTANCE.createFilter();
        Filter servletMerge = WebFactory.eINSTANCE.createFilter();
        String sname = "servName";
        servletBase.setFilterName(sname);
        servletMerge.setFilterName(sname);
        String value = "/1";
        String value2 = "/2";
        UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
        urlPatternType.setValue(value);
        UrlPatternType urlPatternType2 = JavaeeFactory.eINSTANCE.createUrlPatternType();
        urlPatternType2.setValue(value2);
        FilterMapping filterMappingBase = WebFactory.eINSTANCE.createFilterMapping();
        FilterMapping filterMappingMerge = WebFactory.eINSTANCE.createFilterMapping();
        filterMappingBase.setFilterName(sname);
        filterMappingBase.getUrlPatterns().add(urlPatternType);
        filterMappingMerge.setFilterName(sname);
        filterMappingMerge.getUrlPatterns().add(urlPatternType2);
        descriptorBase.getFilterMappings().add(filterMappingBase);
        descriptorToMerge.getFilterMappings().add(filterMappingMerge);
        descriptorBase.getFilters().add(servletBase);
        descriptorToMerge.getFilters().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getFilterMappings().size());
        FilterMapping mapping = (FilterMapping)descriptorBase.getFilterMappings().get(0);
        Assert.assertEquals((String)sname, (String)mapping.getFilterName());
        Assert.assertEquals((int)2, (int)mapping.getUrlPatterns().size());
        Assert.assertEquals((String)value, (String)((UrlPatternType)mapping.getUrlPatterns().get(0)).getValue());
    }

    public void testSingleFilterMappingDifferentFilterName() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Filter servletBase = WebFactory.eINSTANCE.createFilter();
        Filter servletMerge = WebFactory.eINSTANCE.createFilter();
        String sname = "servName";
        String sname1 = "servName1";
        servletBase.setFilterName(sname);
        servletMerge.setFilterName(sname1);
        String value = "/1";
        String value2 = "/2";
        UrlPatternType urlPatternType = JavaeeFactory.eINSTANCE.createUrlPatternType();
        urlPatternType.setValue(value);
        UrlPatternType urlPatternType2 = JavaeeFactory.eINSTANCE.createUrlPatternType();
        urlPatternType2.setValue(value2);
        FilterMapping FilterMappingBase = WebFactory.eINSTANCE.createFilterMapping();
        FilterMapping FilterMappingMerge = WebFactory.eINSTANCE.createFilterMapping();
        FilterMappingBase.setFilterName(sname);
        FilterMappingBase.getUrlPatterns().add(urlPatternType);
        FilterMappingMerge.setFilterName(sname1);
        FilterMappingMerge.getUrlPatterns().add(urlPatternType2);
        descriptorBase.getFilterMappings().add(FilterMappingBase);
        descriptorToMerge.getFilterMappings().add(FilterMappingMerge);
        descriptorBase.getFilters().add(servletBase);
        descriptorToMerge.getFilters().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)2, (int)descriptorBase.getFilterMappings().size());
    }

    public void testSingleInitParamsInBase() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        String sname = "servName";
        servletBase.setServletName(sname);
        servletMerge.setServletName(sname);
        ParamValue initParamsType = JavaeeFactory.eINSTANCE.createParamValue();
        String value = "/1";
        initParamsType.setParamName(sname);
        initParamsType.setParamValue(value);
        servletBase.getInitParams().add(initParamsType);
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getServlets().size());
        Servlet rservlet = (Servlet)descriptorBase.getServlets().get(0);
        Assert.assertEquals((int)1, (int)rservlet.getInitParams().size());
        Assert.assertEquals((String)sname, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamName());
        Assert.assertEquals((String)value, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamValue());
    }

    public void testSingleInitParamsInToMerge() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        String sname = "servName";
        servletBase.setServletName(sname);
        servletMerge.setServletName(sname);
        ParamValue initParamsType = JavaeeFactory.eINSTANCE.createParamValue();
        String value = "/1";
        initParamsType.setParamName(sname);
        initParamsType.setParamValue(value);
        servletMerge.getInitParams().add(initParamsType);
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getServlets().size());
        Servlet rservlet = (Servlet)descriptorBase.getServlets().get(0);
        Assert.assertEquals((int)1, (int)rservlet.getInitParams().size());
        Assert.assertEquals((String)sname, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamName());
        Assert.assertEquals((String)value, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamValue());
    }

    public void testSingleInitParamsSame() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        String sname = "servName";
        servletBase.setServletName(sname);
        servletMerge.setServletName(sname);
        ParamValue initParamsType = JavaeeFactory.eINSTANCE.createParamValue();
        String value = "/1";
        initParamsType.setParamName(sname);
        initParamsType.setParamValue(value);
        servletBase.getInitParams().add(initParamsType);
        servletMerge.getInitParams().add(initParamsType);
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getServlets().size());
        Servlet rservlet = (Servlet)descriptorBase.getServlets().get(0);
        Assert.assertEquals((int)1, (int)rservlet.getInitParams().size());
        Assert.assertEquals((String)sname, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamName());
        Assert.assertEquals((String)value, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamValue());
    }

    public void testSingleInitParamsAdditive() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        String sname = "servName";
        servletBase.setServletName(sname);
        servletMerge.setServletName(sname);
        String value = "/1";
        String value2 = "/2";
        ParamValue initParamsType = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType.setParamName(sname);
        initParamsType.setParamValue(value);
        ParamValue initParamsType2 = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType2.setParamName(sname);
        initParamsType2.setParamValue(value2);
        servletBase.getInitParams().add(initParamsType);
        servletMerge.getInitParams().add(initParamsType2);
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getServlets().size());
        Servlet rservlet = (Servlet)descriptorBase.getServlets().get(0);
        Assert.assertEquals((int)1, (int)rservlet.getInitParams().size());
        Assert.assertEquals((String)sname, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamName());
        Assert.assertEquals((String)value2, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamValue());
    }

    public void testSingleInitParamsDifferentServletName() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Servlet servletBase = WebFactory.eINSTANCE.createServlet();
        Servlet servletMerge = WebFactory.eINSTANCE.createServlet();
        String sname = "servName";
        String sname2 = "servName2";
        servletBase.setServletName(sname);
        servletMerge.setServletName(sname);
        String value = "/1";
        String value2 = "/2";
        ParamValue initParamsType = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType.setParamName(sname);
        initParamsType.setParamValue(value);
        ParamValue initParamsType2 = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType2.setParamName(sname2);
        initParamsType2.setParamValue(value2);
        servletBase.getInitParams().add(initParamsType);
        servletMerge.getInitParams().add(initParamsType2);
        descriptorBase.getServlets().add(servletBase);
        descriptorToMerge.getServlets().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getServlets().size());
        Servlet rservlet = (Servlet)descriptorBase.getServlets().get(0);
        Assert.assertEquals((int)2, (int)rservlet.getInitParams().size());
    }

    public void testSingleFilterInitParamsInBase() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Filter servletBase = WebFactory.eINSTANCE.createFilter();
        Filter servletMerge = WebFactory.eINSTANCE.createFilter();
        String sname = "servName";
        servletBase.setFilterName(sname);
        servletMerge.setFilterName(sname);
        String value = "/1";
        ParamValue initParamsType = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType.setParamName(sname);
        initParamsType.setParamValue(value);
        ParamValue initParamsType2 = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType2.setParamName(sname);
        initParamsType2.setParamValue(value);
        servletBase.getInitParams().add(initParamsType);
        descriptorBase.getFilters().add(servletBase);
        descriptorToMerge.getFilters().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getFilters().size());
        Filter rservlet = (Filter)descriptorBase.getFilters().get(0);
        Assert.assertEquals((int)1, (int)rservlet.getInitParams().size());
        Assert.assertEquals((String)sname, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamName());
        Assert.assertEquals((String)value, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamValue());
    }

    public void testSingleFilterInitParamsInToMerge() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Filter servletBase = WebFactory.eINSTANCE.createFilter();
        Filter servletMerge = WebFactory.eINSTANCE.createFilter();
        String sname = "servName";
        servletBase.setFilterName(sname);
        servletMerge.setFilterName(sname);
        String value = "/1";
        ParamValue initParamsType = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType.setParamName(sname);
        initParamsType.setParamValue(value);
        ParamValue initParamsType2 = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType2.setParamName(sname);
        initParamsType2.setParamValue(value);
        servletMerge.getInitParams().add(initParamsType2);
        descriptorBase.getFilters().add(servletBase);
        descriptorToMerge.getFilters().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getFilters().size());
        Filter rservlet = (Filter)descriptorBase.getFilters().get(0);
        Assert.assertEquals((int)1, (int)rservlet.getInitParams().size());
        Assert.assertEquals((String)sname, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamName());
        Assert.assertEquals((String)value, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamValue());
    }

    public void testSingleFilterInitParamsSame() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Filter servletBase = WebFactory.eINSTANCE.createFilter();
        Filter servletMerge = WebFactory.eINSTANCE.createFilter();
        String sname = "servName";
        servletBase.setFilterName(sname);
        servletMerge.setFilterName(sname);
        String value = "/1";
        ParamValue initParamsType = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType.setParamName(sname);
        initParamsType.setParamValue(value);
        ParamValue initParamsType2 = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType2.setParamName(sname);
        initParamsType2.setParamValue(value);
        servletBase.getInitParams().add(initParamsType);
        servletMerge.getInitParams().add(initParamsType2);
        descriptorBase.getFilters().add(servletBase);
        descriptorToMerge.getFilters().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getFilters().size());
        Filter rservlet = (Filter)descriptorBase.getFilters().get(0);
        Assert.assertEquals((int)1, (int)rservlet.getInitParams().size());
        Assert.assertEquals((String)sname, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamName());
        Assert.assertEquals((String)value, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamValue());
    }

    public void testSingleFilterInitParamsAdditive() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Filter servletBase = WebFactory.eINSTANCE.createFilter();
        Filter servletMerge = WebFactory.eINSTANCE.createFilter();
        String sname = "servName";
        servletBase.setFilterName(sname);
        servletMerge.setFilterName(sname);
        String value = "/1";
        String value2 = "/2";
        ParamValue initParamsType = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType.setParamName(sname);
        initParamsType.setParamValue(value);
        ParamValue initParamsType2 = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType2.setParamName(sname);
        initParamsType2.setParamValue(value2);
        servletBase.getInitParams().add(initParamsType);
        servletMerge.getInitParams().add(initParamsType2);
        descriptorBase.getFilters().add(servletBase);
        descriptorToMerge.getFilters().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getFilters().size());
        Filter rservlet = (Filter)descriptorBase.getFilters().get(0);
        Assert.assertEquals((int)1, (int)rservlet.getInitParams().size());
        Assert.assertEquals((String)sname, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamName());
        Assert.assertEquals((String)value2, (String)((ParamValue)rservlet.getInitParams().get(0)).getParamValue());
    }

    public void testSingleFilterInitParamDifferentFilterName() throws ModelException {
        WebApp descriptorBase = WebFactory.eINSTANCE.createWebApp();
        WebApp descriptorToMerge = WebFactory.eINSTANCE.createWebApp();
        Filter servletBase = WebFactory.eINSTANCE.createFilter();
        Filter servletMerge = WebFactory.eINSTANCE.createFilter();
        String sname = "servName";
        servletBase.setFilterName(sname);
        servletMerge.setFilterName(sname);
        String value = "/1";
        String value2 = "/2";
        ParamValue initParamsType = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType.setParamName(sname);
        initParamsType.setParamValue(value);
        ParamValue initParamsType2 = JavaeeFactory.eINSTANCE.createParamValue();
        initParamsType2.setParamName(sname);
        initParamsType2.setParamValue(value2);
        servletBase.getInitParams().add(initParamsType);
        servletMerge.getInitParams().add(initParamsType2);
        descriptorBase.getFilters().add(servletBase);
        descriptorToMerge.getFilters().add(servletMerge);
        WebApp3Merger result = new WebApp3Merger((JavaEEObject)descriptorBase, (JavaEEObject)descriptorToMerge, 0);
        result.process();
        Assert.assertEquals((int)1, (int)descriptorBase.getFilters().size());
        Filter rservlet = (Filter)descriptorBase.getFilters().get(0);
        Assert.assertEquals((int)1, (int)rservlet.getInitParams().size());
    }
}

