/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.web.tests;

import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.javaee.core.RunAs;
import org.eclipse.jst.javaee.core.SecurityRole;
import org.eclipse.jst.javaee.core.SecurityRoleRef;
import org.eclipse.jst.javaee.web.Servlet;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jee.model.internal.WebAnnotationReader;
import org.eclipse.jst.jee.model.tests.AbstractAnnotationModelTest;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.TestUtils;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;

public class Web3AnnotationReaderTest
extends AbstractAnnotationModelTest {
    private static final String TEST_URL_VALUE = "/testUrl";
    private static final String SERVLET_WITH_URL = "ServletWithUrl";
    private static final String SERVLET_NO_ARGUMENTS = "ServletNoArguments";
    private static final String SERVLET_ANNOTATED_NAME = "ServletNameChange";
    private static String BEAN_WITH_NAME = "package com.sap;import javax.ejb.Stateless;@Stateless(name=\"%s\") public class BeanWithName implements SessionBeanLocal {}";
    private WebApp ddApp;

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite(Web3AnnotationReaderTest.class);
        return suite;
    }

    public static void setUpProject() throws Exception {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(Web3AnnotationReaderTest.class.getSimpleName());
        if (!project.exists()) {
            IFacetedProject facetedProject = AbstractTest.createWebProject(Web3AnnotationReaderTest.class.getSimpleName(), IJ2EEFacetConstants.DYNAMIC_WEB_30, JavaFacetUtils.JAVA_60);
            Web3AnnotationReaderTest.createProjectContent(facetedProject.getProject());
        }
    }

    public static void tearDownAfterClass() throws InterruptedException {
        AbstractTest.deleteProject(Web3AnnotationReaderTest.class.getSimpleName());
    }

    private static void createProjectContent(IProject project) throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder comFolder = javaProject.getProject().getFolder("src/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        IPackageFragment fragment = root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
        Web3AnnotationReaderTest.createServlet3(fragment, SERVLET_NO_ARGUMENTS, null, null);
        Web3AnnotationReaderTest.createServlet3(fragment, SERVLET_ANNOTATED_NAME, "test", null);
        Web3AnnotationReaderTest.createServlet3(fragment, SERVLET_WITH_URL, null, TEST_URL_VALUE);
        Web3AnnotationReaderTest.createServletWithSecurity(fragment);
    }

    private static void createServletWithSecurity(IPackageFragment fragment) throws Exception {
        IFile file = ((IContainer)fragment.getResource()).getFile((IPath)new Path("ServletWithSecurity.java"));
        AbstractTest.saveFile(file, "package com.sap;import javax.servlet.http.HttpServlet;@DeclareRoles(value = {\"role1\", \"role2\"})  public class ServletWithSecurity extends HttpServlet {}");
    }

    private static void createServlet3(IPackageFragment fragment, String className, String name, String urlPattern) throws Exception {
        String params = "";
        if (name != null) {
            params = "name=\"" + name + "\"";
        }
        if (urlPattern != null) {
            if (params.length() > 0) {
                params = String.valueOf(params) + ", ";
            }
            params = String.valueOf(params) + "urlPatterns=\"" + urlPattern + "\"";
        }
        if (params.length() > 0) {
            params = "(" + params + ")";
        }
        String content = "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;import javax.servlet.http.HttpServlet;@WebServlet" + params + " public class " + className + " extends HttpServlet {" + "private static final long serialVersionUID = 1L;" + "@EJB private Comparable comp; @EJB public void setComparable(Comparable comp){};" + "@Resource private Comparable comp2; @Resource public void setComparable2(Comparable comp){} }";
        IFile file = ((IContainer)fragment.getResource()).getFile((IPath)new Path(String.valueOf(className) + ".java"));
        AbstractTest.saveFile(file, content);
    }

    protected void setUp() throws Exception {
        Web3AnnotationReaderTest.setUpProject();
        super.setUp();
        this.ddApp = WebFactory.eINSTANCE.createWebApp();
        Web3AnnotationReaderTest.addServlet(this.ddApp, SERVLET_NO_ARGUMENTS, "com.sap.Servlet1");
        this.fixture = new WebAnnotationReader(this.facetedProject, this.ddApp);
    }

    protected void tearDown() throws Exception {
        ((WebAnnotationReader)this.fixture).dispose();
    }

    public void testAddDeleteEjbRef() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testAddDeleteEjbRef.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;import javax.servlet.http.HttpServlet;@WebServlet public class testAddDeleteEjbRef extends HttpServlet {private static final long serialVersionUID = 1L;@EJB private Comparable comp; @EJB public void setComparable(Comparable comp){};}");
        WebApp result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(8), (Object)new Integer(result.getEjbLocalRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(6), (Object)new Integer(result.getEjbLocalRefs().size()));
    }

    public void testNotAServletAddDeleteEjbRef() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testNotAServletAddDeleteEjbRef.java");
        AbstractTest.saveFile(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;import javax.servlet.http.HttpServlet;public class testNotAServletAddDeleteEjbRef {private static final long serialVersionUID = 1L;@EJB private Comparable comp; @EJB public void setComparable(Comparable comp){};}");
        WebApp result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(6), (Object)new Integer(result.getEjbLocalRefs().size()));
        AbstractTest.deleteFile(file);
        result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(6), (Object)new Integer(result.getEjbLocalRefs().size()));
    }

    public void testAddDeleteResourceRef() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testAddDeleteResourceRef.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;import javax.servlet.http.HttpServlet;@WebServlet public class testAddDeleteResourceRef extends HttpServlet {private static final long serialVersionUID = 1L;@Resource private Comparable comp2; @Resource public void setComparable2(Comparable comp){} }");
        WebApp result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(8), (Object)new Integer(result.getResourceRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(6), (Object)new Integer(result.getResourceRefs().size()));
    }

    public void testListener() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testListener.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;@WebListener public class testListener {@EJB private Comparable comp; @EJB public void setComparable(Comparable comp){};@Resource private Comparable comp2; @Resource public void setComparable2(Comparable comp){} }");
        WebApp result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(8), (Object)new Integer(result.getResourceRefs().size()));
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(8), (Object)new Integer(result.getEjbLocalRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(6), (Object)new Integer(result.getResourceRefs().size()));
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(6), (Object)new Integer(result.getEjbLocalRefs().size()));
    }

    public void testFilter() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testFilter.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;@WebFilter public class testFilter {@EJB private Comparable comp; @EJB public void setComparable(Comparable comp){};@Resource private Comparable comp2; @Resource public void setComparable2(Comparable comp){} }");
        WebApp result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(8), (Object)new Integer(result.getResourceRefs().size()));
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(8), (Object)new Integer(result.getEjbLocalRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(6), (Object)new Integer(result.getResourceRefs().size()));
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(6), (Object)new Integer(result.getEjbLocalRefs().size()));
    }

    public void testResourcesServlet() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testResourcesServlet.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;@Resources(value = {@Resource(name = \"withNotDefaults\", mappedName = \"mappedName\", \tshareable = false, type = java.lang.Comparable.class, \tauthenticationType = AuthenticationType.APPLICATION, description = \"description\"),@Resource(name = \"withDefaults\", type = java.lang.Comparable.class), @Resource(name = \"invalidNoType\") })@WebServlet public class testResourcesServlet {}");
        WebApp result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(8), (Object)new Integer(result.getResourceRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(6), (Object)new Integer(result.getResourceRefs().size()));
    }

    public void testResourcesFilter() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testResourcesFilter.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;@Resources(value = {@Resource(name = \"withNotDefaults\", mappedName = \"mappedName\", \tshareable = false, type = java.lang.Comparable.class, \tauthenticationType = AuthenticationType.APPLICATION, description = \"description\"),@Resource(name = \"withDefaults\", type = java.lang.Comparable.class), @Resource(name = \"invalidNoType\") })@WebFilter public class testResourcesFilter {}");
        WebApp result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(8), (Object)new Integer(result.getResourceRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(6), (Object)new Integer(result.getResourceRefs().size()));
    }

    public void testResourcesOnListener() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testResourcesOnListener.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;@Resources(value = {@Resource(name = \"withNotDefaults\", mappedName = \"mappedName\", \tshareable = false, type = java.lang.Comparable.class, \tauthenticationType = AuthenticationType.APPLICATION, description = \"description\"),@Resource(name = \"withDefaults\", type = java.lang.Comparable.class), @Resource(name = \"invalidNoType\") })@WebListener public class testResourcesOnListener {}");
        WebApp result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(8), (Object)new Integer(result.getResourceRefs().size()));
        this.deleteFileAndUpdate(file);
        result = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(6), (Object)new Integer(result.getResourceRefs().size()));
    }

    public void testDeclareRoles() throws Exception {
        IFile servletFile = this.facetedProject.getProject().getFile("src/com/sap/testDeclareRoles.java");
        this.saveFileAndUpdate(servletFile, "package com.sap;@DeclareRoles(value = {\"testDeclareRoles1\", \"testDeclareRoles1\"}) @WebServlet public class testDeclareRoles extends HttpServlet {}");
        WebApp app = (WebApp)this.fixture.getModelObject();
        Servlet result = TestUtils.findServletByName(app, "testDeclareRoles");
        Web3AnnotationReaderTest.assertNotNull((Object)result);
        SecurityRole role1 = TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoles1");
        SecurityRole role2 = TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoles1");
        Web3AnnotationReaderTest.assertNotNull((Object)role1);
        Web3AnnotationReaderTest.assertNotNull((Object)role2);
        SecurityRoleRef role1Ref = TestUtils.findSecurityRoleRef(result.getSecurityRoleRefs(), "testDeclareRoles1");
        Web3AnnotationReaderTest.assertNotNull((Object)role1Ref);
        SecurityRoleRef role2Ref = TestUtils.findSecurityRoleRef(result.getSecurityRoleRefs(), "testDeclareRoles1");
        Web3AnnotationReaderTest.assertNotNull((Object)role2Ref);
        this.deleteFileAndUpdate(servletFile);
        app = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertNull((Object)TestUtils.findServletByName(app, "testDeclareRoles"));
        Web3AnnotationReaderTest.assertNull((Object)TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoles1"));
        Web3AnnotationReaderTest.assertNull((Object)TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoles1"));
    }

    public void testDeclareRoleOnManyServlets() throws Exception {
        IFile bean1File = this.facetedProject.getProject().getFile("src/com/sap/testDeclareRoleOnManyServlets1.java");
        IFile bean2File = this.facetedProject.getProject().getFile("src/com/sap/testDeclareRoleOnManyServlets2.java");
        this.saveFileAndUpdate(bean1File, "package com.sap;@DeclareRoles(value = {\"testDeclareRoleOnManyBeansRole\"}) @WebServlet public class testDeclareRoleOnManyServlets1 implements SessionBeanLocal {}");
        this.saveFileAndUpdate(bean2File, "package com.sap;@DeclareRoles(value = {\"testDeclareRoleOnManyBeansRole\"}) @WebServlet public class testDeclareRoleOnManyServlets2 implements SessionBeanLocal {}");
        WebApp app = (WebApp)this.fixture.getModelObject();
        Servlet result = TestUtils.findServletByName(app, "testDeclareRoleOnManyServlets1");
        SecurityRole role1 = TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoleOnManyBeansRole");
        Web3AnnotationReaderTest.assertNotNull((Object)role1);
        SecurityRoleRef role1Ref = TestUtils.findSecurityRoleRef(result.getSecurityRoleRefs(), "testDeclareRoleOnManyBeansRole");
        Web3AnnotationReaderTest.assertNotNull((Object)role1Ref);
        this.deleteFileAndUpdate(bean1File);
        Web3AnnotationReaderTest.assertNotNull((Object)TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoleOnManyBeansRole"));
        this.deleteFileAndUpdate(bean2File);
        Web3AnnotationReaderTest.assertNull((Object)TestUtils.findSecurityRole(app.getSecurityRoles(), "testDeclareRoleOnManyBeansRole"));
    }

    public void testRunAs() throws Exception {
        IFile servletFile = this.facetedProject.getProject().getFile("src/com/sap/testRunAs.java");
        this.saveFileAndUpdate(servletFile, "package com.sap;@DeclareRoles(value = {\"testRunAsRole\"}) @RunAs(value = \"testRunAsRole\") @WebServlet public class testRunAs{}");
        WebApp app = (WebApp)this.fixture.getModelObject();
        Servlet result = TestUtils.findServletByName(app, "testRunAs");
        SecurityRole role1 = TestUtils.findSecurityRole(app.getSecurityRoles(), "testRunAsRole");
        Web3AnnotationReaderTest.assertNotNull((Object)role1);
        SecurityRoleRef role1Ref = TestUtils.findSecurityRoleRef(result.getSecurityRoleRefs(), "testRunAsRole");
        Web3AnnotationReaderTest.assertNotNull((Object)role1Ref);
        RunAs runAs = result.getRunAs();
        Web3AnnotationReaderTest.assertNotNull((Object)runAs);
        Web3AnnotationReaderTest.assertEquals((String)"testRunAsRole", (String)runAs.getRoleName());
        this.deleteFileAndUpdate(servletFile);
        Web3AnnotationReaderTest.assertNull((Object)TestUtils.findSecurityRole(((WebApp)this.fixture.getModelObject()).getSecurityRoles(), "testRunAsRole"));
    }

    public void testAddEjbRefToServlet() throws Exception {
        IFile file = this.facetedProject.getProject().getFile("src/com/sap/testAddEjbRefToServlet.java");
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;import javax.servlet.http.HttpServlet;@WebServlet public class testAddEjbRefToServlet extends HttpServlet {private static final long serialVersionUID = 1L;}");
        WebApp app = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(6), (Object)new Integer(app.getEjbLocalRefs().size()));
        this.saveFileAndUpdate(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;import javax.servlet.http.HttpServlet;@WebServlet public class testAddEjbRefToServlet extends HttpServlet {private static final long serialVersionUID = 1L;@EJB private Comparable comp; @EJB public void setComparable(Comparable comp){};}");
        app = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(8), (Object)new Integer(app.getEjbLocalRefs().size()));
        this.deleteFileAndUpdate(file);
        app = (WebApp)this.fixture.getModelObject();
        Web3AnnotationReaderTest.assertEquals((Object)new Integer(6), (Object)new Integer(app.getEjbLocalRefs().size()));
    }

    private static void addServlet(WebApp app, String servletName, String servletClass) {
        Servlet servlet = WebFactory.eINSTANCE.createServlet();
        servlet.setServletName(servletName);
        servlet.setServletClass(servletClass);
        app.getServlets().add(servlet);
    }
}

