/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ejb.verifiers;

import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyVerificationUtil;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.EarUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers.ModuleProjectCreationDataModelVerifier;

public class EJBProjectCreationDataModelVerifier
extends ModuleProjectCreationDataModelVerifier {
    public void verify(IDataModel model) throws Exception {
        super.verify(model);
        this.verifyClient();
    }

    protected void setFacetProjectType() {
        this.facetProjectType = "jst.ejb";
    }

    protected IFile getDDFile() {
        return this.component.getRootFolder().getFile("META-INF/ejb-jar.xml").getUnderlyingFile();
    }

    protected void verifyDD(Object modelObj) {
        String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)this.project);
        if (version.equals("3.0") || version.equals("3.1")) {
            EJBJar ejb = (EJBJar)modelObj;
            Assert.assertEquals((String)"Invalid project version", (String)version, (String)ejb.getVersion());
        } else {
            org.eclipse.jst.j2ee.ejb.EJBJar ejb = (org.eclipse.jst.j2ee.ejb.EJBJar)modelObj;
            Assert.assertEquals((String)"Invalid project version", (String)version, (String)ejb.getVersion());
        }
    }

    private void verifyClient() throws Exception {
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel(this.facetProjectType);
        boolean createClient = facetModel.getBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT");
        boolean addToEAR = this.model.getBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR");
        if (createClient && addToEAR) {
            String clientName = facetModel.getStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_NAME ");
            IProject clientProject = ProjectUtilities.getProject((String)clientName);
            Assert.assertTrue((String)"Client project should exist", (boolean)clientProject.exists());
            String earName = this.model.getStringProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME");
            IProject ear = ProjectUtilities.getProject((String)earName);
            boolean foundEARRefToClient = false;
            IVirtualReference[] refs = EarUtilities.getUtilityModuleReferences((IVirtualComponent)ComponentCore.createComponent((IProject)ear));
            IVirtualComponent clientComp = ComponentCore.createComponent((IProject)clientProject);
            int i = 0;
            while (i < refs.length) {
                IVirtualReference virtualReference = refs[i];
                if (virtualReference.getReferencedComponent().equals(clientComp)) {
                    foundEARRefToClient = true;
                }
                ++i;
            }
            Assert.assertTrue((String)"The created EAR should have a reference to the created EJB client project", (boolean)foundEARRefToClient);
            String ejbName = facetModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
            String ejbClientURI = facetModel.getStringProperty("IEjbFacetInstallDataModelProperties.CLIENT_URI ");
            IProject ejbProject = ProjectUtilities.getProject((String)ejbName);
            DependencyVerificationUtil.verifyManifestReference(ejbProject, ejbClientURI, true);
            String clientSourceFolderPath = facetModel.getStringProperty("IJ2EEFacetInstallDataModelProperties.CONFIG_FOLDER");
            IFolder clientSourceFolder = clientProject.getFolder(clientSourceFolderPath);
            Assert.assertTrue((String)"Client source folder should exist", (boolean)clientSourceFolder.exists());
        }
    }
}

