/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tets.appclient.verifiers;

import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.javaee.applicationclient.ApplicationClient;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers.ModuleProjectCreationDataModelVerifier;

public class AppClientProjectCreationDataModelVerifier
extends ModuleProjectCreationDataModelVerifier {
    public void verify(IDataModel model) throws Exception {
        super.verify(model);
        this.verifyMainClassField();
    }

    protected void setFacetProjectType() {
        this.facetProjectType = "jst.appclient";
    }

    protected IFile getDDFile() {
        return this.component.getRootFolder().getFile("META-INF/application-client.xml").getUnderlyingFile();
    }

    protected void verifyDD(Object modelObj) {
        String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)this.project);
        if (version.equals("5.0")) {
            ApplicationClient client = (ApplicationClient)modelObj;
            Assert.assertEquals((String)"Invalid project version", (String)"5", (String)client.getVersion());
        } else if (version.equals("6.0")) {
            ApplicationClient client = (ApplicationClient)modelObj;
            Assert.assertEquals((String)"Invalid project version", (String)"6", (String)client.getVersion());
        } else {
            org.eclipse.jst.j2ee.client.ApplicationClient client = (org.eclipse.jst.j2ee.client.ApplicationClient)modelObj;
            Assert.assertEquals((String)"Invalid project version", (String)version, (String)client.getVersion());
        }
    }

    private void verifyMainClassField() {
        IFacetProjectCreationDataModelProperties.FacetDataModelMap facetMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel facetModel = facetMap.getFacetDataModel("jst.appclient");
        boolean createDefaultClass = facetModel.getBooleanProperty("IAppClientComponentCreationDataModelProperties.CREATE_DEFAULT_MAIN_CLASS");
        if (createDefaultClass) {
            String projName = this.model.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
            ProjectUtilities.getProject((String)projName);
            IVirtualComponent appClient = ComponentUtilities.getComponent((String)projName);
            IVirtualFolder appClientRootFolder = appClient.getRootFolder();
            IVirtualFile vertMainClass = appClientRootFolder.getFile("Main.java");
            Assert.assertTrue((String)"Default main class Main.java should exist", (boolean)vertMainClass.exists());
        }
    }
}

