/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tets.ear.verifiers;

import java.util.List;
import junit.framework.Assert;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.javaee.application.Application;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers.JEEProjectCreationDataModelVerifier;

public class EARProjectCreationDataModelVerifier
extends JEEProjectCreationDataModelVerifier {
    public void verify(IDataModel model) throws Exception {
        super.verify(model);
        this.verifyContentDir();
        this.verifyProjectDependencies();
    }

    protected void setFacetProjectType() {
        this.facetProjectType = "jst.ear";
    }

    protected IFile getDDFile() {
        return this.component.getRootFolder().getFile("META-INF/application.xml").getUnderlyingFile();
    }

    protected void verifyDD(Object modelObj) {
        String version = J2EEProjectUtilities.getJ2EEProjectVersion((IProject)this.project);
        if (version.equals("5.0")) {
            Application ear = (Application)modelObj;
            Assert.assertEquals((String)"Invalid project version", (String)"5", (String)ear.getVersion());
        } else if (version.equals("6.0")) {
            Application ear = (Application)modelObj;
            Assert.assertEquals((String)"Invalid project version", (String)"6", (String)ear.getVersion());
        } else {
            org.eclipse.jst.j2ee.application.Application ear = (org.eclipse.jst.j2ee.application.Application)modelObj;
            Assert.assertEquals((String)"Invalid project version", (String)version, (String)ear.getVersion());
        }
    }

    private void verifyContentDir() {
        IFacetProjectCreationDataModelProperties.FacetDataModelMap factMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel earModel = (IDataModel)factMap.get((Object)"jst.ear");
        String contentDir = earModel.getStringProperty("IEarFacetInstallDataModelProperties.CONTENT_DIR");
        IFolder contentFolder = this.project.getFolder(contentDir);
        Assert.assertTrue((String)"Content directory should exist", (boolean)contentFolder.exists());
    }

    private void verifyProjectDependencies() throws Exception {
        int j;
        int i;
        IFacetProjectCreationDataModelProperties.FacetDataModelMap factMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel earModel = (IDataModel)factMap.get((Object)"jst.ear");
        List j2eeDependencies = (List)earModel.getProperty("IEarFacetInstallDataModelProperties.J2EE_PROJECTS_LIST");
        List javaDependencies = (List)earModel.getProperty("IEarFacetInstallDataModelProperties.JAVA_PROJECT_LIST");
        IProject[] referencedProjs = this.project.getReferencedProjects();
        boolean foundDependency = false;
        IProject dependencyProj = null;
        if (j2eeDependencies != null) {
            i = 0;
            while (i < j2eeDependencies.size()) {
                dependencyProj = (IProject)j2eeDependencies.get(i);
                j = 0;
                while (j < referencedProjs.length && !foundDependency) {
                    foundDependency = dependencyProj == referencedProjs[j];
                    ++j;
                }
                Assert.assertTrue((String)("EAR should have a referenced project " + dependencyProj.getName()), (boolean)foundDependency);
                ++i;
            }
        }
        if (javaDependencies != null) {
            i = 0;
            while (i < javaDependencies.size()) {
                dependencyProj = (IProject)javaDependencies.get(i);
                j = 0;
                while (j < referencedProjs.length && !foundDependency) {
                    foundDependency = dependencyProj == referencedProjs[j];
                    ++j;
                }
                Assert.assertTrue((String)("EAR should have a referenced project " + dependencyProj.getName()), (boolean)foundDependency);
                ++i;
            }
        }
    }
}

