/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.tests;

import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.internal.ServerPlugin;

public class ProjectPropertiesTestCase
extends TestCase {
    protected static IProject project;
    protected static ProjectProperties props;

    protected ProjectProperties getProjectProperties() throws Exception {
        if (props == null) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject("test");
            if (project != null && !project.exists()) {
                project.create(null);
                project.open(null);
            }
            props = ServerPlugin.getProjectProperties((IProject)project);
        }
        return props;
    }

    public static void addOrderedTests(TestSuite suite) {
        suite.addTest(TestSuite.createTest(ProjectPropertiesTestCase.class, (String)"deleteProject"));
    }

    public void testGetProperties() throws Exception {
        this.getProjectProperties();
    }

    public void testGetRuntime() throws Exception {
        ProjectPropertiesTestCase.assertNull((Object)this.getProjectProperties().getRuntimeTarget());
    }

    public void testGetServerProject() throws Exception {
        ProjectPropertiesTestCase.assertFalse((boolean)this.getProjectProperties().isServerProject());
    }

    public void testSetServerProject() throws Exception {
        this.getProjectProperties().setServerProject(true, null);
        ProjectPropertiesTestCase.assertTrue((boolean)this.getProjectProperties().isServerProject());
    }

    public void testUnsetServerProject() throws Exception {
        this.getProjectProperties().setServerProject(false, null);
        ProjectPropertiesTestCase.assertFalse((boolean)this.getProjectProperties().isServerProject());
    }

    public void deleteProject() throws Exception {
        if (project != null) {
            project.delete(true, true, null);
        }
    }
}

