/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.tests.ext;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.model.ServerDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerTestCase
extends TestCase {
    protected static IProject project;
    protected static ProjectProperties props;
    protected static IServer server;
    protected static IServerAttributes serverAttr;
    protected static IServerWorkingCopy serverWC;
    private static final PropertyChangeListener pcl;
    private static final IServerListener sl;

    static {
        pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent arg0) {
            }
        };
        sl = new IServerListener(){

            public void serverChanged(ServerEvent event) {
            }
        };
    }

    protected IServer getServer() throws Exception {
        if (server == null) {
            server = this.createServer();
            IServerWorkingCopy wc = server.createWorkingCopy();
            wc.saveAll(false, null);
        }
        return server;
    }

    protected IServerAttributes getServerAttributes() throws Exception {
        if (serverAttr == null) {
            serverAttr = this.getServer();
        }
        return serverAttr;
    }

    protected IServerWorkingCopy getServerWorkingCopy() throws Exception {
        if (serverWC == null) {
            serverWC = this.getServer().createWorkingCopy();
        }
        return serverWC;
    }

    public abstract IServer createServer() throws Exception;

    public abstract void deleteServer(IServer var1) throws Exception;

    public static void addOrderedTests(Class<? extends TestCase> testClass, TestSuite suite) {
        suite.addTest(TestSuite.createTest(testClass, (String)"serverPublish"));
        suite.addTest(TestSuite.createTest(testClass, (String)"serverCanRun"));
        suite.addTest(TestSuite.createTest(testClass, (String)"serverRun"));
        suite.addTest(TestSuite.createTest(testClass, (String)"serverCanStop"));
        suite.addTest(TestSuite.createTest(testClass, (String)"serverStop"));
        suite.addTest(TestSuite.createTest(testClass, (String)"serverCanDebug"));
        suite.addTest(TestSuite.createTest(testClass, (String)"serverDebug"));
        suite.addTest(TestSuite.createTest(testClass, (String)"serverCanStop2"));
        suite.addTest(TestSuite.createTest(testClass, (String)"serverStop2"));
        suite.addTest(TestSuite.createTest(testClass, (String)"deleteProject"));
    }

    public static void addFinalTests(Class<? extends TestCase> testClass, TestSuite suite) {
        suite.addTest(TestSuite.createTest(testClass, (String)"clearWorkingCopy"));
        suite.addTest(TestSuite.createTest(testClass, (String)"deleteServer"));
    }

    public void testGetProperties() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("test");
        if (project != null && !project.exists()) {
            project.create(null);
            project.open(null);
        }
        props = ServerPlugin.getProjectProperties((IProject)project);
    }

    public void deleteProject() throws Exception {
        if (project != null) {
            project.delete(true, true, null);
        }
    }

    public void testServerGetDelegate() throws Exception {
        this.getServer().getAdapter(ServerDelegate.class);
    }

    public void testServerLoadDelegate() throws Exception {
        this.getServer().loadAdapter(ServerDelegate.class, null);
    }

    public void testServerAttributesGetDelegate() throws Exception {
        this.getServerAttributes().getAdapter(ServerDelegate.class);
    }

    public void testServerAttributesLoadDelegate() throws Exception {
        this.getServerAttributes().loadAdapter(ServerDelegate.class, null);
    }

    public void testServerGetBehaviourDelegate() throws Exception {
        this.getServer().getAdapter(ServerBehaviourDelegate.class);
    }

    public void serverPublish() throws Exception {
        this.getServer().publish(2, null);
    }

    public void serverCanRun() throws Exception {
        AbstractServerTestCase.assertTrue((boolean)this.getServer().canStart("run").isOK());
    }

    public void serverRun() throws Exception {
        this.getServer().synchronousStart("run", null);
    }

    public void serverCanStop() throws Exception {
        AbstractServerTestCase.assertTrue((boolean)this.getServer().canStop().isOK());
    }

    public void serverStop() throws Exception {
        this.getServer().synchronousStop(false);
    }

    public void serverCanDebug() throws Exception {
        AbstractServerTestCase.assertTrue((boolean)this.getServer().canStart("debug").isOK());
    }

    public void serverDebug() throws Exception {
        this.getServer().synchronousStart("debug", null);
    }

    public void serverCanStop2() throws Exception {
        AbstractServerTestCase.assertTrue((boolean)this.getServer().canStop().isOK());
    }

    public void serverStop2() throws Exception {
        this.getServer().synchronousStop(false);
    }

    public void testGetServerPorts() {
        ServerPort[] ports = server.getServerPorts(null);
        if (ports != null) {
            ServerPort[] serverPortArray = ports;
            int n = ports.length;
            int n2 = 0;
            while (n2 < n) {
                ServerPort port = serverPortArray[n2];
                port.getId();
                port.getContentTypes();
                port.getName();
                port.getPort();
                port.getProtocol();
                port.isAdvanced();
                port.toString();
                port.equals(null);
                port.hashCode();
                ++n2;
            }
        }
    }

    public void testGetServerState() throws Exception {
        this.getServer().getServerState();
    }

    public void testGetServerPublishState() throws Exception {
        this.getServer().getServerPublishState();
    }

    public void testGetServerRestartState() throws Exception {
        this.getServer().getServerRestartState();
    }

    public void testGetModuleState() {
        try {
            this.getServer().getModuleState(null);
        }
        catch (Exception exception) {}
    }

    public void testGetModulePublishState() {
        try {
            this.getServer().getModulePublishState(null);
        }
        catch (Exception exception) {}
    }

    public void testGetModuleRestartState() {
        try {
            this.getServer().getModuleRestartState(null);
        }
        catch (Exception exception) {}
    }

    public void testGetMode() throws Exception {
        this.getServer().getMode();
    }

    public void testCanPublish() throws Exception {
        this.getServer().canPublish();
    }

    public void testCanRestart() throws Exception {
        this.getServer().canRestart("run");
    }

    public void testCanControlModule() {
        try {
            this.getServer().canControlModule(null, null);
        }
        catch (Exception exception) {}
    }

    public void testAddServerListener() throws Exception {
        this.getServer().addServerListener(sl);
    }

    public void testAddServerListener2() throws Exception {
        this.getServer().addServerListener(sl, 0);
    }

    public void testRemoveServerListener() throws Exception {
        this.getServer().removeServerListener(sl);
    }

    public void testGetName() throws Exception {
        this.getServerAttributes().getName();
    }

    public void testGetId() throws Exception {
        this.getServerAttributes().getId();
    }

    public void testIsReadOnly() throws Exception {
        this.getServerAttributes().isReadOnly();
    }

    public void testIsWorkingCopy() throws Exception {
        this.getServerAttributes().isWorkingCopy();
    }

    public void testGetHost() throws Exception {
        this.getServerAttributes().getHost();
    }

    public void testGetRuntime() throws Exception {
        this.getServerAttributes().getRuntime();
    }

    public void testGetServerType() throws Exception {
        this.getServerAttributes().getServerType();
    }

    public void testGetServerConfiguration() throws Exception {
        this.getServerAttributes().getServerConfiguration();
    }

    public void testCreateWorkingCopy() throws Exception {
        this.getServerAttributes().createWorkingCopy();
    }

    public void testGetModules() throws Exception {
        this.getServerAttributes().getModules();
    }

    public void testCanModifyModules() {
        try {
            this.getServerAttributes().canModifyModules(null, null, null);
        }
        catch (Exception exception) {}
    }

    public void testGetChildModules() {
        try {
            this.getServerAttributes().getChildModules(null, null);
        }
        catch (Exception exception) {}
    }

    public void testGetRootModules() {
        try {
            this.getServerAttributes().getRootModules(null, null);
        }
        catch (Exception exception) {}
    }

    public void testGetServerPorts2() throws Exception {
        this.getServerAttributes().getServerPorts(null);
    }

    public void testServerAttributesDelete() {
        try {
            IServerWorkingCopy sa = this.getServerAttributes().createWorkingCopy();
            sa.delete();
        }
        catch (Exception exception) {}
    }

    public void testIsDirty() throws Exception {
        AbstractServerTestCase.assertFalse((boolean)this.getServerWorkingCopy().isDirty());
    }

    public void testSetName() throws Exception {
        this.getServerWorkingCopy().setName("test");
    }

    public void testSetHost() throws Exception {
        this.getServerWorkingCopy().setHost("www.eclipse.org");
    }

    public void testSetReadOnly() throws Exception {
        this.getServerWorkingCopy().setReadOnly(true);
    }

    public void testServerWCIsDirty() throws Exception {
        AbstractServerTestCase.assertTrue((boolean)this.getServerWorkingCopy().isDirty());
    }

    public void testPropertyChangeListener() throws Exception {
        this.getServerWorkingCopy().addPropertyChangeListener(pcl);
        this.getServerWorkingCopy().removePropertyChangeListener(pcl);
    }

    public void testGetOriginal() throws Exception {
        this.getServerWorkingCopy().getOriginal();
    }

    public void testSetServerConfiguration() throws Exception {
        this.getServerWorkingCopy().setServerConfiguration(null);
    }

    public void testModifyModules() {
        try {
            this.getServerWorkingCopy().modifyModules(null, null, null);
        }
        catch (Exception exception) {}
    }

    public void clearWorkingCopy() {
        serverAttr = null;
        serverWC = null;
    }

    public void deleteServer() throws Exception {
        this.deleteServer(this.getServer());
        server = null;
    }
}

