/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.tests.updated;

import java.util.List;
import java.util.Locale;
import junit.framework.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper2;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.traittypes.traittypes.ListOfValues;
import org.eclipse.jst.jsf.test.util.ConfigurableTestCase;

public class TraitValueHelperTests
extends ConfigurableTestCase {
    private final String uri = "http://org.eclipse.jsf/traithelpertest";
    private Entity entity;
    private Entity nlsEntity;
    private ITaglibDomainMetaDataQuery _query;
    private TraitValueHelper2 _helper;

    protected void setUp() throws Exception {
        super.setUp();
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(null);
        this._query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        this.entity = this._query.getQueryHelper().getEntity("http://org.eclipse.jsf/traithelpertest", "tag/attr1");
        Assert.assertNotNull((Object)this.entity);
        this.nlsEntity = this._query.getQueryHelper().getEntity("http://org.eclipse.jsf/traithelpertest", "NLS/NLS");
        Assert.assertNotNull((Object)this.nlsEntity);
        this._helper = new TraitValueHelper2();
    }

    public void testGetValueType() {
        Trait trait = this._query.getQueryHelper().getTrait(this.entity, "singleString");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"AnyType", (String)this._helper.getValueType(trait).getName());
        trait = this._query.getQueryHelper().getTrait(this.entity, "anInteger");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"AnyType", (String)this._helper.getValueType(trait).getName());
        trait = this._query.getQueryHelper().getTrait(this.entity, "multivalStrings");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"ListOfValues", (String)this._helper.getValueType(trait).getName());
        trait = this._query.getQueryHelper().getTrait(this.entity, "multivalIntegers");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"ListOfValues", (String)this._helper.getValueType(trait).getName());
        Assert.assertNull((Object)this._helper.getValueType(null));
        EObject val = trait.getValue();
        trait.setValue(null);
        Assert.assertNull((Object)this._helper.getValueType(trait));
        trait.setValue(val);
        trait = this._query.getQueryHelper().getTrait(this.entity, "NullVal");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"AnyType", (String)this._helper.getValueType(trait).getName());
    }

    public void testGetValue() {
        Trait trait = this._query.getQueryHelper().getTrait(this.entity, "singleString");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"AString", (String)((String)this._helper.getValue(trait)));
        trait = this._query.getQueryHelper().getTrait(this.entity, "anInteger");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((int)1, (int)Integer.parseInt((String)this._helper.getValue(trait)));
        trait = this._query.getQueryHelper().getTrait(this.entity, "aTrueInt");
        Assert.assertNotNull((Object)trait);
        Assert.assertNotNull((Object)trait.getValue());
        Assert.assertTrue((boolean)(trait.getValue() instanceof SimpleAnyType));
        Assert.assertTrue((boolean)((SimpleAnyType)trait.getValue()).getInstanceType().getInstanceClassName().equals("int"));
        Assert.assertEquals((Object)"1", (Object)this._helper.getValue(trait));
        Assert.assertNull((Object)this._helper.getValue(null));
        EObject val = trait.getValue();
        trait.setValue(null);
        Assert.assertNull((Object)this._helper.getValue(trait));
        trait.setValue(val);
        trait = this._query.getQueryHelper().getTrait(this.entity, "NullVal");
        Assert.assertNotNull((Object)trait);
        Assert.assertNull((Object)this._helper.getValue(trait));
    }

    public void testGetValueAsString() {
        Trait trait = this._query.getQueryHelper().getTrait(this.entity, "singleString");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"AString", (String)this._helper.getValueAsString(trait));
        trait = this._query.getQueryHelper().getTrait(this.entity, "anInteger");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((String)"1", (String)this._helper.getValueAsString(trait));
        Assert.assertNull((Object)this._helper.getValue(null));
        EObject val = trait.getValue();
        trait.setValue(null);
        Assert.assertNull((Object)this._helper.getValue(trait));
        trait.setValue(val);
        trait = this._query.getQueryHelper().getTrait(this.entity, "NullVal");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals(null, (String)this._helper.getValueAsString(trait));
    }

    public void testGetValueAsListOfStrings() {
        Trait trait = this._query.getQueryHelper().getTrait(this.entity, "multivalStrings");
        Assert.assertNotNull((Object)trait);
        Assert.assertTrue((boolean)(this._helper.getValueAsListOfStrings(trait) instanceof List));
        List vals = this._helper.getValueAsListOfStrings(trait);
        Assert.assertEquals((int)3, (int)vals.size());
        Assert.assertTrue((boolean)(vals.get(0) instanceof String));
        Assert.assertEquals((String)"A", (String)((String)vals.get(0)));
        Assert.assertEquals((String)"B", (String)((String)vals.get(1)));
        Assert.assertEquals((String)"C", (String)((String)vals.get(2)));
        trait = this._query.getQueryHelper().getTrait(this.entity, "multivalIntegers");
        Assert.assertNotNull((Object)trait);
        Assert.assertTrue((boolean)(this._helper.getValueAsListOfStrings(trait) instanceof List));
        vals = this._helper.getValueAsListOfStrings(trait);
        Assert.assertEquals((int)3, (int)vals.size());
        Assert.assertTrue((boolean)(vals.get(0) instanceof String));
        Assert.assertEquals((String)"1", (String)((String)vals.get(0)));
        Assert.assertEquals((String)"2", (String)((String)vals.get(1)));
        Assert.assertEquals((String)"3", (String)((String)vals.get(2)));
    }

    public void testGetNLSValue() {
        Trait trait = this._query.getQueryHelper().getTrait(this.nlsEntity, "NLS");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals((Object)"%NLS1", (Object)this._helper.getValue(trait));
        if (Locale.getDefault().getCountry().equalsIgnoreCase("us") && Locale.getDefault().getLanguage().equalsIgnoreCase("en")) {
            Assert.assertEquals((String)"a day in the life(en_US)", (String)this._helper.getValueAsString(trait));
        }
        trait = this._query.getQueryHelper().getTrait(this.nlsEntity, "multivalNLS");
        Assert.assertNotNull((Object)trait);
        Assert.assertNotNull((Object)trait.getValue());
        Assert.assertTrue((boolean)(trait.getValue() instanceof ListOfValues));
        List vals = this._helper.getValueAsListOfStrings(trait);
        Assert.assertEquals((int)2, (int)vals.size());
        if (Locale.getDefault().getCountry().equalsIgnoreCase("us") && Locale.getDefault().getLanguage().equalsIgnoreCase("en")) {
            Assert.assertEquals((Object)"a day in the life(en_US)", vals.get(0));
            Assert.assertEquals((Object)"another string(en_US)", vals.get(1));
        }
        trait = this._query.getQueryHelper().getTrait(this.entity, "NullVal");
        Assert.assertNotNull((Object)trait);
        Assert.assertEquals(null, (String)this._helper.getValueAsString(trait));
    }

    public void testGetValueAsBoolean() {
        Trait trait = this._query.getQueryHelper().getTrait(this.entity, "BooleanVal");
        Assert.assertNotNull((Object)trait);
        Assert.assertNotNull((Object)trait.getValue());
        Assert.assertEquals((boolean)true, (boolean)this._helper.getValueAsBoolean(trait));
        trait = this._query.getQueryHelper().getTrait(this.entity, "NullBooleanVal");
        Assert.assertNotNull((Object)trait);
        Assert.assertNotNull((Object)trait.getValue());
        Assert.assertEquals((boolean)false, (boolean)this._helper.getValueAsBoolean(trait));
    }

    public void testStringValueType() {
        Model m = this._query.getQueryHelper().getModel("http://org.eclipse.jsf/traithelpertest");
        TraitValueHelperTests.assertNotNull((Object)m);
        Trait t = this._query.getQueryHelper().getTrait((Entity)m, "TraitId");
        TraitValueHelperTests.assertNotNull((Object)t);
        EObject obj = t.getValue();
        TraitValueHelperTests.assertEquals((String)"StringValue", (String)obj.eClass().getName());
        TraitValueHelperTests.assertEquals((String)"TraitValue", (String)this._helper.getValueAsString(t));
    }

    public void testBooleanValueType() {
        Model m = this._query.getQueryHelper().getModel("http://org.eclipse.jsf/traithelpertest");
        TraitValueHelperTests.assertNotNull((Object)m);
        Trait t2 = this._query.getQueryHelper().getTrait((Entity)m, "TraitId2");
        TraitValueHelperTests.assertNotNull((Object)t2);
        EObject obj2 = t2.getValue();
        TraitValueHelperTests.assertEquals((String)"BooleanValue", (String)obj2.eClass().getName());
        TraitValueHelperTests.assertEquals((boolean)true, (boolean)this._helper.getValueAsBoolean(t2));
        TraitValueHelperTests.assertEquals((String)"true", (String)this._helper.getValueAsString(t2));
        Trait t3 = this._query.getQueryHelper().getTrait((Entity)m, "TraitId3");
        TraitValueHelperTests.assertNotNull((Object)t3);
        EObject obj3 = t3.getValue();
        TraitValueHelperTests.assertEquals((String)"BooleanValue", (String)obj3.eClass().getName());
        TraitValueHelperTests.assertEquals((boolean)false, (boolean)this._helper.getValueAsBoolean(t3));
    }
}

