/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadata.tests.taglibprocessing;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.query.IResultSet;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainEntityPredicateMatcher;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainPredicateMatcherFactory;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.metadata.tests.util.IJSFRuntimeRequiredV11;
import org.eclipse.jst.jsf.metadata.tests.util.JSPTestCase;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfo;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfos;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.TagCreationInfo;
import org.eclipse.jst.jsf.test.util.mock.MockProject;
import org.eclipse.jst.jsf.test.util.mock.MockWorkspaceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFHTMLTestCase
extends JSPTestCase
implements IJSFRuntimeRequiredV11 {
    private String _uri;
    private ITaglibDomainMetaDataModelContext _context;
    private static final boolean DEBUG = false;

    public JSFHTMLTestCase() {
        super(JSFVersion.V1_1, "/testfiles/web/faces-config_1_1.xml.data");
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this._uri = "http://java.sun.com/jsf/html";
        this._context = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)this._testEnv.getTestProject(), (String)this._uri);
    }

    public void testPaletteInfos() {
        Model model = TaglibDomainMetaDataQueryHelper.getModel((ITaglibDomainMetaDataModelContext)this._context);
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((Entity)model, (String)"paletteInfos");
        JSFHTMLTestCase.assertNotNull((Object)trait);
        JSFHTMLTestCase.assertTrue((boolean)(trait.getValue() instanceof PaletteInfos));
        PaletteInfos pis = (PaletteInfos)trait.getValue();
        PaletteInfo cmdBtn = pis.findPaletteInfoById("commandButton");
        JSFHTMLTestCase.assertNotNull((Object)cmdBtn);
        JSFHTMLTestCase.assertEquals((String)"Command Button", (String)cmdBtn.getDisplayLabel());
        PaletteInfo info = pis.findPaletteInfoById("inputText");
        JSFHTMLTestCase.assertNotNull((Object)info);
        JSFHTMLTestCase.assertNotNull((Object)info.getDisplayLabel());
        JSFHTMLTestCase.assertNotNull((Object)info.getDescription());
        JSFHTMLTestCase.assertNull((Object)info.getExpert());
        JSFHTMLTestCase.assertNull((Object)info.getHidden());
        JSFHTMLTestCase.assertFalse((boolean)info.isExpert());
        JSFHTMLTestCase.assertFalse((boolean)info.isHidden());
        JSFHTMLTestCase.assertNotNull((Object)info.getSmallIcon());
        JSFHTMLTestCase.assertNotNull((Object)info.getLargeIcon());
    }

    public void testCreateInfos() {
        Trait trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)this._context, (String)"dataTable", (String)"tag-create");
        JSFHTMLTestCase.assertNotNull((Object)trait);
        JSFHTMLTestCase.assertTrue((boolean)(trait.getValue() instanceof TagCreationInfo));
        TagCreationInfo tci = (TagCreationInfo)trait.getValue();
        Object template = tci.getTemplate();
        JSFHTMLTestCase.assertNotNull((Object)template);
        JSFHTMLTestCase.assertTrue((boolean)(template instanceof String));
        trait = TaglibDomainMetaDataQueryHelper.getTrait((ITaglibDomainMetaDataModelContext)this._context, (String)"commandLink", (String)"tag-create");
        JSFHTMLTestCase.assertNotNull((Object)trait);
        JSFHTMLTestCase.assertTrue((boolean)(trait.getValue() instanceof TagCreationInfo));
        tci = (TagCreationInfo)trait.getValue();
        JSFHTMLTestCase.assertNotNull((Object)tci.getAttributes());
        JSFHTMLTestCase.assertNotNull((Object)tci.getTemplate());
        JSFHTMLTestCase.assertEquals((int)0, (int)tci.getAttributes().size());
    }

    public void testQuery() throws Exception {
        MockProject project = new MockWorkspaceContext().createProject("test");
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext((IProject)project);
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        Model tagLib = query.findTagLibraryModel(this._uri);
        JSFHTMLTestCase.assertNotNull((Object)tagLib);
        Entity tag = query.findTagEntity(tagLib, "commandButton");
        JSFHTMLTestCase.assertNotNull((Object)tag);
        Entity tagAttr = query.findTagAttributeEntity(tag, "value");
        JSFHTMLTestCase.assertNotNull((Object)tagAttr);
        Trait trait1 = query.findTrait((Entity)tagLib, "paletteInfos");
        JSFHTMLTestCase.assertNotNull((Object)trait1);
        Trait trait2 = query.findTrait(tag, "small-icon");
        JSFHTMLTestCase.assertNotNull((Object)trait2);
        Trait trait3 = query.findTrait(tagAttr, "attribute-value-runtime-type");
        JSFHTMLTestCase.assertNotNull((Object)trait3);
        ITaglibDomainPredicateMatcherFactory factory = MetaDataQueryContextFactory.getInstance().getTaglibDomainPredicateMatcherFactory();
        ITaglibDomainEntityPredicateMatcher entityMatcher = factory.createTagEntityMatcher(this._uri, "^[cC].*");
        IResultSet tags = query.findEntities(entityMatcher);
        JSFHTMLTestCase.assertNotNull((Object)tags.getResults());
        JSFHTMLTestCase.assertEquals((int)3, (int)tags.getResults().size());
        this.dumpEntities(tags.getResults(), "All tags beginning with c (case-insensitive)");
    }

    private void dumpEntities(List<Entity> tags, String title) throws Exception {
    }

    private void printHeader(String title) {
        System.out.println();
        System.out.println(title);
        this.printSeparator();
    }

    private void printFooter(int size) {
        this.printSeparator();
        System.out.println("Size: " + size);
        System.out.println();
    }

    private void printSeparator() {
        System.out.println("--------------------------------------------------------");
    }
}

