/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadata.tests.util;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.ITextRegionContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.util.JSFCoreUtilHelper;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.metadata.tests.MetadataTestsPlugin;
import org.eclipse.jst.jsf.metadata.tests.util.BaseTestCase;
import org.eclipse.jst.jsf.metadata.tests.util.NoJSFRuntimeFoundException;
import org.eclipse.jst.jsf.test.util.ConfigurableTestCase;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class JSPTestCase
extends BaseTestCase {
    public static final String FACES_CONFIG_FILE = "facesConfigFile";
    public static final String JSF_CORE_URI = "http://java.sun.com/jsf/core";
    public static final String JSF_HTML_URI = "http://java.sun.com/jsf/html";
    public static final String TAG_TEST_URI = "http://org.eclipse.jsf/tagprocessing";
    public static final String TAG_TEST_TAG = "MyTag";
    private MyConfiguration _myConfig;
    private final JSFVersion _defaultJSFVersion;
    private final String _defaultFacesConfigFile;
    private String[] _runtimeJars;

    public JSPTestCase(JSFVersion defaultJSFVersion, String defaultFacesConfigFile) {
        super(defaultJSFVersion);
        this._defaultJSFVersion = defaultJSFVersion;
        this._defaultFacesConfigFile = defaultFacesConfigFile;
    }

    protected void doStandaloneSetup() {
        super.doStandaloneSetup();
        this._myConfig = new MyConfiguration(this._defaultJSFVersion, this._defaultFacesConfigFile);
    }

    protected void doTestSuiteSetup() {
        super.doTestSuiteSetup();
        this._myConfig = new MyConfiguration(this._testConfiguration);
    }

    protected JSFFacetedTestEnvironment configureJSFEnvironment() throws Exception {
        JSFVersion version = this._myConfig.getFacetVersion();
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize(version.toString());
        try {
            this.initializeJSFRuntime();
            JSFCoreUtilHelper.createRegistryAndAddReferences((JSFFacetedTestEnvironment)jsfFacedEnv, (String[])this._runtimeJars, (JSFVersion)version);
        }
        catch (NoJSFRuntimeFoundException noJSFRuntimeFoundException) {}
        this._testEnv.loadResourceInWebRoot(MetadataTestsPlugin.getDefault().getBundle(), this._myConfig.getFacesConfigFile(), "/WEB-INF/faces-config.xml");
        return jsfFacedEnv;
    }

    protected IFile loadJSP(String srcFileName, String destFileName) throws Exception {
        return (IFile)this._testEnv.loadResourceInWebRoot(MetadataTestsPlugin.getDefault().getBundle(), srcFileName, destFileName);
    }

    protected String getText(IStructuredDocument document, int docPos) {
        IStructuredDocumentContext context = this.getStructuredDocumentContext(document, docPos);
        ITextRegionContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTextRegionResolver(context);
        return this.stripQuotes(resolver.getRegionText());
    }

    protected IStructuredDocumentContext getStructuredDocumentContext(IStructuredDocument document, int docPos) {
        return IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)document, docPos);
    }

    private String stripQuotes(String text) {
        if (text != null && text.startsWith("\"")) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    protected void initializeJSFRuntime() throws NoJSFRuntimeFoundException {
        String dir = JSFCoreUtilHelper.getJSFRuntimeJarsDirectory((JSFVersion)this._defaultJSFVersion);
        if (dir == null || !this.jarsFound(dir)) {
            throw new NoJSFRuntimeFoundException();
        }
    }

    private boolean jarsFound(String dir) {
        File[] files;
        File dirFile = new File(dir);
        if (dirFile.exists() && dirFile.isDirectory() && (files = dirFile.listFiles()).length > 0) {
            this._runtimeJars = new String[files.length];
            int i = 0;
            while (i < files.length) {
                this._runtimeJars[i] = files[i].getAbsolutePath();
                ++i;
            }
            return true;
        }
        return false;
    }

    protected static class MyConfiguration {
        private final JSFVersion _facetVersion;
        private final String _facesConfigFile;

        MyConfiguration(JSFVersion facetVersion, String facesConfigFile) {
            this._facetVersion = facetVersion;
            this._facesConfigFile = facesConfigFile;
        }

        MyConfiguration(ConfigurableTestCase.TestConfiguration testConfiguration) {
            this._facetVersion = JSFVersion.valueOfString((String)((String)testConfiguration.get((Object)"jsfFacetVersion")));
            this._facesConfigFile = (String)testConfiguration.get((Object)JSPTestCase.FACES_CONFIG_FILE);
        }

        public JSFVersion getFacetVersion() {
            return this._facetVersion;
        }

        public String getFacesConfigFile() {
            return this._facesConfigFile;
        }
    }
}

