/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.beaninfo;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.internal.beaninfo.MethodProxy;
import org.eclipse.jem.internal.beaninfo.PropertyDecorator;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.tests.JavaTestsPlugin;
import org.eclipse.jem.tests.beaninfo.AbstractBeanInfoTestCase;

public class TestAWTSwingUI
extends AbstractBeanInfoTestCase {
    public TestAWTSwingUI() {
    }

    public TestAWTSwingUI(String name) {
        super(name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set getNames(String filename) throws IOException {
        HashSet<String> names = new HashSet<String>(50);
        URL url = JavaTestsPlugin.getPlugin().getBundle().getEntry(filename);
        TestAWTSwingUI.assertNotNull((Object)url);
        BufferedReader rdr = new BufferedReader(new InputStreamReader(url.openStream()));
        try {
            String line = null;
            while ((line = rdr.readLine()) != null) {
                names.add(line);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            rdr.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        rdr.close();
        return names;
    }

    protected void testIncludesAllNames(String id, List testNames, Set againstSet, Set exclude) {
        HashSet workingAgainst = new HashSet(againstSet.size());
        workingAgainst.addAll(againstSet);
        boolean wroteAny = false;
        Iterator itr = testNames.iterator();
        while (itr.hasNext()) {
            ENamedElement testName = (ENamedElement)itr.next();
            if (exclude.contains(testName)) continue;
            if (againstSet.contains(testName.getName())) {
                workingAgainst.remove(testName.getName());
                continue;
            }
            if (!wroteAny) {
                wroteAny = true;
                System.out.println("Names in list that are new for " + id + ':');
            }
            System.out.print("  ");
            System.out.println(testName.getName());
        }
        if (wroteAny) {
            System.out.println("End of new names.");
        }
        if (!workingAgainst.isEmpty()) {
            System.out.println("Names that should of been found, but weren't for " + id + ':');
            itr = workingAgainst.iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                System.out.print("  ");
                System.out.println(name);
            }
            System.out.println("End of missing names");
            TestAWTSwingUI.fail((String)("Missing some required names for " + id + '.'));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeNames(String filename, List props, Set excluding) throws FileNotFoundException {
        PrintWriter pr = new PrintWriter(new FileOutputStream(filename));
        try {
            Iterator itr = props.iterator();
            while (itr.hasNext()) {
                ENamedElement element = (ENamedElement)itr.next();
                if (excluding != null && excluding.contains(element)) continue;
                pr.println(element.getName());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            pr.close();
            throw throwable;
        }
        {
            Object var7_9 = null;
            pr.close();
            return;
        }
    }

    protected void reflectHierachy(JavaClass jclass) {
        JavaClass loopClass = jclass;
        while (loopClass != null) {
            System.out.println("Reflecting for " + loopClass.getQualifiedName());
            loopClass.isFinal();
            loopClass = loopClass.getSupertype();
        }
    }

    protected void showSortedOperations(JavaClass jclass) {
        EList allB = jclass.getEAllOperations();
        Object[] names = new String[allB.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = ((MethodProxy)allB.get(i)).getMethod().getMethodElementSignature();
            ++i;
        }
        Arrays.sort(names);
        System.out.println("--- List of Operations for " + jclass.toString());
        i = 0;
        while (i < names.length) {
            System.out.println((String)names[i]);
            ++i;
        }
    }

    protected void showSortedProperties(JavaClass jclass) {
        EList allP = jclass.getAllProperties();
        Object[] names = new String[allP.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = ((EStructuralFeature)allP.get(i)).getName();
            ++i;
        }
        Arrays.sort(names);
        System.out.println("--- List of properties for " + jclass.toString());
        i = 0;
        while (i < names.length) {
            System.out.println((String)names[i]);
            ++i;
        }
    }

    protected JavaClass getButton() {
        return (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/java.awt#Button"), true);
    }

    protected JavaClass getJLabel() {
        return (JavaClass)this.rset.getEObject(URI.createURI((String)"java:/javax.swing#JLabel"), true);
    }

    public void testExternalJar() throws IOException {
        this.objFeaturesSetup();
        JavaClass button = this.getButton();
        this.reflectHierachy(button);
        Set names = this.getNames("testdata/extjarprops.txt");
        this.testIncludesAllNames("Button", (List)button.getAllProperties(), names, this.objFeaturesSet);
        names = this.getNames("testdata/extjarops.txt");
        this.testIncludesAllNames("Button", (List)button.getEOperations(), names, Collections.EMPTY_SET);
    }

    public void testJLabel() throws IOException {
        this.objFeaturesSetup();
        JavaClass jlabel = this.getJLabel();
        this.reflectHierachy(jlabel);
        Set names = this.getNames("testdata/jlabelprops.txt");
        this.testIncludesAllNames("JLabel", (List)jlabel.getAllProperties(), names, this.objFeaturesSet);
        names = this.getNames("testdata/jlabelops.txt");
        this.testIncludesAllNames("JLabel", (List)jlabel.getEAllOperations(), names, Collections.EMPTY_SET);
        EStructuralFeature enabledSF = jlabel.getEStructuralFeature("enabled");
        PropertyDecorator pd = Utilities.getPropertyDecorator((EModelElement)enabledSF);
        TestAWTSwingUI.assertTrue((boolean)pd.isPreferred());
    }
}

