/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.appconfig.provider;

import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import junit.framework.TestCase;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jst.jsf.core.jsfappconfig.IJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.JARFileJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigManager;
import org.eclipse.jst.jsf.core.jsfappconfig.RuntimeClasspathJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.internal.IJSFAppConfigManager;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentExtensionType;
import org.eclipse.jst.jsf.facesconfig.emf.ComponentType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;

public class TestJARFileJSFAppConfigProvider
extends TestCase {
    private static final String NO_EXT_DATA_JAR_PATH = "/testfiles/appconfig/noextdata.jar";
    private static final String WITH_EXT_DATA_JAR_PATH = "/testfiles/appconfig/withextdata.jar";
    private static final String NO_FACES_CONFIG_FILE = "/testfiles/appconfig/fail2_nofacesconfig.jar";
    private static final String FAIL_JAR_PATH = "/testfiles/appconfig/fail2.jar";
    private WebProjectTestEnvironment _testEnv;
    private JDTTestEnvironment _jdtTestEnv;
    private IClasspathEntry _noExtData;
    private IClasspathEntry _withExtData;
    private IClasspathEntry _noFacesConfigFile;
    private IResource _copiedIntoProject;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        TestJARFileJSFAppConfigProvider.setInternetPrefs();
        this._testEnv = new WebProjectTestEnvironment("ELValidationTest_" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName());
        this._testEnv.createProject(false);
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)this._testEnv);
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)this._testEnv.getTestProject());
        TestJARFileJSFAppConfigProvider.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        this._copiedIntoProject = this._testEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), FAIL_JAR_PATH, "WEB-INF/lib/fail2.jar");
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)this._copiedIntoProject);
        TestJARFileJSFAppConfigProvider.assertTrue((boolean)this._copiedIntoProject.exists());
        this._jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._testEnv);
        this._noExtData = this._jdtTestEnv.addJarClasspathEntry(TestsPlugin.getDefault().getBundle(), NO_EXT_DATA_JAR_PATH);
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)this._noExtData);
        this._withExtData = this._jdtTestEnv.addJarClasspathEntry(TestsPlugin.getDefault().getBundle(), WITH_EXT_DATA_JAR_PATH);
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)this._withExtData);
        this._noFacesConfigFile = this._jdtTestEnv.addJarClasspathEntry(TestsPlugin.getDefault().getBundle(), NO_FACES_CONFIG_FILE);
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)this._noFacesConfigFile);
        JSFFacetedTestEnvironment jsfFacedEnv = new JSFFacetedTestEnvironment(this._testEnv);
        jsfFacedEnv.initialize("1.1");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        IVirtualContainer container = this._testEnv.getWebRoot(false, false);
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)container);
        IFile file = container.getFile("WEB-INF/lib/fail2.jar").getUnderlyingFile();
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)file);
        TestJARFileJSFAppConfigProvider.assertTrue((boolean)file.exists());
        this._testEnv.getTestProject().delete(true, null);
        TestJARFileJSFAppConfigProvider.assertFalse((boolean)this._testEnv.getTestProject().exists());
        TestJARFileJSFAppConfigProvider.assertFalse((boolean)file.exists());
    }

    public void testNoExtensionData() throws Exception {
        JARFileJSFAppConfigProvider provider = this.createProvider(this._noExtData, true);
        FacesConfigType facesConfig = provider.getFacesConfigModel();
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)facesConfig);
        this.verifyCommonElements(facesConfig);
    }

    public void testWithExtensionData() throws Exception {
        JARFileJSFAppConfigProvider provider = this.createProvider(this._withExtData, true);
        FacesConfigType facesConfig = provider.getFacesConfigModel();
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)facesConfig);
        this.verifyCommonElements(facesConfig);
        ComponentType componentType = (ComponentType)facesConfig.getComponent().get(0);
        TestJARFileJSFAppConfigProvider.assertEquals((int)1, (int)componentType.getComponentExtension().size());
        ComponentExtensionType extType = (ComponentExtensionType)componentType.getComponentExtension().get(0);
        TestJARFileJSFAppConfigProvider.assertEquals((int)0, (int)extType.getChildNodes().size());
    }

    public void testJarCopiedInProject() throws Exception {
        JARFileJSFAppConfigProvider provider = this.createProvider((IFile)this._copiedIntoProject);
        FacesConfigType facesConfig = provider.getFacesConfigModel();
        TestJARFileJSFAppConfigProvider.assertNotNull((Object)facesConfig);
    }

    public void testNoFacesConfigJar() throws Exception {
        JARFileJSFAppConfigProvider provider = this.createProvider(this._noFacesConfigFile, false);
        FacesConfigType facesConfig = provider.getFacesConfigModel();
        TestJARFileJSFAppConfigProvider.assertNull((Object)facesConfig);
    }

    private void verifyCommonElements(FacesConfigType facesConfig) {
        TestJARFileJSFAppConfigProvider.assertEquals((int)1, (int)facesConfig.getComponent().size());
        ComponentType component = (ComponentType)facesConfig.getComponent().get(0);
        TestJARFileJSFAppConfigProvider.assertEquals((String)"com.ibm.odc.jsf.RichTextEditor", (String)component.getComponentType().getTextContent());
        TestJARFileJSFAppConfigProvider.assertEquals((String)"com.ibm.odc.jsf.components.components.rte.UIRichTextEditor", (String)component.getComponentClass().getTextContent());
        TestJARFileJSFAppConfigProvider.assertEquals((int)1, (int)facesConfig.getManagedBean().size());
        ManagedBeanType managedBean = (ManagedBeanType)facesConfig.getManagedBean().get(0);
        TestJARFileJSFAppConfigProvider.assertEquals((String)"jarBean", (String)managedBean.getManagedBeanName().getTextContent());
        TestJARFileJSFAppConfigProvider.assertEquals((String)"java.util.List", (String)managedBean.getManagedBeanClass().getTextContent());
        TestJARFileJSFAppConfigProvider.assertEquals((String)"request", (String)managedBean.getManagedBeanScope().getTextContent());
    }

    private JARFileJSFAppConfigProvider createProvider(IFile file) throws Exception {
        String libName = file.getLocation().toOSString();
        RuntimeClasspathJSFAppConfigLocater locator = new RuntimeClasspathJSFAppConfigLocater();
        locator.setJSFAppConfigManager((IJSFAppConfigManager)JSFAppConfigManager.getInstance((IProject)this._testEnv.getTestProject()));
        JARFileJSFAppConfigProvider provider = new JARFileJSFAppConfigProvider(libName);
        provider.setJSFAppConfigLocater((IJSFAppConfigLocater)locator);
        return provider;
    }

    private JARFileJSFAppConfigProvider createProvider(IClasspathEntry forJar, boolean assertFacesConfig) throws Exception {
        String libName = TestJARFileJSFAppConfigProvider.getLibraryName(forJar, assertFacesConfig);
        RuntimeClasspathJSFAppConfigLocater locator = new RuntimeClasspathJSFAppConfigLocater();
        locator.setJSFAppConfigManager((IJSFAppConfigManager)JSFAppConfigManager.getInstance((IProject)this._testEnv.getTestProject()));
        JARFileJSFAppConfigProvider provider = new JARFileJSFAppConfigProvider(libName);
        provider.setJSFAppConfigLocater((IJSFAppConfigLocater)locator);
        return provider;
    }

    private static String getLibraryName(IClasspathEntry classPathEntry, boolean assertFacesConfig) throws Exception {
        IPath libraryPath = classPathEntry.getPath();
        String libraryPathString = libraryPath.toOSString();
        if (assertFacesConfig) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(libraryPathString, false);
                JarEntry jarEntry = jarFile.getJarEntry("META-INF/faces-config.xml");
                TestJARFileJSFAppConfigProvider.assertNotNull((Object)jarEntry);
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
        }
        return libraryPathString;
    }

    private static void setInternetPrefs() throws Exception {
        IProxyService proxy = ProxyManager.getProxyManager();
        ProxyData proxyData = new ProxyData("HTTP");
        proxyData.setHost("www-proxy.us.oracle.com");
        proxyData.setPassword("80");
        proxy.setProxyData((IProxyData[])new ProxyData[]{proxyData});
        proxy.setProxiesEnabled(true);
    }
}

