/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.facet;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.Listener;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.ServletMapping;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.internal.impl.ServletTypeImpl;
import org.eclipse.jst.jsf.common.webxml.WebXmlUpdater;
import org.eclipse.jst.jsf.common.webxml.WebXmlUtilsForJ2EE;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class VendorSpecificWebXmlConfigurationForJ2EETest
extends TestCase {
    private static final IProjectFacetVersion WEB_MODULE_VERSION = ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion("2.4");
    private static final IProjectFacetVersion JAVA_VERSION = JavaFacet.VERSION_1_5;
    private static final String SERVLET_NAME = "_TEST_SERVLET_NAME";
    private static final String SERVLET_CLASS_NAME = "_TEST_SERVLET_CLASS_NAME";
    private static final String SERVLET_LOAD_ON_STARTUP = "1";
    private static final String SERVLET_URL_PATTERN = "*._TEST_SERVLET_URL_PATTERN";
    private static final String CONTEXT_PARAM_NAME = "_TEST_CONTEXT_PARAM_NAME";
    private static final String CONTEXT_PARAM_VALUE = "_TEST_CONTEXT_PARAM_VALUE";
    private static final String CONTEXT_PARAM_DESCRIPTION = "_TEST_CONTEXT_PARAM_DESCRIPTION";
    private static final String LISTENER_CLASS = "_TEST_LISTENER_CLASS";
    private IProject project;
    private WebXmlUpdater updater;

    private IProject createProject(String projectName) throws Exception {
        WebProjectTestEnvironment testEnv = new WebProjectTestEnvironment(projectName, JAVA_VERSION, WEB_MODULE_VERSION);
        VendorSpecificWebXmlConfigurationForJ2EETest.assertTrue((boolean)testEnv.createProject(true));
        return testEnv.getTestProject();
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.project = this.createProject(String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + this.getName());
        this.updater = new WebXmlUpdater(this.project, null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        System.out.println(JSFTestUtil.safeDelete((IResource)this.project, (int)3, (int)500));
    }

    public void testAddServlet() throws Exception {
        this.setupServlet();
    }

    private void setupServlet() {
        VendorSpecificWebXmlConfigurationForJ2EETest.assertFalse((boolean)WebXmlUtilsForJ2EE.existsServlet((WebApp)this.updater.getWebAppForJ2EE(), (String)SERVLET_NAME, (String)SERVLET_CLASS_NAME));
        this.updater.addServlet(SERVLET_NAME, SERVLET_CLASS_NAME, SERVLET_LOAD_ON_STARTUP);
        Servlet servlet = WebXmlUtilsForJ2EE.findServlet((WebApp)this.updater.getWebAppForJ2EE(), (String)SERVLET_CLASS_NAME);
        VendorSpecificWebXmlConfigurationForJ2EETest.assertEquals((String)SERVLET_NAME, (String)servlet.getServletName());
        VendorSpecificWebXmlConfigurationForJ2EETest.assertEquals((String)SERVLET_CLASS_NAME, (String)((ServletTypeImpl)servlet.getWebType()).getClassName());
        VendorSpecificWebXmlConfigurationForJ2EETest.assertEquals((int)Integer.parseInt(SERVLET_LOAD_ON_STARTUP), (int)servlet.getLoadOnStartup());
    }

    public void testAddContextParam() throws Exception {
        VendorSpecificWebXmlConfigurationForJ2EETest.assertFalse((boolean)WebXmlUtilsForJ2EE.existsContextParam((WebApp)this.updater.getWebAppForJ2EE(), (String)CONTEXT_PARAM_NAME, (String)CONTEXT_PARAM_VALUE));
        this.updater.addContextParam(CONTEXT_PARAM_NAME, CONTEXT_PARAM_VALUE, CONTEXT_PARAM_DESCRIPTION);
        ParamValue param = WebXmlUtilsForJ2EE.findContextParam((WebApp)this.updater.getWebAppForJ2EE(), (String)CONTEXT_PARAM_NAME, (String)CONTEXT_PARAM_VALUE);
        VendorSpecificWebXmlConfigurationForJ2EETest.assertEquals((String)CONTEXT_PARAM_NAME, (String)param.getName());
        VendorSpecificWebXmlConfigurationForJ2EETest.assertEquals((String)CONTEXT_PARAM_VALUE, (String)param.getValue());
        VendorSpecificWebXmlConfigurationForJ2EETest.assertEquals((String)CONTEXT_PARAM_DESCRIPTION, (String)((Description)param.getDescriptions().get(0)).getValue());
    }

    public void testGetContextParamValue() {
        VendorSpecificWebXmlConfigurationForJ2EETest.assertFalse((boolean)WebXmlUtilsForJ2EE.existsContextParam((WebApp)this.updater.getWebAppForJ2EE(), (String)CONTEXT_PARAM_NAME, (String)CONTEXT_PARAM_VALUE));
        this.updater.addContextParam(CONTEXT_PARAM_NAME, CONTEXT_PARAM_VALUE, CONTEXT_PARAM_DESCRIPTION);
        String contextParamValue = this.updater.getContextParamValue(CONTEXT_PARAM_NAME);
        VendorSpecificWebXmlConfigurationForJ2EETest.assertNotNull((Object)contextParamValue);
        VendorSpecificWebXmlConfigurationForJ2EETest.assertEquals((String)CONTEXT_PARAM_VALUE, (String)contextParamValue);
    }

    public void testGetContextParamValuesAsList() {
        VendorSpecificWebXmlConfigurationForJ2EETest.assertFalse((boolean)WebXmlUtilsForJ2EE.existsContextParam((WebApp)this.updater.getWebAppForJ2EE(), (String)CONTEXT_PARAM_NAME, (String)CONTEXT_PARAM_VALUE));
        this.updater.addContextParam(CONTEXT_PARAM_NAME, "_TEST_CONTEXT_PARAM_VALUE1;_TEST_CONTEXT_PARAM_VALUE2;_TEST_CONTEXT_PARAM_VALUE3", CONTEXT_PARAM_DESCRIPTION);
        List<String> expectedList = Arrays.asList("_TEST_CONTEXT_PARAM_VALUE1", "_TEST_CONTEXT_PARAM_VALUE2", "_TEST_CONTEXT_PARAM_VALUE3");
        List actualList = this.updater.getContextParamValuesAsList(CONTEXT_PARAM_NAME, ";");
        VendorSpecificWebXmlConfigurationForJ2EETest.assertEquals(expectedList, (Object)actualList);
    }

    public void testSetContextParamValue() {
        VendorSpecificWebXmlConfigurationForJ2EETest.assertFalse((boolean)WebXmlUtilsForJ2EE.existsContextParam((WebApp)this.updater.getWebAppForJ2EE(), (String)CONTEXT_PARAM_NAME, (String)CONTEXT_PARAM_VALUE));
        this.updater.setContextParamValue(CONTEXT_PARAM_NAME, CONTEXT_PARAM_VALUE);
        VendorSpecificWebXmlConfigurationForJ2EETest.assertEquals((String)CONTEXT_PARAM_VALUE, (String)this.updater.getContextParamValue(CONTEXT_PARAM_NAME));
        VendorSpecificWebXmlConfigurationForJ2EETest.assertFalse((boolean)this.updater.getContextParamValue(CONTEXT_PARAM_NAME).equals("_TEST_CONTEXT_PARAM_VALUEupdated"));
        this.updater.setContextParamValue(CONTEXT_PARAM_NAME, "_TEST_CONTEXT_PARAM_VALUEupdated");
        VendorSpecificWebXmlConfigurationForJ2EETest.assertEquals((String)"_TEST_CONTEXT_PARAM_VALUEupdated", (String)this.updater.getContextParamValue(CONTEXT_PARAM_NAME));
    }

    public void testAddServletMapping() throws Exception {
        this.setupServlet();
        VendorSpecificWebXmlConfigurationForJ2EETest.assertFalse((boolean)WebXmlUtilsForJ2EE.existsServletMapping((WebApp)this.updater.getWebAppForJ2EE(), (String)SERVLET_NAME, (String)SERVLET_URL_PATTERN));
        this.updater.addServletMapping(SERVLET_NAME, SERVLET_CLASS_NAME, SERVLET_URL_PATTERN);
        ServletMapping mapping = WebXmlUtilsForJ2EE.findServletMapping((WebApp)this.updater.getWebAppForJ2EE(), (String)SERVLET_NAME, (String)SERVLET_URL_PATTERN);
        VendorSpecificWebXmlConfigurationForJ2EETest.assertEquals((String)SERVLET_NAME, (String)mapping.getName());
        VendorSpecificWebXmlConfigurationForJ2EETest.assertEquals((String)SERVLET_URL_PATTERN, (String)mapping.getUrlPattern());
    }

    public void testAddListener() throws Exception {
        VendorSpecificWebXmlConfigurationForJ2EETest.assertFalse((boolean)WebXmlUtilsForJ2EE.existsListener((WebApp)this.updater.getWebAppForJ2EE(), (String)LISTENER_CLASS));
        this.updater.addListener(LISTENER_CLASS);
        Listener listener = WebXmlUtilsForJ2EE.findListener((WebApp)this.updater.getWebAppForJ2EE(), (String)LISTENER_CLASS);
        VendorSpecificWebXmlConfigurationForJ2EETest.assertEquals((String)LISTENER_CLASS, (String)listener.getListenerClassName());
    }
}

