/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import org.eclipse.jst.jsf.core.tests.mock.MockTLDAttributeDeclaration;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.TLDTagAttribute;
import org.eclipse.jst.jsf.test.util.junit4.NoPluginEnvironment;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDAttributeDeclaration;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NoPluginEnvironment.class})
public class TLDAttributeSerializationTests {
    private MockTLDAttributeDeclaration _decl;
    private TLDTagAttribute _attribute;

    @Before
    public void setUp() throws Exception {
        this._decl = new MockTLDAttributeDeclaration("mockAttr", "mockDesc", "mockId", true);
        this._attribute = new TLDTagAttribute((TLDAttributeDeclaration)this._decl);
    }

    @Test
    public void testWriteRead() throws Exception {
        Assert.assertFalse((boolean)this._attribute.hasBeenDeserialized());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutputStream serializationStream = new ObjectOutputStream(stream);
        serializationStream.writeObject(this._attribute);
        ByteArrayInputStream inStream = new ByteArrayInputStream(stream.toByteArray());
        ObjectInputStream deserializeStream = new ObjectInputStream(inStream);
        Object readObject = deserializeStream.readObject();
        Assert.assertNotNull((Object)readObject);
        Assert.assertTrue((boolean)(readObject instanceof TLDTagAttribute));
        TLDTagAttribute tagAttribute = (TLDTagAttribute)readObject;
        Assert.assertEquals((String)"mockAttr", (String)tagAttribute.getName());
        Assert.assertEquals((String)"mockDesc", (String)tagAttribute.getDescription());
        Assert.assertEquals((boolean)true, (boolean)tagAttribute.isRequired());
        Assert.assertTrue((boolean)tagAttribute.hasBeenDeserialized());
    }
}

